/*! \file vapi_defaults.c 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#include "ut.h"
#include "vapi.h"
#include "vcore.h"
#include "vcore_voip.h"

/** Default parameters for a VoIP channel*/
SVoIPChnlParams stVoipDefaultParams_g;

SToneGenParams astDtmfToneGenParams_g[] =
{
	{0, 0, 0, 0, 0, 0, 1, {{697, 100, 1209, 100, 80, 80}}}, /* 1 */
	{0, 0, 0, 0, 0, 0, 1, {{697, 100, 1336, 100, 80, 80}}}, /* 2 */
	{0, 0, 0, 0, 0, 0, 1, {{697, 100, 1477, 100, 80, 80}}}, /* 3 */
	{0, 0, 0, 0, 0, 0, 1, {{770, 100, 1209, 100, 80, 80}}}, /* 4 */
	{0, 0, 0, 0, 0, 0, 1, {{770, 100, 1306, 100, 80, 80}}}, /* 5 */
	{0, 0, 0, 0, 0, 0, 1, {{770, 100, 1477, 100, 80, 80}}}, /* 6 */
	{0, 0, 0, 0, 0, 0, 1, {{852, 100, 1209, 100, 80, 80}}}, /* 7 */
	{0, 0, 0, 0, 0, 0, 1, {{852, 100, 1336, 100, 80, 80}}}, /* 8 */
	{0, 0, 0, 0, 0, 0, 1, {{852, 100, 1477, 100, 80, 80}}}, /* 9 */
	{0, 0, 0, 0, 0, 0, 1, {{697, 100, 1633, 100, 80, 80}}}, /* A */
	{0, 0, 0, 0, 0, 0, 1, {{770, 100, 1633, 100, 80, 80}}}, /* B */
	{0, 0, 0, 0, 0, 0, 1, {{852, 100, 1633, 100, 80, 80}}}, /* C */
	{0, 0, 0, 0, 0, 0, 1, {{941, 100, 1633, 100, 80, 80}}}, /* D */
	{0, 0, 0, 0, 0, 0, 1, {{941, 100, 1209, 100, 80, 80}}}, /* * */
	{0, 0, 0, 0, 0, 0, 1, {{941, 100, 1336, 100, 80, 80}}}, /* 0 */
	{0, 0, 0, 0, 0, 0, 1, {{941, 100, 1477, 100, 80, 80}}} /* # */
};

SCountryInfo astCountryInfoList_g[] = 
{
	/* start of country 1 block*/
	{
		/* start of tones block*/
		{
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* NULL Tone */
			{0, 0, 0, 0, 0, 0xFF, 1, {{480, 100, 620, 100, 250, 250}}},		/* Congestiontone */
			{0, 0, 0, 0, 0, 1, 2, {{440, 100, 0, 0, 1500, 8000}, {440, 100, 0, 0, 500, 8000}}},	/*  Warningtone */
			{0, 0, 0, 0, 0, 1, 1, {{440, 100, 0, 0, 300, 10000}}},			/* Waitingtone */
			{0, 0, 0, 0, 0, 0, 3, {{350, 170, 440, 170, 100, 100}, {350, 170, 440, 170, 100, 100}, {350, 170, 440, 170, 100, 100}}},/* Confirmation tone */
			{0, 0, 0, 0, 0, 0xFF, 1, {{350, 100, 440, 100, 0, 0}}},			/* Dial Tone */
			{0, 0, 0, 0, 0, 0xFF, 1, {{480, 100, 620, 100, 500, 500}}},		/* busytone */
			{0, 0, 0, 0, 0, 0xFF, 1, {{440, 100, 480, 100, 1000, 3000}}},		/* Ringbacktone */
			{0, 0, 0, 0, 0, 1, 3, {{950, 100, 0, 0, 330, 0},{1400, 100, 0, 0, 330, 0}, {1800, 100, 0, 0, 330, 0}}}, /* Specialinfotone */
			{0, 0, 0, 0, 0, 0, 1, {{440, 0xD4, 00, 00, 0x12C, 0x12C}}},		/* SAS Tone */
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom tone 1 */
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom Tone 2*/
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom Tone 3*/
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom Tone 4*/
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom Tone 5*/
		},
	
		/* Caller ID Params */
		{
			0, 1, 1, {0x61}, {0xB6, 0x00, 0x01, 0x012C, 0x00, 0x00B4},
			{0xD4, 0x00, 0x01, 0x0064, 0x852, 0xabe, 0x50, 0xD4, 0xD4, 0x61, 0x64, 0x28, 0xC8, 0x0, 0x01, 0x012C, 0x00, 0x28, NULL}
		},
		/* Caller ID Detection Parameters */
		{
			{0x00, 0x00}, {0x02, 0x0000, 0x0000}, {0x00C0, 0x0060},{0x0018}, {0x0D, 0x14, 0x3C, 0x0070}, {0x00}, 0x02
		}
	},/* end of country 1 block*/

	{/* start of country 2 block*/
		/* start of tones block*/
		{
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}},				/* NULL Tone */
			{0, 0, 0, 0, 0, 0xFF, 1, {{480, 100, 620, 100, 250, 250}}},		/* Congestiontone */
			{0, 0, 0, 0, 0, 1, 2, {{440, 100, 0, 0, 1500, 8000}, {440, 100, 0, 0, 500, 8000}}},	/*  Warningtone */
			{0, 0, 0, 0, 0, 1, 1, {{440, 100, 0, 0, 300, 10000}}},			/* Waitingtone */
			{0, 0, 0, 0, 0, 1, 4, {{350, 100, 440, 100, 100, 0},{350, 100, 440, 100, 100, 0}, {350, 100, 440, 100, 0, 100},{350, 100, 440, 100, 0, 100}}},					/* Confirmation tone */
			{0, 0, 0, 0, 0, 0xFF, 1, {{350, 100, 0, 0, 0, 0}}},			/* Dial Tone */
			{0, 0, 0, 0, 0, 0xFF, 1, {{400, 100, 0, 0, 600, 600}}},			/* busytone */
			{0, 0, 0, 0, 0, 0xFF, 2, {{400, 100, 25, 100, 400, 200},{400, 100, 25, 100, 400, 260}}},	/* Ringback tone */
			{0, 0, 0, 0, 0, 1, 3, {{950, 100, 0, 0, 330, 0}, {1400, 100, 0, 0, 330, 0},{1800, 100, 0, 0, 330, 0}}}, /* Specialinfotone */
			{0, 0, 0, 0, 1, 0, 1, {{440, 0xD4, 00, 00, 0x12C, 0x12C}}},		/* SAS Tone */
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom tone 1 */
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom Tone 2*/
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom Tone 3*/
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom Tone 4*/
			{0, 0, 0, 0, 0, 1, 1, {{0, 0, 0, 0, 0, 0}}}, 				/* Custom Tone 5*/
		},

		/* Caller ID Params */
		{
			0, 1, 1, {0x61}, {0xB6, 0x00, 0x01, 0x012C, 0x00, 0x00B4},
			{0xD4, 0x00, 0x01, 0x0064, 0x852, 0xabe, 0x50, 0xD4, 0xD4, 0x61, 0x64, 0x28, 0xC8, 0x0, 0x01, 0x012C, 0x00, 0x28, NULL}
		},
		/* Caller ID Detection Parameters */
		{
			{0x00, 0x00}, {0x02, 0x0000, 0x0000}, {0x00C0, 0x0060}, {0x0018}, {0x0D, 0x14, 0x3C, 0x0070}, {0x00}, 0x02
		}
	}/* end of country 2 block*/
};

SConferenceParams stConfParams_g;

SToneGeneric astToneGeneric_g[eDUMMYTONE];

/** Caller ID generation global structure */
SCidGen SCidGen_g;
/** Mutex to access the caller id generation structure */
SMutex stMutexCIDGen_g;

/** Caller ID detection global structure */
SCidDet SCidDet_g;
/** Mutex to access the caller id detection structure */
SMutex stMutexCIDDet_g;

/** Mutex to access the tone generic array*/
SMutex stMutexToneGenArr_g;

void DMGR_SetVAPIDefaults(SVAPIConfig * pstVAPIConfig)
{
	pstVAPIConfig->pstVoIPChnlParams = &stVoipDefaultParams_g;
	pstVAPIConfig->pstConfParams = &stConfParams_g;
	pstVAPIConfig->uiNumCountries = sizeof(astCountryInfoList_g) / sizeof(SCountryInfo);
	pstVAPIConfig->pastCountryInfo = astCountryInfoList_g;

	pstVAPIConfig->uiMaxDevices = CFG_MAX_DEVICES;
	pstVAPIConfig->uiMspRespTimeout = CFG_MSP_RESP_TIMEOUT;

	UT_MemSet(&stVoipDefaultParams_g, 0, sizeof(SVoIPChnlParams));

	DMGR_SetVoIPDefaults(pstVAPIConfig->pstVoIPChnlParams);
	DMGR_SetConfDefaults(pstVAPIConfig->pstConfParams);

	return;
}

/****************************************************************************
 * CidInitDefault : The function does the following things -
 ***************************************************************************/
/*! 
 *  - Implementation
 *      - Sets the default cid parameters called by VAPI_Init()
 *
 *  - Assumptions 
 *      - None
 *
 *  \return None 
 */
VSTATUS CidInitDefault(void)
{
	VSTATUS Status;

	/* Set default CID generation parameters*/
	Status = UT_MutexInit(&stMutexCIDGen_g);
	if (Status < 0)
		return Status;

	Status = UT_MutexInit(&stMutexCIDDet_g);
	if (Status < 0)
	{
		UT_MutexDestroy(&stMutexCIDGen_g);
		return Status;
	}

	/* FSK ampliture = -18.2dbv0, Data Tx phase during ring, Alert info byte DT-AS
		Channel seizure bits: 300 bits, Channel seizure First Bit Space
		Mark bits 180 Bits*/
	Status = VAPI_SetCidGenInfo(eAdd, eOnHookXmitInfoType, 6, 0xB6, 0x00, 0x00, 0x012C, 0x00, 0x00B4);
	if (Status != SUCCESS)
		goto out;

	/*FSK ampliture -18.2dbv0, Modulation freq Bell 202, Alert info byte DT-AS, Mark Bits 100 bits */
	Status = VAPI_SetCidGenInfo(eAdd, eOffHookXmitInfoType, 4, 0xD4, 0x00, 0x01, 0x0064);
	if (Status != SUCCESS)
		goto out;

	/* Low nominal frequency 2130 Hz, High nominal frequency 2750 Hz, Duration 80ms
	Low frequency level -21.2 dbv0, High frequency level -21.2 dbv0*/
	Status = VAPI_SetCidGenInfo(eAdd, eCPEAlertToneInfoType, 5, 0x0852, 0x0ABE, 0x50, 0xD4, 0xD4);
	if (Status != SUCCESS)
		goto out;

	/*DTMF Digit 1 ‘A’ ,DTMF Digit 2 ‘D’ , Min Duration 30ms, Time out for ACK 200ms
	Time to data transmission 160ms, Data transmit if no ack, Ack tone min level -30dBv0*/
	Status = VAPI_SetCidGenInfo(eAdd, eCPEAckInfoType, 7, 0x41, 0x44, 0x1E, 0xC8, 0xA0, 0x00, 0x012C);
	if (Status != SUCCESS)
		goto out;

	/* Set default CID detection parameters*/

	/*8 bits no parity/ checksum used for message integrity*/
	Status = VAPI_SetCidDetInfo(eAdd, eDataFormatType, 2, 0, 0);
	if (Status != SUCCESS)
		goto out;

	/* Detects both b202 and V23, Use DSP value for FSK Pull in threshold, use DSP value for FSK drop out value*/
	Status = VAPI_SetCidDetInfo(eAdd, eFSKDetectionType, 3, 2, 0, 0);
	if (Status != SUCCESS)
		goto out;

	/* Channel Seizure Threshold 192 bits, Mark bits Threshold 96 bits */
	Status = VAPI_SetCidDetInfo(eAdd, eOnHookDetType, 2, 192, 96);
	if (Status != SUCCESS)
		goto out;

	/* Mark bits Threshold 96 bits */
	Status = VAPI_SetCidDetInfo(eAdd, eOffHookDetType, 1, 96);
	if (Status != SUCCESS)
		goto out;

	/* DTMF Digit to generate 0x0D, Delay time from CPE Alert Detected 20ms
	Ack Tone Duration 60ms, Ack Tone Tx level -11.2 dBoV */
	Status = VAPI_SetCidDetInfo(eAdd, eAckGenType, 4, 0x0D, 20, 60, 112);
	if (Status != SUCCESS)
		goto out;

	/*Disable NTT cid dectection*/
	Status = VAPI_SetCidDetInfo(eAdd, eNTTDetType, 1, 0);
	if (Status != SUCCESS)
		goto out;

out:
	if (Status != SUCCESS)
		UT_ErrorLog(APPITF, "CidInitDefault: Error in CID block initialization\n");
	else
		UT_Log(APPITF, INFO, "CidInitDefault sucessfully  initilized\n");

	UT_MutexDestroy(&stMutexCIDGen_g);
	UT_MutexDestroy(&stMutexCIDDet_g);

	return Status;
}

/****************************************************************************
 * DMGR_ToneInit : The function does the following things -
 ***************************************************************************/
/*! 
 *  - Implementation
 *      - Sets the default tone parameters
 *
 *  - Assumptions 
 *      - None
 *
 *  \return None 
 */
VSTATUS DMGR_ToneInit()
{
	VSTATUS status;
	UT_MutexInit(&stMutexToneGenArr_g);
	
	status = VAPI_SetTone(eDTMFTONE_1, eDualTone, 0, 6, 697, 100, 1209, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_2, eDualTone, 0, 6, 697, 100, 1336, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_3, eDualTone, 0, 6, 697, 100, 1477, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_4, eDualTone, 0, 6, 770, 100, 1209, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_5, eDualTone, 0, 6, 770, 100, 1306, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_6, eDualTone, 0, 6, 770, 100, 1477, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_7, eDualTone, 0, 6, 852, 100, 1209, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_8, eDualTone, 0, 6, 852, 100, 1336, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_9, eDualTone, 0, 6, 852, 100, 1477, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_A, eDualTone, 0, 6, 697, 100, 1633, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_B, eDualTone, 0, 6, 770, 100, 1633, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_C, eDualTone, 0, 6, 852, 100, 1633, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_D, eDualTone, 0, 6, 941, 100, 1633, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_STAR, eDualTone, 0, 6, 941, 100, 1209, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_0, eDualTone, 0, 6, 941, 100, 1336, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDTMFTONE_HASH, eDualTone, 0, 6, 941, 100, 1477, 100, 80, 80);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eNULLTONE, eDualTone, 1, 6, 0, 0, 0, 0, 0, 0);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eCONGESTIONTONE, eDualTone, 0xFF, 6, 480, 100, 620, 100, 250, 250);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eWARNINGTONE, eDualTone, 1, 12, 440, 100, 0, 0, 1500, 8000,
								440, 100, 0, 0, 500, 8000);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eWAITINGTONE, eDualTone, 1, 6, 440, 100, 0, 0, 300, 10000);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eCONFIRMATIONTONE, eDualTone, 0, 18, 350, 170, 440, 170, 100, 100,
								350, 170, 440, 170, 100, 100, 
								350, 170, 440, 170, 100, 100);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eDIALTONE, eDualTone, 0xFF, 6, 350, 100, 440, 100, 0, 0);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eBUSYTONE, eDualTone, 0xFF, 6, 480, 100, 620, 100, 500, 500);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eRINGBACKTONE, eDualTone, 0xFF, 6, 440, 100, 480, 100, 1000, 3000);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eSPECIALTONE, eDualTone, 1, 18, 950, 100, 0, 0, 330, 0,
								1400, 100, 0, 0, 330, 0, 
								1800, 100, 0, 0, 330, 0);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eSASTONE, eDualTone, 1, 6, 440, 0xD4, 00, 00, 0x12C, 0x12C);
	if (status != SUCCESS)
		goto out;

	status = VAPI_SetTone(eCUSTOM_1, eQuadTone, 0, 10, 440, 130, 440, 130, 440, 130, 440, 130, 300, 300);
	if (status != SUCCESS)
		goto out;

out:
	return status;
}
