/*! @ingroup misc
*  @{
*/

/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */


#ifndef _CONFIG_H_
#define _CONFIG_H_

#include "vcore_voip.h"
#include "vcore_types.h"


/*VAPI Defaults*/
typedef struct _SVAPIConfig {
	U32 uiMspRespTimeout;			/* MSP response timeout value */
	U32 uiMaxDevices;			/* Max number of devices supported by VAPI */
	U32 uiNumCountries;			/* Number of countries */
	SCountryInfo *pastCountryInfo;		/* Country specific Caller Id settings */
	SConferenceParams *pstConfParams;	/* Conference settings */
	SVoIPChnlParams *pstVoIPChnlParams;	/* VoIP/FoIP Channel defaults */
} SVAPIConfig;

/***************************************************************************
 * pfnUsrQueryVapiDefaultsEnumerate: The function does the following things -
 ***************************************************************************/
/*! 
*	\n \b Description: \n
*	This API is implemented by Application to override the default settings done by VAPI. \n
*	If application intends to override some/all of the default parameters then it should initialize this global function pointer by
*	its own function before calling VAPI_Init().\n
*	By default this global is initialized to NULL. When VAPI_Init() is called by application, VAPI Initializes the SVAPIConfig structure
*	and calls the function pointed to by this global pointer. Inside this function user can override the defaults done by VAPI.\n
*	Note that not only the values can be changed, but also the pointers can be changed to point to some other memory location. \n
*	This will not cause a memory leak as the pointers inside the SVAPIConfig structure are not pointing to any dynamically allocated
*	memory, they are just pointers to global memory locations. \n
*	Typically, users should not opt for overriding the pointers unless they want to change the size of an array, for example adding
*	more countries in the array SVAPIConfig::pastCountryInfo. \n
*	Any memory allocated here can be cleaned up in the function pfnUsrDefaultsClose. \n
*	\n
*	<table style="text-align: left; width: 640px" border="0" cellpadding="2" cellspacing="0">
*	<tr>
*		<td style="background-color: rgb(213, 225, 232);"><b>Inputs-Outputs</b></td>
*		<td style="background-color: rgb(213, 225, 232);"><b></b></td>
*	</tr>
*	<tr>
*		<td style="vertical-align: top;">pstVAPIConfig</td>
*		<td style="vertical-align: top;">pointer to global SVAPIConfig VAPI structure defined in vapi_config.h</td>
*	</tr>
*	</table>
*
*	\n \b Returns:
*	\li SUCCESS
*
*	\b Usage: \n
*	\include set_default_config.c
*
*	\n \b Commands:
*	\li No Comcerto commands sent.
*/
typedef VSTATUS(*PFNUSRQueryVAPIDefaultsEnumerate) (IN OUT SVAPIConfig * pstVAPIConfig);

/***************************************************************************
 * pfnUsrDefaultsClose: The function does the following things -
 ***************************************************************************/
/*! 
*	\n \b Description: \n
*	This API may be implemented by the application if application wants to do some cleanup operation for the 
*	initializations done in pfnUsrQueryVapiDefaultsEnumerate. \n
*	User has to override this global before VAPI_Close() is called. \n
*	The function pointed by this global pointer is called from the implementation of VAPI_Close().\n
*	\n
*	<table style="text-align: left; width: 640px" border="0" cellpadding="2" cellspacing="0">
*	<tr>
*		<td style="background-color: rgb(213, 225, 232);"><b>Inputs-Outputs</b></td>
*		<td style="background-color: rgb(213, 225, 232);"><b></b></td>
*	</tr>
*	<tr>
*		<td style="vertical-align: top;">NONE</td>
*		<td style="vertical-align: top;"></td>
*	</tr>
*	</table>
*
*	\n \b Returns:
*	\li SUCCESS
*
*	\n \b Commands:
*	\li No Comcerto commands sent.
*/
typedef VSTATUS(*PFNUSRQueryVAPIDefaultsClose) (void);

extern PFNUSRQueryVAPIDefaultsEnumerate pfnUsrQueryVapiDefaultsEnumerate;
extern PFNUSRQueryVAPIDefaultsClose pfnUsrDefaultsClose;

#endif
/** @} */ /*end of addtogroup misc group*/
