/*! \file resmgr.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */
#include "vapi.h"
#include "ut.h"
#include "dmgr.h"

#ifndef _RES_MGR_H
#define _RES_MGR_H

#define COMCERTO_RESOURCES	1000000

typedef struct _SConnResources {
	CONNID ConnId;			/**< Unique Connection identifier */
	U16 usConnRes;			/**< Resource amount allocated for the connection id */
} SConnResources;

typedef struct _SDevResources {
	int ResourceCount;		/**< Resource count for this device */
	U16 *pusGenericResources;	/**< Generic Resources available for this device*/
	U16 *pusCurrentResources;	/**< Current Resources available for this device*/
	Boolean bIsResourceMngr:1;	/**< Indicate if the resource manager is enabled for this device*/
	SMutex mutex_res;
} SDevResources;

typedef struct _SResRequest {
	EConnType eConnType;	/**< Connection type */
	EPartType ePartType;	/**< Particinat type */
	ECodecType eCodecType;	/**< Codec type */
	U8 ucPacketSize;	/**< Packet size */
	U8 ucVAD;		/**< VAD */
	U8 ucG729_1_rate;	/**< G729 WB mode */
} SResRequest;

#endif


