/*! \file param_check.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _PARAM_CHECK_H
#define _PARAM_CHECK_H

#define MAX_VALID_TONE_TIME     8191
#define MIN_DIGITAL_GAIN        -140	/* -14dB */
#define MAX_DIGITAL_GAIN        60	/* 6dB */


#define VERIFY_CALLER_ID_PARAM( pstParam, bValid )      \
{   \
    (bValid) = True;    \
    if(( (pstParam)->ucOnhookOffhookSelect > 1)||  \
        ((pstParam)->ucModType > 1)|| \
        ((pstParam)->ucCIDMsgLen < 1))    \
            (bValid) = False;   \
}

#define VERIFY_CID_ONHOOK_PARAM( pstParam, bValid ) \
{   \
    (bValid) = True;    \
    if(((pstParam)->ucDataTxPhase > 1)||   \
        (pstParam->ucAlertInfoByte > 2)||   \
        (pstParam->ucChnlSeizureFirstBit > 1)) \
        (bValid) = False;   \
}

#define VERIFY_CID_OFFHOOK_PARAM( pstParam, bValid )    \
{   \
    (bValid) = True;    \
    if(((pstParam)->ucModFreqByte > 1)||  \
        ((pstParam)->ucAlertInfoByte > 3)||  \
        ((pstParam)->ucMinDurationACK > 40)||    \
        ((pstParam)->usTimeOutForACK > 4000)||   \
        ((pstParam)->ucTxDataIfNoACK > 1)||   \
        ((pstParam)->usAckToneMinLevel > 630))   \
            (bValid) = False;   \
}

#define VERIFY_START_TONE_PARAM( pstParam, bValid ) \
{   \
    (bValid) = True;    \
    if(((pstParam)->ucToneDir > 1)||  \
            ((pstParam)->ucTimeStampCntrl > 3)|| \
            ((pstParam)->ucProtectedGen > 1)||   \
            ((pstParam)->ucNoOfCdnBlk > 4))    \
        (bValid) = False;   \
}

#define VERIFY_TONE_CADENCE_PARAM( pstParam, bValid )   \
{   \
    (bValid) = True;    \
    if(((pstParam)->usPrmToneFreq > 4000)||   \
            ((pstParam)->usPrmToneAmp > 692)||   \
            ((pstParam)->usSecToneFreq > 4000)||    \
            ((pstParam)->usSecToneAmp > 692))  \
        (bValid) = False;   \
}

#define VERIFY_SETUP_TDM_PARAM( pstParam, bValid )    \
{ \
    STdmBusParams *pstTdm = NULL;    \
    U8 ucCnt =0;   \
    (bValid) = True;    \
    if(((pstParam)->usMode !=  4)&&((pstParam)->usMode != 2)&&((pstParam)->usMode != 1)) \
        (bValid) = False;   \
    else if((pstParam)->usNoOfBus > (pstParam)->usMode)   \
        (bValid) = False;   \
    else        \
    {   \
        for( ucCnt = 0; ucCnt < (pstParam)->usNoOfBus; ucCnt++ )   \
        {   \
            pstTdm = &pstParam->astTdmBusParam[ucCnt]; \
            if(((pstTdm)->ucBusId >= (pstParam)->usMode)||   \
                ((pstTdm)->ucTxOrder > 1)|| \
                ((pstTdm)->ucRxPolarity > 1)||\
                ((pstTdm)->ucTxPolarity > 1) ||\
                ((pstTdm)->ucRxClkMode > 1) ||   \
                ((pstTdm)->ucTxClkMode > 1) ||  \
                ((pstTdm)->ucRxClkEdge > 1) ||    \
                ((pstTdm)->ucTxClkEdge > 1) ||   \
                ((pstTdm)->ucFrameEdge > 1) ||    \
                ((pstTdm)->ucInvertedFrmSig > 1)||  \
                ((pstTdm)->ucBitOrderRcv > 1)|| \
                ((pstTdm)->usNumOfTS < 3)|| \
                ((pstTdm)->usNumOfTS > 1023)||  \
                        ((pstTdm)->usNumTdmClkCyclesDelayTx & 0xF000)|| \
                        ((pstTdm)->usNumTdmClkCyclesDelayRx & 0xF000)) \
            {   \
                    bValid = False;     \
                    break;  \
            }   \
        }   \
    }   \
}

#endif
