/*! \file msp.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */


/* if VAPI_ BIGENDIAN flag is on, set he Comcerto header flag to big endian too */
#ifdef VAPI_BIGENDIAN
#define _HOST_BIG_ENDIAN_
#endif

#include "comcerto-api-defs.h"
#include "comcerto-voip-types.h"
#include "comcerto-ethernet-interface-types.h"
#include "comcerto-ip-device-level-types.h"
#include "comcerto-t38-types.h"
#include "comcerto-tones-types.h"
#include "comcerto-conferencing-types.h"


#ifndef _MSP_H_
#define _MSP_H_

#define MAILBOX_BMR_CMD 0x03	/* Value of BMR to be used for commands in PCI*/
#define MAILBOX_BRM_RESP 0x0b	/* Value of BMR to be used for responses in PCI*/

#define SIDX_FUNC_CODE  2	/**< Fifo word index for Func. Index in FIFO*/
#define SIDX_VSTATUS    4	 /**< Index of Status in response messages*/
#define SIDX_PART_ID    5	/**< Index of participant id in response messages*/


#define MAX_SYNCEOF_SIZE		244
#define MAX_SYNCEOF_DATA		232
#define PACKET_TYPE_LOAD_PLAYBACK	0x07

/*REMDET - 2833 event types*/
#define REMDET_CNG 		0x2403
#define REMDET_ANS 		0x2003
#define REMDET_UDPTL		0x0005


#define ALERT_UNEX_DATA		0x0024	/* Data abort*/
#define ALERT_UNKNOWN_CHANNEL	0xFFFE	/* Undefined channel alert*/

/* M821xx memories defines */
#define M821XX_SDRAM_START	0x00000000
#define M821XX_SDRAM_SIZE	(128 * 1024 * 1024)	/* 128M */

#define M821XX_ARAM_START	0x0a000000
#define M821XX_ARAM_SIZE	(64 * 1024)		/* 64K */

/* M823xx memories defines */
#define M823XX_SDRAM_START	0x00000000
#define M823XX_SDRAM_SIZE	(16 * 1024 * 1024)	/* 16M */

#define M823XX_ERAM_START	0x08000000
#define M823XX_ERAM_SIZE	(640 * 1024)		/* 640K */

#define M823XX_ARAM_START	0x0a000000
#define M823XX_ARAM_SIZE	(72 * 1024)		/* 72K */

/* M823xx_2 memories defines */
#define M823XX_2_SDRAM_START	0x00000000
#define M823XX_2_SDRAM_SIZE	(16 * 1024 * 1024)	/* 16M */

#define M823XX_2_ERAM_START	0x08000000
#define M823XX_2_ERAM_SIZE	(320 * 1024)		/* 320K */

#define M823XX_2_ARAM_START	0x0a000000
#define M823XX_2_ARAM_SIZE	(72 * 1024)		/* 72K */

/* M825xx memories defines */
/* M825xx-1 */
#define M825XX_SDRAM_START	0x00000000
#define M825XX_SDRAM_SIZE	(16 * 1024 * 1024)	/* 16M */

#define M825XX_IRAM_START	0x09000000
#define M825XX_IRAM_SIZE	(8 * 1024)		/* 8K */

#define M825XX_ERAM_START	0x08000000
#define M825XX_ERAM_SIZE	(1 * 1024 * 1024)	/* 1M */

/* M825xx-2 */
#define M825XX_2_SDRAM_START 0x00000000
#define M825XX_2_SDRAM_SIZE     (16 * 1024 * 1024)      /* 16M */

#define M825XX_2_IRAM_START     0x09000000
#define M825XX_2_IRAM_SIZE      (72 * 1024)             /* 72K */

#define M825XX_2_ERAM_START     0x08000000
#define M825XX_2_ERAM_SIZE      (256 * 1024)    /* 256K */

#define M825XX_2_ARAM_START     0x0A000000
#define M825XX_2_ARAM_SIZE      (64 * 1024)     /* 64K */

/* M826xx memories defines */
#define M826XX_SDRAM_START	0x00000000
#define M826XX_SDRAM_SIZE	(16 * 1024 * 1024)	/* 16M */

#define M826XX_IRAM_START	0x09000000
#define M826XX_IRAM_SIZE	(8 * 1024)		/* 8K */

#define M826XX_ERAM_START	0x08000000
#define M826XX_ERAM_SIZE	(1 * 1024 * 1024)	/* 1M */

/* M827xx memories defines */
#define M827XX_SDRAM_START	0x00000000
#define M827XX_SDRAM_SIZE	(16 * 1024 * 1024)	/* 16M */

#define M827XX_IRAM_START	0x09000000
#define M827XX_IRAM_SIZE	(136 * 1024)		/* 136K */

#define M827XX_ERAM_START	0x08000000
#define M827XX_ERAM_SIZE	(1.5 * 1024 * 1024)	/* 1.5M */

#define M827XX_ARAM_START	0x0a000000
#define M827XX_ARAM_SIZE	(128 * 1024)		/* 128K */

/* M828xx memories defines */
#define M828XX_SDRAM_START	0x00000000
#define M828XX_SDRAM_SIZE	(16 * 1024 * 1024)	/* 16M */

#define M828XX_IRAM_START	0x09000000
#define M828XX_IRAM_SIZE	(136 * 1024)		/* 136K */

#define M828XX_ERAM_START	0x08000000
#define M828XX_ERAM_SIZE	(384 * 1024)		/* 384K */

#define M828XX_ARAM_START	0x0a000000
#define M828XX_ARAM_SIZE	(128 * 1024)		/* 128K */

/* M829xx memories defines */
#define M829XX_SDRAM_START	0x00000000
#define M829XX_SDRAM_SIZE	(32 * 1024 * 1024)	/* 32M */

/*CPRAM*/
#define M829XX_IRAM_START	0x0b000000
#define M829XX_IRAM_SIZE	(512 * 1024)		/* 512K */

#define M829XX_ERAM_START	0x08000000
#define M829XX_ERAM_SIZE	(3 * 1024 * 1024)	/* 3M */

#define M829XX_ARAM_START	0x0a000000
#define M829XX_ARAM_SIZE	(648 * 1024)		/* 640K */


#define SDRAM_INDEX	0
#define IRAM_INDEX	1
#define ERAM_INDEX	2
#define ARAM_INDEX	3


#define	MR4 4
#define	MR5 5
#define	MR6 6
#define	MR7 7
#define	MR8 8
#define	MR9 9
#define	MR10 10
#define	MR11 11
#define	MR12 12
#define	MR13 13
#define	MR14 14
#define	MR15 15
#define	MR16 16
#define	MR17 17
#define	MR18 18
#define	MR19 19
#define	MR20 20
#define	MR21 21
#define	MR22 22
#define	MR23 23
#define	MR24 24
#define	MR25 25

#endif
