/*! \file hwcfg.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _MIRO_HW_H_
#define _MIRO_HW_H_

#define PLL_CONTROL_REGISTER	0x100b0000	/* PLL Control register ARM */
#define PLL_WA1_VALUE		0x03000004
#define PLL_WA1_VALUE_M829XX	0xad000023

/*
 * SET_CLOCK parameters
 */
#define BRM_CLOCK_MULTIPLIER	((U16)0x14)
#define BRM_SETCLOCK_PARAM	(BRM_CLOCK_MULTIPLIER << 8)

/*
 * SET_ARM_CLKMODE	parameters
 */
#define BRM_ARM_CLKMODE		((U16)0x3)
#define BRM_ARM_CLKMODE_PARAM	(BRM_ARM_CLKMODE)
/*
 * SDRAM parameters
 */
#define SDRAM_PARAM_TRAS        ((U16)6)
#define SDRAM_PARAM_TRC         ((U16)8)
#define SDRAM_PARAM_TRCD        ((U16)3)
#define SDRAM_PARAM_TRP         ((U16)3)
#define SDRAM_PARAM_CL          ((U16)3)

#define SDRAM_PARAM_TIMING1     ((SDRAM_PARAM_TRAS<<13)|(SDRAM_PARAM_TRC<<9)| \
                (SDRAM_PARAM_TRCD <<6)|(SDRAM_PARAM_TRP<<3)|SDRAM_PARAM_CL)

#define SDRAM_PARAM_TIMING1_M829XX	((U16)0xD092) 

#define SDRAM_PARAM_TRC_M823XX		((U16)0xB)
#define SDRAM_PARAM_CL_M823XX		((U16)6)
#define SDRAM_PARAM_TIMING1_M823XX	((SDRAM_PARAM_TRAS<<13)|(SDRAM_PARAM_TRC_M823XX<<9)| \
					(SDRAM_PARAM_TRCD <<6)|(SDRAM_PARAM_TRP<<3)| \
					SDRAM_PARAM_CL_M823XX)

#define SDRAM_PARAM_TRC_M823XX_2	((U16)0xB)
#define SDRAM_PARAM_CL_M823XX_2	((U16)6)
#define SDRAM_PARAM_TIMING1_M823XX_2	((SDRAM_PARAM_TRAS<<13)|(SDRAM_PARAM_TRC_M823XX_2<<9)| \
					(SDRAM_PARAM_TRCD <<6)|(SDRAM_PARAM_TRP<<3)| \
					SDRAM_PARAM_CL_M823XX_2)

#define SDRAM_PARAM_MRS		((U16)1)
#define SDRAM_PARAM_BANKNUM	((U16)1)
#define SDRAM_PARAM_BANKWIDTH	((U16)1)
#define SDRAM_PARAM_TMRS	((U16)2)
#define SDRAM_PARAM_TRRD	((U16)2)

#define SDRAM_PARAM_TIMING2	((SDRAM_PARAM_MRS<<7)| \
		(SDRAM_PARAM_BANKNUM<<6)|(SDRAM_PARAM_BANKWIDTH << 5)| \
		(SDRAM_PARAM_TMRS << 2)|(SDRAM_PARAM_TRRD))

#define SDRAM_PARAM_TIMING2_M829XX 	((U16)0x03EA) 


#define SDRAM_PARAM_MDRIVE_M823XX 	((U16)1)
#define SDRAM_PARAM_MDSIZE_M823XX	((U16)2)
#define SDRAM_PARAM_TWR_M823XX		((U16)3)
#define SDRAM_PARAM_BANKWIDTH_M823XX	((U16)0)

#define SDRAM_PARAM_TIMING2_M823XX	((SDRAM_PARAM_MDRIVE_M823XX << 14)|(SDRAM_PARAM_MDSIZE_M823XX << 11)| \
		(SDRAM_PARAM_TWR_M823XX<<8)|(SDRAM_PARAM_MRS<<7)| \
		(SDRAM_PARAM_BANKNUM<<6)|(SDRAM_PARAM_BANKWIDTH_M823XX << 5)| \
		(SDRAM_PARAM_TMRS << 2)|(SDRAM_PARAM_TRRD))


#define SDRAM_PARAM_MDRIVE_M823XX_2 	((U16)1)
#define SDRAM_PARAM_MDSIZE_M823XX_2	((U16)2)
#define SDRAM_PARAM_TWR_M823XX_2	((U16)3)
#define SDRAM_PARAM_BANKWIDTH_M823XX_2	((U16)0)

#define SDRAM_PARAM_TIMING2_M823XX_2	((SDRAM_PARAM_MDRIVE_M823XX_2 << 14)|(SDRAM_PARAM_MDSIZE_M823XX_2 << 11)| \
		(SDRAM_PARAM_TWR_M823XX_2<<8)|(SDRAM_PARAM_MRS<<7)| \
		(SDRAM_PARAM_BANKNUM<<6)|(SDRAM_PARAM_BANKWIDTH_M823XX_2 << 5)| \
		(SDRAM_PARAM_TMRS << 2)|(SDRAM_PARAM_TRRD))

#define SDRAM_PARAM_REF_FREQ		((U16)0x0615)
#define SDRAM_PARAM_REF_FREQ_M823XX	((U16)0x0400)
#define SDRAM_PARAM_REF_FREQ_M829XX	((U16)0x0823) 
#define SDRAM_PARAM_POWERON		((U16)0x0042)
#define SDRAM_PARAM_REF_FREQ_M823XX_2	((U16)0x0400)

/*
 * Chip select 0 (CS0) parameters 
 */
#define CS0_PARAM_DWIDTH	((U16)0)
#define CS0_PARAM_ASETUP_MSB	((U32)0)
#define CS0_PARAM_MEMTYP	((U16)1)
#define CS0_PARAM_ASETUP_LBS	((U32)0)
#define CS0_PARAM_CSLVL		((U16)0)
#define CS0_PARAM_DQMMOD	((U16)0)
#define CS0_PARAM_CSW		((U16)0)

/* Device refclk types for M823XX*/
#define DEVICE_REFCLK_10MHZ	((U16)10)
#define DEVICE_REFCLK_25MHZ	((U16)25)

/* Device AMBA clk types for M823V2*/
#define DEVICE_AMBA_M823V2_137MHZ	((U16)137)
#define DEVICE_AMBA_M823V2_150MHZ	((U16)150)

/* the bus number defines */
#define PLL_BUS_ARM		((U16)0)
#define PLL_BUS_SPU		((U16)1)
#define PLL_BUS_AMBA		((U16)2)

/* ARM refclk defines for 10MHz refclk (M823XX) */
#define PLL_REFCLK_M823XX_10MHZ_ARM_NR		((U8)19)
#define PLL_REFCLK_M823XX_10MHZ_ARM_OD		((U8)0)
#define PLL_REFCLK_M823XX_10MHZ_ARM_NF		((U16)1749)

/* ARM refclk defines for 25MHz refclk (M823XX) */
#define PLL_REFCLK_M823XX_25MHZ_ARM_NR		((U8)49)
#define PLL_REFCLK_M823XX_25MHZ_ARM_OD		((U8)0)
#define PLL_REFCLK_M823XX_25MHZ_ARM_NF		((U16)1749)

/* SPU refclk defines (M823XX) */
#define PLL_REFCLK_M823XX_SPU_NR		((U8)9)
#define PLL_REFCLK_M823XX_SPU_OD		((U8)1)
#define PLL_REFCLK_M823XX_SPU_NF		((U16)1499)

/* 133MHz AMBA defines for 10MHz refclk (M823XX) */
#define PLL_REFCLK_M823XX_10MHZ_AMBA_NR	((U8)9)
#define PLL_REFCLK_M823XX_10MHZ_AMBA_OD	((U8)0)
#define PLL_REFCLK_M823XX_10MHZ_AMBA_NF	((U16)531)

/* 133MHz AMBA defines for 25MHz refclk (M823XX) */
#define PLL_REFCLK_M823XX_25MHZ_AMBA_NR	((U8)24)
#define PLL_REFCLK_M823XX_25MHZ_AMBA_OD	((U8)0)
#define PLL_REFCLK_M823XX_25MHZ_AMBA_NF	((U16)531)

/* 550MHz ARM clk defines (M823V2) */
#define PLL_REFCLK_M823V2_ARM_550MHZ_NR	((U8)0)
#define PLL_REFCLK_M823V2_ARM_550MHZ_OD	((U8)0)
#define PLL_REFCLK_M823V2_ARM_550MHZ_NF	((U16)43)

/* 425MHz SPU clk defines (M823V2) */
#define PLL_REFCLK_M823V2_SPU_425MHZ_NR	((U8)0)
#define PLL_REFCLK_M823V2_SPU_425MHZ_OD	((U8)0)
#define PLL_REFCLK_M823V2_SPU_425MHZ_NF	((U16)33)

/* 150MHz AMBA clk defines (M823V2) */
#define PLL_REFCLK_M823V2_AMBA_150MHZ_NR	((U8)0)
#define PLL_REFCLK_M823V2_AMBA_150MHZ_OD	((U8)1)
#define PLL_REFCLK_M823V2_AMBA_150MHZ_NF	((U16)47)

/* 450MHz ARM clk defines (M823V2) */
#define PLL_REFCLK_M823V2_ARM_450MHZ_NR	((U8)0)
#define PLL_REFCLK_M823V2_ARM_450MHZ_OD	((U8)0)
#define PLL_REFCLK_M823V2_ARM_450MHZ_NF	((U16)35)

/* 350MHz SPU clk defines (M823V2) */
#define PLL_REFCLK_M823V2_SPU_350MHZ_NR	((U8)0)
#define PLL_REFCLK_M823V2_SPU_350MHZ_OD	((U8)1)
#define PLL_REFCLK_M823V2_SPU_350MHZ_NF	((U16)55)

/* 137.5MHz AMBA clk defines (M823V2) */
#define PLL_REFCLK_M823V2_AMBA_137MHZ_NR	((U8)0)
#define PLL_REFCLK_M823V2_AMBA_137MHZ_OD	((U8)1)
#define PLL_REFCLK_M823V2_AMBA_137MHZ_NF	((U16)43)

#define CS0_PARAM_TIMING	((CS0_PARAM_DWIDTH<<11)|\
				(CS0_PARAM_ASETUP_MSB<<10)|\
				(CS0_PARAM_MEMTYP << 9)|\
				(CS0_PARAM_ASETUP_LBS << 7)|\
				(CS0_PARAM_CSLVL << 6)|\
				(CS0_PARAM_DQMMOD << 5)|\
				(CS0_PARAM_CSW << 1))

#define CS0_PARAM_TIMING_M823XX_2	0x200

#define CS0_PARAM_SIZE_16M		((U16)0x000C)
#define CS0_PARAM_SIZE_32M		((U16)0x000D)

#define EMAC_ARCCTRL 0x100DE344
#define ADDRESS_COMPARISON_ENABLE  (1<<4) /* 0x0010*/ 
#endif
