/*! \file appitf.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */


#ifndef _APPITF_H_
#define _APPITF_H_

/** User data structure for VFSM_BootDevice */
typedef struct _SBootDevUserData {
	U32 uImageSize;
	void *pvImageFile;
	char strFileName[256];
	SHwCfg *pstSHwCfg; /**< pointer on structure with modified HW params */
} SBootDevUserData;

/** Userdata structure for VFSM_Loopback*/
typedef struct _SLpbackUserData {
	CONNID ConnId2;
	ELoopbackType eLoopback;
} SLpbackUserData;

typedef struct _SPtmngUserData {
	ECodecType eCodec;
	U16 usPTIndex;
	U8 ucPlTypVal;
	U8 ucDir;
} SPtmngUserData;

typedef struct _SHoldStateData {
	EHoldState eHoldState;
	U16 usMspPartId;
	U16 usMspConfId;
	U32 usSrcPartId;
} SHoldStateData;

typedef struct _SNteEventUserData {
	U32 uiNtePyLd;
	U16 usOverRideBitField;
	U16 usRedundancyInterval;
	U32 uiSsrc;
	U16 usPyLdType;
} SNteEventUserData;

/** Userdata structure for VAPI_StartCallerIdGen*/
typedef struct _SStartCIDUserData {
	U8 *ucMsgString;
	SCallerIdParams *pstCallerIdParams;
} SStartCIDUserData;

/** Userdata structure for VAPI_SetParticipantDgain*/
typedef struct _SDgainStateData {
	U16 usMspPartId;
	U16 usMspConfId;
	U16 usGain;
} SDgainStateData;

/** Userdata structure for VAPI_SetParticipantOpt*/
typedef struct _SRFC2833StateData {
	U16 usMspPartId;
	U16 usMspConfId;
	U16 usRfc2833OnOff;
} SRFC2833StateData;

/** Userdata structure for VAPI_MuteParticipant*/
typedef struct _SParticipantData {
	U16 usMspPartId;
	U16 usMspConfId;
	U16 usIsMute;
} SParticipantData;

VSTATUS APPITF_CreateParticipant(IN CONFID ConfId,
				 IN PARTID PartId,
				 IN U16 usTdmTimeSlot,
				 IN U8 ucAU_Law,
				 IN EPartType ePartType,
				 IN SRequest * pstRequest, IN PFNEventCallback pfnEventCallback);

VSTATUS APPITF_CloseDevice(IN SDevice * pstDevice, IN ECloseMode eMode);

#define LOG_PARAM INFO
#define LOG_CREATE_CONNECTION_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_CreateConnection: %u,%u,%u,%u,%u,0x%08x,0x%08x\n", \
						DevId,  \
						ConnId,  \
						eConnType, \
						usTdmTimeSlot, \
						ucAU_Law,      \
						pstRequest,   \
						pfnEventCallback); \

#define LOG_ALLOCATE_CONNECTION_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_AllocateConnection: %u,%u,%u,%u,%u,0x%08x,0x%08x,0x%08x\n", \
						DevId,  \
						ConnId,  \
						eConnType, \
						eConnMode, \
						ucNumOfParams, \
						pusParams,      \
						pstRequest,   \
						pfnEventCallback); \

#define LOG_RECOVER_CONNECTION_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_RecoverConnection: %u,%u,%u,%u,0x%08x,0x%08x\n", \
						DevId,  \
						ConnId,  \
						eConnType, \
						usTdmTimeSlot, \
						pstRequest,   \
						pfnEventCallback); \

#define LOG_DESTROY_CONNECTION_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_DestroyConnection: %u,0x%08x\n", ConnId, pstRequest);
#define LOG_SET_CONNECTION_OPMODE_PARAMS UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetConnectionState: %u, %u, 0x%08x\n", ConnId, eOpMode, pstRequest);
#define LOG_ENABLE_CONNECTION_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_EnableConnection: %u,0x%08x\n", ConnId, pstRequest);
#define	LOG_DISABLE_CONNECTION_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_DisableConnection: %u,0x%08x\n", ConnId, pstRequest);
#define	LOG_LOOPBACK_PARAMS		UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_Loopback: %u,%u,%u,0x%04x\n", ConnId1, ConnId2, eLoopback, pstRequest);
#define	LOG_STARTTONE_PARAMS		UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_StartTone: %u,%u,%u,%u,0x%08x\n", ConnId, ucDir, eToneId, eCountryCode, pstRequest);
#define	LOG_PLAYTONE_PARAMS		UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_PlayTone: %u,%u,%u,0x%08x,%u,0x%08x\n", ConnId, eToneId, eToneDir, pstPlayToneOpt, usParamNum, pstRequest);
#define	LOG_STOPTONE_PARAMS		UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_StopTone: %u,%u,0x%08x\n", ConnId, usToneDuration, pstRequest);

#define	LOG_START_CALLER_ID_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_StartCallerId: %u,%u,%u\n", \
						pstCidInfo->MsgLen, \
 						pstCidInfo->bIsOnHook, \
 						pstCidInfo->eCountryCode);

#define	LOG_PLAY_CALLER_ID_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_PlayCid: %u,%u,%u\n", \
						pstCidInfo->MsgLen, \
 						pstCidInfo->bIsOnHook, \
 						pstCidInfo->ucModulType);

#define	LOG_STOP_CALLER_ID_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_StopCallerId: %u,0x%08x\n", ConnId, pstRequest);
#define	LOG_ENABLE_CID_DETECTION_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_EnableCIDDetection: %u,%u,%u,0x%08x\n", ConnId, eCountryCode, ucEnableType, pstRequest);

#define	LOG_ENABLE_SET_CID_DETECTION_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetCidDetection: %u,%u,%u,0x%08x\n", ConnId, pstCidDetCtrl->usCidEnable, pstCidDetCtrl->usHookStatus, pstRequest);

#define	LOG_SET_CODEC_TYPE_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetCodecType: %u,%u,0x%08x\n", ConnId, eCodecIndex, pstRequest);
#define	LOG_SET_PACKET_INTERVAL_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetPacketInterval: %u,%u,0x%08x\n", ConnId, ucMilliSec, pstRequest);
#define	LOG_SET_PAYLOAD_TYPE_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetPayloadType: %u,%u,%u,%u,0x%08x\n", ConnId, eCodec, ucPlTypVal, eDir, pstRequest);
#define	LOG_SET_ECHOCANCELLOR_RESET_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_EchoCancellerReset: %u,0x%08x\n", ConnId, pstRequest);

#define	LOG_SEND_NTE_EVENT_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SendNteEvent: %u,%u,%u,%u,%u,%u,0x%08x\n",\
						ConnId,    \
						uiNtePyLd,  \
						usOverRideBitField, \
						usRedundancyInterval, \
						uiSsrc, \
						usPyLdType, \
						pstRequest);

#define LOG_SET_RTP_SSRC_HDR_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetRtpSsrcHeader: %u,%u,0x%08x\n", ConnId, uiSsrcVal, pstRequest);

#define	LOG_START_RECORD_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_StartRecord: %u,%u,%u,%u,%u,0x%08x,%u,0x%08x,0x%08x\n", \
						ConnId,   \
						pstRecData->eMediaHost, \
						pstRecData->eCodingScheme,  \
						pstRecData->eSourceType,  \
						pstRecData->uiTimeOut,  \
						pstRecData->pucBuffer,  \
						pstRecData->uiBufferLength,  \
						pstRecData->pfnFrameHndlr, \
						pstRequest);

#define	LOG_STOP_RECORD_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_StopRecord: %u,%u,0x%08x\n", ConnId, eStopAnnType, pstRequest);

#define	LOG_START_PLAYBACK_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_StartPlayback: %u,%u,%u,%u,%u,%u,0x%08x,%u,0x%08x\n", \
						ConnId,   \
						pstPlayData->eMediaHost, \
						pstPlayData->eCodingScheme,  \
						pstPlayData->eDestinationType,  \
						pstPlayData->ePlaybackMode,  \
						pstPlayData->uiTimeOut, \
						pstPlayData->pucBuffer, \
						pstPlayData->uiBufferLength, \
						pstRequest);  \

#define	LOG_STOP_PLAYBACK_PARAMS		UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_StopPlayback: %u,%u,0x%08x\n", ConnId, eStopAnnType, pstRequest);

#define	LOG_PLAYBACK_SET_RATE_PARAMS		UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_PlaybackSetRate: %u,%u,0x%08x\n", ConnId, ePlaybackRate, pstRequest);

#define	LOG_CONVERT_HOST_SPEECH_DATA_PARAMS UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_ConvertHostSpeechData: %u,0x%08x,%u,%u,0x%08x,%u,%u,0x%08x\n", \
						ConnId,  \
						pstConvertData->pucSrcBuffer,  \
						pstConvertData->uiSrcBufferLength,  \
						pstConvertData->ucCurrentCoding, \
						pstConvertData->pucOutBuffer,  \
						pstConvertData->uiOutBufferLength, \
						pstConvertData->ucNewCoding, \
						pstRequest);

#define	LOG_CONFIGURE_T38_OPTIONS_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_ConfigureT38Options: %u,%u,%u,%u,%u,%u,%u,%u,%u,%u,0x%08x\n", \
						ConnId,  \
						pstFaxConfigOpts->bUseExistingOpts,  \
						pstFaxConfigOpts->stFaxOpts.ucT38PktLossConcealment, \
						pstFaxConfigOpts->stFaxOpts.ucECMDisable, \
						pstFaxConfigOpts->stFaxOpts.ucFaxDataRedundancyCnt, \
						pstFaxConfigOpts->stFaxOpts.ucT30RedundancyCnt,  \
						pstFaxConfigOpts->stFaxOpts.ucFaxConnSpeedLimit, \
						pstFaxConfigOpts->stFaxOpts.ucErrRcvyMethod, \
						pstFaxConfigOpts->stFaxOpts.ucTCFProcedure,  \
						pstFaxConfigOpts->stFaxOpts.ucNumFEC, \
						pstFaxConfigOpts->stFaxOpts.ucNumIFPs, \
						pstFaxConfigOpts->ucFaxTxLevel,   \
						pstFaxConfigOpts->bEnableFaxAutoSwitch, \
						pstFaxConfigOpts->usSwitchoverEventMask, \
						pstRequest);

#define	LOG_SWITCH_TO_T38_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SwitchToT38: %u,%u,%u,%u,%u,%u,%u,%u,%u,%u,0x%08x\n", \
						ConnId,  \
						pstFaxConfigOpts->bUseExistingOpts,  \
						pstFaxConfigOpts->stFaxOpts.ucT38PktLossConcealment, \
						pstFaxConfigOpts->stFaxOpts.ucECMDisable, \
						pstFaxConfigOpts->stFaxOpts.ucFaxDataRedundancyCnt, \
						pstFaxConfigOpts->stFaxOpts.ucT30RedundancyCnt, \
						pstFaxConfigOpts->stFaxOpts.ucFaxConnSpeedLimit, \
						pstFaxConfigOpts->stFaxOpts.ucErrRcvyMethod, \
						pstFaxConfigOpts->stFaxOpts.ucTCFProcedure, \
						pstFaxConfigOpts->stFaxOpts.ucNumFEC,  \
						pstFaxConfigOpts->stFaxOpts.ucNumIFPs,  \
						pstFaxConfigOpts->ucFaxTxLevel,         \
						pstFaxConfigOpts->bEnableFaxAutoSwitch, \
						pstFaxConfigOpts->usSwitchoverEventMask, \
						pstRequest);

#define LOG_SET_CONN_IP_PARAMS		UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetConnIpParams: %u,0x%08x,%u,0x%08x,%u,0x%08x\n",\
						ConnId, \
						pstIpParams->uiDestIpAddr, \
						pstIpParams->usDestUdpPort, \
						pstIpParams->uiSrcIpAddr, \
						pstIpParams->usSrcUdpPort, \
						pstRequest);

#define	LOG_CREATE_CONFERENCE_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_CreateConference: %u,%u,%u,%u,%u,%u,%u,%u,%u,%u,%u,0x%08x\n", \
						DevId, \
						ConfId, \
						pstConfParams->bTranscoding,  \
						pstConfParams->bBlockDTMF,    \
						bIsEnhancedConf, \
						pstConfDTSParams->bDTSOnOff,   \
						pstConfDTSParams->usAttackConst, \
						pstConfDTSParams->usNTH1, \
						pstConfDTSParams->usNTH2,  \
						pstConfDTSParams->usHoldConst, \
						pstConfDTSParams->usN1, \
						pstConfDTSParams->usG1, \
						pstConfDTSParams->usN2, \
						pstConfDTSParams->usG2, \
						pstConfDTSParams->usN3, \
						pstConfDTSParams->usG3, \
						pstRequest);

#define	LOG_DESTROY_PARTICIPANT_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_DestroyParticipant: %u,0x%08x\n", PartId, pstRequest);
#define	LOG_DESTROY_CONFERENCE_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_DestroyConference: %u,0x%08x\n", ConfId, pstRequest);
#define	LOG_ENABLE_PARTICIPANT_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_EnableParticipant: %u,0x%08x\n", PartId, pstRequest);
#define	LOG_DISABLE_PARTICIPANT_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_DisableParticipant: %u,0x%08x\n", PartId, pstRequest);
#define	LOG_PUT_PARTICIPANT_ONHOLD_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_PutParticipantOnHold: %u,%u,%u,0x%08x\n", \
						PartId, \
						eHoldState, \
						uiSrcPartId, \
						pstRequest);

#define	LOG_MUTE_PARTICIPANT_ONHOLD_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_MuteParticipant: %u,%u,0x%08x\n", PartId, bMute, pstRequest);
#define	LOG_CREATE_TDM_SIDE_PARTICIPANT_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_CreateTdmSideParticipant: %u,%u,%u,%u,0x%08x,0x%08x\n", \
						ConfId, \
						PartId, \
						usTdmTimeSlot, \
						ucAU_Law,  \
						pstRequest, \
						pfnEventCallback); \

#define	LOG_CREATE_IP_SIDE_PARTICIPANT_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_CreateIpSideParticipant: %u,%u,0x%04x,0x%04x\n", \
						ConfId, \
						PartId, \
						pstRequest, \
						pfnEventCallback);

#define	LOG_CREATE_TRANSCODING_PARTICIPANT_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_CreateTranscodingParticipant: %u,%u,0x%04x,0x%04x\n", \
						ConfId, \
						PartId, \
						pstRequest, \
						pfnEventCallback);

#define LOG_SET_PARTICIPANT_DGAIN_PARAMS      UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetParticipantDgain: %u,%u,0x%08x\n", PartId, usGain, pstRequest);

#define LOG_SET_PARTICIPANT_OPT_PARAMS      UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetParticipantOpt: %u,%u,0x%08x\n", PartId, usRfc2833OnOff, pstRequest); 

#define	LOG_DEVICE_INIT_PARAMS	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_InitDevice: %u,%u,%u,0x%04x,0x%04x\n", \
						DevId, \
						ulOperationModeId, \
						ulProfileId, \
						pulUserParams, \
						pstRequest);

#define LOG_SET_CONFERENCE_LATENCY_PARAMS      UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetConferenceLatency: %u,%u,0x%08x\n", DevId, usLatency, pstRequest); 

#define LOG_SET_CONFERENCE_DGAIN_PARAMS      UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SetConferenceDgain: %u,%u,0x%08x\n", DevId, usGain, pstRequest); 

#define	LOG_SEND_H245_MESSAGE	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_SendH245Message: %u,%u,0x%08x,0x%08x\n", \
						ConnId,   \
						uiH245MsgLength, \
						ptrH245Msg,  \
						pstRequest);  \

#define	LOG_CHANGE_CONNECTION_TYPE	UT_Log(APPITF, LOG_PARAM, "VAPI param debug: VAPI_ChangeConnectionType: %u,%u,%u,%u,%u,%u,0x%08x,0x%08x\n", \
						ConnId, \
						pstChangeConnInfo->eConnType, \
						pstChangeConnInfo->eConnMode, \
						pstChangeConnInfo->ePartType, \
						pstChangeConnInfo->eChangeOpMode, \
						NumParam, \
						pusParams, \
						pstRequest); \

#endif

