/*! \file avl.h 
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _AVL_H
#define _AVL_H

#ifdef __cplusplus
extern "C" {
#endif

#include "ut_port.h"

/* Data structures */

/* One element of the AVL tree */
typedef struct _SAVL {
	struct _SAVL *pstLeft;
	struct _SAVL *pstRight;
	signed char cBalance;
} SAVL;

/* An AVL tree */
typedef struct _SAVL_Tree {
	SAVL *pstRoot;
	int (*pfnCompare) (void *pvA, void *pvB);
} SAVL_Tree;

/* Public methods */

/* Insert element a into the AVL tree 
 * returns 1 if the depth of the tree has grown
 * Warning: do not insert elements already present
 */
INT __AVL_Insert(SAVL_Tree *pstTree, SAVL *pstA);

/* Remove an element a from the AVL tree 
 * returns -1 if the depth of the tree has shrunk
 * Warning: if the element is not present in the tree, 
 *          returns 0 as if it had been removed succesfully.
 */
INT __AVL_Remove(SAVL_Tree *pstTree, SAVL *pstA);

/* Remove the root of the AVL tree 
 * Warning: dumps core if pstTree is empty
 */
INT __AVL_RemoveRoot(SAVL_Tree *pstTree);

SAVL *__AVL_Search(SAVL_Tree *pstTree, SAVL *pstA);

#ifdef __cplusplus
};
#endif

#endif /* _AVL_H */
