/*! \file tmap_devinfo.h 
 *
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef _TMAP_DEVINFO_H
#define _TMAP_DEVINFO_H

#include "gtl.h"

#if defined NOPCI && defined NOETH && defined NOPOS
#error "NOPCI and NOETH and NOPOS cannot be defined simultaneously"
#endif

#ifndef NOETH
extern int TETH_Init(IN GTL_READ_CB pfnReadCb, OUT STAdapterFns * pstAdapterFns, SGtlDeviceInfo *, U32);
#endif

#ifndef NOPCI
extern int TPCI_Init(IN GTL_READ_CB pfnReadCb, OUT STAdapterFns * pstAdapterFns, SGtlDeviceInfo *, U32);
#endif

#ifndef NOPOS
extern int TSP3_Init(IN GTL_READ_CB pfnReadCb, OUT STAdapterFns * pstAdapterFns, SGtlDeviceInfo *, U32);
#endif

#define PCI_DEVICES 2
#define ETH_DEVICES 4
#define POS_DEVICES 11		/* 8 master over TSP3, 3 slave over TSP3 */

#define INVALID_ITF_IDX     0xFFFFFFFF

extern SItfDesc astItfList[];
extern SGtlDeviceInfo *pastDevList;

#endif
