/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_VOIP_API_H_
#define _COMCERTO_VOIP_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
CAQR:VoIP_VOPENA (Function code=0x8000, class=0x02, type=0x00)
************************************************************/
struct _VOIP_VOPENA
{
	/* parameter [4] */
	_u_16_ mode;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15> */
			_u_16_ rtp_m:1;

			/* parameter [5] bit(s) <14:8> */
			_u_16_ rtp_pt:7;

			/* parameter [5] bit(s) <7:6> */
			_u_16_ rtp_v:2;

			/* parameter [5] bit(s) <5> */
			_u_16_ rtp_p:1;

			/* parameter [5] bit(s) <4> */
			_u_16_ rtp_x:1;

			/* parameter [5] bit(s) <3:0> */
			_u_16_ rtp_cc:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	/* parameter [6] */
	_u_16_ rtp_seq;

	/*parameters [7:8]*/
	_u_32_ rtp_timestamp;	/*default=0x0*/
	/*parameters [9:10]*/
	_u_32_ rtp_ssrc;	/*default=0x0*/
	/*parameters [11:12]*/
	_u_32_ rtp_csrc1;	/*default=0x0*/
	/*parameters [13:14]*/
	_u_32_ rtp_csrc2;	/*default=0x0*/

} ATTRIBUTE_PACKED;


/************************************************************
CAQR:VoIP_VOPDIS (Function code=0x9600, class=0x02, type=0x00)
************************************************************/
struct _VOIP_VOPDIS
{
	/* parameter [4] */
	_u_16_ mode;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:VoIP_VCEOPT (Function code=0x8001, class=0x02, type=0x00)
************************************************************/
struct _VOIP_VCEOPT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ packet_interval:8;

			/* parameter [4] bit(s) <7:6> */
			_u_16_ vadtype:2;

			/* parameter [4] bit(s) <5> */
			_u_16_ adaptive_post_filter:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ g_723_rate:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ packet_generation:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ g_723_dc_removal:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ cng:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ compander:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15> */
			_u_16_ pkt_recept:1;

			/* parameter [5] bit(s) <14> */
			_u_16_ udptl:1;

			/* parameter [5] bit(s) <13> */
			_u_16_ packing:1;

			/* parameter [5] bit(s) <12:10> */
			_u_16_ amr_mode:3;

			/* parameter [5] bit(s) <9> */
			_u_16_ reserved5_bit_9:1;

			/* parameter [5] bit(s) <8> */
			_u_16_ reserved5_bit_8:1;

			/* parameter [5] bit(s) <7> */
			_u_16_ reserved5_bit_7:1;

			/* parameter [5] bit(s) <6> */
			_u_16_ reserved5_bit_6:1;

			/* parameter [5] bit(s) <5:4> */
			_u_16_ redundancy:2;

			/* parameter [5] bit(s) <3:2> */
			_u_16_ reserved5_bits_3_2:2;

			/* parameter [5] bit(s) <1:0> */
			_u_16_ reserved5_bits_1_0:2;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	/* parameter [6] */
	_u_16_ vad_tune;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:8> */
			_u_16_ g711_model:8;

			/* parameter [7] bit(s) <7:0> */
			_u_16_ cng_model:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15> */
			_u_16_ amr_frame_format:1;

			/* parameter [8] bit(s) <14:11> */
			_u_16_ reserved:4;

			/* parameter [8] bit(s) <10> */
			_u_16_ transcode_mode:1;

			/* parameter [8] bit(s) <9> */
			_u_16_ amr_wb_crc:1;

			/* parameter [8] bit(s) <8:5> */
			_u_16_ amr_wb_rate:4;

			/* parameter [8] bit(s) <4> */
			_u_16_ cdma_rate:1;

			/* parameter [8] bit(s) <3> */
			_u_16_ g729eg_rate:1;

			/* parameter [8] bit(s) <2> */
			_u_16_ crc_for_amr:1;

			/* parameter [8] bit(s) <1> */
			_u_16_ bits_per_sample:1;

			/* parameter [8] bit(s) <0> */
			_u_16_ plc_cfg:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:VoIP_DTMFOPT (Function code=0x8002, class=0x02, type=0x00)
************************************************************/
struct _VOIP_DTMFOPT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:9> */
			_u_16_ reserved4_bits_15_9:7;

			/* parameter [4] bit(s) <8> */
			_u_16_ ssrc:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ silence_removal:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ rfc_packet_format:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ event_report:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ regeneration:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ removal:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ redundancy:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ dtmf_rtp:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ dtmf_voice:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ dtmf_pt;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:VoIP_DGAIN (Function code=0x8005, class=0x02, type=0x00)
************************************************************/
struct _VOIP_DGAIN
{
	/* parameter [4] */
	_u_16_ packet_to_pcm_gain;

	/* parameter [5] */
	_u_16_ pcm_to_packet_gain;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:VoIP_ECHOCAN (Function code=0x8006, class=0x02, type=0x00)
************************************************************/
struct _VOIP_ECHOCAN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ ecenb:1;

			/* parameter [4] bit(s) <14> */
			_u_16_ ec_dc_removal:1;

			/* parameter [4] bit(s) <13> */
			_u_16_ ec_h_reset:1;

			/* parameter [4] bit(s) <12> */
			_u_16_ ecinit:1;

			/* parameter [4] bit(s) <11> */
			_u_16_ hecfrz:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ nlp:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ reserved4_bit_9:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ reserved4_bit_8:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ nlptune_hi:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ cng:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ reserved4_bit_5:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ nlptune_lo:1;

			/* parameter [4] bit(s) <3:0> */
			_u_16_ heclen:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:VoIP_DFECAN (Function code=0x80E3, class=0x02, type=0x00)
************************************************************/
struct _VOIP_DFECAN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ ecenb:1;

			/* parameter [4] bit(s) <14> */
			_u_16_ ecdcd:1;

			/* parameter [4] bit(s) <13> */
			_u_16_ ectts:1;

			/* parameter [4] bit(s) <12> */
			_u_16_ ecinit:1;

			/* parameter [4] bit(s) <11> */
			_u_16_ ecfrz:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ ecnlp:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ ecdyn:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ ecbnr:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ ecspf:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ eccng:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ ecflt:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ ecrdc:1;

			/* parameter [4] bit(s) <3:0> */
			_u_16_ eclen:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;



/************************************************************
CAQR:VoIP_DFECTUNE (Function code=0x80E4, class=0x02, type=0x00)
************************************************************/
struct _VOIP_DFECTUNE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ cont:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ index0;

	/* parameter [6] */
	_u_16_ value0;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:VoIP_TONEGEN (Function code=0x8009, class=0x02, type=0x00)
************************************************************/
struct _VOIP_TONEGEN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ cadence_rpt:8;

			/* parameter [4] bit(s) <7> */
			_u_16_ reserved4_bit_7:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ concurrently:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ mix_mode_off:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ mix_mode_on:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ prot_gen:1;

			/* parameter [4] bit(s) <2:1> */
			_u_16_ timestamp_ctrl:2;

			/* parameter [4] bit(s) <0> */
			_u_16_ tone_dir:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ start_ts_l;

	/* parameter [6] */
	_u_16_ start_ts_m;

	/* parameter [7] */
	_u_16_ lim_ts_l;

	/* parameter [8] */
	_u_16_ lim_ts_m;

	/* parameter [9] */
	_u_16_ reserved9;

	/* parameter [10] */
	_u_16_ reserved10;

	/* parameter [11] */
	_u_16_ reserved11;

	/* parameter [12] */
	_u_16_ prim_tone_freq;

	/* parameter [13] */
	_u_16_ prim_tone_amp;

	/* parameter [14] */
	_u_16_ sec_tone_freq;

	/* parameter [15] */
	_u_16_ sec_tone_amp;

	/* parameter [16] */
	_u_16_ on_time;

	/* parameter [17] */
	_u_16_ off_time;

	/* parameter [18] */
	_u_16_ reserved18;

	/* parameter [19] */
	_u_16_ reserved19;

	/* parameter [20] */
	_u_16_ prim_tone_freq2;

	/* parameter [21] */
	_u_16_ prim_tone_amp2;

	/* parameter [22] */
	_u_16_ sec_tone_freq2;

	/* parameter [23] */
	_u_16_ sec_tone_amp2;

	/* parameter [24] */
	_u_16_ on_time2;

	/* parameter [25] */
	_u_16_ off_time2;

	/* parameter [26] */
	_u_16_ reserved26;

	/* parameter [27] */
	_u_16_ reserved27;

	/* parameter [28] */
	_u_16_ prim_tone_freq3;

	/* parameter [29] */
	_u_16_ prim_tone_amp3;

	/* parameter [30] */
	_u_16_ sec_tone_freq3;

	/* parameter [31] */
	_u_16_ sec_tone_amp3;

	/* parameter [32] */
	_u_16_ on_time3;

	/* parameter [33] */
	_u_16_ off_time3;

	/* parameter [34] */
	_u_16_ reserved34;

	/* parameter [35] */
	_u_16_ reserved35;

	/* parameter [36] */
	_u_16_ prim_tone_freq4;

	/* parameter [37] */
	_u_16_ prim_tone_amp4;

	/* parameter [38] */
	_u_16_ sec_tone_freq4;

	/* parameter [39] */
	_u_16_ sec_tone_amp4;

	/* parameter [40] */
	_u_16_ on_time4;

	/* parameter [41] */
	_u_16_ off_time4;

	/* parameter [42] */
	_u_16_ reserved42;

	/* parameter [43] */
	_u_16_ reserved43;

	/* parameter [44] */
	_u_16_ prim_tone_freq5;

	/* parameter [45] */
	_u_16_ prim_tone_amp5;

	/* parameter [46] */
	_u_16_ sec_tone_freq5;

	/* parameter [47] */
	_u_16_ sec_tone_amp5;

	/* parameter [48] */
	_u_16_ on_time5;

	/* parameter [49] */
	_u_16_ off_time5;

	/* parameter [50] */
	_u_16_ reserved50;

	/* parameter [51] */
	_u_16_ reserved51;


} ATTRIBUTE_PACKED;



/************************************************************
I:VoIP_TONEDET (Function code=0x800D, class=0x02, type=0x03)
************************************************************/
struct _VOIP_TONEDET_IND
{
	/* parameter [4] */
	_u_16_ tone;

	/*parameters [5:6]*/
	_u_32_ timestamp;
	/* parameter [7] */
	_u_16_ level;


} ATTRIBUTE_PACKED;

/************************************************************
I:VoIP_SSRCCHG (Function code=0x800E, class=0x02, type=0x03)
************************************************************/
struct _VOIP_SSRCCHG_IND
{
	/*parameters [4:5]*/
	_u_32_ ssrc;

} ATTRIBUTE_PACKED;

/************************************************************
I:VoIP_PTCHNG (Function code=0x800F, class=0x02, type=0x03)
************************************************************/
struct _VOIP_PTCHNG_IND
{
	/* parameter [4] */
	_u_16_ pt;

	/* parameter [5] */
	_u_16_ reserved5;


} ATTRIBUTE_PACKED;

/************************************************************
I:VoIP_TCMPLT (Function code=0x8010, class=0x02, type=0x03)
************************************************************/
struct _VOIP_TCMPLT_IND
{
	/* parameter [4] */
	_u_16_ reason;

	/* parameter [5] */
	_u_16_ tonedir;


} ATTRIBUTE_PACKED;

/************************************************************
CAQR:VoIP_LOOPBACK (Function code=0x8012, class=0x02, type=0x00)
************************************************************/
struct _VOIP_LOOPBACK
{
	/* parameter [4] */
	_u_16_ mode;

	/* parameter [5] */
	_u_16_ dest_channel;


} ATTRIBUTE_PACKED;

/************************************************************
CAQR:VoIP_TONEOFF (Function code=0x8014, class=0x02, type=0x00)
************************************************************/
struct _VOIP_TONEOFF
{
	/* parameter [4] */
	_u_16_ wait;

	/* parameter [5] */
	_u_16_ tonedir;


} ATTRIBUTE_PACKED;

/************************************************************
I:VoIP_EVENTDET (Function code=0x8017, class=0x02, type=0x03)
************************************************************/
struct _VOIP_EVENTDET_IND
{
	/* parameter [4] */
	_u_16_ event;

	/*parameters [5:6]*/
	_u_32_ timestamp;

} ATTRIBUTE_PACKED;

/************************************************************
CAQR:VoIP_PTMNG (Function code=0x8018, class=0x02, type=0x00)
************************************************************/
struct _VOIP_PTMNG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ redundant_dtmf:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ generic_comfort_noise:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:8> */
			_u_16_ t_38:8;

			/* parameter [5] bit(s) <7:0> */
			_u_16_ rtp_dtmf:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:8> */
			_u_16_ g_711_alaw:8;

			/* parameter [6] bit(s) <7:0> */
			_u_16_ g_711_mulaw:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:8> */
			_u_16_ g_728:8;

			/* parameter [7] bit(s) <7:0> */
			_u_16_ g_723_1:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:8> */
			_u_16_ g_726_32:8;

			/* parameter [8] bit(s) <7:0> */
			_u_16_ g_729a:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [9] bit(s) <15:8> */
			_u_16_ gsm_fr:8;

			/* parameter [9] bit(s) <7:0> */
			_u_16_ g_727:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [10] bit(s) <15:8> */
			_u_16_ passthrough_mulaw:8;

			/* parameter [10] bit(s) <7:0> */
			_u_16_ clear_channel:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_10;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [11] bit(s) <15:8> */
			_u_16_ g_726_16:8;

			/* parameter [11] bit(s) <7:0> */
			_u_16_ passthrough_alaw:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_11;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [12] bit(s) <15:8> */
			_u_16_ g_726_40:8;

			/* parameter [12] bit(s) <7:0> */
			_u_16_ g_726_24:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_12;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [13] bit(s) <15:8> */
			_u_16_ amr:8;

			/* parameter [13] bit(s) <7:0> */
			_u_16_ gsm_efr:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_13;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [14] bit(s) <15:8> */
			_u_16_ cnf_sec:8;

			/* parameter [14] bit(s) <7:0> */
			_u_16_ evrc:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_14;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [15] bit(s) <15:8> */
			_u_16_ qcelp_13k:8;

			/* parameter [15] bit(s) <7:0> */
			_u_16_ smv:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_15;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [16] bit(s) <15:8> */
			_u_16_ crbt_adpcm:8;

			/* parameter [16] bit(s) <7:0> */
			_u_16_ qcelp_8k:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_16;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [17] bit(s) <15:8> */
			_u_16_ fec:8;

			/* parameter [17] bit(s) <7:0> */
			_u_16_ g729eg:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_17;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [18] bit(s) <15:8> */
			_u_16_ ilbc_13k:8;

			/* parameter [18] bit(s) <7:0> */
			_u_16_ ilbc_15k:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_18;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [19] bit(s) <15:8> */
			_u_16_ amr_bwe:8;

			/* parameter [19] bit(s) <7:0> */
			_u_16_ rfc2833_event:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_19;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [20] bit(s) <15:8> */
			_u_16_ rfc2833_tones:8;

			/* parameter [20] bit(s) <7:0> */
			_u_16_ four_gv:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_20;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [21] bit(s) <15:8> */
			_u_16_ g729_mspd:8;

			/* parameter [21] bit(s) <7:0> */
			_u_16_ amr_wb:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_21;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [22] bit(s) <15:8> */
			_u_16_ gsm_hr:8;

			/* parameter [22] bit(s) <7:0> */
			_u_16_ cesopsn:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_22;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [23] bit(s) <15:8> */
			_u_16_ csd_bs30t_32k:8;

			/* parameter [23] bit(s) <7:0> */
			_u_16_ csd_bs30t_64k:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_23;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [24] bit(s) <15:8> */
			_u_16_ csd_bs30t_28k8:8;

			/* parameter [24] bit(s) <7:0> */
			_u_16_ csd_bs30t_33k6:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_24;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [25] bit(s) <15:8> */
			_u_16_ csd_bs20nt_28k8:8;

			/* parameter [25] bit(s) <7:0> */
			_u_16_ csd_bs20nt_57k6:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_25;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [26] bit(s) <15:8> */
			_u_16_ g729_wb:8;

			/* parameter [26] bit(s) <7:0> */
			_u_16_ csd_bs20nt_14k4:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_26;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [27] bit(s) <15:8> */
			_u_16_ CCISOIP:8;

			/* parameter [27] bit(s) <7:0> */
			_u_16_ AMRWB_OL:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_27;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [28] bit(s) <15:8> */
			_u_16_ islp:8;

			/* parameter [28] bit(s) <7:0> */
			_u_16_ g_722:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_28;


} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_SENDNTE (Function code=0x801E, class=0x02, type=0x00)
************************************************************/
struct _VOIP_SENDNTE
{
	/* parameter [4] */
	_u_16_ nte_payload_mst;

	/* parameter [5] */
	_u_16_ nte_payload_lst;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:10> */
			_u_16_ reserved6_bits_15_10:6;

			/* parameter [6] bit(s) <9> */
			_u_16_ stop_event:1;

			/* parameter [6] bit(s) <8> */
			_u_16_ start_event:1;

			/* parameter [6] bit(s) <7> */
			_u_16_ single_nte_ovd:1;

			/* parameter [6] bit(s) <6:4> */
			_u_16_ dft_redd_val_ovd:3;

			/* parameter [6] bit(s) <3> */
			_u_16_ payload_type_ovd:1;

			/* parameter [6] bit(s) <2> */
			_u_16_ ssrc_type_ovd:1;

			/* parameter [6] bit(s) <1> */
			_u_16_ redd_interval_ovd:1;

			/* parameter [6] bit(s) <0> */
			_u_16_ redd_ovd:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	/* parameter [7] */
	_u_16_ redd_interval;

	/* parameter [8] */
	_u_16_ high_SSRC;

	/* parameter [9] */
	_u_16_ low_SSRC;

	/* parameter [10] */
	_u_16_ payload_type;

	/* parameter [11] */
	_u_16_ guard_timer;


} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_DTMFDPAR (Function code=0x8021, class=0x02, type=0x00)
************************************************************/
struct _VOIP_DTMFDPAR
{
	/* parameter [4] */
	_u_16_ min_tone_on_time;

	/* parameter [5] */
	_u_16_ min_tone_off_time;

	/* parameter [6] */
	_u_16_ max_tone_dropout;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:2> */
			_u_16_ reserved7_bits_15_2:14;

			/* parameter [7] bit(s) <1> */
			_u_16_ anti_tapp_digd:1;

			/* parameter [7] bit(s) <0> */
			_u_16_ dtmfdpar_anti_tapping:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	/* parameter [8] */
	_u_16_ min_anti_tapp_on;

	/* parameter [9] */
	_u_16_ min_anti_tapp_off;

	/* parameter [10] */
	_u_16_ max_anti_tapp_dropout;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:VoIP_SS7COT (Function code=0x8029, class=0x02, type=0x00)
************************************************************/
struct _VOIP_SS7COT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:7> */
			_u_16_ reserved4_bits_15_7:9;

			/* parameter [4] bit(s) <6> */
			_u_16_ monitor_1780:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ monitor_2010:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ tx_frequency:1;

			/* parameter [4] bit(s) <3:0> */
			_u_16_ operation:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_DTMFTUNE (Function code=0x8034, class=0x02, type=0x00)
************************************************************/
struct _VOIP_DTMFTUNE
{
	/* parameter [4] */
	_u_16_ frequency_deviation;

	/* parameter [5] */
	_u_16_ negative_twist;

	/* parameter [6] */
	_u_16_ positive_twist;

	/* parameter [7] */
	_u_16_ minimum_level_threshold;

	/* parameter [8] */
	_u_16_ snr_threshold;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [9] bit(s) <15:3> */
			_u_16_ reserved9_bits_15_3:13;

			/* parameter [9] bit(s) <2:1> */
			_u_16_ detection_delay:2;

			/* parameter [9] bit(s) <0> */
			_u_16_ intermodulation_distortion_compensation:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:VoIP_QUADTONEGEN (Function code=0x8040, class=0x02, type=0x00)
************************************************************/
struct _VOIP_QUADTONEGEN
{
	/* parameter [4] */
	_u_16_ tone1_freq;

	/* parameter [5] */
	_u_16_ tone1_amp;

	/* parameter [6] */
	_u_16_ tone2_freq;

	/* parameter [7] */
	_u_16_ tone2_amp;

	/* parameter [8] */
	_u_16_ tone3_freq;

	/* parameter [9] */
	_u_16_ tone3_amp;

	/* parameter [10] */
	_u_16_ tone4_freq;

	/* parameter [11] */
	_u_16_ tone4_amp;

	/* parameter [12] */
	_u_16_ on_time;

	/* parameter [13] */
	_u_16_ off_time;

	/* parameter [14] */
	_u_16_ Ctrl;

	/* parameter [15] */
	_u_16_ reserved0;


} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_CNTRYCODE (Function code=0x805A, class=0x02, type=0x00)
************************************************************/
struct _VOIP_CNTRYCODE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:0> */
			_u_16_ code1:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:0> */
			_u_16_ code2:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:0> */
			_u_16_ code3:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:0> */
			_u_16_ code4:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:0> */
			_u_16_ filter:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;


} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_TONECTRL (Function code=0x805B, class=0x02, type=0x00)
************************************************************/
struct _VOIP_TONECTRL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ ansam_det:1;

			/* parameter [4] bit(s) <14> */
			_u_16_ tdm_ptd:1;

			/* parameter [4] bit(s) <13> */
			_u_16_ fft_tone:1;

			/* parameter [4] bit(s) <12> */
			_u_16_ fft_event:1;

			/* parameter [4] bit(s) <11> */
			_u_16_ call_progress_det:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ reserved4_bit_10:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ bell_ans:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ v32:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ notch_filter:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ call_progress_ind:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ answer_tone_ctrl:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ fax_call_ctrl:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ v8bis_2002hz_ctrl:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ modem_passthrough_ind:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ t38_tone_ind:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ dtmf_ind:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:8> */
			_u_16_ reserved1:8;

			/* parameter [5] bit(s) <7> */
			_u_16_ v18_notch_filter:1;

			/* parameter [5] bit(s) <6:1> */
			_u_16_ reserved2:6;

			/* parameter [5] bit(s) <0> */
			_u_16_ v18_baudot:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:8> */
			_u_16_ reserved6_f0:8;

			/* parameter [6] bit(s) <7> */
			_u_16_ tdm_2000:1;

			/* parameter [6] bit(s) <6:5> */
			_u_16_ reserved6_60:2;

			/* parameter [6] bit(s) <4> */
			_u_16_ tdm_1650:1;

			/* parameter [6] bit(s) <3> */
			_u_16_ tdm_1330:1;

			/* parameter [6] bit(s) <2> */
			_u_16_ tdm_1270:1;

			/* parameter [6] bit(s) <1> */
			_u_16_ tdm_980:1;

			/* parameter [6] bit(s) <0> */
			_u_16_ tdm_390:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:8> */
			_u_16_ reserved7_f0:8;

			/* parameter [7] bit(s) <7> */
			_u_16_ ip_2000:1;

			/* parameter [7] bit(s) <6:5> */
			_u_16_ reserved7_60:2;

			/* parameter [7] bit(s) <4> */
			_u_16_ ip_1650:1;

			/* parameter [7] bit(s) <3> */
			_u_16_ ip_1330:1;

			/* parameter [7] bit(s) <2> */
			_u_16_ ip_1270:1;

			/* parameter [7] bit(s) <1> */
			_u_16_ ip_980:1;

			/* parameter [7] bit(s) <0> */
			_u_16_ ip_390:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:3> */
			_u_16_ reserved8_bit_3_15:13;

			/* parameter [8] bit(s) <2> */
			_u_16_ ip_side_narrow_det:1;

			/* parameter [8] bit(s) <1> */
			_u_16_ tdm_side_narrow_det:1;

			/* parameter [8] bit(s) <0> */
			_u_16_ cas_tone_det:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:8> */
			_u_16_ reserved9_bit_8_15:8;

			/* parameter [8] bit(s) <7> */
			_u_16_ ip_v18_notch_filter:1;

			/* parameter [8] bit(s) <6:1> */
			_u_16_ reserved9_bit_1_6:6;

			/* parameter [8] bit(s) <0> */
			_u_16_ ip_v18_baudot:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;


} ATTRIBUTE_PACKED;


/************************************************************
I:VoIP_REMDET (Function code=0x805C, class=0x02, type=0x03)
************************************************************/
struct _VOIP_REMDET_IND
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ event:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ remote_type:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:8> */
			_u_16_ remote_payload_type_next_byte:8;

			/* parameter [5] bit(s) <7:0> */
			_u_16_ remote_payload_type_first_byte:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;


} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_TONEOPT (Function code=0x806C, class=0x02, type=0x00)
************************************************************/
struct _VOIP_TONEOPT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:7> */
			_u_16_ reserved4_bits_15_7:9;

			/* parameter [4] bit(s) <6> */
			_u_16_ toneopt_tonedet:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ reserved4_bit_5:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ toneopt_answer:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ toneopt_phase:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ toneopt_ansam:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ toneopt_confirmed:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ toneopt_early:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [5] bit(s) <0> */
			_u_16_ toneopt_cas:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

} ATTRIBUTE_PACKED;


/************************************************************
I:VoIP_IPTONEDET (Function code=0x806D, class=0x02, type=0x03)
************************************************************/
struct _VOIP_IPTONEDET_IND
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ cot_tone_det:1;

			/* parameter [4] bit(s) <14:13> */
			_u_16_ generic_res:2;

			/* parameter [4] bit(s) <12> */
			_u_16_ generic_1650_det:1;

			/* parameter [4] bit(s) <11> */
			_u_16_ generic_1300_det:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ generic_1270_det:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ generic_980_det:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ generic_390_det:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ v18_annex_a_det:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ ip_prg_tone_det:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ pre_std_v32_det:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ bell_v22_ans_det:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ phase_revers_det:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ ans_15_amp__mod_det:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ ans_confirm_det:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ ans_early_det:1;
		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:6]*/
	_u_32_ timestamp;

	/*parameters [7]*/
	_u_16_ power_level;

} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_PROGRAM_TONE_ENGINE (Function code=0x806E, class=0x02, type=0x00)
************************************************************/
struct _VOIP_PROGRAM_TONE_ENGINE
{
	/* parameter [4] */
	_u_16_ number;

	/* parameter [5] */
	_u_16_ tone1freq1;

	/* parameter [6] */
	_u_16_ tone1level1;

	/* parameter [7] */
	_u_16_ tone1freq2;

	/* parameter [8] */
	_u_16_ tone1level2;

	/* parameter [9] */
	_u_16_ tone1freq3;

	/* parameter [10] */
	_u_16_ tone1level3;

	/* parameter [11] */
	_u_16_ tone1freq4;

	/* parameter [12] */
	_u_16_ tone1level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [13] bit(s) <15:8> */
			_u_16_ sum1:8;

			/* parameter [13] bit(s) <7:0> */
			_u_16_ reserved13_bits_7_0:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_13;

	/* parameter [14] */
	_u_16_ tone2freq1;

	/* parameter [15] */
	_u_16_ tone2level1;

	/* parameter [16] */
	_u_16_ tone2freq2;

	/* parameter [17] */
	_u_16_ tone2level2;

	/* parameter [18] */
	_u_16_ tone2freq3;

	/* parameter [19] */
	_u_16_ tone2level3;

	/* parameter [20] */
	_u_16_ tone2freq4;

	/* parameter [21] */
	_u_16_ tone2level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [22] bit(s) <15:8> */
			_u_16_ sum2:8;

			/* parameter [22] bit(s) <7:0> */
			_u_16_ reserved22:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_22;

	/* parameter [23] */
	_u_16_ tone3freq1;

	/* parameter [24] */
	_u_16_ tone3level1;

	/* parameter [25] */
	_u_16_ tone3freq2;

	/* parameter [26] */
	_u_16_ tone3level2;

	/* parameter [27] */
	_u_16_ tone3freq3;

	/* parameter [28] */
	_u_16_ tone3level3;

	/* parameter [29] */
	_u_16_ tone3freq4;

	/* parameter [30] */
	_u_16_ tone3level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [31] bit(s) <15:8> */
			_u_16_ sum3:8;

			/* parameter [31] bit(s) <7:0> */
			_u_16_ reserved31:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_31;

	/* parameter [32] */
	_u_16_ tone4freq1;

	/* parameter [33] */
	_u_16_ tone4level1;

	/* parameter [34] */
	_u_16_ tone4freq2;

	/* parameter [35] */
	_u_16_ tone4level2;

	/* parameter [36] */
	_u_16_ tone4freq3;

	/* parameter [37] */
	_u_16_ tone4level3;

	/* parameter [38] */
	_u_16_ tone4freq4;

	/* parameter [39] */
	_u_16_ tone4level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [40] bit(s) <15:8> */
			_u_16_ sum4:8;

			/* parameter [40] bit(s) <7:0> */
			_u_16_ reserved40:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_40;

	/* parameter [41] */
	_u_16_ tone5freq1;

	/* parameter [42] */
	_u_16_ tone5level1;

	/* parameter [43] */
	_u_16_ tone5freq2;

	/* parameter [44] */
	_u_16_ tone5level2;

	/* parameter [45] */
	_u_16_ tone5freq3;

	/* parameter [46] */
	_u_16_ tone5level3;

	/* parameter [47] */
	_u_16_ tone5freq4;

	/* parameter [48] */
	_u_16_ tone5level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [49] bit(s) <15:8> */
			_u_16_ sum5:8;

			/* parameter [49] bit(s) <7:0> */
			_u_16_ reserved49:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_49;

	/* parameter [50] */
	_u_16_ tone6freq1;

	/* parameter [51] */
	_u_16_ tone6level1;

	/* parameter [52] */
	_u_16_ tone6freq2;

	/* parameter [53] */
	_u_16_ tone6level2;

	/* parameter [54] */
	_u_16_ tone6freq3;

	/* parameter [55] */
	_u_16_ tone6level3;

	/* parameter [56] */
	_u_16_ tone6freq4;

	/* parameter [57] */
	_u_16_ tone6level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [58] bit(s) <15:8> */
			_u_16_ sum6:8;

			/* parameter [58] bit(s) <7:0> */
			_u_16_ reserved58:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_58;

	/* parameter [59] */
	_u_16_ tone7freq1;

	/* parameter [60] */
	_u_16_ tone7level1;

	/* parameter [61] */
	_u_16_ tone7freq2;

	/* parameter [62] */
	_u_16_ tone7level2;

	/* parameter [63] */
	_u_16_ tone7freq3;

	/* parameter [64] */
	_u_16_ tone7level3;

	/* parameter [65] */
	_u_16_ tone7freq4;

	/* parameter [66] */
	_u_16_ tone7level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [67] bit(s) <15:8> */
			_u_16_ sum7:8;

			/* parameter [67] bit(s) <7:0> */
			_u_16_ reserved67:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_67;

	/* parameter [68] */
	_u_16_ tone8freq1;

	/* parameter [69] */
	_u_16_ tone8level1;

	/* parameter [70] */
	_u_16_ tone8freq2;

	/* parameter [71] */
	_u_16_ tone8level2;

	/* parameter [72] */
	_u_16_ tone8freq3;

	/* parameter [73] */
	_u_16_ tone8level3;

	/* parameter [74] */
	_u_16_ tone8freq4;

	/* parameter [75] */
	_u_16_ tone8level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [76] bit(s) <15:8> */
			_u_16_ sum8:8;

			/* parameter [76] bit(s) <7:0> */
			_u_16_ reserved76:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_76;

	/* parameter [77] */
	_u_16_ tone9freq1;

	/* parameter [78] */
	_u_16_ tone9level1;

	/* parameter [79] */
	_u_16_ tone9freq2;

	/* parameter [80] */
	_u_16_ tone9level2;

	/* parameter [81] */
	_u_16_ tone9freq3;

	/* parameter [82] */
	_u_16_ tone9level3;

	/* parameter [83] */
	_u_16_ tone9freq4;

	/* parameter [84] */
	_u_16_ tone9level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [85] bit(s) <15:8> */
			_u_16_ sum9:8;

			/* parameter [85] bit(s) <7:0> */
			_u_16_ reserved85:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_85;

	/* parameter [86] */
	_u_16_ tone10freq1;

	/* parameter [87] */
	_u_16_ tone10level1;

	/* parameter [88] */
	_u_16_ tone10freq2;

	/* parameter [89] */
	_u_16_ tone10level2;

	/* parameter [90] */
	_u_16_ tone10freq3;

	/* parameter [91] */
	_u_16_ tone10level3;

	/* parameter [92] */
	_u_16_ tone10freq4;

	/* parameter [93] */
	_u_16_ tone10level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [94] bit(s) <15:8> */
			_u_16_ sum10:8;

			/* parameter [94] bit(s) <7:0> */
			_u_16_ reserved94:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_94;

	/* parameter [95] */
	_u_16_ tone11freq1;

	/* parameter [96] */
	_u_16_ tone11level1;

	/* parameter [97] */
	_u_16_ tone11freq2;

	/* parameter [98] */
	_u_16_ tone11level2;

	/* parameter [99] */
	_u_16_ tone11freq3;

	/* parameter [100] */
	_u_16_ tone11level3;

	/* parameter [101] */
	_u_16_ tone11freq4;

	/* parameter [102] */
	_u_16_ tone11level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [103] bit(s) <15:8> */
			_u_16_ sum11:8;

			/* parameter [103] bit(s) <7:0> */
			_u_16_ reserved103:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_103;

	/* parameter [104] */
	_u_16_ tone12freq1;

	/* parameter [105] */
	_u_16_ tone12level1;

	/* parameter [106] */
	_u_16_ tone12freq2;

	/* parameter [107] */
	_u_16_ tone12level2;

	/* parameter [108] */
	_u_16_ tone12freq3;

	/* parameter [109] */
	_u_16_ tone12level3;

	/* parameter [110] */
	_u_16_ tone12freq4;

	/* parameter [111] */
	_u_16_ tone12level4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [112] bit(s) <15:8> */
			_u_16_ sum12:8;

			/* parameter [112] bit(s) <7:0> */
			_u_16_ reserved112:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_112;


} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_PROGRAM_CADENCE_ENGINE (Function code=0x806F, class=0x02, type=0x00)
************************************************************/
struct _VOIP_PROGRAM_CADENCE_ENGINE
{
	/* parameter [4] */
	_u_16_ param1;

	/* parameter [5] */
	_u_16_ param2;

	/* parameter [6] */
	_u_16_ param3;

	/* parameter [7] */
	_u_16_ param4;

	/* parameter [8] */
	_u_16_ param5;

	/* parameter [9] */
	_u_16_ param6;

	/* parameter [10] */
	_u_16_ param7;

	/* parameter [11] */
	_u_16_ param8;

	/* parameter [12] */
	_u_16_ param9;

	/* parameter [13] */
	_u_16_ param10;

	/* parameter [14] */
	_u_16_ param11;

	/* parameter [15] */
	_u_16_ param12;

	/* parameter [16] */
	_u_16_ param13;

	/* parameter [17] */
	_u_16_ param14;

	/* parameter [18] */
	_u_16_ param15;

	/* parameter [19] */
	_u_16_ param16;

	/* parameter [20] */
	_u_16_ param17;

	/* parameter [21] */
	_u_16_ param18;

	/* parameter [22] */
	_u_16_ param19;

	/* parameter [23] */
	_u_16_ param20;

	/* parameter [24] */
	_u_16_ param21;

	/* parameter [25] */
	_u_16_ param22;

	/* parameter [26] */
	_u_16_ param23;

	/* parameter [27] */
	_u_16_ param24;

	/* parameter [28] */
	_u_16_ param25;

	/* parameter [29] */
	_u_16_ param26;

	/* parameter [30] */
	_u_16_ param27;

	/* parameter [31] */
	_u_16_ param28;

	/* parameter [32] */
	_u_16_ param29;

	/* parameter [33] */
	_u_16_ param30;

	/* parameter [34] */
	_u_16_ param31;

	/* parameter [35] */
	_u_16_ param32;

	/* parameter [36] */
	_u_16_ param33;

	/* parameter [37] */
	_u_16_ param34;

	/* parameter [38] */
	_u_16_ param35;

	/* parameter [39] */
	_u_16_ param36;

	/* parameter [40] */
	_u_16_ param37;

	/* parameter [41] */
	_u_16_ param38;

	/* parameter [42] */
	_u_16_ param39;

	/* parameter [43] */
	_u_16_ param40;

	/* parameter [44] */
	_u_16_ param41;

	/* parameter [45] */
	_u_16_ param42;

	/* parameter [46] */
	_u_16_ param43;

	/* parameter [47] */
	_u_16_ param44;

	/* parameter [48] */
	_u_16_ param45;

	/* parameter [49] */
	_u_16_ param46;

	/* parameter [50] */
	_u_16_ param47;

	/* parameter [51] */
	_u_16_ param48;

	/* parameter [52] */
	_u_16_ param49;

	/* parameter [53] */
	_u_16_ param50;

	/* parameter [54] */
	_u_16_ param51;

	/* parameter [55] */
	_u_16_ param52;

	/* parameter [56] */
	_u_16_ param53;

	/* parameter [57] */
	_u_16_ param54;

	/* parameter [58] */
	_u_16_ param55;

	/* parameter [59] */
	_u_16_ param56;

	/* parameter [60] */
	_u_16_ param57;

	/* parameter [61] */
	_u_16_ param58;

	/* parameter [62] */
	_u_16_ param59;

	/* parameter [63] */
	_u_16_ param60;

	/* parameter [64] */
	_u_16_ param61;

	/* parameter [65] */
	_u_16_ param62;

	/* parameter [66] */
	_u_16_ param63;

	/* parameter [67] */
	_u_16_ param64;

	/* parameter [68] */
	_u_16_ param65;

	/* parameter [69] */
	_u_16_ param66;

	/* parameter [70] */
	_u_16_ param67;

	/* parameter [71] */
	_u_16_ param68;

	/* parameter [72] */
	_u_16_ param69;

	/* parameter [73] */
	_u_16_ param70;

	/* parameter [74] */
	_u_16_ param71;

	/* parameter [75] */
	_u_16_ param72;

	/* parameter [76] */
	_u_16_ param73;

	/* parameter [77] */
	_u_16_ param74;

	/* parameter [78] */
	_u_16_ param75;

	/* parameter [79] */
	_u_16_ param76;

	/* parameter [80] */
	_u_16_ param77;

	/* parameter [81] */
	_u_16_ param78;

	/* parameter [82] */
	_u_16_ param79;

	/* parameter [83] */
	_u_16_ param80;

	/* parameter [84] */
	_u_16_ param81;

	/* parameter [85] */
	_u_16_ param82;

	/* parameter [86] */
	_u_16_ param83;

	/* parameter [87] */
	_u_16_ param84;

	/* parameter [88] */
	_u_16_ param85;

	/* parameter [89] */
	_u_16_ param86;

	/* parameter [90] */
	_u_16_ param87;

	/* parameter [91] */
	_u_16_ param88;

	/* parameter [92] */
	_u_16_ param89;

	/* parameter [93] */
	_u_16_ param90;

	/* parameter [94] */
	_u_16_ param91;

	/* parameter [95] */
	_u_16_ param92;

	/* parameter [96] */
	_u_16_ param93;

	/* parameter [97] */
	_u_16_ param94;

	/* parameter [98] */
	_u_16_ param95;

	/* parameter [99] */
	_u_16_ param96;

	/* parameter [100] */
	_u_16_ param97;

	/* parameter [101] */
	_u_16_ param98;

	/* parameter [102] */
	_u_16_ param99;

	/* parameter [103] */
	_u_16_ param100;

	/* parameter [104] */
	_u_16_ param101;

	/* parameter [105] */
	_u_16_ param102;

	/* parameter [106] */
	_u_16_ param103;

	/* parameter [107] */
	_u_16_ param104;

	/* parameter [108] */
	_u_16_ param105;

	/* parameter [109] */
	_u_16_ param106;

	/* parameter [110] */
	_u_16_ param107;

	/* parameter [111] */
	_u_16_ param108;

	/* parameter [112] */
	_u_16_ param109;

	/* parameter [113] */
	_u_16_ param110;

	/* parameter [114] */
	_u_16_ param111;

	/* parameter [115] */
	_u_16_ param112;

	/* parameter [116] */
	_u_16_ param113;

	/* parameter [117] */
	_u_16_ param114;

	/* parameter [118] */
	_u_16_ param115;

	/* parameter [119] */
	_u_16_ param116;

	/* parameter [120] */
	_u_16_ param117;

	/* parameter [121] */
	_u_16_ param118;

	/* parameter [122] */
	_u_16_ param119;

	/* parameter [123] */
	_u_16_ param120;

	/* parameter [124] */
	_u_16_ param121;

	/* parameter [125] */
	_u_16_ param122;

	/* parameter [126] */
	_u_16_ param123;

	/* parameter [127] */
	_u_16_ param124;


} ATTRIBUTE_PACKED;

/************************************************************
C:VoIP_INDCTRL (Function code=0x8084, class=0x02, type=0x00)
************************************************************/
struct _VOIP_INDCTRL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:12> */
			_u_16_ reserved4_bits_15_12:4;

			/* parameter [4] bit(s) <11> */
			_u_16_ icmp_ind:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ ptchng_ind:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ jb_overflow_ind:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ jb_dmax_exc_ind:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ rfc2833_dtmf_ind:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ inband_dtmf_ind:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ dtmf_event_det:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ dtmf_tone_det:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ reserved4_bit_3:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ ssrcviol:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ ssrcchg:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ ptcchg:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ ptcchg_time;


} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_JBOPT (Function code=0x8090, class=0x02, type=0x00)
************************************************************/
struct _VOIP_JBOPT
{
	/* parameter [4] */
	_u_16_ delay_min;

	/* parameter [5] */
	_u_16_ delay_max;

	/* parameter [6] */
	_u_16_ delay_init;

	/* parameter [7] */
	_u_16_ ap;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:4> */
			_u_16_ reserved8_bits_15_4:12;

			/* parameter [8] bit(s) <3> */
			_u_16_ immediatly_adjust:1;

			/* parameter [8] bit(s) <2:1> */
			_u_16_ reserved8_bits_2_1:2;

			/* parameter [8] bit(s) <0> */
			_u_16_ deletion_mode:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;

	/* parameter [9] */
	_u_16_ deletion_threshold;


} ATTRIBUTE_PACKED;


/************************************************************
CA:EC_CONTROL (Function code=0x8091, class=0x02, type=0x00)
************************************************************/
struct _EC_CONTROL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ cc_cacl:1;

			/* parameter [4] bit(s) <14> */
			_u_16_ spec_ep_change:1;

			/* parameter [4] bit(s) <13> */
			_u_16_ erl_chg_detection:1;

			/* parameter [4] bit(s) <12> */
			_u_16_ fc_control:1;

			/* parameter [4] bit(s) <11:4> */
			_u_16_ reserved4_bits_11_4:8;

			/* parameter [4] bit(s) <3:0> */
			_u_16_ ec_window:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_TONES_RELAY_OPTION (Function code=0x8092, class=0x02, type=0x00)
************************************************************/
struct _VOIP_TONES_RELAY_OPTION
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:9> */
			_u_16_ reserved4_bits_15_9:7;

			/* parameter [4] bit(s) <8> */
			_u_16_ send_2833_event:1;

			/* parameter [4] bit(s) <7:5> */
			_u_16_ ccisoip_tone_duration:3;

			/* parameter [4] bit(s) <4> */
			_u_16_ redundancy_2833_scheme:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ ccisoip_packet_format:1;

			/* parameter [4] bit(s) <2:1> */
			_u_16_ ccisoip_tone_volume:2;

			/* parameter [4] bit(s) <0> */
			_u_16_ control_m_fax_tones:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:1> */
			_u_16_ reserved5_bits_15_1:15;

			/* parameter [5] bit(s) <0> */
			_u_16_ cng_relay_over_ip:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_DIGITSTRGEN (Function code=0x8098, class=0x02, type=0x00)
************************************************************/
struct _VOIP_DIGITSTRGEN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:0> */
			_u_16_ tone_type:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:7> */
			_u_16_ reserved5_bits_15_7:9;

			/* parameter [5] bit(s) <6> */
			_u_16_ concurrently:1;

			/* parameter [5] bit(s) <5> */
			_u_16_ reserved5_bit_5:1;

			/* parameter [5] bit(s) <4> */
			_u_16_ multiple_events:1;

			/* parameter [5] bit(s) <3> */
			_u_16_ dtmfopt_override:1;

			/* parameter [5] bit(s) <2> */
			_u_16_ packet_format:1;

			/* parameter [5] bit(s) <1> */
			_u_16_ mode:1;

			/* parameter [5] bit(s) <0> */
			_u_16_ direction:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:0> */
			_u_16_ amplitude:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:0> */
			_u_16_ on_time:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:0> */
			_u_16_ off_time:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [9] bit(s) <15:0> */
			_u_16_ pause:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [10] bit(s) <15:0> */
			_u_16_ number:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_10;


	/*parameters [11:$] = digits:OCTETS*/
	_u_8_ digits [234];

} ATTRIBUTE_PACKED;



/************************************************************
CA:VoIP_MFTUNE (Function code=0x809A, class=0x02, type=0x00)
************************************************************/
struct _VOIP_MFTUNE
{
	/* parameter [4] */
	_u_16_ frequency_deviation;

	/* parameter [5] */
	_u_16_ negative_twist;

	/* parameter [6] */
	_u_16_ positive_twist;

	/* parameter [7] */
	_u_16_ minimum_level_threshold;

	/* parameter [8] */
	_u_16_ snr_threshold;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [9] bit(s) <15:3> */
			_u_16_ reserved9_bits_15_3:13;

			/* parameter [9] bit(s) <2:1> */
			_u_16_ detection_delay:2;

			/* parameter [9] bit(s) <0> */
			_u_16_ reserved9_bit_0:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;

	/* parameter [10] */
	_u_16_ mf_selector;


} ATTRIBUTE_PACKED;



/************************************************************
CA:VoIP_MFDPAR (Function code=0x809B, class=0x02, type=0x00)
************************************************************/
struct _VOIP_MFDPAR
{
	/* parameter [4] */
	_u_16_ minimum_on_time;

	/* parameter [5] */
	_u_16_ minimum_off_time;

	/* parameter [6] */
	_u_16_ maximum_dropout_time;

	/* parameter [7] */
	_u_16_ mf_selector;


} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_CDMA_MODES (Function code=0x80B0, class=0x02, type=0x00)
************************************************************/
struct _VOIP_CDMA_MODES
{
	/* parameter [4] */
	_u_16_ cdma_codec_mode;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:13> */
			_u_16_ reserved5_bits_15_13:3;

			/* parameter [5] bit(s) <12> */
			_u_16_ tty:1;

			/* parameter [5] bit(s) <11:8> */
			_u_16_ max_rate:4;

			/* parameter [5] bit(s) <7:4> */
			_u_16_ min_rate:4;

			/* parameter [5] bit(s) <3:0> */
			_u_16_ signaling:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;


} ATTRIBUTE_PACKED;


/************************************************************
CA:SET_PASSTHRU_AUTOSWITCH (Function code=0x80BE, class=0x02, type=0x00)
************************************************************/
struct _SET_PASSTHRU_AUTOSWITCH
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:12> */
			_u_16_ reserved4_bits_15_12:4;

			/* parameter [4] bit(s) <11> */
			_u_16_ rfc2833:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ v8bis:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ ptchng:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ use_pt:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ ssad_badout:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ relay:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ voice_switch:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ ssad_mpt:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ sw_ind:1;

			/* parameter [4] bit(s) <2:0> */
			_u_16_ pt_autoswitch:3;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ reserved5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:8> */
			_u_16_ delay:8;

			/* parameter [6] bit(s) <7:0> */
			_u_16_ vbd_pt:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:11> */
			_u_16_ reserved7_bits_15_11:5;

			/* parameter [7] bit(s) <10> */
			_u_16_ adj_internal:1;

			/* parameter [7] bit(s) <9> */
			_u_16_ adj_tdm:1;

			/* parameter [7] bit(s) <8> */
			_u_16_ adj_ip:1;

			/* parameter [7] bit(s) <7:0> */
			_u_16_ packet_interval:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:14> */
			_u_16_ reserved8_bits_15_14:2;

			/* parameter [8] bit(s) <13> */
			_u_16_ tr_sw_on_v_21_tone_1650:1;

			/* parameter [8] bit(s) <12> */
			_u_16_ tr_sw_on_v_21_tone_980:1;

			/* parameter [8] bit(s) <11> */
			_u_16_ tr_sw_on_v_23_tone_1300:1;

			/* parameter [8] bit(s) <10> */
			_u_16_ tr_sw_on_v_23_tone_390:1;

			/* parameter [8] bit(s) <9> */
			_u_16_ tr_sw_on_ans_tone:1;

			/* parameter [8] bit(s) <8> */
			_u_16_ tr_sw_on_ansam_tone:1;

			/* parameter [8] bit(s) <7> */
			_u_16_ tr_sw_on_ans_or_tone:1;

			/* parameter [8] bit(s) <6> */
			_u_16_ tr_sw_on_ansam_or_tone:1;

			/* parameter [8] bit(s) <5> */
			_u_16_ tr_sw_on_v8bis_cre_tone:1;

			/* parameter [8] bit(s) <4> */
			_u_16_ tr_sw_on_v_21_flags_tone:1;

			/* parameter [8] bit(s) <3> */
			_u_16_ tr_sw_on_fax_calling_tone_980:1;

			/* parameter [8] bit(s) <2> */
			_u_16_ tr_sw_on_v22_usb1_2250_tone:1;

			/* parameter [8] bit(s) <1> */
			_u_16_ tr_sw_on_bell_103_tone:1;

			/* parameter [8] bit(s) <0> */
			_u_16_ tr_sw_on_cot_tone:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;


} ATTRIBUTE_PACKED;


/************************************************************
I:PASSTHRU_AUTOSWITCH_IND (Function code=0x80BF, class=0x02, type=0x03)
************************************************************/
struct _PASSTHRU_AUTOSWITCH_IND
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:4> */
			_u_16_ reserved4_bits_15_4:12;

			/* parameter [4] bit(s) <3> */
			_u_16_ redundant_switch:1;

			/* parameter [4] bit(s) <2:0> */
			_u_16_ switch_type:3;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_AGCSET (Function code=0x80D1, class=0x02, type=0x00)
************************************************************/
struct _VOIP_AGCSET
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:11> */
			_u_16_ reserved4_bits_15_11:5;

			/* parameter [4] bit(s) <10> */
			_u_16_ g169enb:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ txinit:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ rxinit:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ txlim:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ rxlim:1;

			/* parameter [4] bit(s) <5:4> */
			_u_16_ pcm2pkt_slew_rate:2;

			/* parameter [4] bit(s) <3:2> */
			_u_16_ pkt2pcm_slew_rate:2;

			/* parameter [4] bit(s) <1> */
			_u_16_ pcm2pkt_enb:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ pkt2pcm_enb:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ pkt2pcm_target_level;

	/* parameter [6] */
	_u_16_ pcm2pkt_target_level;

	/* parameter [7] */
	_u_16_ pkt2pcm_max_gain;

	/* parameter [8] */
	_u_16_ pkt2pcm_min_gain;

	/* parameter [9] */
	_u_16_ pcm2pkt_max_gain;

	/* parameter [10] */
	_u_16_ pcm2pkt_min_gain;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:AEC_CONTROL (Function code=0x80E5, class=0x02, type=0x00)
************************************************************/
struct _AEC_CONTROL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ ip_aecenb:1;

			/* parameter [4] bit(s) <14> */
			_u_16_ ip_aecinit:1;

			/* parameter [4] bit(s) <13:11> */
			_u_16_ reserved4_bits_13_11:3;

			/* parameter [4] bit(s) <10:9> */
			_u_16_ ip_aecmod:2;

			/* parameter [4] bit(s) <8> */
			_u_16_ ip_aecnlp:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ ip_aeccng:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ ip_aecdyn:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ ip_aecdcd:1;

			/* parameter [4] bit(s) <4:0> */
			_u_16_ reserved4_bits_4_0:5;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:8> */
			_u_16_ ip_minepd:8;

			/* parameter [5] bit(s) <7:0> */
			_u_16_ reserved5_bits_7_0:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:8> */
			_u_16_ ip_disepd:8;

			/* parameter [6] bit(s) <7:0> */
			_u_16_ ip_minerl:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15> */
			_u_16_ tdm_aecenb:1;

			/* parameter [7] bit(s) <14> */
			_u_16_ tdm_aecinit:1;

			/* parameter [7] bit(s) <13:11> */
			_u_16_ reserved7_bits_13_11:3;

			/* parameter [7] bit(s) <10:9> */
			_u_16_ tdm_aecmod:2;

			/* parameter [7] bit(s) <8> */
			_u_16_ tdm_aecnlp:1;

			/* parameter [7] bit(s) <7> */
			_u_16_ tdm_aeccng:1;

			/* parameter [7] bit(s) <6> */
			_u_16_ tdm_aecdyn:1;

			/* parameter [7] bit(s) <5> */
			_u_16_ tdm_aecdcd:1;

			/* parameter [7] bit(s) <4:0> */
			_u_16_ reserved7_bits_4_0:5;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:8> */
			_u_16_ tdm_minepd:8;

			/* parameter [8] bit(s) <7:0> */
			_u_16_ reserved8_bits_7_0:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [9] bit(s) <15:8> */
			_u_16_ tdm_disepd:8;

			/* parameter [9] bit(s) <7:0> */
			_u_16_ tdm_minerl:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;


} ATTRIBUTE_PACKED;


/************************************************************
CA:RTP_MONITOR_ENA (Function code=0x80EE, class=0x02, type=0x00)
************************************************************/
struct _RTP_MONITOR_ENA
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:2> */
			_u_16_ reserved4_bits_15_2:14;

			/* parameter [4] bit(s) <1> */
			_u_16_ pt_chg_ind:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ mode:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:6]*/
	_u_32_ timer;

} ATTRIBUTE_PACKED;


/************************************************************
I:RTP_MONITOR_IND (Function code=0x80EF, class=0x02, type=0x03)
************************************************************/
struct _RTP_MONITOR_IND
{
	/* parameter [4] */
	_u_16_ type;

	/*parameters [5:6]*/
	_u_32_ timestamp;
	/* parameter [7] */
	_u_16_ pt;

	/* parameter [8] */
	_u_16_ silence_suppr;


} ATTRIBUTE_PACKED;

/************************************************************
CAQR:RTP_TX_TIMESTAMP (Function code=0x80E7, class=0x02, type=0x00)
************************************************************/
struct _RTP_TX_TIMESTAMP
{
	/*parameters [4:5]*/
	_u_32_ timestamp;

} ATTRIBUTE_PACKED;

/************************************************************
CAQR:RTP_TX_SEQNUM (Function code=0x80E8, class=0x02, type=0x00)
************************************************************/
struct _RTP_TX_SEQNUM
{
	/* parameter [4] */
	_u_16_ seqnum;


} ATTRIBUTE_PACKED;

/************************************************************
CAQR:RTP_PKTHDLR_INFO (Function code=0x80E9, class=0x02, type=0x00)
************************************************************/
struct _RTP_PKTHDLR_INFO
{
	/* parameter [4] */
	_u_16_ rx_base_seqnum;

	/* parameter [5] */
	_u_16_ rx_max_seqnum;

	/* parameter [6] */
	_u_16_ probation;

	/* parameter [7] */
	_u_16_ reserved7;

	/*parameters [8:9]*/
	_u_32_ rx_total_packets;
	/*parameters [10:11]*/
	_u_32_ rx_packets_expected;
	/*parameters [12:13]*/
	_u_32_ rx_pacets_received;
	/*parameters [14:15]*/
	_u_32_ rx_cycles;
	/*parameters [16:17]*/
	_u_32_ incoming_ssrc;
	/*parameters [18:19]*/
	_u_32_ tx_total_packets;
	/*parameters [20:21]*/
	_u_32_ tx_total_octets;
	/*parameters [22:23]*/
	_u_32_ rtcp_elapsed_time;

} ATTRIBUTE_PACKED;

/************************************************************
CA:RTCP_BYE_PKT_DISABLE (Function code=0x80EC, class=0x02, type=0x00)
************************************************************/
struct _RTCP_BYE_PKT_DISABLE
{
	/* parameter [4] */
	_u_16_ mode;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:NC_CONTROL (Function code=0x81E7, class=0x02, type=0x00)
************************************************************/
struct _NC_CONTROL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:2> */
			_u_16_ reserved4_bits_15_2:14;

			/* parameter [4] bit(s) <1> */
			_u_16_ nc_nlc:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ nc_enb:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;



/************************************************************
CAQR:NC_TUNE (Function code=0x81E8, class=0x02, type=0x00)
************************************************************/
struct _NC_TUNE
{
	/* parameter [4] */
	_u_16_ nc_vad_up_hangover;

	/* parameter [5] */
	_u_16_ nc_vad_down_hangover;

	/* parameter [6] */
	_u_16_ nc_intg_factor;

	/* parameter [7] */
	_u_16_ nc_snr_intg_factor;

	/* parameter [8] */
	_u_16_ nc_snr_init_update_complete;

	/* parameter [9] */
	_u_16_ nc_snr_corr;

	/* parameter [10] */
	_u_16_ nc_g0;

	/* parameter [11] */
	_u_16_ nc_g_max;

	/* parameter [12] */
	_u_16_ nc_snr0;

	/* parameter [13] */
	_u_16_ nc_alpha;

	/* parameter [14] */
	_u_16_ nc_enc_intg_factor;

	/* parameter [15] */
	_u_16_ nlc_max_in_level;

	/* parameter [16] */
	_u_16_ nlc_max_level;

	/* parameter [17] */
	_u_16_ nlc_start_level;

	/* parameter [18] */
	_u_16_ nlc_gain1_fx;

	/* parameter [19] */
	_u_16_ nlc_coeff_0;


} ATTRIBUTE_PACKED;


/************************************************************
CA:DPNS_CONTROL (Function code=0x81E9, class=0x02, type=0x00)
************************************************************/
struct _DPNS_CONTROL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ dpns_enb:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ dpns_supp_cntr_fx;


} ATTRIBUTE_PACKED;


/************************************************************
CA:IPDTMF_CTRL (Function code=0x9040, class=0x02, type=0x00)
************************************************************/
struct _IPDTMF_CTRL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:4> */
			_u_16_ reserved4_bits_15_4:12;

			/* parameter [4] bit(s) <3> */
			_u_16_ events:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ inband_detection:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ inband_removal:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ removal:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ reserved5;


} ATTRIBUTE_PACKED;


/************************************************************
I:INBAND_DTMF_DET (Function code=0x9041, class=0x02, type=0x03)
************************************************************/
struct _INBAND_DTMF_DET_IND
{
	/* parameter [4] */
	_u_16_ tone;

	/*parameters [5:6]*/
	_u_32_ timestamp;
	/* parameter [7] */
	_u_16_ power;


} ATTRIBUTE_PACKED;

/************************************************************
I:RFC2833_DTMF_DET (Function code=0x9042, class=0x02, type=0x03)
************************************************************/
struct _RFC2833_DTMF_DET_IND
{
	/* parameter [4] */
	_u_16_ tone;

	/*parameters [5:6]*/
	_u_32_ timestamp;
	/* parameter [7] */
	_u_16_ power;


} ATTRIBUTE_PACKED;

/************************************************************
CA:RFC2833_TONEPLYCFG (Function code=0x9050, class=0x02, type=0x00)
************************************************************/
struct _RFC2833_TONEPLYCFG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ min_on_time:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ min_off_time:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;



/************************************************************
CA:VoIP_MEASOFF (Function code=0x9109, class=0x02, type=0x00)
************************************************************/
struct _VOIP_MEASOFF
{
	/* parameter [4] */
	_u_16_ reserved4;


} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_CFGMEAS (Function code=0x9110, class=0x02, type=0x00)
************************************************************/
struct _VOIP_CFGMEAS
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ biquad:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ a2_1;

	/* parameter [6] */
	_u_16_ a1_1;

	/* parameter [7] */
	_u_16_ a0_1;

	/* parameter [8] */
	_u_16_ reserved8;

	/* parameter [9] */
	_u_16_ b2_1;

	/* parameter [10] */
	_u_16_ b1_1;

	/* parameter [11] */
	_u_16_ a2_2;

	/* parameter [12] */
	_u_16_ a1_2;

	/* parameter [13] */
	_u_16_ a0_2;

	/* parameter [14] */
	_u_16_ reserved14;

	/* parameter [15] */
	_u_16_ b2_2;

	/* parameter [16] */
	_u_16_ b1_2;


} ATTRIBUTE_PACKED;



/************************************************************
CA:VoIP_MEASTONE (Function code=0x9111, class=0x02, type=0x00)
************************************************************/
struct _VOIP_MEASTONE
{
	/* parameter [4] */
	_u_16_ freq;

	/* parameter [5] */
	_u_16_ time;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:9> */
			_u_16_ reserved6_bits_15_9:7;

			/* parameter [6] bit(s) <8> */
			_u_16_ mode_time:1;

			/* parameter [6] bit(s) <7:0> */
			_u_16_ mode:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;


} ATTRIBUTE_PACKED;

/************************************************************
I:VoIP_MEASDONE (Function code=0x9112, class=0x02, type=0x03)
************************************************************/
struct _VOIP_MEASDONE_IND
{
	/* parameter [4] */
	_u_16_ var1;

	/* parameter [5] */
	_u_16_ var2;

	/* parameter [6] */
	_u_16_ var3;


} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_TDETGLOBALCFG (Function code=0x9116, class=0x02, type=0x00)
************************************************************/
struct _VOIP_TDETGLOBALCFG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ enable:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:8> */
			_u_16_ reserved5_bits_15_8:8;

			/* parameter [5] bit(s) <7:0> */
			_u_16_ status_sel:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:8> */
			_u_16_ snr:8;

			/* parameter [6] bit(s) <7:0> */
			_u_16_ min_level:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:8> */
			_u_16_ reserved7_bits_15_8:8;

			/* parameter [7] bit(s) <7:0> */
			_u_16_ max_twist:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;


} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_TDETCFG (Function code=0x9117, class=0x02, type=0x00)
************************************************************/
struct _VOIP_TDETCFG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ detector:8;

			/* parameter [4] bit(s) <7> */
			_u_16_ reserved4_bit_7:1;

			/* parameter [4] bit(s) <6:5> */
			_u_16_ cadence:2;

			/* parameter [4] bit(s) <4> */
			_u_16_ reserved4_bit_4:1;

			/* parameter [4] bit(s) <3:2> */
			_u_16_ noise:2;

			/* parameter [4] bit(s) <1:0> */
			_u_16_ det_type:2;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ min_on1;

	/* parameter [6] */
	_u_16_ max_on1;

	/* parameter [7] */
	_u_16_ min_off1;

	/* parameter [8] */
	_u_16_ max_off1;

	/* parameter [9] */
	_u_16_ min_freq1;

	/* parameter [10] */
	_u_16_ max_freq1;

	/* parameter [11] */
	_u_16_ min_freq2;

	/* parameter [12] */
	_u_16_ max_freq2;

	/* parameter [13] */
	_u_16_ min_on2;

	/* parameter [14] */
	_u_16_ max_on2;

	/* parameter [15] */
	_u_16_ min_off2;

	/* parameter [16] */
	_u_16_ max_off2;

	/* parameter [17] */
	_u_16_ detect_delay;

	/* parameter [18] */
	_u_16_ drop_delay;


} ATTRIBUTE_PACKED;


/************************************************************
I:VoIP_TDETIND (Function code=0x9118, class=0x02, type=0x03)
************************************************************/
struct _VOIP_TDETIND_IND
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ detector:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ indication:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ freq1;

	/* parameter [6] */
	_u_16_ freq2;

	/* parameter [7] */
	_u_16_ reserved7;

	/* parameter [8] */
	_u_16_ level1;

	/* parameter [9] */
	_u_16_ level2;

	/* parameter [10] */
	_u_16_ reserved10;

	/*parameters [11:12]*/
	_u_32_ timestamp;
	/* parameter [13] */
	_u_16_ reserved13;

	/* parameter [14] */
	_u_16_ reserved14;


} ATTRIBUTE_PACKED;

/************************************************************
CA:IPTONEDETEN (Function code=0x9119, class=0x02, type=0x00)
************************************************************/
struct _IPTONEDETEN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:0> */
			_u_16_ detection:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
CA:THC_REDIRECT_RX (Function code=0x9200, class=0x02, type=0x00)
************************************************************/
struct _THC_REDIRECT_RX
{
	/* parameter [4] */
	_u_16_ slot;


} ATTRIBUTE_PACKED;

/************************************************************
CA:THC_MODE_ENABLE (Function code=0x9201, class=0x02, type=0x00)
************************************************************/
struct _THC_MODE_ENABLE
{
	/* parameter [4] */
	_u_16_ level;


} ATTRIBUTE_PACKED;

/************************************************************
CA:THC_GEN_PKT (Function code=0x9202, class=0x02, type=0x00)
************************************************************/
struct _THC_GEN_PKT
{
	/* parameter [4] */
	_u_16_ mode;


} ATTRIBUTE_PACKED;


/************************************************************
CA:SELECT_MF_TONEDET (Function code=0x9421, class=0x02, type=0x00)
************************************************************/
struct _SELECT_MF_TONEDET
{
	/* parameter [4] */
	_u_16_ type;


} ATTRIBUTE_PACKED;


/************************************************************
CA:RL_EVRCX_CONTROL (Function code=0x81ED, class=0x02, type=0x00)
************************************************************/
struct _RL_EVRCX_CONTROL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ rl_control:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
CA:SET_UMA_PARAMS (Function code=0x8600, class=0x02, type=0x00)
************************************************************/
struct _SET_UMA_PARAMS
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ reserved4_bit_15:1;

			/* parameter [4] bit(s) <14> */
			_u_16_ mcn:1;

			/* parameter [4] bit(s) <13> */
			_u_16_ rate_change_event:1;

			/* parameter [4] bit(s) <12> */
			_u_16_ stat_change_event:1;

			/* parameter [4] bit(s) <11> */
			_u_16_ cmr_change_event:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ q_zero_event:1;

			/* parameter [4] bit(s) <9:6> */
			_u_16_ cmr_value:4;

			/* parameter [4] bit(s) <5:2> */
			_u_16_ threshold_window:4;

			/* parameter [4] bit(s) <1:0> */
			_u_16_ uma_state:2;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:14> */
			_u_16_ redund:2;

			/* parameter [5] bit(s) <13:7> */
			_u_16_ bad_treshold:7;

			/* parameter [5] bit(s) <6:0> */
			_u_16_ good_treshold:7;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:12> */
			_u_16_ reserved6_bits_15_12:4;

			/* parameter [6] bit(s) <11> */
			_u_16_ cmr_autoadapt:1;

			/* parameter [6] bit(s) <10> */
			_u_16_ apply_amr_mcp:1;

			/* parameter [6] bit(s) <9> */
			_u_16_ apply_amr_ms:1;

			/* parameter [6] bit(s) <8:0> */
			_u_16_ amr_mode:9;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	/* parameter [7] */
	_u_16_ mcp_value;


} ATTRIBUTE_PACKED;


/************************************************************
CA:C2C_CONNECT_UMA_UP (Function code=0x0C07, class=0x06, type=0x00)
************************************************************/
struct _C2C_CONNECT_UMA_UP
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:4> */
			_u_16_ reserved4_bits_15_4:12;

			/* parameter [4] bit(s) <3:2> */
			_u_16_ inter_mode:2;

			/* parameter [4] bit(s) <1> */
			_u_16_ connection_type:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ connection:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:10> */
			_u_16_ reserved5_bits_15_10:6;

			/* parameter [5] bit(s) <9:0> */
			_u_16_ up_channel_a:10;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:10> */
			_u_16_ reserved6_bits_15_10:6;

			/* parameter [6] bit(s) <9:0> */
			_u_16_ up_channel_b:10;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:10> */
			_u_16_ reserved7_bits_15_10:6;

			/* parameter [7] bit(s) <9:0> */
			_u_16_ rfci_to_cmr_timer:10;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:8> */
			_u_16_ rfci_num_515_885:8;

			/* parameter [8] bit(s) <7:0> */
			_u_16_ rfci_num_475_660:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [9] bit(s) <15:8> */
			_u_16_ rfci_num_670_1425:8;

			/* parameter [9] bit(s) <7:0> */
			_u_16_ rfci_num_590_1265:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [10] bit(s) <15:8> */
			_u_16_ rfci_num_795_1825:8;

			/* parameter [10] bit(s) <7:0> */
			_u_16_ rfci_num_740_1585:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_10;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [11] bit(s) <15:8> */
			_u_16_ rfci_num_122_2305:8;

			/* parameter [11] bit(s) <7:0> */
			_u_16_ rfci_num_102_1985:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_11;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [12] bit(s) <15:8> */
			_u_16_ rfci_num_nodata_sid:8;

			/* parameter [12] bit(s) <7:0> */
			_u_16_ rfci_num_sid_2385:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_12;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [13] bit(s) <15:8> */
			_u_16_ ignored:8;

			/* parameter [13] bit(s) <7:0> */
			_u_16_ rfci_num_ignored_nodata:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_13;


} ATTRIBUTE_PACKED;


/************************************************************
CA:G729_WB_MODE (Function code=0x81EC, class=0x02, type=0x00)
************************************************************/
struct _G729_WB_MODE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

			/* parameter [4] bit(s) <7:4> */
			_u_16_ mbs:4;

			/* parameter [4] bit(s) <3:0> */
			_u_16_ ft:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;



/************************************************************
CA:MTOM_SETUP (Function code=0x8720, class=0x02, type=0x00)
************************************************************/
struct _MTOM_SETUP
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:3> */
			_u_16_ reserved4_bits_15_3:13;

			/* parameter [4] bit(s) <2> */
			_u_16_ crc_check_tdm_ip:1;

			/* parameter [4] bit(s) <1:0> */
			_u_16_ mtm_mode:2;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;



/************************************************************
CA:EVRC_POSTFILTER_CONFIG (Function code=0x8740, class=0x02, type=0x00)
************************************************************/
struct _EVRC_POSTFILTER_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ ctrl:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
CA:CIPHER_AES_OPT (Function code=0x8046, class=0x02, type=0x00)
************************************************************/
struct _CIPHER_AES_OPT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ aes:1;

			/* parameter [4] bit(s) <14:12> */
			_u_16_ cipher_layer:3;

			/* parameter [4] bit(s) <11:9> */
			_u_16_ pcdc:3;

			/* parameter [4] bit(s) <8> */
			_u_16_ key:1;

			/* parameter [4] bit(s) <7:6> */
			_u_16_ btm:2;

			/* parameter [4] bit(s) <5:2> */
			_u_16_ mode:4;

			/* parameter [4] bit(s) <1:0> */
			_u_16_ key_size:2;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


	/*parameters [5:$] = init_array:OCTETS*/
	_u_8_ init_array [246];

} ATTRIBUTE_PACKED;


/************************************************************
CA:VoIP_VOISIDET (Function code=0x8037, class=0x02, type=0x00)
************************************************************/
struct _VOIP_VOISIDET
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:3> */
			_u_16_ reserved4_bits_15_3:13;

			/* parameter [4] bit(s) <2> */
			_u_16_ voice_detect:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ secondary_timer:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ primary_timer:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ pri_sdt;

	/* parameter [6] */
	_u_16_ sec_sdt;

	/* parameter [7] */
	_u_16_ tx_threshold;

	/* parameter [8] */
	_u_16_ rx_threshold;


} ATTRIBUTE_PACKED;


/************************************************************
CA:CTM_CONFIG (Function code=0x80EA, class=0x02, type=0x00)
************************************************************/
struct _CTM_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ ctm:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
I:CTM_CHANGE_IND (Function code=0x80EB, class=0x02, type=0x03)
************************************************************/
struct _CTM_CHANGE_IND
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ ctm_state:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
QR:CTM_STATISTICS (class=0x01, type=0x2C)
************************************************************/
struct _CTM_STATISTICS
{
	/*parameters [4:5]*/
	_u_32_ revision;
	/*parameters [6:7]*/
	_u_32_ ctm_tx;
	/*parameters [8:9]*/
	_u_32_ ctm_rx;

} ATTRIBUTE_PACKED;
#endif /* COMCERTO_VOIP_API_H_ */ 
