/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifdef _HOST_BIG_ENDIAN_
#include "comcerto-voip-types_be.h"
#else
#include "comcerto-voip-types_le.h"
#endif



/* Definitions associated to VOIP_VOPENA */
#define VOIP_VOPENA_MODE_DISABLE 0x0
#define VOIP_VOPENA_MODE_ENABLE_RTP 0x1
#define VOIP_VOPENA_MODE_ENABLE_UDPTL 0x2
#define VOIP_VOPENA_MODE_ENABLE_AAL2 0x3
#define VOIP_VOPENA_MODE_ENABLE_CDMA_AAL5 0x4
#define VOIP_VOPENA_MODE_ENABLE_NORTP 0x6
#define VOIP_VOPENA_MODE_ENABLE_INBAND_TONE 0x7
#define VOIP_VOPENA_MODE_ENABLE_IUUP 0x8
#define VOIP_VOPENA_MODE_ENABLE_AAL2_DATA 0x9
#define VOIP_VOPENA_MODE_ENABLE_LSP 0xA
#define VOIP_VOPENA_MODE_ENABLE_TONEGEN 0xD
#define VOIP_VOPENA_MODE_ENABLE_TONEDET 0xE
#define VOIP_VOPENA_MODE_ENABLE_T38oRTP 0x10
#define VOIP_VOPENA_MODE_ENABLE_UDPTL_SPY 0x11
#define VOIP_VOPENA_MODE_ENABLE_IP_TDM 0x13

#define VOIP_VOPENA_RTP_PT_PCMU 0x0
#define VOIP_VOPENA_RTP_PT_G726_32 0x2
#define VOIP_VOPENA_RTP_PT_GSM 0x3
#define VOIP_VOPENA_RTP_PT_G723 0x4
#define VOIP_VOPENA_RTP_PT_DVI4_8K 0x5
#define VOIP_VOPENA_RTP_PT_DVI4_16K 0x6
#define VOIP_VOPENA_RTP_PT_LPC 0x7
#define VOIP_VOPENA_RTP_PT_PCMA 0x8
#define VOIP_VOPENA_RTP_PT_G722 0x9
#define VOIP_VOPENA_RTP_PT_L16_44K1_STEREO 0xA
#define VOIP_VOPENA_RTP_PT_L16_44K1_MONO 0xB
#define VOIP_VOPENA_RTP_PT_QCELP 0xC
#define VOIP_VOPENA_RTP_PT_CN 0xD
#define VOIP_VOPENA_RTP_PT_MPA 0xE
#define VOIP_VOPENA_RTP_PT_G728 0xF
#define VOIP_VOPENA_RTP_PT_DVI4_11K025 0x10
#define VOIP_VOPENA_RTP_PT_DVI4_22K050 0x11
#define VOIP_VOPENA_RTP_PT_G729 0x12
#define VOIP_VOPENA_RTP_PT_CELB 0x19
#define VOIP_VOPENA_RTP_PT_JPEG 0x1A
#define VOIP_VOPENA_RTP_PT_NV 0x1C
#define VOIP_VOPENA_RTP_PT_H261 0x1F
#define VOIP_VOPENA_RTP_PT_MPV 0x20
#define VOIP_VOPENA_RTP_PT_MP2T 0x21
#define VOIP_VOPENA_RTP_PT_H263 0x22
#define VOIP_VOPENA_RTP_V_DEFAULT 0x2

#define VOIP_VOPENA_RTP_P_NOPADDING 0x0
#define VOIP_VOPENA_RTP_P_PADDING 0x1
#define VOIP_VOPENA_RTP_P_DEFAULT 0x0

#define VOIP_VOPENA_RTP_X_NOEXTENSION 0x0
#define VOIP_VOPENA_RTP_X_EXTENSION 0x1
#define VOIP_VOPENA_RTP_X_DEFAULT 0x0

#define VOIP_VOPENA_RTP_SEQ_DEFAULT 0x0


/* Definitions associated to VOIP_VOPDIS */
#define VOIP_VOPDIS_MODE_DISABLE 0x0
#define VOIP_VOPDIS_MODE_DEFAULT 0x0


/* Definitions associated to VOIP_VCEOPT */
#define VOIP_VCEOPT_VADTYPE_DISABLE 0x0
#define VOIP_VCEOPT_VADTYPE_ENABLE 0x1
#define VOIP_VCEOPT_VADTYPE_ENABLE_PT13 0x2
#define VOIP_VCEOPT_VADTYPE_DEFAULT 0x0

#define VOIP_VCEOPT_ADAPTIVE_POST_FILTER_DISABLE 0x0
#define VOIP_VCEOPT_ADAPTIVE_POST_FILTER_ENABLE 0x1
#define VOIP_VCEOPT_ADAPTIVE_POST_FILTER_DEFAULT 0x1

#define VOIP_VCEOPT_G_723_RATE_LOW 0x0
#define VOIP_VCEOPT_G_723_RATE_HIGH 0x1
#define VOIP_VCEOPT_G_723_RATE_DEFAULT 0x1

#define VOIP_VCEOPT_PACKET_GENERATION_ENABLE 0x0
#define VOIP_VCEOPT_PACKET_GENERATION_DISABLE 0x1
#define VOIP_VCEOPT_PACKET_GENERATION_DEFAULT 0x0

#define VOIP_VCEOPT_G_723_DC_REMOVAL_ENABLE 0x0
#define VOIP_VCEOPT_G_723_DC_REMOVAL_DISABLE 0x1
#define VOIP_VCEOPT_G_723_DC_REMOVAL_DEFAULT 0x0

#define VOIP_VCEOPT_CNG_ENABLE 0x0
#define VOIP_VCEOPT_CNG_DISABLE 0x1
#define VOIP_VCEOPT_CNG_DEFAULT 0x0

#define VOIP_VCEOPT_COMPANDER_ALAW 0x0
#define VOIP_VCEOPT_COMPANDER_MULAW 0x1
#define VOIP_VCEOPT_COMPANDER_DEFAULT 0x1

#define VOIP_VCEOPT_PKT_RECEPT_ENABLE 0x0
#define VOIP_VCEOPT_PKT_RECEPT_DISABLE 0x1
#define VOIP_VCEOPT_PKT_RECEPT_DEFAULT 0x0

#define VOIP_VCEOPT_UDPTL_DISABLE 0x0
#define VOIP_VCEOPT_UDPTL_ENABLE 0x1
#define VOIP_VCEOPT_UDPTL_DEFAULT 0x0

#define VOIP_VCEOPT_PACKING_ITU 0x0
#define VOIP_VCEOPT_PACKING_IETF 0x1
#define VOIP_VCEOPT_PACKING_DEFAULT 0x1

#define VOIP_VCEOPT_AMR_MODE_AMRMODE_475 0x0
#define VOIP_VCEOPT_AMR_MODE_AMRMODE_515 0x1
#define VOIP_VCEOPT_AMR_MODE_AMRMODE_590 0x2
#define VOIP_VCEOPT_AMR_MODE_AMRMODE_670 0x3
#define VOIP_VCEOPT_AMR_MODE_AMRMODE_740 0x4
#define VOIP_VCEOPT_AMR_MODE_AMRMODE_795 0x5
#define VOIP_VCEOPT_AMR_MODE_AMRMODE_102 0x6
#define VOIP_VCEOPT_AMR_MODE_AMRMODE_122 0x7
#define VOIP_VCEOPT_AMR_MODE_DEFAULT 0x7

#define VOIP_VCEOPT_REDUNDANCY_DISABLE 0x0
#define VOIP_VCEOPT_REDUNDANCY_ENABLE_1 0x1
#define VOIP_VCEOPT_REDUNDANCY_ENABLE_2 0x2
#define VOIP_VCEOPT_REDUNDANCY_ENABLE_3 0x3
#define VOIP_VCEOPT_REDUNDANCY_DEFAULT 0x0

#define VOIP_VCEOPT_VAD_TUNE_DEFAULT 0x4

#define VOIP_VCEOPT_G711_MODEL_DEFAULT 0x0

#define VOIP_VCEOPT_CNG_MODEL_DEFAULT 0x0

#define VOIP_VCEOPT_AMR_FRAME_FORMAT_FT1 0x0
#define VOIP_VCEOPT_AMR_FRAME_FORMAT_FT2 0x1
#define VOIP_VCEOPT_AMR_FRAME_FORMAT_DEFAULT 0x0

#define VOIP_VCEOPT_RESERVED_DEFAULT 0x0

#define VOIP_VCEOPT_TRANSCODE_MODE_DISABLE 0x0
#define VOIP_VCEOPT_TRANSCODE_MODE_ENABLE 0x1
#define VOIP_VCEOPT_TRANSCODE_MODE_DEFAULT 0x0

#define VOIP_VCEOPT_AMR_WB_CRC_DISABLE 0x0
#define VOIP_VCEOPT_AMR_WB_CRC_ENABLE 0x1
#define VOIP_VCEOPT_AMR_WB_CRC_DEFAULT 0x0

#define VOIP_VCEOPT_AMR_WB_RATE_AMR_WB_660 0x0
#define VOIP_VCEOPT_AMR_WB_RATE_AMR_WB_885 0x1
#define VOIP_VCEOPT_AMR_WB_RATE_AMR_WB_1265 0x2
#define VOIP_VCEOPT_AMR_WB_RATE_AMR_WB_1425 0x3
#define VOIP_VCEOPT_AMR_WB_RATE_AMR_WB_1585 0x4
#define VOIP_VCEOPT_AMR_WB_RATE_AMR_WB_1825 0x5
#define VOIP_VCEOPT_AMR_WB_RATE_AMR_WB_1985 0x6
#define VOIP_VCEOPT_AMR_WB_RATE_AMR_WB_2305 0x7
#define VOIP_VCEOPT_AMR_WB_RATE_AMR_WB_2385 0x8
#define VOIP_VCEOPT_AMR_WB_RATE_DEFAULT 0x0

#define VOIP_VCEOPT_CDMA_RATE_DISABLE 0x0
#define VOIP_VCEOPT_CDMA_RATE_ENABLE 0x1
#define VOIP_VCEOPT_CDMA_RATE_DEFAULT 0x0

#define VOIP_VCEOPT_G729EG_RATE_RATE8 0x0
#define VOIP_VCEOPT_G729EG_RATE_RATE11 0x1
#define VOIP_VCEOPT_G729EG_RATE_DEFAULT 0x0

#define VOIP_VCEOPT_CRC_FOR_AMR_DISABLE 0x0
#define VOIP_VCEOPT_CRC_FOR_AMR_ENABLE 0x1
#define VOIP_VCEOPT_CRC_FOR_AMR_DEFAULT 0x0

#define VOIP_VCEOPT_BITS_PER_SAMPLE_BITS8 0x0
#define VOIP_VCEOPT_BITS_PER_SAMPLE_BITS16 0x1
#define VOIP_VCEOPT_BITS_PER_SAMPLE_DEFAULT 0x0

#define VOIP_VCEOPT_PLC_CFG_DISABLE 0x0
#define VOIP_VCEOPT_PLC_CFG_ENABLE 0x1
#define VOIP_VCEOPT_PLC_CFG_DEFAULT 0x1


/* Definitions associated to VOIP_DTMFOPT */
#define VOIP_DTMFOPT_SSRC_NTE 0x0
#define VOIP_DTMFOPT_SSRC_DTMF 0x1
#define VOIP_DTMFOPT_SSRC_DEFAULT 0x0

#define VOIP_DTMFOPT_SILENCE_REMOVAL_DISABLE 0x0
#define VOIP_DTMFOPT_SILENCE_REMOVAL_ENABLE 0x1
#define VOIP_DTMFOPT_SILENCE_REMOVAL_DEFAULT 0x0

#define VOIP_DTMFOPT_RFC_PACKET_FORMAT_EVENTS 0x0
#define VOIP_DTMFOPT_RFC_PACKET_FORMAT_TONES 0x1
#define VOIP_DTMFOPT_RFC_PACKET_FORMAT_DEFAULT 0x0

#define VOIP_DTMFOPT_EVENT_REPORT_DISABLE 0x0
#define VOIP_DTMFOPT_EVENT_REPORT_ENABLE 0x1
#define VOIP_DTMFOPT_EVENT_REPORT_DEFAULT 0x0

#define VOIP_DTMFOPT_REGENERATION_ENABLE 0x0
#define VOIP_DTMFOPT_REGENERATION_DISABLE 0x1
#define VOIP_DTMFOPT_REGENERATION_DEFAULT 0x0

#define VOIP_DTMFOPT_REMOVAL_ENABLE 0x0
#define VOIP_DTMFOPT_REMOVAL_DISABLE 0x1
#define VOIP_DTMFOPT_REMOVAL_DEFAULT 0x0

#define VOIP_DTMFOPT_REDUNDANCY_IETF 0x0
#define VOIP_DTMFOPT_REDUNDANCY_AAL2 0x1
#define VOIP_DTMFOPT_REDUNDANCY_DEFAULT 0x0

#define VOIP_DTMFOPT_DTMF_RTP_DISABLE 0x0
#define VOIP_DTMFOPT_DTMF_RTP_ENABLE 0x1
#define VOIP_DTMFOPT_DTMF_RTP_DEFAULT 0x0

#define VOIP_DTMFOPT_DTMF_VOICE_DISABLE 0x0
#define VOIP_DTMFOPT_DTMF_VOICE_ENABLE 0x1
#define VOIP_DTMFOPT_DTMF_VOICE_DEFAULT 0x1


/* Definitions associated to VOIP_DGAIN */
#define VOIP_DGAIN_PACKET_TO_PCM_GAIN_DEFAULT 0x0

#define VOIP_DGAIN_PCM_TO_PACKET_GAIN_DEFAULT 0x0


/* Definitions associated to VOIP_ECHOCAN */
#define VOIP_ECHOCAN_ECENB_DISABLE 0x0
#define VOIP_ECHOCAN_ECENB_ENABLE 0x1
#define VOIP_ECHOCAN_ECENB_DEFAULT 0x1

#define VOIP_ECHOCAN_EC_DC_REMOVAL_ENABLE 0x0
#define VOIP_ECHOCAN_EC_DC_REMOVAL_DISABLE 0x1
#define VOIP_ECHOCAN_EC_DC_REMOVAL_DEFAULT 0x0

#define VOIP_ECHOCAN_EC_H_RESET_INIT_FINISHED 0x0
#define VOIP_ECHOCAN_EC_H_RESET_INIT 0x1
#define VOIP_ECHOCAN_EC_H_RESET_DEFAULT 0x0

#define VOIP_ECHOCAN_ECINIT_INIT_FINISHED 0x0
#define VOIP_ECHOCAN_ECINIT_INIT 0x1
#define VOIP_ECHOCAN_ECINIT_DEFAULT 0x0

#define VOIP_ECHOCAN_HECFRZ_UPDATE 0x0
#define VOIP_ECHOCAN_HECFRZ_FREEZE 0x1
#define VOIP_ECHOCAN_HECFRZ_DEFAULT 0x0

#define VOIP_ECHOCAN_NLP_ENABLE 0x0
#define VOIP_ECHOCAN_NLP_DISABLE 0x1
#define VOIP_ECHOCAN_NLP_DEFAULT 0x0

#define VOIP_ECHOCAN_NLPTUNE_HI_DEFAULT 0x0

#define VOIP_ECHOCAN_CNG_ENABLE 0x0
#define VOIP_ECHOCAN_CNG_DISABLE 0x1
#define VOIP_ECHOCAN_CNG_DEFAULT 0x0

#define VOIP_ECHOCAN_NLPTUNE_LO_DEFAULT 0x0

#define VOIP_ECHOCAN_HECLEN_DEFAULT 0x7


/* Definitions associated to VOIP_DFECAN */
#define VOIP_DFECAN_ECENB_DISABLE 0x0
#define VOIP_DFECAN_ECENB_ENABLE 0x1
#define VOIP_DFECAN_ECENB_DEFAULT 0x1

#define VOIP_DFECAN_ECDCD_ENABLE 0x0
#define VOIP_DFECAN_ECDCD_DISABLE 0x1
#define VOIP_DFECAN_ECDCD_DEFAULT 0x0

#define VOIP_DFECAN_ECTTS_DISABLE 0x0
#define VOIP_DFECAN_ECTTS_ENABLE 0x1
#define VOIP_DFECAN_ECTTS_DEFAULT 0x0

#define VOIP_DFECAN_ECINIT_DISABLE 0x0
#define VOIP_DFECAN_ECINIT_ENABLE 0x1
#define VOIP_DFECAN_ECINIT_DEFAULT 0x0

#define VOIP_DFECAN_ECFRZ_ENABLE 0x0
#define VOIP_DFECAN_ECFRZ_DISABLE 0x1
#define VOIP_DFECAN_ECFRZ_DEFAULT 0x0

#define VOIP_DFECAN_ECNLP_ENABLE 0x0
#define VOIP_DFECAN_ECNLP_DISABLE 0x1
#define VOIP_DFECAN_ECNLP_DEFAULT 0x0

#define VOIP_DFECAN_ECDYN_DISABLE 0x0
#define VOIP_DFECAN_ECDYN_ENABLE 0x1
#define VOIP_DFECAN_ECDYN_DEFAULT 0x0

#define VOIP_DFECAN_ECBNR_DISABLE 0x0
#define VOIP_DFECAN_ECBNR_ENABLE 0x1
#define VOIP_DFECAN_ECBNR_DEFAULT 0x0

#define VOIP_DFECAN_ECSPF_FULL 0x0
#define VOIP_DFECAN_ECSPF_SPARSE 0x1
#define VOIP_DFECAN_ECSPF_DEFAULT 0x1

#define VOIP_DFECAN_ECCNG_ENABLE 0x0
#define VOIP_DFECAN_ECCNG_DISABLE 0x1
#define VOIP_DFECAN_ECCNG_DEFAULT 0x0

#define VOIP_DFECAN_ECFLT_ENABLE 0x0
#define VOIP_DFECAN_ECFLT_DISABLE 0x1
#define VOIP_DFECAN_ECFLT_DEFAULT 0x0

#define VOIP_DFECAN_ECRDC_DISABLE 0x0
#define VOIP_DFECAN_ECRDC_ENABLE 0x1
#define VOIP_DFECAN_ECRDC_DEFAULT 0x0

#define VOIP_DFECAN_ECLEN_DEFAULT 0xF


/* Definitions associated to VOIP_DFECTUNE */
#define VOIP_DFECTUNE_CONT_NO 0x0
#define VOIP_DFECTUNE_CONT_YES 0x1
#define VOIP_DFECTUNE_CONT_DEFAULT 0x1


/* Definitions associated to VOIP_TONEGEN */
#define VOIP_TONEGEN_CADENCE_RPT_DEFAULT 0x0

#define VOIP_TONEGEN_CONCURRENTLY_DISABLE 0x0
#define VOIP_TONEGEN_CONCURRENTLY_ENABLE 0x1
#define VOIP_TONEGEN_CONCURRENTLY_DEFAULT 0x0

#define VOIP_TONEGEN_MIX_MODE_OFF_DISABLE 0x0
#define VOIP_TONEGEN_MIX_MODE_OFF_ENABLE 0x1
#define VOIP_TONEGEN_MIX_MODE_OFF_DEFAULT 0x0

#define VOIP_TONEGEN_MIX_MODE_ON_DISABLE 0x0
#define VOIP_TONEGEN_MIX_MODE_ON_ENABLE 0x1
#define VOIP_TONEGEN_MIX_MODE_ON_DEFAULT 0x0

#define VOIP_TONEGEN_PROT_GEN_MANUAL 0x0
#define VOIP_TONEGEN_PROT_GEN_AUTO 0x1
#define VOIP_TONEGEN_PROT_GEN_DEFAULT 0x0

#define VOIP_TONEGEN_TIMESTAMP_CTRL_IGNORE 0x0
#define VOIP_TONEGEN_TIMESTAMP_CTRL_SYNC 0x1
#define VOIP_TONEGEN_TIMESTAMP_CTRL_END_LIMIT 0x2
#define VOIP_TONEGEN_TIMESTAMP_CTRL_RANGE_LIMIT 0x3
#define VOIP_TONEGEN_TIMESTAMP_CTRL_DEFAULT 0x0

#define VOIP_TONEGEN_TONE_DIR_IF_PCM 0x0
#define VOIP_TONEGEN_TONE_DIR_IF_PACKET 0x1
#define VOIP_TONEGEN_START_TS_L_DEFAULT 0x0

#define VOIP_TONEGEN_START_TS_M_DEFAULT 0x0

#define VOIP_TONEGEN_LIM_TS_L_DEFAULT 0x0

#define VOIP_TONEGEN_LIM_TS_M_DEFAULT 0x0


/* Definitions associated to VOIP_TONEDET */
#define VOIP_TONEDET_TONE_START_DTMF_0 0x0
#define VOIP_TONEDET_TONE_START_DTMF_1 0x1
#define VOIP_TONEDET_TONE_START_DTMF_2 0x2
#define VOIP_TONEDET_TONE_START_DTMF_3 0x3
#define VOIP_TONEDET_TONE_START_DTMF_4 0x4
#define VOIP_TONEDET_TONE_START_DTMF_5 0x5
#define VOIP_TONEDET_TONE_START_DTMF_6 0x6
#define VOIP_TONEDET_TONE_START_DTMF_7 0x7
#define VOIP_TONEDET_TONE_START_DTMF_8 0x8
#define VOIP_TONEDET_TONE_START_DTMF_9 0x9
#define VOIP_TONEDET_TONE_START_DTMF_S 0xA
#define VOIP_TONEDET_TONE_START_DTMF_P 0xB
#define VOIP_TONEDET_TONE_START_DTMF_A 0xC
#define VOIP_TONEDET_TONE_START_DTMF_B 0xD
#define VOIP_TONEDET_TONE_START_DTMF_C 0xE
#define VOIP_TONEDET_TONE_START_DTMF_D 0xF
#define VOIP_TONEDET_TONE_START_V_25_ANSWER_NO_PHASEREV 0x10
#define VOIP_TONEDET_TONE_START_V_25_ANSWER_PHASEREV 0x11
#define VOIP_TONEDET_TONE_START_V_8_ANSAM_PHASEREV 0x12
#define VOIP_TONEDET_TONE_START_V_8_ANSAM_NO_PHASEREV 0x13
#define VOIP_TONEDET_TONE_START_V_8BIS_CRE 0x14
#define VOIP_TONEDET_TONE_START_V_18_BAUDOT 0x15
#define VOIP_TONEDET_TONE_START_V_18_EDT 0x17
#define VOIP_TONEDET_TONE_BELL_ANS_2225 0x1A
#define VOIP_TONEDET_TONE_PRE_STD_V32_AA_TONE 0x1B
#define VOIP_TONEDET_TONE_PROG_TONE 0x1C
#define VOIP_TONEDET_TONE_T30_CNG_START 0x20
#define VOIP_TONEDET_TONE_START_V21_FLAGS 0x22
#define VOIP_TONEDET_TONE_V23MODEM_LOW  0x23
#define VOIP_TONEDET_TONE_V21MODEM_LOW  0x24
#define VOIP_TONEDET_TONE_BELL_ANS_1270 0x25
#define VOIP_TONEDET_TONE_V23MODEM_HIGH 0x26
#define VOIP_TONEDET_TONE_V21MODEM_HIGH 0x27
#define VOIP_TONEDET_TONE_COT_TONE 0x2A
#define VOIP_TONEDET_TONE_START_CPT 0x30
#define VOIP_TONEDET_TONE_INACTIVITY_TIMEOUT 0x31
#define VOIP_TONEDET_TONE_START_2010_HZ 0x50
#define VOIP_TONEDET_TONE_START_1780_HZ 0x51
#define VOIP_TONEDET_TONE_START_TDET_0 0x60
#define VOIP_TONEDET_TONE_START_TDET_1 0x61
#define VOIP_TONEDET_TONE_START_TDET_2 0x62
#define VOIP_TONEDET_TONE_START_TDET_3 0x63
#define VOIP_TONEDET_TONE_START_TDET_4 0x64
#define VOIP_TONEDET_TONE_START_TDET_5 0x65
#define VOIP_TONEDET_TONE_START_TDET_6 0x66
#define VOIP_TONEDET_TONE_START_TDET_7 0x67
#define VOIP_TONEDET_TONE_EARLY_CAS 0x70
#define VOIP_TONEDET_TONE_CAS 0x71
#define VOIP_TONEDET_TONE_START_EDETCED 0x81
#define VOIP_TONEDET_TONE_START_2002_HZ 0x82
#define VOIP_TONEDET_TONE_END_TDET_0 0xE0
#define VOIP_TONEDET_TONE_END_TDET_1 0xE1
#define VOIP_TONEDET_TONE_END_TDET_2 0xE2
#define VOIP_TONEDET_TONE_END_TDET_3 0xE3
#define VOIP_TONEDET_TONE_END_TDET_4 0xE4
#define VOIP_TONEDET_TONE_END_TDET_5 0xE5
#define VOIP_TONEDET_TONE_END_TDET_6 0xE6
#define VOIP_TONEDET_TONE_END_TDET_7 0xE7
#define VOIP_TONEDET_TONE_END 0xFF


/* Definitions associated to VOIP_TCMPLT */
#define VOIP_TCMPLT_REASON_NORMAL 0x0
#define VOIP_TCMPLT_REASON_PASSED_LIMIT 0x1
#define VOIP_TCMPLT_REASON_NOT_REACH_START 0x2
#define VOIP_TCMPLT_REASON_TONEOFF 0x3
#define VOIP_TCMPLT_REASON_NULLTONEGEN 0x4
#define VOIP_TCMPLT_REASON_NEWTONEGEN 0x5
#define VOIP_TCMPLT_REASON_OVERRIDE 0x6
#define VOIP_TCMPLT_REASON_PROTECTED 0x7
#define VOIP_TCMPLT_REASON_BUFFER_FULL 0x8
#define VOIP_TCMPLT_REASON_NOTPROTECTED_DROP 0x9
#define VOIP_TCMPLT_REASON_REPLACE_UNPROT 0xA
#define VOIP_TCMPLT_REASON_TOO_EARLY 0xB
#define VOIP_TCMPLT_REASON_NEW_DIGITSTRING 0xC
#define VOIP_TCMPLT_TONEDIR_RESERVED 0x0
#define VOIP_TCMPLT_TONEDIR_PCM 0x1
#define VOIP_TCMPLT_TONEDIR_IP 0x2


/* Definitions associated to VOIP_LOOPBACK */
#define VOIP_LOOPBACK_MODE_OFF 0x0
#define VOIP_LOOPBACK_MODE_TDM_LB 0x1
#define VOIP_LOOPBACK_MODE_PRE_ENC_LB 0x2
#define VOIP_LOOPBACK_MODE_POST_ENC_LB 0x3
#define VOIP_LOOPBACK_MODE_RTP_DECODER 0x4
#define VOIP_LOOPBACK_MODE_INTER_CHAN 0x5
#define VOIP_LOOPBACK_MODE_RESERVED 0x6
#define VOIP_LOOPBACK_MODE_TDM_CDMA 0x7


/* Definitions associated to VOIP_TONEOFF */
#define VOIP_TONEOFF_TONEDIR_BOTH 0x0
#define VOIP_TONEOFF_TONEDIR_PCM 0x1
#define VOIP_TONEOFF_TONEDIR_IP 0x2


/* Definitions associated to VOIP_EVENTDET */
#define VOIP_EVENTDET_EVENT_DTMF_0 0x0
#define VOIP_EVENTDET_EVENT_DTMF_1 0x1
#define VOIP_EVENTDET_EVENT_DTMF_2 0x2
#define VOIP_EVENTDET_EVENT_DTMF_3 0x3
#define VOIP_EVENTDET_EVENT_DTMF_4 0x4
#define VOIP_EVENTDET_EVENT_DTMF_5 0x5
#define VOIP_EVENTDET_EVENT_DTMF_6 0x6
#define VOIP_EVENTDET_EVENT_DTMF_7 0x7
#define VOIP_EVENTDET_EVENT_DTMF_8 0x8
#define VOIP_EVENTDET_EVENT_DTMF_9 0x9
#define VOIP_EVENTDET_EVENT_DTMF_S 0xA
#define VOIP_EVENTDET_EVENT_DTMF_P 0xB
#define VOIP_EVENTDET_EVENT_DTMF_A 0xC
#define VOIP_EVENTDET_EVENT_DTMF_B 0xD
#define VOIP_EVENTDET_EVENT_DTMF_C 0xE
#define VOIP_EVENTDET_EVENT_DTMF_D 0xF
#define VOIP_EVENTDET_EVENT_V_18_BAUDOT 0x15
#define VOIP_EVENTDET_EVENT_V_18_EDT 0x17
#define VOIP_EVENTDET_EVENT_CPT_DIAL_TONE 0x32
#define VOIP_EVENTDET_EVENT_CPT_RING_BACK 0x33
#define VOIP_EVENTDET_EVENT_CPT_BUSY_TONE 0x34
#define VOIP_EVENTDET_EVENT_CPT_NUMBER_UNREACHABLE 0x35
#define VOIP_EVENTDET_EVENT_START_G_711 0x40
#define VOIP_EVENTDET_EVENT_START_FAX_CNG_TONE 0x41
#define VOIP_EVENTDET_EVENT_END_FAX_CNG_TONE 0x42
#define VOIP_EVENTDET_EVENT_SPECIAL_TONE 0x43
#define VOIP_EVENTDET_EVENT_START_CONCURRENT_G_711_MULAW 0x44
#define VOIP_EVENTDET_EVENT_START_CONCURRENT_G_711_ALAW 0x45
#define VOIP_EVENTDET_EVENT_START_PASS_THROUGH 0x46
#define VOIP_EVENTDET_EVENT_START_CONCURRENT_PASS_THROUGH_MULAW 0x47
#define VOIP_EVENTDET_EVENT_START_CONCURRENT_PASS_THROUGH_ALAW 0x48
#define VOIP_EVENTDET_EVENT_ALT_T_38 0x49
#define VOIP_EVENTDET_EVENT_ALT_NO_T_38 0x4A
#define VOIP_EVENTDET_EVENT_PRIMARY_SILENCE 0x50
#define VOIP_EVENTDET_EVENT_SECONDARY_SILENCE 0x51
#define VOIP_EVENTDET_EVENT_VOICE 0x52
#define VOIP_EVENTDET_EVENT_TDET_0 0x60
#define VOIP_EVENTDET_EVENT_TDET_1 0x61
#define VOIP_EVENTDET_EVENT_TDET_2 0x62
#define VOIP_EVENTDET_EVENT_TDET_3 0x63
#define VOIP_EVENTDET_EVENT_TDET_4 0x64
#define VOIP_EVENTDET_EVENT_TDET_5 0x65
#define VOIP_EVENTDET_EVENT_TDET_6 0x66
#define VOIP_EVENTDET_EVENT_TDET_7 0x67
#define VOIP_EVENTDET_EVENT_AT_0 0x80
#define VOIP_EVENTDET_EVENT_AT_1 0x81
#define VOIP_EVENTDET_EVENT_AT_2 0x82
#define VOIP_EVENTDET_EVENT_AT_3 0x83
#define VOIP_EVENTDET_EVENT_AT_4 0x84
#define VOIP_EVENTDET_EVENT_AT_5 0x85
#define VOIP_EVENTDET_EVENT_AT_6 0x86
#define VOIP_EVENTDET_EVENT_AT_7 0x87
#define VOIP_EVENTDET_EVENT_AT_8 0x88
#define VOIP_EVENTDET_EVENT_AT_9 0x89
#define VOIP_EVENTDET_EVENT_AT_A 0x8A
#define VOIP_EVENTDET_EVENT_AT_B 0x8B
#define VOIP_EVENTDET_EVENT_AT_C 0x8C
#define VOIP_EVENTDET_EVENT_AT_D 0x8D
#define VOIP_EVENTDET_EVENT_AT_E 0x8E
#define VOIP_EVENTDET_EVENT_AT_F 0x8F


/* Definitions associated to VOIP_PTMNG */
#define VOIP_PTMNG_REDUNDANT_DTMF_DEFAULT 0xFF

#define VOIP_PTMNG_GENERIC_COMFORT_NOISE_DEFAULT 0xD

#define VOIP_PTMNG_T_38_DEFAULT 0xFF

#define VOIP_PTMNG_RTP_DTMF_DEFAULT 0xFF

#define VOIP_PTMNG_G_711_ALAW_DEFAULT 0x8

#define VOIP_PTMNG_G_711_MULAW_DEFAULT 0x0

#define VOIP_PTMNG_G_728_DEFAULT 0xF

#define VOIP_PTMNG_G_723_1_DEFAULT 0x4

#define VOIP_PTMNG_G_726_32_DEFAULT 0x2

#define VOIP_PTMNG_G_729A_DEFAULT 0x12

#define VOIP_PTMNG_GSM_FR_DEFAULT 0x3

#define VOIP_PTMNG_G_727_DEFAULT 0xFF

#define VOIP_PTMNG_PASSTHROUGH_MULAW_DEFAULT 0xFF

#define VOIP_PTMNG_CLEAR_CHANNEL_DEFAULT 0xFF

#define VOIP_PTMNG_G_726_16_DEFAULT 0xFF

#define VOIP_PTMNG_PASSTHROUGH_ALAW_DEFAULT 0xFF

#define VOIP_PTMNG_G_726_40_DEFAULT 0xFF

#define VOIP_PTMNG_G_726_24_DEFAULT 0xFF

#define VOIP_PTMNG_AMR_DEFAULT 0xFF

#define VOIP_PTMNG_GSM_EFR_DEFAULT 0xFF

#define VOIP_PTMNG_CNF_SEC_DEFAULT 0xD

#define VOIP_PTMNG_EVRC_DEFAULT 0xFF

#define VOIP_PTMNG_QCELP_13K_DEFAULT 0xFF

#define VOIP_PTMNG_SMV_DEFAULT 0xFF

#define VOIP_PTMNG_CRBT_ADPCM_DEFAULT 0xFF

#define VOIP_PTMNG_QCELP_8K_DEFAULT 0xFF

#define VOIP_PTMNG_FEC_DEFAULT 0x64

#define VOIP_PTMNG_G729EG_DEFAULT 0xFF

#define VOIP_PTMNG_ILBC_13K_DEFAULT 0xFF

#define VOIP_PTMNG_ILBC_15K_DEFAULT 0xFF

#define VOIP_PTMNG_AMR_BWE_DEFAULT 0xFF

#define VOIP_PTMNG_RFC2833_EVENT_DEFAULT 0xFF

#define VOIP_PTMNG_RFC2833_TONES_DEFAULT 0xFF

#define VOIP_PTMNG_FOUR_GV_DEFAULT 0xFF

#define VOIP_PTMNG_G729_MSPD_DEFAULT 0xFF

#define VOIP_PTMNG_AMR_WB_DEFAULT 0xFF

#define VOIP_PTMNG_GSM_HR_DEFAULT 0xFF

#define VOIP_PTMNG_CESOPSN_DEFAULT 0xFF

#define VOIP_PTMNG_CSD_BS30T_32K_DEFAULT 0xFF

#define VOIP_PTMNG_CSD_BS30T_64K_DEFAULT 0xFF

#define VOIP_PTMNG_CSD_BS30T_28K8_DEFAULT 0xFF

#define VOIP_PTMNG_CSD_BS30T_33K6_DEFAULT 0xFF

#define VOIP_PTMNG_CSD_BS20NT_28K8_DEFAULT 0xFF

#define VOIP_PTMNG_CSD_BS20NT_57K6_DEFAULT 0xFF

#define VOIP_PTMNG_G729_WB_DEFAULT 0xFF

#define VOIP_PTMNG_CSD_BS20NT_14K4_DEFAULT 0xFF

#define VOIP_PTMNG_CCISOIP_DEFAULT 0xFF

#define VOIP_PTMNG_AMRWB_OL_DEFAULT 0xFF

#define VOIP_PTMNG_ISLP_DEFAULT 0xFF

#define VOIP_PTMNG_G_722_DEFAULT 0xFF


/* Definitions associated to VOIP_SENDNTE */
#define VOIP_SENDNTE_NTE_PAYLOAD_MST_DEFAULT 0x0

#define VOIP_SENDNTE_NTE_PAYLOAD_LST_DEFAULT 0x0

#define VOIP_SENDNTE_STOP_EVENT_DEFAULT 0x0

#define VOIP_SENDNTE_START_EVENT_DEFAULT 0x0

#define VOIP_SENDNTE_SINGLE_NTE_OVD_DEFAULT 0x0

#define VOIP_SENDNTE_DFT_REDD_VAL_OVD_DEFAULT 0x0

#define VOIP_SENDNTE_PAYLOAD_TYPE_OVD_DEFAULT 0x0

#define VOIP_SENDNTE_SSRC_TYPE_OVD_DEFAULT 0x0

#define VOIP_SENDNTE_REDD_INTERVAL_OVD_DEFAULT 0x0

#define VOIP_SENDNTE_REDD_OVD_DEFAULT 0x0

#define VOIP_SENDNTE_REDD_INTERVAL_DEFAULT 0x0

#define VOIP_SENDNTE_HIGH_SSRC_DEFAULT 0x0

#define VOIP_SENDNTE_LOW_SSRC_DEFAULT 0x0

#define VOIP_SENDNTE_PAYLOAD_TYPE_DEFAULT 0x0

#define VOIP_SENDNTE_GUARD_TIMER_DEFAULT 0x1F40


/* Definitions associated to VOIP_DTMFDPAR */
#define VOIP_DTMFDPAR_MIN_TONE_ON_TIME_DEFAULT 0x1E

#define VOIP_DTMFDPAR_MIN_TONE_OFF_TIME_DEFAULT 0x23

#define VOIP_DTMFDPAR_MAX_TONE_DROPOUT_DEFAULT 0x14

#define VOIP_DTMFDPAR_ANTI_TAPP_DIGD_DISABLE 0x0
#define VOIP_DTMFDPAR_ANTI_TAPP_DIGD_ENABLE 0x1
#define VOIP_DTMFDPAR_ANTI_TAPP_DIGD_DEFAULT 0x0

#define VOIP_DTMFDPAR_DTMFDPAR_ANTI_TAPPING_DISABLE 0x0
#define VOIP_DTMFDPAR_DTMFDPAR_ANTI_TAPPING_ENABLE 0x1
#define VOIP_DTMFDPAR_DTMFDPAR_ANTI_TAPPING_DEFAULT 0x0

#define VOIP_DTMFDPAR_MIN_ANTI_TAPP_ON_DEFAULT 0x0

#define VOIP_DTMFDPAR_MIN_ANTI_TAPP_OFF_DEFAULT 0x0

#define VOIP_DTMFDPAR_MAX_ANTI_TAPP_DROPOUT_DEFAULT 0x0


/* Definitions associated to VOIP_SS7COT */
#define VOIP_SS7COT_MONITOR_1780_DISABLE 0x0
#define VOIP_SS7COT_MONITOR_1780_ENABLE 0x1
#define VOIP_SS7COT_MONITOR_1780_DEFAULT 0x0

#define VOIP_SS7COT_MONITOR_2010_DISABLE 0x0
#define VOIP_SS7COT_MONITOR_2010_ENABLE 0x1
#define VOIP_SS7COT_MONITOR_2010_DEFAULT 0x0

#define VOIP_SS7COT_TX_FREQUENCY_HZ1780 0x0
#define VOIP_SS7COT_TX_FREQUENCY_HZ2010 0x1
#define VOIP_SS7COT_TX_FREQUENCY_DEFAULT 0x0

#define VOIP_SS7COT_OPERATION_IDLE 0x0
#define VOIP_SS7COT_OPERATION_PROBING 0x1
#define VOIP_SS7COT_OPERATION_MONITOR 0x2
#define VOIP_SS7COT_OPERATION_LB_DESIG_FREQ 0x3
#define VOIP_SS7COT_OPERATION_LB_ALT_FREQ 0x4
#define VOIP_SS7COT_OPERATION_LB_ORIG_FREQ 0x5
#define VOIP_SS7COT_OPERATION_DEFAULT 0x0


/* Definitions associated to VOIP_DTMFTUNE */
#define VOIP_DTMFTUNE_FREQUENCY_DEVIATION_DEFAULT 0x12

#define VOIP_DTMFTUNE_DETECTION_DELAY_DELAY_18MS 0x0
#define VOIP_DTMFTUNE_DETECTION_DELAY_DELAY_30MS 0x2
#define VOIP_DTMFTUNE_DETECTION_DELAY_DELAY_40MS 0x3
#define VOIP_DTMFTUNE_DETECTION_DELAY_DEFAULT 0x3

#define VOIP_DTMFTUNE_INTERMODULATION_DISTORTION_COMPENSATION_DISABLE 0x0
#define VOIP_DTMFTUNE_INTERMODULATION_DISTORTION_COMPENSATION_ENABLE 0x1
#define VOIP_DTMFTUNE_INTERMODULATION_DISTORTION_COMPENSATION_DEFAULT 0x0


/* Definitions associated to VOIP_QUADTONEGEN */
#define VOIP_QUADTONEGEN_CTRL_DEFAULT 0x0

#define VOIP_QUADTONEGEN_RESERVED0_DEFAULT 0x0


/* Definitions associated to VOIP_TONECTRL */
#define VOIP_TONECTRL_ANSAM_DET_DISABLE 0x0
#define VOIP_TONECTRL_ANSAM_DET_ENABLE 0x1
#define VOIP_TONECTRL_ANSAM_DET_DEFAULT 0x0

#define VOIP_TONECTRL_TDM_PTD_DISABLE 0x0
#define VOIP_TONECTRL_TDM_PTD_ENABLE 0x1
#define VOIP_TONECTRL_TDM_PTD_DEFAULT 0x0

#define VOIP_TONECTRL_FFT_TONE_DISABLE 0x0
#define VOIP_TONECTRL_FFT_TONE_ENABLE 0x1
#define VOIP_TONECTRL_FFT_TONE_DEFAULT 0x0

#define VOIP_TONECTRL_FFT_EVENT_DISABLE 0x0
#define VOIP_TONECTRL_FFT_EVENT_ENABLE 0x1
#define VOIP_TONECTRL_FFT_EVENT_DEFAULT 0x0

#define VOIP_TONECTRL_CALL_PROGRESS_DET_DISABLE 0x0
#define VOIP_TONECTRL_CALL_PROGRESS_DET_ENABLE 0x1
#define VOIP_TONECTRL_CALL_PROGRESS_DET_DEFAULT 0x0

#define VOIP_TONECTRL_BELL_ANS_DISABLE 0x0
#define VOIP_TONECTRL_BELL_ANS_ENABLE 0x1
#define VOIP_TONECTRL_BELL_ANS_DEFAULT 0x0

#define VOIP_TONECTRL_V32_DISABLE 0x0
#define VOIP_TONECTRL_V32_ENABLE 0x1
#define VOIP_TONECTRL_V32_DEFAULT 0x0

#define VOIP_TONECTRL_NOTCH_FILTER_DISABLE 0x0
#define VOIP_TONECTRL_NOTCH_FILTER_ENABLE 0x1
#define VOIP_TONECTRL_NOTCH_FILTER_DEFAULT 0x0

#define VOIP_TONECTRL_CALL_PROGRESS_IND_DISABLE 0x0
#define VOIP_TONECTRL_CALL_PROGRESS_IND_ENABLE 0x1
#define VOIP_TONECTRL_CALL_PROGRESS_IND_DEFAULT 0x0

#define VOIP_TONECTRL_ANSWER_TONE_CTRL_DISABLE 0x0
#define VOIP_TONECTRL_ANSWER_TONE_CTRL_ENABLE 0x1
#define VOIP_TONECTRL_ANSWER_TONE_CTRL_DEFAULT 0x0

#define VOIP_TONECTRL_FAX_CALL_CTRL_DISABLE 0x0
#define VOIP_TONECTRL_FAX_CALL_CTRL_ENABLE 0x1
#define VOIP_TONECTRL_FAX_CALL_CTRL_DEFAULT 0x0

#define VOIP_TONECTRL_V8BIS_2002HZ_CTRL_DISABLE 0x0
#define VOIP_TONECTRL_V8BIS_2002HZ_CTRL_ENABLE 0x1
#define VOIP_TONECTRL_V8BIS_2002HZ_CTRL_DEFAULT 0x0

#define VOIP_TONECTRL_MODEM_PASSTHROUGH_IND_DISABLE 0x0
#define VOIP_TONECTRL_MODEM_PASSTHROUGH_IND_ENABLE 0x1
#define VOIP_TONECTRL_MODEM_PASSTHROUGH_IND_DEFAULT 0x0

#define VOIP_TONECTRL_T38_TONE_IND_DISABLE 0x0
#define VOIP_TONECTRL_T38_TONE_IND_ENABLE 0x1
#define VOIP_TONECTRL_T38_TONE_IND_DEFAULT 0x0

#define VOIP_TONECTRL_DTMF_IND_DISABLE 0x0
#define VOIP_TONECTRL_DTMF_IND_ENABLE 0x1
#define VOIP_TONECTRL_DTMF_IND_DEFAULT 0x0

#define VOIP_TONECTRL_RESERVED1_DEFAULT 0x0

#define VOIP_TONECTRL_V18_NOTCH_FILTER_ENABLE 0x0
#define VOIP_TONECTRL_V18_NOTCH_FILTER_DISABLE 0x1
#define VOIP_TONECTRL_V18_NOTCH_FILTER_DEFAULT 0x0

#define VOIP_TONECTRL_RESERVED2_DEFAULT 0x0

#define VOIP_TONECTRL_V18_BAUDOT_DISABLE 0x0
#define VOIP_TONECTRL_V18_BAUDOT_ENABLE 0x1
#define VOIP_TONECTRL_V18_BAUDOT_DEFAULT 0x0

#define VOIP_TONECTRL_RESERVED6_F0_DEFAULT 0x0

#define VOIP_TONECTRL_TDM_2000_DISABLE 0x0
#define VOIP_TONECTRL_TDM_2000_ENABLE 0x1
#define VOIP_TONECTRL_TDM_2000_DEFAULT 0x0

#define VOIP_TONECTRL_RESERVED6_60_DEFAULT 0x0

#define VOIP_TONECTRL_TDM_1650_DISABLE 0x0
#define VOIP_TONECTRL_TDM_1650_ENABLE 0x1
#define VOIP_TONECTRL_TDM_1650_DEFAULT 0x0

#define VOIP_TONECTRL_TDM_1330_DISABLE 0x0
#define VOIP_TONECTRL_TDM_1330_ENABLE 0x1
#define VOIP_TONECTRL_TDM_1330_DEFAULT 0x0

#define VOIP_TONECTRL_TDM_1270_DISABLE 0x0
#define VOIP_TONECTRL_TDM_1270_ENABLE 0x1
#define VOIP_TONECTRL_TDM_1270_DEFAULT 0x0

#define VOIP_TONECTRL_TDM_980_DISABLE 0x0
#define VOIP_TONECTRL_TDM_980_ENABLE 0x1
#define VOIP_TONECTRL_TDM_980_DEFAULT 0x0

#define VOIP_TONECTRL_TDM_390_DISABLE 0x0
#define VOIP_TONECTRL_TDM_390_ENABLE 0x1
#define VOIP_TONECTRL_TDM_390_DEFAULT 0x0

#define VOIP_TONECTRL_RESERVED7_F0_DEFAULT 0x0

#define VOIP_TONECTRL_IP_2000_DISABLE 0x0
#define VOIP_TONECTRL_IP_2000_ENABLE 0x1
#define VOIP_TONECTRL_IP_2000_DEFAULT 0x0

#define VOIP_TONECTRL_RESERVED7_60_DEFAULT 0x0

#define VOIP_TONECTRL_IP_1650_DISABLE 0x0
#define VOIP_TONECTRL_IP_1650_ENABLE 0x1
#define VOIP_TONECTRL_IP_1650_DEFAULT 0x0

#define VOIP_TONECTRL_IP_1330_DISABLE 0x0
#define VOIP_TONECTRL_IP_1330_ENABLE 0x1
#define VOIP_TONECTRL_IP_1330_DEFAULT 0x0

#define VOIP_TONECTRL_IP_1270_DISABLE 0x0
#define VOIP_TONECTRL_IP_1270_ENABLE 0x1
#define VOIP_TONECTRL_IP_1270_DEFAULT 0x0

#define VOIP_TONECTRL_IP_980_DISABLE 0x0
#define VOIP_TONECTRL_IP_980_ENABLE 0x1
#define VOIP_TONECTRL_IP_980_DEFAULT 0x0

#define VOIP_TONECTRL_IP_390_DISABLE 0x0
#define VOIP_TONECTRL_IP_390_ENABLE 0x1
#define VOIP_TONECTRL_IP_390_DEFAULT 0x0

#define VOIP_TONECTRL_RESERVED8_F0_DEFAULT 0x0

#define VOIP_TONECTRL_CAS_TONE_DET_DISABLE 0x0
#define VOIP_TONECTRL_CAS_TONE_DET_ENABLE 0x1
#define VOIP_TONECTRL_CAS_TONE_DET_DEFAULT 0x0

#define VOIP_TONECTRL_IP_V18_NOTCH_FILTER_ENABLE 0x0
#define VOIP_TONECTRL_IP_V18_NOTCH_FILTER_DISABLE 0x1
#define VOIP_TONECTRL_IP_V18_NOTCH_FILTER_DEFAULT 0x0

#define VOIP_TONECTRL_IP_V18_BAUDOT_DISABLE 0x0
#define VOIP_TONECTRL_IP_V18_BAUDOT_ENABLE 0x1
#define VOIP_TONECTRL_IP_V18_BAUDOT_DEFAULT 0x0


/* Definitions associated to VOIP_REMDET */
#define VOIP_REMDET_EVENT_UNKNOWN 0x0
#define VOIP_REMDET_EVENT_DTMF_0 0x1
#define VOIP_REMDET_EVENT_DTMF_1 0x2
#define VOIP_REMDET_EVENT_DTMF_2 0x3
#define VOIP_REMDET_EVENT_DTMF_3 0x4
#define VOIP_REMDET_EVENT_DTMF_4 0x5
#define VOIP_REMDET_EVENT_DTMF_5 0x6
#define VOIP_REMDET_EVENT_DTMF_6 0x7
#define VOIP_REMDET_EVENT_DTMF_7 0x8
#define VOIP_REMDET_EVENT_DTMF_8 0x9
#define VOIP_REMDET_EVENT_DTMF_9 0xA
#define VOIP_REMDET_EVENT_DTMF_S 0xB
#define VOIP_REMDET_EVENT_DTMF_P 0xC
#define VOIP_REMDET_EVENT_DTMF_A 0xD
#define VOIP_REMDET_EVENT_DTMF_B 0xE
#define VOIP_REMDET_EVENT_DTMF_C 0xF
#define VOIP_REMDET_EVENT_DTMF_D 0x10
#define VOIP_REMDET_EVENT_ANS 0x20
#define VOIP_REMDET_EVENT_NANS 0x21
#define VOIP_REMDET_EVENT_ANSAM 0x22
#define VOIP_REMDET_EVENT_NANSAM 0x23
#define VOIP_REMDET_EVENT_CNG 0x24
#define VOIP_REMDET_REMOTE_TYPE_UNKNOWN 0x2
#define VOIP_REMDET_REMOTE_TYPE_RFC2833_IETF 0x3
#define VOIP_REMDET_REMOTE_TYPE_RFC2833_AAL 0x4
#define VOIP_REMDET_REMOTE_TYPE_UDPTL 0x5


/* Definitions associated to VOIP_TONEOPT */
#define VOIP_TONEOPT_TONEOPT_TONEDET_DISABLE 0x0
#define VOIP_TONEOPT_TONEOPT_TONEDET_ENABLE 0x1
#define VOIP_TONEOPT_TONEOPT_TONEDET_DEFAULT 0x0

#define VOIP_TONEOPT_TONEOPT_ANSWER_DISABLE 0x0
#define VOIP_TONEOPT_TONEOPT_ANSWER_ENABLE 0x1
#define VOIP_TONEOPT_TONEOPT_ANSWER_DEFAULT 0x0

#define VOIP_TONEOPT_TONEOPT_PHASE_DISABLE 0x0
#define VOIP_TONEOPT_TONEOPT_PHASE_ENABLE 0x1
#define VOIP_TONEOPT_TONEOPT_PHASE_DEFAULT 0x0

#define VOIP_TONEOPT_TONEOPT_ANSAM_DISABLE 0x0
#define VOIP_TONEOPT_TONEOPT_ANSAM_ENABLE 0x1
#define VOIP_TONEOPT_TONEOPT_ANSAM_DEFAULT 0x0

#define VOIP_TONEOPT_TONEOPT_CONFIRMED_DISABLE 0x0
#define VOIP_TONEOPT_TONEOPT_CONFIRMED_ENABLE 0x1
#define VOIP_TONEOPT_TONEOPT_CONFIRMED_DEFAULT 0x0

#define VOIP_TONEOPT_TONEOPT_EARLY_DISABLE 0x0
#define VOIP_TONEOPT_TONEOPT_EARLY_ENABLE 0x1
#define VOIP_TONEOPT_TONEOPT_EARLY_DEFAULT 0x0


/* Definitions associated to VOIP_IPTONEDET */
#define VOIP_IPTONEDET_TONE_EARLY_2100		0x0001
#define VOIP_IPTONEDET_TONE_CONFIRMED_2100	0x0003
#define VOIP_IPTONEDET_TONE_ANSAM		0x0007
#define VOIP_IPTONEDET_TONE_PH_REVERSAL_2100	0x000B
#define VOIP_IPTONEDET_TONE_PH_REVERSAL_ANSAM	0x000F
#define VOIP_IPTONEDET_TONE_BELL_V22		0x0010
#define VOIP_IPTONEDET_TONE_V32EXTAA_1800	0x0020
#define VOIP_IPTONEDET_TONE_PROG_TONE		0x0040
#define VOIP_IPTONEDET_TONE_V18_ANNEX		0x0080
#define VOIP_IPTONEDET_TONE_GENERIC_TONE_390	0x0100
#define VOIP_IPTONEDET_TONE_GENERIC_TONE_980	0x0200
#define VOIP_IPTONEDET_TONE_GENERIC_TONE_1270	0x0400
#define VOIP_IPTONEDET_TONE_GENERIC_TONE_1300	0x0800
#define VOIP_IPTONEDET_TONE_GENERIC_TONE_1650	0x1000
#define VOIP_IPTONEDET_TONE_GENERIC_TONE_COT	0x8000
#define VOIP_IPTONEDET_TONE_TONE_END		0x00FF

/* Definitions associated to VOIP_PROGRAM_TONE_ENGINE */
#define VOIP_PROGRAM_TONE_ENGINE_RESERVED22_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED31_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED40_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED49_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED58_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED67_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED76_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED85_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED94_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED103_DEFAULT 0x0

#define VOIP_PROGRAM_TONE_ENGINE_RESERVED112_DEFAULT 0x0


/* Definitions associated to VOIP_INDCTRL */
#define VOIP_INDCTRL_ICMP_IND_ENABLE 0x0
#define VOIP_INDCTRL_ICMP_IND_DISABLE 0x1
#define VOIP_INDCTRL_ICMP_IND_DEFAULT 0x0

#define VOIP_INDCTRL_PTCHNG_IND_ENABLE 0x0
#define VOIP_INDCTRL_PTCHNG_IND_DISABLE 0x1
#define VOIP_INDCTRL_PTCHNG_IND_DEFAULT 0x0

#define VOIP_INDCTRL_JB_OVERFLOW_IND_ENABLE 0x0
#define VOIP_INDCTRL_JB_OVERFLOW_IND_DISABLE 0x1
#define VOIP_INDCTRL_JB_OVERFLOW_IND_DEFAULT 0x0

#define VOIP_INDCTRL_JB_DMAX_EXC_IND_ENABLE 0x0
#define VOIP_INDCTRL_JB_DMAX_EXC_IND_DISABLE 0x1
#define VOIP_INDCTRL_JB_DMAX_EXC_IND_DEFAULT 0x0

#define VOIP_INDCTRL_RFC2833_DTMF_IND_ENABLE 0x0
#define VOIP_INDCTRL_RFC2833_DTMF_IND_DISABLE 0x1
#define VOIP_INDCTRL_RFC2833_DTMF_IND_DEFAULT 0x0

#define VOIP_INDCTRL_INBAND_DTMF_IND_ENABLE 0x0
#define VOIP_INDCTRL_INBAND_DTMF_IND_DISABLE 0x1
#define VOIP_INDCTRL_INBAND_DTMF_IND_DEFAULT 0x0

#define VOIP_INDCTRL_DTMF_EVENT_DET_ENABLE 0x0
#define VOIP_INDCTRL_DTMF_EVENT_DET_DISABLE 0x1
#define VOIP_INDCTRL_DTMF_EVENT_DET_DEFAULT 0x0

#define VOIP_INDCTRL_DTMF_TONE_DET_ENABLE 0x0
#define VOIP_INDCTRL_DTMF_TONE_DET_DISABLE 0x1
#define VOIP_INDCTRL_DTMF_TONE_DET_DEFAULT 0x0

#define VOIP_INDCTRL_SSRCVIOL_ENABLE 0x0
#define VOIP_INDCTRL_SSRCVIOL_DISABLE 0x1
#define VOIP_INDCTRL_SSRCVIOL_DEFAULT 0x0

#define VOIP_INDCTRL_SSRCCHG_ENABLE 0x0
#define VOIP_INDCTRL_SSRCCHG_DISABLE 0x1
#define VOIP_INDCTRL_SSRCCHG_DEFAULT 0x0

#define VOIP_INDCTRL_PTCCHG_ENABLE 0x0
#define VOIP_INDCTRL_PTCCHG_DISABLE 0x1
#define VOIP_INDCTRL_PTCCHG_DEFAULT 0x0

#define VOIP_INDCTRL_PTCCHG_TIME_DEFAULT 0x0


/* Definitions associated to VOIP_JBOPT */
#define VOIP_JBOPT_DELAY_MIN_DEFAULT 0x0

#define VOIP_JBOPT_DELAY_MAX_DEFAULT 0xC8

#define VOIP_JBOPT_DELAY_INIT_DEFAULT 0x0

#define VOIP_JBOPT_AP_DEFAULT 0x2710

#define VOIP_JBOPT_IMMEDIATLY_ADJUST_FALSE 0x0
#define VOIP_JBOPT_IMMEDIATLY_ADJUST_TRUE 0x1
#define VOIP_JBOPT_IMMEDIATLY_ADJUST_DEFAULT 0x0

#define VOIP_JBOPT_DELETION_MODE_SOFT 0x0
#define VOIP_JBOPT_DELETION_MODE_HARD 0x1
#define VOIP_JBOPT_DELETION_MODE_DEFAULT 0x0

#define VOIP_JBOPT_DELETION_THRESHOLD_DEFAULT 0x1F4


/* Definitions associated to EC_CONTROL */
#define EC_CONTROL_CC_CACL_DISABLE 0x0
#define EC_CONTROL_CC_CACL_ENABLE 0x1
#define EC_CONTROL_CC_CACL_DEFAULT 0x0

#define EC_CONTROL_SPEC_EP_CHANGE_DISABLE 0x0
#define EC_CONTROL_SPEC_EP_CHANGE_ENABLE 0x1
#define EC_CONTROL_SPEC_EP_CHANGE_DEFAULT 0x0

#define EC_CONTROL_ERL_CHG_DETECTION_DISABLE 0x0
#define EC_CONTROL_ERL_CHG_DETECTION_ENABLE 0x1
#define EC_CONTROL_ERL_CHG_DETECTION_DEFAULT 0x0

#define EC_CONTROL_FC_CONTROL_DISABLE 0x0
#define EC_CONTROL_FC_CONTROL_ENABLE 0x1
#define EC_CONTROL_FC_CONTROL_DEFAULT 0x0

#define EC_CONTROL_EC_WINDOW_WND_16MS 0x3
#define EC_CONTROL_EC_WINDOW_WND_24MS 0x5
#define EC_CONTROL_EC_WINDOW_WND_32MS 0x7
#define EC_CONTROL_EC_WINDOW_WND_48MS 0xB
#define EC_CONTROL_EC_WINDOW_WND_64MS 0xF
#define EC_CONTROL_EC_WINDOW_DEFAULT 0x5


/* Definitions associated to VOIP_TONES_RELAY_OPTION */
#define VOIP_TONES_RELAY_OPTION_SEND_2833_EVENT_DISABLE 0x0
#define VOIP_TONES_RELAY_OPTION_SEND_2833_EVENT_ENABLE 0x1
#define VOIP_TONES_RELAY_OPTION_SEND_2833_EVENT_DEFAULT 0x0

#define VOIP_TONES_RELAY_OPTION_REDUNDANCY_2833_SCHEME_IETF 0x0
#define VOIP_TONES_RELAY_OPTION_REDUNDANCY_2833_SCHEME_AAL2 0x1
#define VOIP_TONES_RELAY_OPTION_REDUNDANCY_2833_SCHEME_DEFAULT 0x0

#define VOIP_TONES_RELAY_OPTION_CONTROL_M_FAX_TONES_DISABLE 0x0
#define VOIP_TONES_RELAY_OPTION_CONTROL_M_FAX_TONES_ENABLE 0x1
#define VOIP_TONES_RELAY_OPTION_CONTROL_M_FAX_TONES_DEFAULT 0x0

#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_VOLUME_5DB 0x0
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_VOLUME_10DB 0x1
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_VOLUME_15DB 0x2
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_VOLUME_20DB 0x3

#define VOIP_TONES_RELAY_OPTION_CCISOIP_PKT_FORMAT_DISABLE 0x0
#define VOIP_TONES_RELAY_OPTION_CCISOIP_PKT_FORMAT_ENABLE 0x1
#define VOIP_TONES_RELAY_OPTION_CCISOIP_PKT_FORMAT_DEFAULT 0x0

#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_50MS 0x0
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_100MS 0x1
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_200MS 0x2
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_300MS 0x3
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_400MS 0x4
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_500MS 0x5
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_600MS 0x6
#define VOIP_TONES_RELAY_OPTION_CCISOIP_TONE_DURATION_700MS 0x7

#define VOIP_TONES_RELAY_CNG_OIP_DISABLE 0x0
#define VOIP_TONES_RELAY_CNG_OIP_ENABLE 0x1
#define VOIP_TONES_RELAY_CNG_OIP_DEFAULT 0x0

/* Definitions associated to VOIP_DIGITSTRGEN */
#define VOIP_DIGITSTRGEN_TONE_TYPE_DTMF 0x0
#define VOIP_DIGITSTRGEN_TONE_TYPE_MFR1 0x1
#define VOIP_DIGITSTRGEN_TONE_TYPE_MFR2_F 0x2
#define VOIP_DIGITSTRGEN_TONE_TYPE_MFR2_B 0x3
#define VOIP_DIGITSTRGEN_CONCURRENTLY_DISABLE 0x0
#define VOIP_DIGITSTRGEN_CONCURRENTLY_ENABLE 0x1
#define VOIP_DIGITSTRGEN_CONCURRENTLY_DEFAULT 0x0

#define VOIP_DIGITSTRGEN_MULTIPLE_EVENTS_DISABLE 0x0
#define VOIP_DIGITSTRGEN_MULTIPLE_EVENTS_ENABLE 0x1
#define VOIP_DIGITSTRGEN_MULTIPLE_EVENTS_DEFAULT 0x0

#define VOIP_DIGITSTRGEN_DTMFOPT_OVERRIDE_DISABLE 0x0
#define VOIP_DIGITSTRGEN_DTMFOPT_OVERRIDE_ENABLE 0x1
#define VOIP_DIGITSTRGEN_DTMFOPT_OVERRIDE_DEFAULT 0x0

#define VOIP_DIGITSTRGEN_PACKET_FORMAT_INBAND 0x0
#define VOIP_DIGITSTRGEN_PACKET_FORMAT_RFC2833 0x1
#define VOIP_DIGITSTRGEN_MODE_NORMAL 0x0
#define VOIP_DIGITSTRGEN_MODE_PROTECTED 0x1
#define VOIP_DIGITSTRGEN_MODE_DEFAULT 0x0

#define VOIP_DIGITSTRGEN_DIRECTION_TDM 0x0
#define VOIP_DIGITSTRGEN_DIRECTION_IP 0x1


/* Definitions associated to VOIP_MFTUNE */
#define VOIP_MFTUNE_FREQUENCY_DEVIATION_DEFAULT 0x12

#define VOIP_MFTUNE_NEGATIVE_TWIST_DEFAULT 0x64

#define VOIP_MFTUNE_POSITIVE_TWIST_DEFAULT 0x64

#define VOIP_MFTUNE_MINIMUM_LEVEL_THRESHOLD_DEFAULT 0x15E

#define VOIP_MFTUNE_SNR_THRESHOLD_DEFAULT 0x0

#define VOIP_MFTUNE_DETECTION_DELAY_D18 0x0
#define VOIP_MFTUNE_DETECTION_DELAY_D25 0x1
#define VOIP_MFTUNE_DETECTION_DELAY_D30 0x2
#define VOIP_MFTUNE_DETECTION_DELAY_D40 0x3
#define VOIP_MFTUNE_DETECTION_DELAY_DEFAULT 0x1

#define VOIP_MFTUNE_MF_SELECTOR_R1 0x0
#define VOIP_MFTUNE_MF_SELECTOR_R2 0x1
#define VOIP_MFTUNE_MF_SELECTOR_MFE 0x2
#define VOIP_MFTUNE_MF_SELECTOR_MFK5_MFK6 0x3


/* Definitions associated to VOIP_MFDPAR */
#define VOIP_MFDPAR_MINIMUM_ON_TIME_DEFAULT 0x0

#define VOIP_MFDPAR_MINIMUM_OFF_TIME_DEFAULT 0x0

#define VOIP_MFDPAR_MAXIMUM_DROPOUT_TIME_DEFAULT 0x0

#define VOIP_MFDPAR_MF_SELECTOR_R1 0x0
#define VOIP_MFDPAR_MF_SELECTOR_R2 0x1
#define VOIP_MFDPAR_MF_SELECTOR_MFE 0x2
#define VOIP_MFDPAR_MF_SELECTOR_MFK5_MFK6 0x3


/* Definitions associated to VOIP_CDMA_MODES */
#define VOIP_CDMA_MODES_TTY_DISABLE 0x0
#define VOIP_CDMA_MODES_TTY_ENABLE 0x1
#define VOIP_CDMA_MODES_TTY_DEFAULT 0x0

#define VOIP_CDMA_MODES_MAX_RATE_BLANKED 0x0
#define VOIP_CDMA_MODES_MAX_RATE_RATE_1_8 0x1
#define VOIP_CDMA_MODES_MAX_RATE_RATE_1_4 0x2
#define VOIP_CDMA_MODES_MAX_RATE_RATE_1_2 0x3
#define VOIP_CDMA_MODES_MAX_RATE_RATE_FULL 0x4
#define VOIP_CDMA_MODES_MAX_RATE_DEFAULT 0x4

#define VOIP_CDMA_MODES_MIN_RATE_BLANKED 0x0
#define VOIP_CDMA_MODES_MIN_RATE_RATE_1_8 0x1
#define VOIP_CDMA_MODES_MIN_RATE_RATE_1_4 0x2
#define VOIP_CDMA_MODES_MIN_RATE_RATE_1_2 0x3
#define VOIP_CDMA_MODES_MIN_RATE_RATE_FULL 0x4
#define VOIP_CDMA_MODES_MIN_RATE_DEFAULT 0x1

#define VOIP_CDMA_MODES_SIGNALING_SIG_OFF 0x0
#define VOIP_CDMA_MODES_SIGNALING_DIM_AND_BURST_HALF_RATE 0x1
#define VOIP_CDMA_MODES_SIGNALING_BLANK 0x2
#define VOIP_CDMA_MODES_SIGNALING_RESERVED 0x3
#define VOIP_CDMA_MODES_SIGNALING_DEFAULT 0x0


/* Definitions associated to SET_PASSTHRU_AUTOSWITCH */
#define SET_PASSTHRU_AUTOSWITCH_RFC2833_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_RFC2833_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_RFC2833_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_V8BIS_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_V8BIS_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_V8BIS_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_PTCHNG_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_PTCHNG_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_PTCHNG_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_USE_PT_G711 0x0
#define SET_PASSTHRU_AUTOSWITCH_USE_PT_VBD 0x1
#define SET_PASSTHRU_AUTOSWITCH_USE_PT_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_SSAD_BADOUT_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_SSAD_BADOUT_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_SSAD_BADOUT_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_RELAY_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_RELAY_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_RELAY_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_VOICE_SWITCH_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_VOICE_SWITCH_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_VOICE_SWITCH_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_SSAD_MPT_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_SSAD_MPT_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_SSAD_MPT_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_SW_IND_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_SW_IND_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_SW_IND_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_PT_AUTOSWITCH_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_PT_AUTOSWITCH_A_PT 0x1
#define SET_PASSTHRU_AUTOSWITCH_PT_AUTOSWITCH_A_T_38 0x2
#define SET_PASSTHRU_AUTOSWITCH_PT_AUTOSWITCH_BPT 0x3
#define SET_PASSTHRU_AUTOSWITCH_PT_AUTOSWITCH_MPT 0x4
#define SET_PASSTHRU_AUTOSWITCH_PT_AUTOSWITCH_PT 0x5
#define SET_PASSTHRU_AUTOSWITCH_PT_AUTOSWITCH_T_38 0x6
#define SET_PASSTHRU_AUTOSWITCH_PT_AUTOSWITCH_VOICE 0x7
#define SET_PASSTHRU_AUTOSWITCH_PT_AUTOSWITCH_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_DELAY_DEFAULT 0x3C

#define SET_PASSTHRU_AUTOSWITCH_VBD_PT_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_ADJ_INTERNAL_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_ADJ_INTERNAL_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_ADJ_INTERNAL_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_ADJ_TDM_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_ADJ_TDM_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_ADJ_TDM_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_ADJ_IP_DISABLE 0x0
#define SET_PASSTHRU_AUTOSWITCH_ADJ_IP_ENABLE 0x1
#define SET_PASSTHRU_AUTOSWITCH_ADJ_IP_DEFAULT 0x0

#define SET_PASSTHRU_AUTOSWITCH_PACKET_INTERVAL_DEFAULT 0x0


/* Definitions associated to PASSTHRU_AUTOSWITCH_IND */
#define PASSTHRU_AUTOSWITCH_IND_SWITCH_TYPE_ST_VOICE 0x0
#define PASSTHRU_AUTOSWITCH_IND_SWITCH_TYPE_ST_MPT 0x1
#define PASSTHRU_AUTOSWITCH_IND_SWITCH_TYPE_ST_PT 0x2
#define PASSTHRU_AUTOSWITCH_IND_SWITCH_TYPE_ST_T38 0x3
#define PASSTHRU_AUTOSWITCH_IND_SWITCH_TYPE_ST_BAUDOT 0x4


/* Definitions associated to VOIP_AGCSET */
#define VOIP_AGCSET_G169ENB_DISABLE 0x0
#define VOIP_AGCSET_G169ENB_ENABLE 0x1
#define VOIP_AGCSET_G169ENB_DEFAULT 0x0

#define VOIP_AGCSET_TXINIT_DISABLE 0x0
#define VOIP_AGCSET_TXINIT_ENABLE 0x1
#define VOIP_AGCSET_TXINIT_DEFAULT 0x0

#define VOIP_AGCSET_RXINIT_DISABLE 0x0
#define VOIP_AGCSET_RXINIT_ENABLE 0x1
#define VOIP_AGCSET_RXINIT_DEFAULT 0x0

#define VOIP_AGCSET_TXLIM_DISABLE 0x0
#define VOIP_AGCSET_TXLIM_ENABLE 0x1
#define VOIP_AGCSET_TXLIM_DEFAULT 0x0

#define VOIP_AGCSET_RXLIM_DISABLE 0x0
#define VOIP_AGCSET_RXLIM_ENABLE 0x1
#define VOIP_AGCSET_RXLIM_DEFAULT 0x0

#define VOIP_AGCSET_PCM2PKT_SLEW_RATE_FAST 0x0
#define VOIP_AGCSET_PCM2PKT_SLEW_RATE_MEDIUM 0x1
#define VOIP_AGCSET_PCM2PKT_SLEW_RATE_SLOW 0x2
#define VOIP_AGCSET_PCM2PKT_SLEW_RATE_DEFAULT 0x1

#define VOIP_AGCSET_PKT2PCM_SLEW_RATE_FAST 0x0
#define VOIP_AGCSET_PKT2PCM_SLEW_RATE_MEDIUM 0x1
#define VOIP_AGCSET_PKT2PCM_SLEW_RATE_SLOW 0x2
#define VOIP_AGCSET_PKT2PCM_SLEW_RATE_DEFAULT 0x1

#define VOIP_AGCSET_PCM2PKT_ENB_DISABLE 0x0
#define VOIP_AGCSET_PCM2PKT_ENB_ENABLE 0x1
#define VOIP_AGCSET_PCM2PKT_ENB_DEFAULT 0x0

#define VOIP_AGCSET_PKT2PCM_ENB_DISABLE 0x0
#define VOIP_AGCSET_PKT2PCM_ENB_ENABLE 0x1
#define VOIP_AGCSET_PKT2PCM_ENB_DEFAULT 0x0

#define VOIP_AGCSET_PKT2PCM_TARGET_LEVEL_DEFAULT 0x98

#define VOIP_AGCSET_PCM2PKT_TARGET_LEVEL_DEFAULT 0x98

#define VOIP_AGCSET_PKT2PCM_MAX_GAIN_DEFAULT 0x140

#define VOIP_AGCSET_PKT2PCM_MIN_GAIN_DEFAULT 0xFEC0

#define VOIP_AGCSET_PCM2PKT_MAX_GAIN_DEFAULT 0x140

#define VOIP_AGCSET_PCM2PKT_MIN_GAIN_DEFAULT 0xFEC0


/* Definitions associated to AEC_CONTROL */
#define AEC_CONTROL_IP_AECENB_DISABLE 0x0
#define AEC_CONTROL_IP_AECENB_ENABLE 0x1
#define AEC_CONTROL_IP_AECENB_DEFAULT 0x1

#define AEC_CONTROL_IP_AECINIT_DISABLE 0x0
#define AEC_CONTROL_IP_AECINIT_ENABLE 0x1
#define AEC_CONTROL_IP_AECINIT_DEFAULT 0x0

#define AEC_CONTROL_IP_AECMOD_DEFAULT 0x0

#define AEC_CONTROL_IP_AECNLP_ENABLE 0x0
#define AEC_CONTROL_IP_AECNLP_DISABLE 0x1
#define AEC_CONTROL_IP_AECNLP_DEFAULT 0x0

#define AEC_CONTROL_IP_AECCNG_ENABLE 0x0
#define AEC_CONTROL_IP_AECCNG_DISABLE 0x1
#define AEC_CONTROL_IP_AECCNG_DEFAULT 0x0

#define AEC_CONTROL_IP_AECDYN_DISABLE 0x0
#define AEC_CONTROL_IP_AECDYN_ENABLE 0x1
#define AEC_CONTROL_IP_AECDYN_DEFAULT 0x0

#define AEC_CONTROL_IP_AECDCD_ENABLE 0x0
#define AEC_CONTROL_IP_AECDCD_DISABLE 0x1
#define AEC_CONTROL_IP_AECDCD_DEFAULT 0x0

#define AEC_CONTROL_IP_MINEPD_DEFAULT 0x0

#define AEC_CONTROL_IP_DISEPD_DEFAULT 0x3C

#define AEC_CONTROL_IP_MINERL_DEFAULT 0x19

#define AEC_CONTROL_TDM_AECENB_DISABLE 0x0
#define AEC_CONTROL_TDM_AECENB_ENABLE 0x1
#define AEC_CONTROL_TDM_AECENB_DEFAULT 0x1

#define AEC_CONTROL_TDM_AECINIT_DISABLE 0x0
#define AEC_CONTROL_TDM_AECINIT_ENABLE 0x1
#define AEC_CONTROL_TDM_AECINIT_DEFAULT 0x0

#define AEC_CONTROL_TDM_AECMOD_DEFAULT 0x0

#define AEC_CONTROL_TDM_AECNLP_ENABLE 0x0
#define AEC_CONTROL_TDM_AECNLP_DISABLE 0x1
#define AEC_CONTROL_TDM_AECNLP_DEFAULT 0x0

#define AEC_CONTROL_TDM_AECCNG_ENABLE 0x0
#define AEC_CONTROL_TDM_AECCNG_DISABLE 0x1
#define AEC_CONTROL_TDM_AECCNG_DEFAULT 0x0

#define AEC_CONTROL_TDM_AECDYN_DISABLE 0x0
#define AEC_CONTROL_TDM_AECDYN_ENABLE 0x1
#define AEC_CONTROL_TDM_AECDYN_DEFAULT 0x0

#define AEC_CONTROL_TDM_AECDCD_ENABLE 0x0
#define AEC_CONTROL_TDM_AECDCD_DISABLE 0x1
#define AEC_CONTROL_TDM_AECDCD_DEFAULT 0x0

#define AEC_CONTROL_TDM_MINEPD_DEFAULT 0x0

#define AEC_CONTROL_TDM_DISEPD_DEFAULT 0x3C

#define AEC_CONTROL_TDM_MINERL_DEFAULT 0x19


/* Definitions associated to RTP_MONITOR_ENA */
#define RTP_MONITOR_ENA_PT_CHG_IND_DISABLE 0x0
#define RTP_MONITOR_ENA_PT_CHG_IND_ENABLE 0x1
#define RTP_MONITOR_ENA_PT_CHG_IND_DEFAULT 0x0

#define RTP_MONITOR_ENA_MODE_DISABLE 0x0
#define RTP_MONITOR_ENA_MODE_ENABLE 0x1
#define RTP_MONITOR_ENA_MODE_DEFAULT 0x0


/* Definitions associated to RTP_MONITOR_IND */
#define RTP_MONITOR_IND_TYPE_STOP 0x0
#define RTP_MONITOR_IND_TYPE_START 0x1
#define RTP_MONITOR_IND_TYPE_PT_CHANGE 0x2


/* Definitions associated to RTCP_BYE_PKT_DISABLE */
#define RTCP_BYE_PKT_DISABLE_MODE_ENABLE 0x0
#define RTCP_BYE_PKT_DISABLE_MODE_DISABLE 0x1
#define RTCP_BYE_PKT_DISABLE_MODE_DEFAULT 0x0


/* Definitions associated to NC_CONTROL */
#define NC_CONTROL_NC_NLC_DISABLE 0x0
#define NC_CONTROL_NC_NLC_ENABLE 0x1
#define NC_CONTROL_NC_NLC_DEFAULT 0x0

#define NC_CONTROL_NC_ENB_DISABLE 0x0
#define NC_CONTROL_NC_ENB_ENABLE 0x1
#define NC_CONTROL_NC_ENB_DEFAULT 0x0


/* Definitions associated to NC_TUNE */
#define NC_TUNE_NC_VAD_UP_HANGOVER_DEFAULT 0x2

#define NC_TUNE_NC_VAD_DOWN_HANGOVER_DEFAULT 0x1

#define NC_TUNE_NC_INTG_FACTOR_DEFAULT 0x200

#define NC_TUNE_NC_SNR_INTG_FACTOR_DEFAULT 0x80

#define NC_TUNE_NC_SNR_INIT_UPDATE_COMPLETE_DEFAULT 0x14

#define NC_TUNE_NC_SNR_CORR_DEFAULT 0x1200

#define NC_TUNE_NC_G0_DEFAULT 0xF00

#define NC_TUNE_NC_G_MAX_DEFAULT 0xF00

#define NC_TUNE_NC_SNR0_DEFAULT 0x1900

#define NC_TUNE_NC_ALPHA_DEFAULT 0x666

#define NC_TUNE_NC_ENC_INTG_FACTOR_DEFAULT 0x40

#define NC_TUNE_NLC_MAX_IN_LEVEL_DEFAULT 0x4E20

#define NC_TUNE_NLC_MAX_LEVEL_DEFAULT 0x3A98

#define NC_TUNE_NLC_START_LEVEL_DEFAULT 0x32C8

#define NC_TUNE_NLC_GAIN1_FX_DEFAULT 0x6000

#define NC_TUNE_NLC_COEFF_0_DEFAULT 0x4AE5


/* Definitions associated to DPNS_CONTROL */
#define DPNS_CONTROL_DPNS_ENB_DISABLE 0x0
#define DPNS_CONTROL_DPNS_ENB_ENABLE 0x1
#define DPNS_CONTROL_DPNS_ENB_DEFAULT 0x0

#define DPNS_CONTROL_DPNS_SUPP_CNTR_FX_DEFAULT 0x2000


/* Definitions associated to IPDTMF_CTRL */
#define IPDTMF_CTRL_EVENTS_DISABLE 0x0
#define IPDTMF_CTRL_EVENTS_ENABLE 0x1
#define IPDTMF_CTRL_EVENTS_DEFAULT 0x0

#define IPDTMF_CTRL_INBAND_DETECTION_DISABLE 0x0
#define IPDTMF_CTRL_INBAND_DETECTION_ENABLE 0x1
#define IPDTMF_CTRL_INBAND_DETECTION_DEFAULT 0x0

#define IPDTMF_CTRL_INBAND_REMOVAL_DISABLE 0x0
#define IPDTMF_CTRL_INBAND_REMOVAL_ENABLE 0x1
#define IPDTMF_CTRL_INBAND_REMOVAL_DEFAULT 0x0

#define IPDTMF_CTRL_REMOVAL_COMPLETE 0x0
#define IPDTMF_CTRL_REMOVAL_PARTIAL 0x1
#define IPDTMF_CTRL_REMOVAL_DEFAULT 0x1


/* Definitions associated to INBAND_DTMF_DET */
#define INBAND_DTMF_DET_TONE_DTMF_0 0x0
#define INBAND_DTMF_DET_TONE_DTMF_1 0x1
#define INBAND_DTMF_DET_TONE_DTMF_2 0x2
#define INBAND_DTMF_DET_TONE_DTMF_3 0x3
#define INBAND_DTMF_DET_TONE_DTMF_4 0x4
#define INBAND_DTMF_DET_TONE_DTMF_5 0x5
#define INBAND_DTMF_DET_TONE_DTMF_6 0x6
#define INBAND_DTMF_DET_TONE_DTMF_7 0x7
#define INBAND_DTMF_DET_TONE_DTMF_8 0x8
#define INBAND_DTMF_DET_TONE_DTMF_9 0x9
#define INBAND_DTMF_DET_TONE_DTMF_S 0xA
#define INBAND_DTMF_DET_TONE_DTMF_P 0xB
#define INBAND_DTMF_DET_TONE_DTMF_A 0xC
#define INBAND_DTMF_DET_TONE_DTMF_B 0xD
#define INBAND_DTMF_DET_TONE_DTMF_C 0xE
#define INBAND_DTMF_DET_TONE_DTMF_D 0xF
#define INBAND_DTMF_DET_TONE_END_TONE 0xFF


/* Definitions associated to RFC2833_DTMF_DET */
#define RFC2833_DTMF_DET_TONE_DTMF_0 0x0
#define RFC2833_DTMF_DET_TONE_DTMF_1 0x1
#define RFC2833_DTMF_DET_TONE_DTMF_2 0x2
#define RFC2833_DTMF_DET_TONE_DTMF_3 0x3
#define RFC2833_DTMF_DET_TONE_DTMF_4 0x4
#define RFC2833_DTMF_DET_TONE_DTMF_5 0x5
#define RFC2833_DTMF_DET_TONE_DTMF_6 0x6
#define RFC2833_DTMF_DET_TONE_DTMF_7 0x7
#define RFC2833_DTMF_DET_TONE_DTMF_8 0x8
#define RFC2833_DTMF_DET_TONE_DTMF_9 0x9
#define RFC2833_DTMF_DET_TONE_DTMF_S 0xA
#define RFC2833_DTMF_DET_TONE_DTMF_P 0xB
#define RFC2833_DTMF_DET_TONE_DTMF_A 0xC
#define RFC2833_DTMF_DET_TONE_DTMF_B 0xD
#define RFC2833_DTMF_DET_TONE_DTMF_C 0xE
#define RFC2833_DTMF_DET_TONE_DTMF_D 0xF
#define RFC2833_DTMF_DET_TONE_END_TONE 0xFF


/* Definitions associated to RFC2833_TONEPLYCFG */
#define RFC2833_TONEPLYCFG_MIN_ON_TIME_DISABLE 0x0
#define RFC2833_TONEPLYCFG_MIN_ON_TIME_ON_50 0x1
#define RFC2833_TONEPLYCFG_MIN_ON_TIME_ON_60 0x2
#define RFC2833_TONEPLYCFG_MIN_ON_TIME_ON_70 0x3
#define RFC2833_TONEPLYCFG_MIN_ON_TIME_ON_80 0x4
#define RFC2833_TONEPLYCFG_MIN_ON_TIME_ON_40 0x5
#define RFC2833_TONEPLYCFG_MIN_ON_TIME_DEFAULT 0x1

#define RFC2833_TONEPLYCFG_MIN_OFF_TIME_DISABLE 0x0
#define RFC2833_TONEPLYCFG_MIN_OFF_TIME_OFF_50 0x1
#define RFC2833_TONEPLYCFG_MIN_OFF_TIME_OFF_60 0x2
#define RFC2833_TONEPLYCFG_MIN_OFF_TIME_OFF_70 0x3
#define RFC2833_TONEPLYCFG_MIN_OFF_TIME_OFF_80 0x4
#define RFC2833_TONEPLYCFG_MIN_OFF_TIME_OFF_40 0x5
#define RFC2833_TONEPLYCFG_MIN_OFF_TIME_DEFAULT 0x1


/* Definitions associated to VOIP_CFGMEAS */
#define VOIP_CFGMEAS_BIQUAD_DISABLE 0x0
#define VOIP_CFGMEAS_BIQUAD_ENABLE 0x1
#define VOIP_CFGMEAS_BIQUAD_DEFAULT 0x0

#define VOIP_CFGMEAS_A2_1_DEFAULT 0x30EE

#define VOIP_CFGMEAS_A1_1_DEFAULT 0x9E3D

#define VOIP_CFGMEAS_A0_1_DEFAULT 0x30ED

#define VOIP_CFGMEAS_B2_1_DEFAULT 0xD449

#define VOIP_CFGMEAS_B1_1_DEFAULT 0x6958

#define VOIP_CFGMEAS_A2_2_DEFAULT 0x4000

#define VOIP_CFGMEAS_A1_2_DEFAULT 0x80C1

#define VOIP_CFGMEAS_A0_2_DEFAULT 0x4000

#define VOIP_CFGMEAS_B2_2_DEFAULT 0xC93E

#define VOIP_CFGMEAS_B1_2_DEFAULT 0x7392


/* Definitions associated to VOIP_MEASTONE */
#define VOIP_MEASTONE_MODE_TIME_ONE 0x0
#define VOIP_MEASTONE_MODE_TIME_CONTINUOUS 0x1
#define VOIP_MEASTONE_MODE_DIRECT 0x0
#define VOIP_MEASTONE_MODE_ABS 0x1
#define VOIP_MEASTONE_MODE_MAX 0x2
#define VOIP_MEASTONE_MODE_SQUARE 0x3
#define VOIP_MEASTONE_MODE_SIGNAL 0x10


/* Definitions associated to VOIP_TDETGLOBALCFG */
#define VOIP_TDETGLOBALCFG_STATUS_SEL_TDETIND 0x0
#define VOIP_TDETGLOBALCFG_STATUS_SEL_TONEDET 0x1
#define VOIP_TDETGLOBALCFG_STATUS_SEL_EVENTDET 0x2
#define VOIP_TDETGLOBALCFG_SNR_DEFAULT 0x0

#define VOIP_TDETGLOBALCFG_MIN_LEVEL_DEFAULT 0x0

#define VOIP_TDETGLOBALCFG_MAX_TWIST_DEFAULT 0x0


/* Definitions associated to VOIP_TDETCFG */
#define VOIP_TDETCFG_CADENCE_DEFAULT 0x0

#define VOIP_TDETCFG_NOISE_DEFAULT 0x0

#define VOIP_TDETCFG_MIN_ON2_DEFAULT 0x0

#define VOIP_TDETCFG_MAX_ON2_DEFAULT 0x0

#define VOIP_TDETCFG_MIN_OFF2_DEFAULT 0x0

#define VOIP_TDETCFG_MAX_OFF2_DEFAULT 0x0

#define VOIP_TDETCFG_DETECT_DELAY_DEFAULT 0x0

#define VOIP_TDETCFG_DROP_DELAY_DEFAULT 0x0


/* Definitions associated to IPTONEDETEN */
#define IPTONEDETEN_DETECTION_DISABLE 0x0
#define IPTONEDETEN_DETECTION_ENABLE 0x1
#define IPTONEDETEN_DETECTION_DEFAULT 0x1


/* Definitions associated to THC_MODE_ENABLE */
#define THC_MODE_ENABLE_LEVEL_DB00 0x0
#define THC_MODE_ENABLE_LEVEL_DB05 0x1
#define THC_MODE_ENABLE_LEVEL_DB10 0x2
#define THC_MODE_ENABLE_LEVEL_DB35 0x3
#define THC_MODE_ENABLE_LEVEL_DB40 0x4
#define THC_MODE_ENABLE_LEVEL_DB60 0x5


/* Definitions associated to THC_GEN_PKT */
#define THC_GEN_PKT_MODE_DISABLE 0x0
#define THC_GEN_PKT_MODE_ENABLE 0x1
#define THC_GEN_PKT_MODE_DEFAULT 0x0


/* Definitions associated to SELECT_MF_TONEDET */
#define SELECT_MF_TONEDET_TYPE_NONE 0x0
#define SELECT_MF_TONEDET_TYPE_DTMF 0x1
#define SELECT_MF_TONEDET_TYPE_MF_R1 0x2
#define SELECT_MF_TONEDET_TYPE_MF_R2_BACKWARD 0x3
#define SELECT_MF_TONEDET_TYPE_MF_R2_FORWARD 0x4
#define SELECT_MF_TONEDET_TYPE_MFE_FORWARD 0x5
#define SELECT_MF_TONEDET_TYPE_MFE_BACKWARD 0x6
#define SELECT_MF_TONEDET_TYPE_MFK5_FORWARD 0x7
#define SELECT_MF_TONEDET_TYPE_MFK5_BACKWARD 0x8
#define SELECT_MF_TONEDET_TYPE_MFK6_FORWARD 0x9
#define SELECT_MF_TONEDET_TYPE_MFK6_BACKWARD 0xA
#define SELECT_MF_TONEDET_TYPE_MF_R2_BACKWARD_CS 0xB
#define SELECT_MF_TONEDET_TYPE_MF_R2_FORWARD_CS 0xC
#define SELECT_MF_TONEDET_TYPE_MFE_FORWARD_CS 0xD
#define SELECT_MF_TONEDET_TYPE_MFE_BACKWARD_CS 0xE
#define SELECT_MF_TONEDET_TYPE_MFK5_FORWARD_CS 0xF
#define SELECT_MF_TONEDET_TYPE_MFK5_BACKWARD_CS 0x10
#define SELECT_MF_TONEDET_TYPE_MFK6_FORWARD_CS 0x11
#define SELECT_MF_TONEDET_TYPE_MFK6_BACKWARD_CS 0x12
#define SELECT_MF_TONEDET_TYPE_DEFAULT 0x1


/* Definitions associated to RL_EVRCX_CONTROL */
#define RL_EVRCX_CONTROL_RL_CONTROL_DISABLE 0x0
#define RL_EVRCX_CONTROL_RL_CONTROL_ENABLE 0x1
#define RL_EVRCX_CONTROL_RL_CONTROL_DEFAULT 0x0


/* Definitions associated to SET_UMA_PARAMS */
#define SET_UMA_PARAMS_MCN_DISABLE 0x0
#define SET_UMA_PARAMS_MCN_ENABLE 0x1
#define SET_UMA_PARAMS_MCN_DEFAULT 0x0

#define SET_UMA_PARAMS_RATE_CHANGE_EVENT_DISABLE 0x0
#define SET_UMA_PARAMS_RATE_CHANGE_EVENT_ENABLE 0x1
#define SET_UMA_PARAMS_RATE_CHANGE_EVENT_DEFAULT 0x0

#define SET_UMA_PARAMS_STAT_CHANGE_EVENT_DISABLE 0x0
#define SET_UMA_PARAMS_STAT_CHANGE_EVENT_ENABLE 0x1
#define SET_UMA_PARAMS_STAT_CHANGE_EVENT_DEFAULT 0x0

#define SET_UMA_PARAMS_CMR_CHANGE_EVENT_DISABLE 0x0
#define SET_UMA_PARAMS_CMR_CHANGE_EVENT_ENABLE 0x1
#define SET_UMA_PARAMS_CMR_CHANGE_EVENT_DEFAULT 0x0

#define SET_UMA_PARAMS_Q_ZERO_EVENT_DISABLE 0x0
#define SET_UMA_PARAMS_Q_ZERO_EVENT_ENABLE 0x1
#define SET_UMA_PARAMS_Q_ZERO_EVENT_DEFAULT 0x0

#define SET_UMA_PARAMS_CMR_VALUE_DEFAULT 0xF

#define SET_UMA_PARAMS_THRESHOLD_WINDOW_FIVE_SECS 0x1
#define SET_UMA_PARAMS_THRESHOLD_WINDOW_SIXTY_SECS 0xC
#define SET_UMA_PARAMS_UMA_STATE_GOOD 0x0
#define SET_UMA_PARAMS_UMA_STATE_BAD 0x1
#define SET_UMA_PARAMS_UMA_STATE_UNDEFINED 0x2
#define SET_UMA_PARAMS_UMA_STATE_DEFAULT 0x2

#define SET_UMA_PARAMS_REDUND_DISABLE 0x0
#define SET_UMA_PARAMS_REDUND_ENABLE_1 0x1
#define SET_UMA_PARAMS_REDUND_ENABLE_2 0x2
#define SET_UMA_PARAMS_REDUND_ENABLE_3 0x3
#define SET_UMA_PARAMS_REDUND_DEFAULT 0x0

#define SET_UMA_PARAMS_CMR_AUTOADAPT_DISABLE 0x0
#define SET_UMA_PARAMS_CMR_AUTOADAPT_ENABLE 0x1
#define SET_UMA_PARAMS_APPLY_AMR_MCP_DISABLE 0x0
#define SET_UMA_PARAMS_APPLY_AMR_MCP_ENABLE 0x1
#define SET_UMA_PARAMS_APPLY_AMR_MS_DISABLE 0x0
#define SET_UMA_PARAMS_APPLY_AMR_MS_ENABLE 0x1
#define SET_UMA_PARAMS_AMR_MODE_MODE_0 0x1
#define SET_UMA_PARAMS_AMR_MODE_MODE_1 0x2
#define SET_UMA_PARAMS_AMR_MODE_MODE_2 0x4
#define SET_UMA_PARAMS_AMR_MODE_MODE_3 0x8
#define SET_UMA_PARAMS_AMR_MODE_MODE_4 0x10
#define SET_UMA_PARAMS_AMR_MODE_MODE_5 0x20
#define SET_UMA_PARAMS_AMR_MODE_MODE_6 0x40
#define SET_UMA_PARAMS_AMR_MODE_MODE_7 0x80
#define SET_UMA_PARAMS_AMR_MODE_MODE_8 0x100


/* Definitions associated to C2C_CONNECT_UMA_UP */
#define C2C_CONNECT_UMA_UP_INTER_MODE_HDLC2 0x1
#define C2C_CONNECT_UMA_UP_INTER_MODE_HDLC1 0x2
#define C2C_CONNECT_UMA_UP_INTER_MODE_DEFAULT 0x2

#define C2C_CONNECT_UMA_UP_CONNECTION_TYPE_INTRA 0x0
#define C2C_CONNECT_UMA_UP_CONNECTION_TYPE_INTER 0x1
#define C2C_CONNECT_UMA_UP_CONNECTION_DISABLE 0x0
#define C2C_CONNECT_UMA_UP_CONNECTION_ENABLE 0x1
#define C2C_CONNECT_UMA_UP_UP_CHANNEL_B_DEFAULT 0x0

#define C2C_CONNECT_UMA_UP_RFCI_TO_CMR_TIMER_DEFAULT 0x0


/* Definitions associated to G729_WB_MODE */
#define G729_WB_MODE_MBS_MBS_8_KBPS 0x0
#define G729_WB_MODE_MBS_MBS_12_KBPS 0x1
#define G729_WB_MODE_MBS_MBS_14_KBPS 0x2
#define G729_WB_MODE_MBS_MBS_16_KBPS 0x3
#define G729_WB_MODE_MBS_MBS_18_KBPS 0x4
#define G729_WB_MODE_MBS_MBS_20_KBPS 0x5
#define G729_WB_MODE_MBS_MBS_22_KBPS 0x6
#define G729_WB_MODE_MBS_MBS_24_KBPS 0x7
#define G729_WB_MODE_MBS_MBS_26_KBPS 0x8
#define G729_WB_MODE_MBS_MBS_28_KBPS 0x9
#define G729_WB_MODE_MBS_MBS_30_KBPS 0xA
#define G729_WB_MODE_MBS_MBS_32_KBPS 0xB
#define G729_WB_MODE_MBS_NO_MBS 0xF
#define G729_WB_MODE_MBS_DEFAULT 0x1

#define G729_WB_MODE_FT_FT_8_KBPS 0x0
#define G729_WB_MODE_FT_FT_12_KBPS 0x1
#define G729_WB_MODE_FT_FT_14_KBPS 0x2
#define G729_WB_MODE_FT_FT_16_KBPS 0x3
#define G729_WB_MODE_FT_FT_18_KBPS 0x4
#define G729_WB_MODE_FT_FT_20_KBPS 0x5
#define G729_WB_MODE_FT_FT_22_KBPS 0x6
#define G729_WB_MODE_FT_FT_24_KBPS 0x7
#define G729_WB_MODE_FT_FT_26_KBPS 0x8
#define G729_WB_MODE_FT_FT_28_KBPS 0x9
#define G729_WB_MODE_FT_FT_30_KBPS 0xA
#define G729_WB_MODE_FT_FT_32_KBPS 0xB
#define G729_WB_MODE_FT_DEFAULT 0x0


/* Definitions associated to MTOM_SETUP */
#define MTOM_SETUP_CRC_CHECK_TDM_IP_DISABLE 0x0
#define MTOM_SETUP_CRC_CHECK_TDM_IP_ENABLE 0x1
#define MTOM_SETUP_CRC_CHECK_TDM_IP_DEFAULT 0x0

#define MTOM_SETUP_MTM_MODE_DISABLE 0x0
#define MTOM_SETUP_MTM_MODE_ENABLE 0x1
#define MTOM_SETUP_MTM_MODE_STANDBY 0x2
#define MTOM_SETUP_MTM_MODE_DEFAULT 0x0


/* Definitions associated to EVRC_POSTFILTER_CONFIG */
#define EVRC_POSTFILTER_CONFIG_CTRL_DISABLE 0x0
#define EVRC_POSTFILTER_CONFIG_CTRL_ENABLE 0x1
#define EVRC_POSTFILTER_CONFIG_CTRL_DEFAULT 0x0


/* Definitions associated to CIPHER_AES_OPT */
#define CIPHER_AES_OPT_AES_DISABLE 0x0
#define CIPHER_AES_OPT_AES_ENABLE 0x1
#define CIPHER_AES_OPT_CIPHER_LAYER_RTP 0x0
#define CIPHER_AES_OPT_CIPHER_LAYER_RTCP 0x1
#define CIPHER_AES_OPT_CIPHER_LAYER_DEFAULT 0x0

#define CIPHER_AES_OPT_PCDC_NULL_VAL 0x0
#define CIPHER_AES_OPT_PCDC_RTP_AES 0x1
#define CIPHER_AES_OPT_PCDC_RTCP_AES_CBC 0x2
#define CIPHER_AES_OPT_PCDC_DEFAULT 0x0

#define CIPHER_AES_OPT_KEY_SYMMETRIC 0x0
#define CIPHER_AES_OPT_KEY_ASYMMETRIC 0x1
#define CIPHER_AES_OPT_KEY_DEFAULT 0x0

#define CIPHER_AES_OPT_BTM_RFC1423 0x0
#define CIPHER_AES_OPT_BTM_NIST 0x1
#define CIPHER_AES_OPT_BTM_DEFAULT 0x0

#define CIPHER_AES_OPT_MODE_ECB 0x0
#define CIPHER_AES_OPT_MODE_CBC 0x1
#define CIPHER_AES_OPT_MODE_DEFAULT 0x0

#define CIPHER_AES_OPT_KEY_SIZE_S128 0x0
#define CIPHER_AES_OPT_KEY_SIZE_S192 0x1
#define CIPHER_AES_OPT_KEY_SIZE_S256 0x2
#define CIPHER_AES_OPT_KEY_SIZE_DEFAULT 0x0


/* Definitions associated to VOIP_VOISIDET */
#define VOIP_VOISIDET_VOICE_DETECT_DISABLE 0x0
#define VOIP_VOISIDET_VOICE_DETECT_ENABLE 0x1
#define VOIP_VOISIDET_VOICE_DETECT_DEFAULT 0x0

#define VOIP_VOISIDET_SECONDARY_TIMER_DISABLE 0x0
#define VOIP_VOISIDET_SECONDARY_TIMER_ENABLE 0x1
#define VOIP_VOISIDET_SECONDARY_TIMER_DEFAULT 0x0

#define VOIP_VOISIDET_PRIMARY_TIMER_DISABLE 0x0
#define VOIP_VOISIDET_PRIMARY_TIMER_ENABLE 0x1
#define VOIP_VOISIDET_PRIMARY_TIMER_DEFAULT 0x0

#define VOIP_VOISIDET_PRI_SDT_DEFAULT 0x19

#define VOIP_VOISIDET_SEC_SDT_DEFAULT 0x10

#define VOIP_VOISIDET_TX_THRESHOLD_DEFAULT 0x26

#define VOIP_VOISIDET_RX_THRESHOLD_DEFAULT 0x26


/* Definitions associated to CTM_CONFIG */
#define CTM_CONFIG_CTM_DISABLE 0x0
#define CTM_CONFIG_CTM_ENABLE 0x1


/* Definitions associated to CTM_CHANGE_IND */
#define CTM_CHANGE_IND_CTM_STATE_IDLE 0x1
#define CTM_CHANGE_IND_CTM_STATE_PREPARE 0x2
#define CTM_CHANGE_IND_CTM_STATE_CONNECTED 0x6

