/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _UD_COMMANDS_API_H_
#define _UD_COMMANDS_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
C:REDIRECT_CSM (Function code=0x0001, class=0xC2, type=0x78)
************************************************************/
struct _REDIRECT_CSM
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <7:0> */
			_u_16_ protocol:8;

			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:7] = hostmac:EUI48*/
	_u_16_ hostmac[3];
	/*parameters [8:10] = assignedmac:EUI48*/
	_u_16_ assignedmac[3];
	/* parameter [11] */
	_u_16_ type;

} ATTRIBUTE_PACKED;

/************************************************************
C:REDIRECT_CSM_UDP (Function code=0x0004, class=0xC2, type=0x78)
************************************************************/
struct _REDIRECT_CSM_UDP
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <7:0> */
			_u_16_ protocol:8;

			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:7] = dst_mac:EUI48*/
	_u_16_ dst_mac[3];
	/*parameters [8:10] = src_mac:EUI48*/
	_u_16_ src_mac[3];
	/* parameter [11] */
	_u_16_ packet_type;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [12] bit(s) <3:0> */
			_u_16_ ip_hl:4;

			/* parameter [12] bit(s) <7:4> */
			_u_16_ ip_v:4;

			/* parameter [12] bit(s) <15:8> */
			_u_16_ ip_tos:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_12;

	/* parameter [13] */
	_u_16_ ip_len;

	/* parameter [14] */
	_u_16_ ip_id;

	/* parameter [15] */
	_u_16_ ip_fragment;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [16] bit(s) <7:0> */
			_u_16_ ip_p:8;

			/* parameter [16] bit(s) <15:8> */
			_u_16_ ip_ttl:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_16;

	/* parameter [17] */
	_u_16_ ip_checksum;

	/*parameters [18:19]*/
	_u_32_ ip_src;
	/*parameters [20:21]*/
	_u_32_ ip_dst;
	/* parameter [22] */
	_u_16_ udp_sport;

	/* parameter [23] */
	_u_16_ udp_dport;

	/* parameter [24] */
	_u_16_ udp_len;

	/* parameter [25] */
	_u_16_ udp_checksum;


} ATTRIBUTE_PACKED;

#endif /* UD_COMMANDS_API_H_ */ 

