/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_TRANSCODING_API_H_
#define _COMCERTO_TRANSCODING_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
C:TRANS_CONNECT (Function code=0x9322, class=0x06, type=0x00)
************************************************************/
struct _TRANS_CONNECT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ trans_enable:1;

			/* parameter [4] bit(s) <2:1> */
			_u_16_ bypass_mode:2;

			/* parameter [4] bit(s) <3> */
			_u_16_ reduced_virtual_transcode_latency:1;

			/* parameter [4] bit(s) <15:4> */
			_u_16_ reserved4_bits_15_1:12;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ trans_ch_a;

	/* parameter [6] */
	_u_16_ trans_payload_a;

	/* parameter [7] */
	_u_16_ trans_ch_b;

	/* parameter [8] */
	_u_16_ trans_payload_b;


} ATTRIBUTE_PACKED;

#endif /* COMCERTO_TRANSCODING_API_H_ */ 

