/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_TONES_API_H_
#define _COMCERTO_TONES_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
CA:CND_ONHOOK_GEN (Function code=0x8039, class=0x02, type=0x00)
************************************************************/
struct _CND_ONHOOK_GEN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <7:0> */
			_u_16_ modulation_type:8;

			/* parameter [4] bit(s) <15:8> */
			_u_16_ msg_type_id:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


	/*parameters [5:$] = cid_data:OCTETS*/
	_u_8_ cid_data [246];

} ATTRIBUTE_PACKED;

/************************************************************
CA:CND_OFFHOOK_GEN (Function code=0x803B, class=0x02, type=0x00)
************************************************************/
struct _CND_OFFHOOK_GEN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <7:0> */
			_u_16_ msg_type_id:8;

			/* parameter [4] bit(s) <15:8> */
			_u_16_ cid_data_byte1:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


	/*parameters [5:$] = cid_data:OCTETS*/
	_u_8_ cid_data [246];

} ATTRIBUTE_PACKED;

/************************************************************
CA:CND_STOP (Function code=0x803C, class=0x02, type=0x00)
************************************************************/
struct _CND_STOP
{

} ATTRIBUTE_PACKED;

/************************************************************
I:CND_DONE (Function code=0x803D, class=0x02, type=0x03)
************************************************************/
struct _CND_DONE_IND
{
	/* parameter [4] */
	_u_16_ reason;


} ATTRIBUTE_PACKED;

/************************************************************
CA:CNDDETCTL (Function code=0x80B1, class=0x02, type=0x00)
************************************************************/
struct _CNDDETCTL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ cid_enable:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ hook_status:1;

			/* parameter [4] bit(s) <15:2> */
			_u_16_ reserved4_bits_15_2:14;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

} ATTRIBUTE_PACKED;

/************************************************************
CA:CNDDETSP (Function code=0x80AE, class=0x02, type=0x00)
************************************************************/
struct _CNDDETSP
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <7:0> */
			_u_16_ info_type:8;

			/* parameter [4] bit(s) <15:8> */
			_u_16_ info_count:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


	/*parameters [5:$] = info_param:OCTETS*/
	_u_8_ info_param [246];

} ATTRIBUTE_PACKED;

/************************************************************
I:CNDRXMSG (Function code=0x80AD, class=0x02, type=0x03)
************************************************************/
struct _CNDRXMSG_IND
{
	/* parameter [4] */
	_u_16_ msg_stat;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <7:0> */
			_u_16_ msg_type_id:8;

			/* parameter [5] bit(s) <15:8> */
			_u_16_ msg_byte_count:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;


	/*parameters [6:$] = msg_byte:OCTETS*/
	_u_8_ msg_byte [244];

} ATTRIBUTE_PACKED;
#endif /* COMCERTO_TONES_API_H_ */ 

