/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_TDM_BUS_API_H_
#define _COMCERTO_TDM_BUS_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
C:TDM_SELECT_BUS_MODE (Function code=0x0417, class=0x06, type=0x00)
************************************************************/
struct _TDM_SELECT_BUS_MODE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <7:0> */
			_u_16_ busmode:8;

			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
C:TDM_ENABLE_BUS (Function code=0x0405, class=0x06, type=0x00)
************************************************************/
struct _TDM_ENABLE_BUS
{
	/* parameter [4] */
	_u_16_ bus_count;


} ATTRIBUTE_PACKED;


/************************************************************
C:SUPVSR_SET_PCM_LAW (Function code=0x0425, class=0x06, type=0x00)
************************************************************/
struct _SUPVSR_SET_PCM_LAW
{
	/* parameter [4] */
	_u_16_ compander;


} ATTRIBUTE_PACKED;

/************************************************************
C:SUPVSR_SET_TS_MODE (Function code=0x0424, class=0x06, type=0x00)
************************************************************/
struct _SUPVSR_SET_TS_MODE
{
	/* parameter [4] */
	_u_16_ timeslot;

	/* parameter [5] */
	_u_16_ mode;


} ATTRIBUTE_PACKED;

#endif /* COMCERTO_TDM_BUS_API_H_ */ 

