/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_T38_API_H_
#define _COMCERTO_T38_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
CA:FOIP_FAXSPLOPT (Function code=0x8085, class=0x02, type=0x00)
************************************************************/
struct _FOIP_FAXSPLOPT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ dsi_removal:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ nsf_rermoval:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ csi_removal:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ tsi_removal:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ tdm_to_packet_byte_base:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ packet_to_tdm_byte_base:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ t38_spoofing:1;

			/* parameter [4] bit(s) <15:7> */
			_u_16_ reserved4_bits_15_7:9;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
CA:FAXOPT (Function code=0x8003, class=0x02, type=0x00)
************************************************************/
struct _FAXOPT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ tcf_procedure:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ error_recovery_method:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ reserved4_bit_2:1;

			/* parameter [4] bit(s) <5:3> */
			_u_16_ speed_limit:3;

			/* parameter [4] bit(s) <7:6> */
			_u_16_ reserved4_bits_7_6:2;

			/* parameter [4] bit(s) <10:8> */
			_u_16_ udptl_redundancy_t30:3;

			/* parameter [4] bit(s) <12:11> */
			_u_16_ udptl_redundancy_fax_page:2;

			/* parameter [4] bit(s) <13> */
			_u_16_ ecm_disable:1;

			/* parameter [4] bit(s) <15:14> */
			_u_16_ t38_packet_loss_concealment:2;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <7:0> */
			_u_16_ reserved5_bits_7_0:8;

			/* parameter [5] bit(s) <8> */
			_u_16_ transmit_small:1;

			/* parameter [5] bit(s) <15:9> */
			_u_16_ reserved5_bits_15_9:7;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	/* parameter [6] */
	_u_16_ reserved6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <0> */
			_u_16_ enable_v34_fax:1;

			/* parameter [7] bit(s) <4:1> */
			_u_16_ v34_speed_limit:4;

			/* parameter [7] bit(s) <15:5> */
			_u_16_ reserved7_bits_15_5:11;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;


} ATTRIBUTE_PACKED;

/************************************************************
CA:FAXLVL (Function code=0x8026, class=0x02, type=0x00)
************************************************************/
struct _FAXLVL
{
	/* parameter [4] */
	_u_16_ faxlvl;


} ATTRIBUTE_PACKED;


/************************************************************
I:FAXSTATE (Function code=0x8011, class=0x02, type=0x03)
************************************************************/
struct _FAXSTATE_IND
{
	/* parameter [4] */
	_u_16_ state;


} ATTRIBUTE_PACKED;

/************************************************************
CA:FAXV8_REMOVAL_CONFIG (Function code=0x8730, class=0x02, type=0x00)
************************************************************/
struct _FAXV8_REMOVAL_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <1:0> */
			_u_16_ removal:2;

			/* parameter [4] bit(s) <2> */
			_u_16_ rem_det_ind:1;

			/* parameter [4] bit(s) <15:3> */
			_u_16_ reserved4_bits_15_3:13;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
I:FAXV8_REMOVAL_IND (Function code=0x8731, class=0x02, type=0x03)
************************************************************/
struct _FAXV8_REMOVAL_IND
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ action:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ removal_side:1;

			/* parameter [4] bit(s) <15:2> */
			_u_16_ reserved4_bits_15_2:14;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:6]*/
	_u_32_ timestamp;
	/* parameter [7] */
	_u_16_ reserved7;


} ATTRIBUTE_PACKED;

#endif /* COMCERTO_T38_API_H_ */ 

