/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifdef _HOST_BIG_ENDIAN_
#include "comcerto-t38-types_be.h"
#else
#include "comcerto-t38-types_le.h"
#endif

#define T30_FCF_DIS	0x01
#define T30_FCF_CSI	0x02
#define T30_FCF_NSF	0x04
#define T30_FCF_CFR	0x21
#define T30_FCF_FTT	0x22
#define T30_FCF_MCF	0x31
#define T30_FCF_RTN	0x32
#define T30_FCF_RTP	0x33
#define T30_FCF_DCN	0x5F
#define T30_FCF_DCS	0xC1
#define T30_FCF_TSI	0xC2
#define T30_FCF_EOM	0xF1
#define T30_FCF_MPS	0xF2
#define T30_FCF_EOP	0xF4
#define T30_FCF_TCP_IP	0x7E
#define T30_FCF_TCP_TDM	0x7F

/* Definitions associated to FOIP_FAXSPLOPT */
#define FOIP_FAXSPLOPT_T38_SPOOFING_ENABLE 0x0
#define FOIP_FAXSPLOPT_T38_SPOOFING_DISABLE 0x1
#define FOIP_FAXSPLOPT_T38_SPOOFING_DEFAULT 0x1

#define FOIP_FAXSPLOPT_PACKET_TO_TDM_BYTE_BASE_COMPLETE_FRAME_TO_TDM 0x0
#define FOIP_FAXSPLOPT_PACKET_TO_TDM_BYTE_BASE_BYTE_PROCESS_TO_TDM 0x1
#define FOIP_FAXSPLOPT_PACKET_TO_TDM_BYTE_BASE_DEFAULT 0x1

#define FOIP_FAXSPLOPT_TDM_TO_PACKET_BYTE_BASE_COMPLETE_FRAME_TO_PACKET 0x0
#define FOIP_FAXSPLOPT_TDM_TO_PACKET_BYTE_BASE_BYTE_PROCESS_TO_PACKET 0x1
#define FOIP_FAXSPLOPT_TDM_TO_PACKET_BYTE_BASE_DEFAULT 0x1

#define FOIP_FAXSPLOPT_TSI_REMOVAL_INCLUDE_TSI 0x0
#define FOIP_FAXSPLOPT_TSI_REMOVAL_REMOVE_TSI 0x1
#define FOIP_FAXSPLOPT_TSI_REMOVAL_DEFAULT 0x0

#define FOIP_FAXSPLOPT_CSI_REMOVAL_INCLUDE_CSI 0x0
#define FOIP_FAXSPLOPT_CSI_REMOVAL_REMOVE_CSI 0x1
#define FOIP_FAXSPLOPT_CSI_REMOVAL_DEFAULT 0x0

#define FOIP_FAXSPLOPT_NSF_RERMOVAL_INCLUDE_NSF 0x0
#define FOIP_FAXSPLOPT_NSF_RERMOVAL_REMOVE_NSF 0x1
#define FOIP_FAXSPLOPT_NSF_RERMOVAL_DEFAULT 0x0

#define FOIP_FAXSPLOPT_DSI_REMOVAL_INCLUDE_DSI 0x0
#define FOIP_FAXSPLOPT_DSI_REMOVAL_REMOVE_DSI 0x1
#define FOIP_FAXSPLOPT_DSI_REMOVAL_DEFAULT 0x0

/* Definitions associated to FAXOPT */
#define FAXOPT_T38_PACKET_LOSS_CONCEALMENT_DISABLE 0x0
#define FAXOPT_T38_PACKET_LOSS_CONCEALMENT_ENABLE_WHITE_PAGES 0x1
#define FAXOPT_T38_PACKET_LOSS_CONCEALMENT_ENABLE_GOOD_LINES 0x2
#define FAXOPT_T38_PACKET_LOSS_CONCEALMENT_RESERVED 0x3
#define FAXOPT_T38_PACKET_LOSS_CONCEALMENT_DEFAULT 0x0

#define FAXOPT_ECM_DISABLE_DISABLE 0x0
#define FAXOPT_ECM_DISABLE_ENABLE 0x1
#define FAXOPT_ECM_DISABLE_DEFAULT 0x0

#define FAXOPT_UDPTL_REDUNDANCY_FAX_PAGE_DEFAULT 0x0

#define FAXOPT_UDPTL_REDUNDANCY_T30_DEFAULT 0x3

#define FAXOPT_SPEED_LIMIT_NO_LIMIT 0x0
#define FAXOPT_SPEED_LIMIT_SPEED_LIMIT_2400 0x1
#define FAXOPT_SPEED_LIMIT_SPEED_LIMIT_4800 0x2
#define FAXOPT_SPEED_LIMIT_SPEED_LIMIT_7200 0x3
#define FAXOPT_SPEED_LIMIT_SPEED_LIMIT_9600 0x4
#define FAXOPT_SPEED_LIMIT_SPEED_LIMIT_12000 0x5
#define FAXOPT_SPEED_LIMIT_SPEED_LIMIT_14400 0x6
#define FAXOPT_SPEED_LIMIT_DEFAULT 0x0

#define FAXOPT_ERROR_RECOVERY_METHOD_REDUNDANCY 0x0
#define FAXOPT_ERROR_RECOVERY_METHOD_RESERVED 0x1
#define FAXOPT_ERROR_RECOVERY_METHOD_DEFAULT 0x0

#define FAXOPT_TCF_PROCEDURE_REMOTE_TCF 0x0
#define FAXOPT_TCF_PROCEDURE_LOCAL_TCF 0x1
#define FAXOPT_TCF_PROCEDURE_DEFAULT 0x1

#define FAXOPT_TRANSMIT_SMALL_COMPLETE_HDLC_ECM_FRAME 0x0
#define FAXOPT_TRANSMIT_SMALL_SMALL_T4_ECM 0x1
#define FAXOPT_TRANSMIT_SMALL_DEFAULT 0x1

#define FAXOPT_V34_SPEED_LIMIT_NO 0x0
#define FAXOPT_V34_SPEED_LIMIT_V8_300_BPS 0x1
#define FAXOPT_V34_SPEED_LIMIT_v34_2400_BPS 0x2
#define FAXOPT_V34_SPEED_LIMIT_v34_4800_BPS 0x3
#define FAXOPT_V34_SPEED_LIMIT_v34_7200_BPS 0x4
#define FAXOPT_V34_SPEED_LIMIT_v34_9600_BPS 0x5
#define FAXOPT_V34_SPEED_LIMIT_v34_12000_BPS 0x6
#define FAXOPT_V34_SPEED_LIMIT_v34_14400_BPS 0x7
#define FAXOPT_V34_SPEED_LIMIT_v34_16800_BPS 0x8
#define FAXOPT_V34_SPEED_LIMIT_v34_19200_BPS 0x9
#define FAXOPT_V34_SPEED_LIMIT_v34_21600_BPS 0xA
#define FAXOPT_V34_SPEED_LIMIT_v34_24000_BPS 0xB
#define FAXOPT_V34_SPEED_LIMIT_v34_26400_BPS 0xC
#define FAXOPT_V34_SPEED_LIMIT_v34_28800_BPS 0xD
#define FAXOPT_V34_SPEED_LIMIT_v34_31200_BPS 0xE
#define FAXOPT_V34_SPEED_LIMIT_v34_33600_BPS 0xF
#define FAXOPT_V34_SPEED_LIMIT_DEFAULT 0x0

#define FAXOPT_ENABLE_V34_FAX_DISABLE 0x0
#define FAXOPT_ENABLE_V34_FAX_ENABLE 0x1
#define FAXOPT_ENABLE_V34_FAX_DEFAULT 0x0

/* Definitions associated to FAXLVL */
#define FAXLVL_FAXLVL_DEFAULT 0xA

/* Definitions associated to FAXSTATE */
#define FAXSTATE_STATE_IDLE 0x0
#define FAXSTATE_STATE_RESERVED 0x1
#define FAXSTATE_STATE_CNG_RECV 0x2
#define FAXSTATE_STATE_CNG_SENT 0x3
#define FAXSTATE_STATE_CED_RECV 0x4
#define FAXSTATE_STATE_CED_SENT 0x5
#define FAXSTATE_STATE_V21_DEMOD 0x6
#define FAXSTATE_STATE_V21_REMOD 0x7
#define FAXSTATE_STATE_V27TER_2400_DEMOD 0x8
#define FAXSTATE_STATE_V27TER_2400_REMOD 0x9
#define FAXSTATE_STATE_V27TER_4800_DEMOD 0xA
#define FAXSTATE_STATE_V27TER_4800_REMOD 0xB
#define FAXSTATE_STATE_V29_7200_DEMOD 0xC
#define FAXSTATE_STATE_V29_7200_REMOD 0xD
#define FAXSTATE_STATE_V29_9600_DEMOD 0xE
#define FAXSTATE_STATE_V29_9600_REMOD 0xF
#define FAXSTATE_STATE_V17_7200_SHORT_DEMOD 0x10
#define FAXSTATE_STATE_V17_7200_SHORT_REMOD 0x11
#define FAXSTATE_STATE_V17_7200_LONG_DEMOD 0x12
#define FAXSTATE_STATE_V17_7200_LONG_REMOD 0x13
#define FAXSTATE_STATE_V17_9600_SHORT_DEMOD 0x14
#define FAXSTATE_STATE_V17_9600_SHORT_REMOD 0x15
#define FAXSTATE_STATE_V17_9600_LONG_DEMOD 0x16
#define FAXSTATE_STATE_V17_9600_LONG_REMOD 0x17
#define FAXSTATE_STATE_V17_12000_SHORT_DEMOD 0x18
#define FAXSTATE_STATE_V17_12000_SHORT_REMOD 0x19
#define FAXSTATE_STATE_V17_12000_LONG_DEMOD 0x1A
#define FAXSTATE_STATE_V17_12000_LONG_REMOD 0x1B
#define FAXSTATE_STATE_V17_14400_SHORT_DEMOD 0x1C
#define FAXSTATE_STATE_V17_14400_SHORT_REMOD 0x1D
#define FAXSTATE_STATE_V17_14400_LONG_DEMOD 0x1E
#define FAXSTATE_STATE_V17_14400_LONG_REMOD 0x1F

/* Definitions associated to FAXV8_REMOVAL_CONFIG */
#define FAXV8_REMOVAL_CONFIG_REM_DET_IND_DISABLE 0x0
#define FAXV8_REMOVAL_CONFIG_REM_DET_IND_ENABLE 0x1
#define FAXV8_REMOVAL_CONFIG_REM_DET_IND_DEFAULT 0x0

#define FAXV8_REMOVAL_CONFIG_REMOVAL_DISABLE 0x0
#define FAXV8_REMOVAL_CONFIG_REMOVAL_TRIGGERED 0x1
#define FAXV8_REMOVAL_CONFIG_REMOVAL_IMMEDIATE 0x2
#define FAXV8_REMOVAL_CONFIG_REMOVAL_DEFAULT 0x0

/* Definitions associated to FAXV8_REMOVAL_IND */
#define FAXV8_REMOVAL_IND_REMOVAL_SIDE_TDM 0x0
#define FAXV8_REMOVAL_IND_REMOVAL_SIDE_IP 0x1
#define FAXV8_REMOVAL_IND_REMOVAL_SIDE_DEFAULT 0x0

#define FAXV8_REMOVAL_IND_ACTION_PASSING 0x0
#define FAXV8_REMOVAL_IND_ACTION_REMOVING 0x1

/* definition associated to GET_DATAGRAM */ 
#define MAX_IFP_RX_DATAGRAM_SIZE	1472

/* definition associated to GET_BUFFSZ */ 
#define MAX_IFP_BUFFER_SIZE		9792


