/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_SUPERVISOR_API_H_
#define _COMCERTO_SUPERVISOR_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
I:SUPVSR_READY (Function code=0x0000, class=0x03, type=0xD4)
************************************************************/
struct _SUPVSR_READY
{
	/* parameter [4] */
	_u_16_ result;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <7:0> */
			_u_16_ devicename:8;

			/* parameter [5] bit(s) <15:8> */
			_u_16_ eramstatus:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	/* parameter [6] */
	_u_16_ unknown;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_READY */
#define SUPVSR_READY_DEVICENAME_M82530 0x0
#define SUPVSR_READY_DEVICENAME_M82520 0x1
#define SUPVSR_READY_DEVICENAME_M82510 0x2
#define SUPVSR_READY_DEVICENAME_M82505 0x3
#define SUPVSR_READY_DEVICENAME_M82610 0x4
#define SUPVSR_READY_DEVICENAME_M82600 0x5
#define SUPVSR_READY_DEVICENAME_M82620 0x6
#define SUPVSR_READY_DEVICENAME_M82610_11P 0x7
#define SUPVSR_READY_DEVICENAME_M82530_SLAVE 0x8
#define SUPVSR_READY_DEVICENAME_M82520_SLAVE 0x9
#define SUPVSR_READY_DEVICENAME_M82510_SLAVE 0xA
#define SUPVSR_READY_DEVICENAME_M82505_SLAVE 0xB
#define SUPVSR_READY_DEVICENAME_M827XX 0xC
#define SUPVSR_READY_DEVICENAME_M82515 0xD
#define SUPVSR_READY_DEVICENAME_M82511 0xE
#define SUPVSR_READY_DEVICENAME_M82506 0xF
#define SUPVSR_READY_DEVICENAME_M82501 0x10
#define SUPVSR_READY_DEVICENAME_M82515_SLAVE 0x11
#define SUPVSR_READY_DEVICENAME_M82511_SLAVE 0x12
#define SUPVSR_READY_DEVICENAME_M82506_SLAVE 0x13
#define SUPVSR_READY_DEVICENAME_M82501_SLAVE 0x14
#define SUPVSR_READY_DEVICENAME_M82514 0x15
#define SUPVSR_READY_DEVICENAME_M82514_SLAVE 0x16
#define SUPVSR_READY_DEVICENAME_M82524 0x17
#define SUPVSR_READY_DEVICENAME_M82524_SLAVE 0x18
#define SUPVSR_READY_DEVICENAME_M829XX 0x19
#define SUPVSR_READY_DEVICENAME_M82708 0x1A
#define SUPVSR_READY_DEVICENAME_M82359 0x1B
#define SUPVSR_READY_DEVICENAME_M82358 0x1C
#define SUPVSR_READY_DEVICENAME_M82356 0x1D
#define SUPVSR_READY_DEVICENAME_M82354 0x1E
#define SUPVSR_READY_DEVICENAME_M82353 0x1F
#define SUPVSR_READY_DEVICENAME_M82359_SLAVE 0x20
#define SUPVSR_READY_DEVICENAME_M82358_SLAVE 0x21
#define SUPVSR_READY_DEVICENAME_M82356_SLAVE 0x22
#define SUPVSR_READY_DEVICENAME_M82354_SLAVE 0x23
#define SUPVSR_READY_DEVICENAME_M82353_SLAVE 0x24
#define SUPVSR_READY_DEVICENAME_M82803 0x39
#define SUPVSR_READY_DEVICENAME_M82801 0x3A
#define SUPVSR_READY_DEVICENAME_M82805 0x3B
#define SUPVSR_READY_DEVICENAME_M82810 0x3C
#define SUPVSR_READY_DEVICENAME_M82815 0x3D
#define SUPVSR_READY_DEVICENAME_M82820 0x3E

/************************************************************
C:SUPVSR_CREATE_CHANNEL (Function code=0x0010, class=0x06, type=0x00)
************************************************************/
struct _SUPVSR_CREATE_CHANNEL
{
	/* parameter [4] */
	_u_16_ type;

	/* parameter [5] */
	_u_16_ timeslot;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_CREATE_CHANNEL */
#define SUPVSR_CREATE_CHANNEL_TYPE_VOIP 0x2
#define SUPVSR_CREATE_CHANNEL_TYPE_FOIP 0x7
#define SUPVSR_CREATE_CHANNEL_TYPE_VOATM 0x8
#define SUPVSR_CREATE_CHANNEL_TYPE_IUUPORTP 0x9
#define SUPVSR_CREATE_CHANNEL_TYPE_IUUPOAAL2 0xA
#define SUPVSR_CREATE_CHANNEL_TYPE_DSPONLY 0xB
#define SUPVSR_CREATE_CHANNEL_TYPE_FOIPDSPONLY 0xC
#define SUPVSR_CREATE_CHANNEL_TYPE_SOMATADSP 0xF
#define SUPVSR_CREATE_CHANNEL_TYPE_SOMATATDM 0x10
#define SUPVSR_CREATE_CHANNEL_TYPE_SLIC 0x10
#define SUPVSR_CREATE_CHANNEL_TYPE_TONEGEN 0x11
#define SUPVSR_CREATE_CHANNEL_TYPE_TONEDET 0x12
#define SUPVSR_CREATE_CHANNEL_TYPE_WARNINGTONEGEN 0x13
#define SUPVSR_CREATE_CHANNEL_TYPE_IP_REDIRECT 0x14
#define SUPVSR_CREATE_CHANNEL_TYPE_HOSTDATALINK 0x15
#define SUPVSR_CREATE_CHANNEL_TYPE_HDLCOTDM 0x17
#define SUPVSR_CREATE_CHANNEL_TYPE_DSPDIAG 0x20
#define SUPVSR_CREATE_CHANNEL_TYPE_AAL1CES 0x40
#define SUPVSR_CREATE_CHANNEL_TYPE_AAL0WRAPPER 0x41
#define SUPVSR_CREATE_CHANNEL_TYPE_AAL0 0x42
#define SUPVSR_CREATE_CHANNEL_TYPE_POSWRAPPER 0x43
#define SUPVSR_CREATE_CHANNEL_TYPE_HW_UMG8900 0x44
#define SUPVSR_CREATE_CHANNEL_TYPE_CCS 0x80
#define SUPVSR_CREATE_CHANNEL_TYPE_CESOPSN 0x81

/************************************************************
A:SUPVSR_CREATE_CHANNEL (Function code=0x0010, class=0x06, type=0x02)
************************************************************/
struct _SUPVSR_CREATE_CHANNEL_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ id;

	/* parameter [6] */
	_u_16_ timeslot;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_CREATE_CHANNEL */
#define SUPVSR_CREATE_CHANNEL_STATUS_CNF_OK 0x0

/************************************************************
C:SUPVSR_DESTROY_CHANNEL (Function code=0x0011, class=0x06, type=0x00)
************************************************************/
struct _SUPVSR_DESTROY_CHANNEL
{
	/* parameter [4] */
	_u_16_ id;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_DESTROY_CHANNEL */

/************************************************************
A:SUPVSR_DESTROY_CHANNEL (Function code=0x0011, class=0x06, type=0x02)
************************************************************/
struct _SUPVSR_DESTROY_CHANNEL_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ id;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_DESTROY_CHANNEL */
#define SUPVSR_DESTROY_CHANNEL_STATUS_CNF_OK 0x0

/************************************************************
C:SUPVSR_SETUP_TDM_PARAMS (Function code=0x0407, class=0x06, type=0x00)
************************************************************/
struct _SUPVSR_SETUP_TDM_PARAMS
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <7:0> */
			_u_16_ tpf:8;

			/* parameter [4] bit(s) <8> */
			_u_16_ fe:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ xce:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ rce:1;

			/* parameter [4] bit(s) <11> */
			_u_16_ cmsx:1;

			/* parameter [4] bit(s) <12> */
			_u_16_ cmsr:1;

			/* parameter [4] bit(s) <13> */
			_u_16_ dix:1;

			/* parameter [4] bit(s) <14> */
			_u_16_ dir:1;

			/* parameter [4] bit(s) <15> */
			_u_16_ box:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <9:0> */
			_u_16_ cycx_lo:10;

			/* parameter [5] bit(s) <10> */
			_u_16_ bor:1;

			/* parameter [5] bit(s) <11> */
			_u_16_ fein:1;

			/* parameter [5] bit(s) <12> */
			_u_16_ reserved5_bit_12:1;

			/* parameter [5] bit(s) <13> */
			_u_16_ reserved5_bit_13:1;

			/* parameter [5] bit(s) <15:14> */
			_u_16_ cycx_hi:2;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <11:0> */
			_u_16_ cycr:12;

			/* parameter [6] bit(s) <15:12> */
			_u_16_ reserved6_bits_15_12:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <1:0> */
			_u_16_ tpf_hi:2;

			/* parameter [7] bit(s) <3:2> */
			_u_16_ bus:2;

			/* parameter [7] bit(s) <15:4> */
			_u_16_ reserved7_bits_15_4:12;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_SETUP_TDM_PARAMS */
#define SUPVSR_SETUP_TDM_PARAMS_TPF_DEFAULT 0x80

#define SUPVSR_SETUP_TDM_PARAMS_FE_FALLING 0x0
#define SUPVSR_SETUP_TDM_PARAMS_FE_RISING 0x1
#define SUPVSR_SETUP_TDM_PARAMS_FE_DEFAULT 0x1

#define SUPVSR_SETUP_TDM_PARAMS_XCE_FALLING 0x0
#define SUPVSR_SETUP_TDM_PARAMS_XCE_RISING 0x1
#define SUPVSR_SETUP_TDM_PARAMS_XCE_DEFAULT 0x1

#define SUPVSR_SETUP_TDM_PARAMS_RCE_FALLING 0x0
#define SUPVSR_SETUP_TDM_PARAMS_RCE_RISING 0x1
#define SUPVSR_SETUP_TDM_PARAMS_RCE_DEFAULT 0x0

#define SUPVSR_SETUP_TDM_PARAMS_CMSX_SINGLE 0x0
#define SUPVSR_SETUP_TDM_PARAMS_CMSX_DOUBLE 0x1
#define SUPVSR_SETUP_TDM_PARAMS_CMSX_DEFAULT 0x0

#define SUPVSR_SETUP_TDM_PARAMS_CMSR_SINGLE 0x0
#define SUPVSR_SETUP_TDM_PARAMS_CMSR_DOUBLE 0x1
#define SUPVSR_SETUP_TDM_PARAMS_CMSR_DEFAULT 0x0

#define SUPVSR_SETUP_TDM_PARAMS_DIX_ACTIVEHIGH 0x0
#define SUPVSR_SETUP_TDM_PARAMS_DIX_ACTIVELOW 0x1
#define SUPVSR_SETUP_TDM_PARAMS_DIX_DEFAULT 0x0

#define SUPVSR_SETUP_TDM_PARAMS_DIR_ACTIVEHIGH 0x0
#define SUPVSR_SETUP_TDM_PARAMS_DIR_ACTIVELOW 0x1
#define SUPVSR_SETUP_TDM_PARAMS_DIR_DEFAULT 0x0

#define SUPVSR_SETUP_TDM_PARAMS_BOX_LSB_FIRST 0x0
#define SUPVSR_SETUP_TDM_PARAMS_BOX_MSB_FIRST 0x1
#define SUPVSR_SETUP_TDM_PARAMS_BOX_DEFAULT 0x1

#define SUPVSR_SETUP_TDM_PARAMS_CYCX_LO_DEFAULT 0x0

#define SUPVSR_SETUP_TDM_PARAMS_BOR_LSB_FIRST 0x0
#define SUPVSR_SETUP_TDM_PARAMS_BOR_MSB_FIRST 0x1
#define SUPVSR_SETUP_TDM_PARAMS_BOR_DEFAULT 0x1

#define SUPVSR_SETUP_TDM_PARAMS_FEIN_ACTIVEHIGH 0x0
#define SUPVSR_SETUP_TDM_PARAMS_FEIN_ACTIVELOW 0x1
#define SUPVSR_SETUP_TDM_PARAMS_FEIN_DEFAULT 0x1

#define SUPVSR_SETUP_TDM_PARAMS_CYCX_HI_DEFAULT 0x0

#define SUPVSR_SETUP_TDM_PARAMS_CYCR_DEFAULT 0x0

#define SUPVSR_SETUP_TDM_PARAMS_TPF_HI_DEFAULT 0x0


/************************************************************
Q:SUPVSR_GET_DEVICE_VERSION (Function code=0x0410, class=0x06, type=0x01)
************************************************************/
struct _SUPVSR_GET_DEVICE_VERSION
{

} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_GET_DEVICE_VERSION */

/************************************************************
Q:SUPVSR_GET_ARM_CLK (Function code=0x0411, class=0x06, type=0x01)
************************************************************/
struct _SUPVSR_GET_ARM_CLK
{

} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_GET_ARM_CLK */

/************************************************************
Q:SUPVSR_GET_SPU_CLK (Function code=0x0412, class=0x06, type=0x01)
************************************************************/
struct _SUPVSR_GET_SPU_CLK
{

} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_GET_SPU_CLK */

/************************************************************
C:SUPVSR_SET_ARM_CLK (Function code=0x0411, class=0x06, type=0x00)
************************************************************/
struct _SUPVSR_SET_ARM_CLK
{
	/* parameter [4] */
	_u_16_ speed;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_SET_ARM_CLK */

/************************************************************
C:SUPVSR_SET_SPU_CLK (Function code=0x0412, class=0x06, type=0x00)
************************************************************/
struct _SUPVSR_SET_SPU_CLK
{
	/* parameter [4] */
	_u_16_ speed;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_SET_SPU_CLK */

/************************************************************
Q:SUPVSR_GET_ARM_CODE_VERSION (Function code=0x0021, class=0x06, type=0x01)
************************************************************/
struct _SUPVSR_GET_ARM_CODE_VERSION
{

} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_GET_ARM_CODE_VERSION */

/************************************************************
Q:SUPVSR_GET_SPU_CODE_VERSION (Function code=0x0022, class=0x06, type=0x01)
************************************************************/
struct _SUPVSR_GET_SPU_CODE_VERSION
{

} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_GET_SPU_CODE_VERSION */

/************************************************************
Q:SUPVSR_RUN_CHECKSUM (Function code=0x0023, class=0x06, type=0x01)
************************************************************/
struct _SUPVSR_RUN_CHECKSUM
{

} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_RUN_CHECKSUM */

/************************************************************
Q:SUPVSR_GET_DEVICE_TYPE (Function code=0x0031, class=0x06, type=0x01)
************************************************************/
struct _SUPVSR_GET_DEVICE_TYPE
{

} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_GET_DEVICE_TYPE */

/************************************************************
C:SUPVSR_MAC_HAIRPIN (Function code=0x9700, class=0x06, type=0x00)
************************************************************/
struct _SUPVSR_MAC_HAIRPIN
{
	/* parameter [4] */
	_u_16_ flag;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_MAC_HAIRPIN */
#define SUPVSR_MAC_HAIRPIN_FLAG_DISABLE 0x0
#define SUPVSR_MAC_HAIRPIN_FLAG_ENABLE 0x1
#define SUPVSR_MAC_HAIRPIN_FLAG_DEFAULT 0x0


/************************************************************
C:C2C_SERVICE_CFG (Function code=0x0C00, class=0x06, type=0x00)
************************************************************/
struct _C2C_SERVICE_CFG
{
	/* parameter [4] */
	_u_16_ max_connections;


} ATTRIBUTE_PACKED;
/* Definitions associated to C2C_SERVICE_CFG */

/************************************************************
C:SUPVSR_NEXT_VOIP_CHAN_ON_ACP (Function code=0x0460, class=0x06, type=0x00)
************************************************************/
struct _SUPVSR_NEXT_VOIP_CHAN_ON_ACP
{
	/* parameter [4] */
	_u_16_ reserved4;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_NEXT_VOIP_CHAN_ON_ACP */

/************************************************************
A:SUPVSR_NEXT_VOIP_CHAN_ON_ACP (Function code=0x0460, class=0x06, type=0x02)
************************************************************/
struct _SUPVSR_NEXT_VOIP_CHAN_ON_ACP_RESP
{
	/* parameter [4] */
	_u_16_ status;


} ATTRIBUTE_PACKED;
/* Definitions associated to SUPVSR_NEXT_VOIP_CHAN_ON_ACP */
#define SUPVSR_NEXT_VOIP_CHAN_ON_ACP_STATUS_CNF_OK 0x0
#endif /* COMCERTO_SUPERVISOR_API_H_ */ 
