/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_STAT_VOICE_PACKET_RECEIVE_API_H_
#define _COMCERTO_STAT_VOICE_PACKET_RECEIVE_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
QR:VoIP_PKTRX (class=0x01, type=0x09)
************************************************************/
struct _VOIP_PKTRX
{
	/*parameters [4:5]*/
	_u_32_ revision;
	/*parameters [6:7]*/
	_u_32_ voice_packets;
	/*parameters [8:9]*/
	_u_32_ signaling_packets;
	/*parameters [10:11]*/
	_u_32_ comfort_noise_packets;
	/*parameters [12:13]*/
	_u_32_ total_receive_duration;
	/*parameters [14:15]*/
	_u_32_ voice_receive_duration;
	/*parameters [16:17]*/
	_u_32_ packets_out_sequence;
	/*parameters [18:19]*/
	_u_32_ bad_protocol_headers;
	/*parameters [20:21]*/
	_u_32_ late_packets;
	/*parameters [22:23]*/
	_u_32_ early_packets;
	/*parameters [24:25]*/
	_u_32_ rx_voice_octets;
	/*parameters [26:27]*/
	_u_32_ lost_packets;

} ATTRIBUTE_PACKED;
#endif /* COMCERTO_STAT_VOICE_PACKET_RECEIVE_API_H_ */ 

