/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_STAT_COMBINED_VOICE_API_H_
#define _COMCERTO_STAT_COMBINED_VOICE_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
QR:VoIP_VCEINFO (class=0x01, type=0x0E)
************************************************************/
struct _VOIP_VCEINFO
{
	/*parameters [4:5]*/
	_u_32_ format;
	/* parameter [6] */
	_u_16_ reserved6;

	/* parameter [7] */
	_u_16_ reserved7;

	/*parameters [8:9]*/
	_u_32_ call_timer;
	/*parameters [10:11]*/
	_u_32_ cur_playout_delay;
	/*parameters [12:13]*/
	_u_32_ min_playout_delay;
	/*parameters [14:15]*/
	_u_32_ max_playout_delay;
	/*parameters [16:17]*/
	_u_32_ clock_offset;
	/*parameters [18:19]*/
	_u_32_ peak_jitter;
	/*parameters [20:21]*/
	_u_32_ interpolative_concealment;
	/*parameters [22:23]*/
	_u_32_ silence_concealment;
	/*parameters [24:25]*/
	_u_32_ overflow_discard;
	/*parameters [26:27]*/
	_u_32_ ep_detection_errors;
	/*parameters [28:29]*/
	_u_32_ tx_voice_packets;
	/*parameters [30:31]*/
	_u_32_ tx_signaling_packets;
	/*parameters [32:33]*/
	_u_32_ tx_comfort_noise_packets;
	/*parameters [34:35]*/
	_u_32_ total_transmit_duration;
	/*parameters [36:37]*/
	_u_32_ voice_transmit_duration;
	/*parameters [38:39]*/
	_u_32_ rx_voice_packets;
	/*parameters [40:41]*/
	_u_32_ rx_signaling_packets;
	/*parameters [42:43]*/
	_u_32_ rx_comfort_noise_packets;
	/*parameters [44:45]*/
	_u_32_ total_receive_duration;
	/*parameters [46:47]*/
	_u_32_ voice_receive_duration;
	/*parameters [48:49]*/
	_u_32_ packets_out_sequence;
	/*parameters [50:51]*/
	_u_32_ bad_protocol_headers;
	/*parameters [52:53]*/
	_u_32_ late_packets;
	/*parameters [54:55]*/
	_u_32_ early_packets;
	/*parameters [56:57]*/
	_u_32_ rx_voice_octets;
	/*parameters [58:59]*/
	_u_32_ lost_packets;
	/*parameters [60:61]*/
	_u_32_ cur_transmit_power;
	/*parameters [62:63]*/
	_u_32_ mean_transmit_power;
	/*parameters [64:65]*/
	_u_32_ cur_receive_power;
	/*parameters [66:67]*/
	_u_32_ mean_receive_power;
	/*parameters [68:69]*/
	_u_32_ background_noise;
	/*parameters [70:71]*/
	_u_32_ erl_level;
	/*parameters [72:73]*/
	_u_32_ acom_level;
	/*parameters [74:75]*/
	_u_32_ cur_transmit_activity;
	/*parameters [76:77]*/
	_u_32_ cur_receive_activity;
	/*parameters [78:79]*/
	_u_32_ dscrd_unxp_pkts;
	/*parameters [80:81]*/
	_u_32_ dscrd_pkts_due_rx_dis;
	/*parameters [82:83]*/
	_u_32_ dscrd_dupl_pkts;
	/*parameters [84:85]*/
	_u_32_ dscrd_pkts_incorrect_ppl;
	/*parameters [86:87]*/
	_u_32_ dscrd_pkts_chnl_inactive;
	/*parameters [88:89]*/
	_u_32_ dscrd_pkts_insuf_mem;
	/*parameters [90:91]*/
	_u_32_ dscrd_pkts_chnl_lock_up;

} ATTRIBUTE_PACKED;
#endif /* COMCERTO_STAT_COMBINED_VOICE_API_H_ */ 

