/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_SPECIALPKT_API_H_
#define _COMCERTO_SPECIALPKT_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
C:SPECIALPKT_HANDLING_SERVICE_CONFIG (Function code=0x0107, class=0x06, type=0x00)
************************************************************/
struct _SPECIALPKT_HANDLING_SERVICE_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:2> */
			_u_16_ reserved4_bits_15_2:14;

			/* parameter [4] bit(s) <1> */
			_u_16_ arp_req_forward:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ arp_forward:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:1> */
			_u_16_ reserved5_bits_15_1:15;

			/* parameter [5] bit(s) <0> */
			_u_16_ icmp_forward:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;


} ATTRIBUTE_PACKED;

/************************************************************
I:SPECIALPKT_HANDLING_INDICATION_ETH (Function code=0x0108, class=0x06, type=0x03)
************************************************************/
struct _SPECIALPKT_HANDLING_INDICATION_ETH
{

	/*parameters [4:$] = pkt_data:OCTETS*/
	_u_8_ pkt_data [248];

} ATTRIBUTE_PACKED;

/************************************************************
C:SPECIALPKT_HANDLING_GEN_ETH (Function code=0x0109, class=0x06, type=0x00)
************************************************************/
struct _SPECIALPKT_HANDLING_GEN_ETH
{

	/*parameters [4:$] = pkt_data:OCTETS*/
	_u_8_ pkt_data [248];

} ATTRIBUTE_PACKED;

/************************************************************
C:SPECIALPKT_HANDLING_GEN_IPoAAL5 (Function code=0x010C, class=0x06, type=0x00)
************************************************************/
struct _SPECIALPKT_HANDLING_GEN_IPOAAL5
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ service_descriptor:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


	/*parameters [5:$] = pkt_data:OCTETS*/
	_u_8_ pkt_data [246];

} ATTRIBUTE_PACKED;


/************************************************************
I:SPECIALPKT_HANDLING_INDICATION_IP (Function code=0x010B, class=0x06, type=0x03)
************************************************************/
struct _SPECIALPKT_HANDLING_INDICATION_IP
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ trunc:1;

			/* parameter [4] bit(s) <14:8> */
			_u_16_ reserved4_bits_14_8:7;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ service_descriptor:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


	/*parameters [5:$] = pkt_data:OCTETS*/
	_u_8_ pkt_data [246];

} ATTRIBUTE_PACKED;

/************************************************************
QR:SPECIALPKT_HANDLING_STATISTICS (class=0x05, type=0x02)
************************************************************/
struct _SPECIALPKT_HANDLING_STATISTICS
{
	/*parameters [4:5]*/
	_u_32_ revision;
	/*parameters [6:7]*/
	_u_32_ gen_eth_req;
	/*parameters [8:9]*/
	_u_32_ gen_eth_drop;
	/*parameters [10:11]*/
	_u_32_ forward_eth_req;
	/*parameters [12:13]*/
	_u_32_ forward_eth_drop;
	/*parameters [14:15]*/
	_u_32_ gen_ipoaal5_req;
	/*parameters [16:17]*/
	_u_32_ gen_ipoaal5_drop;
	/*parameters [18:19]*/
	_u_32_ forward_ip_req;
	/*parameters [20:21]*/
	_u_32_ forward_ip_drop;

} ATTRIBUTE_PACKED;
#endif /* COMCERTO_SPECIALPKT_API_H_ */ 

