/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_RTCPSTAT_API_H_
#define _COMCERTO_RTCPSTAT_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
QR:VoIP_RTCPSTAT (Function code=0x800C, class=0x02, type=0x01)
************************************************************/
struct _VOIP_RTCPSTAT
{
	/*parameters [4:5]*/
	_u_32_ revision;
	/*parameters [6:7]*/
	_u_32_ timestamp;
	/*parameters [8:9]*/
	_u_32_ sender_packets;
	/*parameters [10:11]*/
	_u_32_ sender_octets;
	/*parameters [12:13]*/
	_u_32_ ssrc_1;
	/*parameters [14:15]*/
	_u_32_ lost;
	/*parameters [16:17]*/
	_u_32_ ehs;
	/*parameters [18:19]*/
	_u_32_ jitter;
	/*parameters [20:21]*/
	_u_32_ lsr;
	/*parameters [22:23]*/
	_u_32_ dlsr;
	/*parameters [24:25]*/
	_u_32_ rtd;
	/*parameters [26:27]*/
	_u_32_ rtcp;
	/*parameters [28:29]*/
	_u_32_ sr;
	/*parameters [30:31]*/
	_u_32_ rr;
	/*parameters [32:33]*/
	_u_32_ sdes;
	/*parameters [34:35]*/
	_u_32_ remjitmean;
	/*parameters [36:37]*/
	_u_32_ remjitmax;
	/*parameters [38:39]*/
	_u_32_ locjitmean;
	/*parameters [40:41]*/
	_u_32_ locjitmax;
	/*parameters [42:43]*/
	_u_32_ remplrmean;
	/*parameters [44:45]*/
	_u_32_ remplrmax;
	/*parameters [46:47]*/
	_u_32_ locplrmean;
	/*parameters [48:49]*/
	_u_32_ locplrmax;
	/*parameters [50:51]*/
	_u_32_ rtdmean;
	/*parameters [52:53]*/
	_u_32_ rtdmax;
	/*parameters [54:55]*/
	_u_32_ rxpktcount;
	/*parameters [56:57]*/
	_u_32_ rxbytecount;
	/*parameters [58:59]*/
	_u_32_ srcssrc;

} ATTRIBUTE_PACKED;
#endif /* COMCERTO_RTCPSTAT_API_H_ */ 

