/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_RTCP_XR_API_H_
#define _COMCERTO_RTCP_XR_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
QR:RTCP_XR_STATS (class=0x01, type=0x2B)
************************************************************/
struct _RTCP_XR_STATS
{
	/*parameters [4:5]*/
	_u_32_ revision;
	/*parameters [6:7]*/
	_u_32_ timestamp;
	/*parameters [8:9]*/
	_u_32_ sent_packets;

} ATTRIBUTE_PACKED;

/************************************************************
I:IND_RTCP_XR (Function code=0x80A2, class=0x02, type=0x03)
************************************************************/
struct _IND_RTCP_XR_IND
{
	/* parameter [4] */
	_u_16_ length;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <7:0> */
			_u_16_ rb_type:8;

			/* parameter [5] bit(s) <15:8> */
			_u_16_ rb_flags:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	/* parameter [6] */
	_u_16_ rb_length;

	/*parameters [7:8]*/
	_u_32_ rb_ssrc;
	/* parameter [9] */
	_u_16_ begin_seq;

	/* parameter [10] */
	_u_16_ end_seq;

	/*parameters [11:12]*/
	_u_32_ lost_pkt;
	/*parameters [13:14]*/
	_u_32_ dup_pkt;
	/*parameters [15:16]*/
	_u_32_ min_jitter;
	/*parameters [17:18]*/
	_u_32_ max_jitter;
	/*parameters [19:20]*/
	_u_32_ mean_jitter;
	/*parameters [21:22]*/
	_u_32_ dev_jitter;
	/* parameter [23] */
	_u_16_ reserved1;

	/* parameter [24] */
	_u_16_ reserved2;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [25] bit(s) <7:0> */
			_u_16_ mb_type:8;

			/* parameter [25] bit(s) <15:8> */
			_u_16_ mb_reserved:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_25;

	/* parameter [26] */
	_u_16_ mb_length;

	/*parameters [27:28]*/
	_u_32_ mb_ssrc;
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [29] bit(s) <7:0> */
			_u_16_ lost_rate:8;

			/* parameter [29] bit(s) <15:8> */
			_u_16_ discard_rate:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_29;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [30] bit(s) <7:0> */
			_u_16_ burst_density:8;

			/* parameter [30] bit(s) <15:8> */
			_u_16_ gap_density:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_30;

	/* parameter [31] */
	_u_16_ burst_duration;

	/* parameter [32] */
	_u_16_ gap_duration;

	/* parameter [33] */
	_u_16_ rtd;

	/* parameter [34] */
	_u_16_ esd;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [35] bit(s) <7:0> */
			_u_16_ signal_lvl:8;

			/* parameter [35] bit(s) <15:8> */
			_u_16_ noise_lvl:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_35;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [36] bit(s) <7:0> */
			_u_16_ rerl:8;

			/* parameter [36] bit(s) <15:8> */
			_u_16_ gmin:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_36;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [37] bit(s) <7:0> */
			_u_16_ r_factor:8;

			/* parameter [37] bit(s) <15:8> */
			_u_16_ r_factor_ex:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_37;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [38] bit(s) <7:0> */
			_u_16_ mos_lq:8;

			/* parameter [38] bit(s) <15:8> */
			_u_16_ mos_cq:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_38;

	/* parameter [39] */
	_u_16_ rx_cfg;

	/* parameter [40] */
	_u_16_ jb_nom;

	/* parameter [41] */
	_u_16_ jb_max;

	/* parameter [42] */
	_u_16_ jb_abs_max;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [43] bit(s) <7:0> */
			_u_16_ block_type:8;

			/* parameter [43] bit(s) <15:8> */
			_u_16_ reserved3:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_43;

	/* parameter [44] */
	_u_16_ block_length;

	/*parameters [45:46]*/
	_u_32_ src_ssrc;
	/* parameter [47] */
	_u_16_ begin_seq2;

	/* parameter [48] */
	_u_16_ end_seq2;

	/* parameter [49] */
	_u_16_ maxdiff_jitter;

	/* parameter [50] */
	_u_16_ range_jitter;

	/*parameters [51:52]*/
	_u_32_ sum_jitter;
	/* parameter [53] */
	_u_16_ sum_cycles;

	/* parameter [54] */
	_u_16_ jb_events;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [55] bit(s) <7:0> */
			_u_16_ reserved4:8;

			/* parameter [55] bit(s) <15:8> */
			_u_16_ tdeg_network_hi:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_55;

	/* parameter [56] */
	_u_16_ tdeg_network_lo;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [57] bit(s) <7:0> */
			_u_16_ reserved5:8;

			/* parameter [57] bit(s) <15:8> */
			_u_16_ tdeg_jb_hi:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_57;

	/* parameter [58] */
	_u_16_ tdeg_jb_lo;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [59] bit(s) <7:0> */
			_u_16_ reserved6:8;

			/* parameter [59] bit(s) <15:8> */
			_u_16_ es:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_59;

	/* parameter [60] */
	_u_16_ es1;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [61] bit(s) <7:0> */
			_u_16_ reserved7:8;

			/* parameter [61] bit(s) <15:8> */
			_u_16_ ses:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_61;

	/* parameter [62] */
	_u_16_ ses1;


} ATTRIBUTE_PACKED;

/************************************************************
QR:RTCP_XR_METRICS_SUMMARY_STATS (class=0x01, type=0x2F)
************************************************************/
struct _RTCP_XR_METRICS_SUMMARY_STATS
{
	/* parameter [4] */
	_u_16_ revision;

	/* parameter [5] */
	_u_16_ recv_blocks;

	/*parameters [6:7]*/
	_u_32_ remote_rtd;
	/*parameters [8:9]*/
	_u_32_ remote_esd;
	/*parameters [10:11]*/
	_u_32_ remote_signal;
	/*parameters [12:13]*/
	_u_32_ remote_noice;
	/*parameters [14:15]*/
	_u_32_ remote_rerl;
	/* parameter [16] */
	_u_16_ sent_blocks;

	/*parameters [17:18]*/
	_u_32_ local_rtd;
	/*parameters [19:20]*/
	_u_32_ local_esd;
	/*parameters [21:22]*/
	_u_32_ local_signal;
	/*parameters [23:24]*/
	_u_32_ local_noice;
	/*parameters [25:26]*/
	_u_32_ local_rerl;
	/* parameter [27] */
	_u_16_ min_rtd;

	/* parameter [28] */
	_u_16_ max_rtd;

	/* parameter [29] */
	_u_16_ min_esd;

	/* parameter [30] */
	_u_16_ max_esd;

	/* parameter [31] */
	_u_16_ local_discards;


} ATTRIBUTE_PACKED;

/************************************************************
C:PROGRAM_RTCP_XR_PARAMS (Function code=0x80F3, class=0x02, type=0x00)
************************************************************/
struct _PROGRAM_RTCP_XR_PARAMS
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ use_gmin:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ use_delay:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ gather_mss:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ reserved_bit3:1;

			/* parameter [4] bit(s) <7:4> */
			_u_16_ rle_value:4;

			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ gmin;

	/* parameter [6] */
	_u_16_ delay;


} ATTRIBUTE_PACKED;




/************************************************************
I:IND_RTCP_XR_TX (Function code=0x8A01, class=0x02, type=0x03)
************************************************************/
struct _IND_RTCP_XR_TX_IND
{
	/* parameter [4] */
	_u_16_ length;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <7:0> */
			_u_16_ rb_type:8;

			/* parameter [5] bit(s) <15:8> */
			_u_16_ rb_flags:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	/* parameter [6] */
	_u_16_ rb_length;

	/*parameters [7:8]*/
	_u_32_ rb_ssrc;
	/* parameter [9] */
	_u_16_ begin_seq;

	/* parameter [10] */
	_u_16_ end_seq;

	/*parameters [11:12]*/
	_u_32_ lost_pkt;
	/*parameters [13:14]*/
	_u_32_ dup_pkt;
	/*parameters [15:16]*/
	_u_32_ min_jitter;
	/*parameters [17:18]*/
	_u_32_ max_jitter;
	/*parameters [19:20]*/
	_u_32_ mean_jitter;
	/*parameters [21:22]*/
	_u_32_ dev_jitter;
	/* parameter [23] */
	_u_16_ reserved1;

	/* parameter [24] */
	_u_16_ reserved2;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [25] bit(s) <7:0> */
			_u_16_ mb_type:8;

			/* parameter [25] bit(s) <15:8> */
			_u_16_ mb_reserved:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_25;

	/* parameter [26] */
	_u_16_ mb_length;

	/*parameters [27:28]*/
	_u_32_ mb_ssrc;
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [29] bit(s) <7:0> */
			_u_16_ lost_rate:8;

			/* parameter [29] bit(s) <15:8> */
			_u_16_ discard_rate:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_29;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [30] bit(s) <7:0> */
			_u_16_ burst_density:8;

			/* parameter [30] bit(s) <15:8> */
			_u_16_ gap_density:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_30;

	/* parameter [31] */
	_u_16_ burst_duration;

	/* parameter [32] */
	_u_16_ gap_duration;

	/* parameter [33] */
	_u_16_ rtd;

	/* parameter [34] */
	_u_16_ esd;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [35] bit(s) <7:0> */
			_u_16_ signal_lvl:8;

			/* parameter [35] bit(s) <15:8> */
			_u_16_ noise_lvl:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_35;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [36] bit(s) <7:0> */
			_u_16_ rerl:8;

			/* parameter [36] bit(s) <15:8> */
			_u_16_ gmin:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_36;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [37] bit(s) <7:0> */
			_u_16_ r_factor:8;

			/* parameter [37] bit(s) <15:8> */
			_u_16_ r_factor_ex:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_37;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [38] bit(s) <7:0> */
			_u_16_ mos_lq:8;

			/* parameter [38] bit(s) <15:8> */
			_u_16_ mos_cq:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_38;

	/* parameter [39] */
	_u_16_ rx_cfg;

	/* parameter [40] */
	_u_16_ jb_nom;

	/* parameter [41] */
	_u_16_ jb_max;

	/* parameter [42] */
	_u_16_ jb_abs_max;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [43] bit(s) <7:0> */
			_u_16_ block_type:8;

			/* parameter [43] bit(s) <15:8> */
			_u_16_ reserved3:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_43;

	/* parameter [44] */
	_u_16_ block_length;

	/*parameters [45:46]*/
	_u_32_ src_ssrc;
	/* parameter [47] */
	_u_16_ begin_seq2;

	/* parameter [48] */
	_u_16_ end_seq2;

	/* parameter [49] */
	_u_16_ maxdiff_jitter;

	/* parameter [50] */
	_u_16_ range_jitter;

	/*parameters [51:52]*/
	_u_32_ sum_jitter;
	/* parameter [53] */
	_u_16_ sum_cycles;

	/* parameter [54] */
	_u_16_ jb_events;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [55] bit(s) <7:0> */
			_u_16_ reserved4:8;

			/* parameter [55] bit(s) <15:8> */
			_u_16_ tdeg_network_hi:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_55;

	/* parameter [56] */
	_u_16_ tdeg_network_lo;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [57] bit(s) <7:0> */
			_u_16_ reserved5:8;

			/* parameter [57] bit(s) <15:8> */
			_u_16_ tdeg_jb_hi:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_57;

	/* parameter [58] */
	_u_16_ tdeg_jb_lo;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [59] bit(s) <7:0> */
			_u_16_ reserved6:8;

			/* parameter [59] bit(s) <15:8> */
			_u_16_ es:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_59;

	/* parameter [60] */
	_u_16_ es1;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [61] bit(s) <7:0> */
			_u_16_ reserved7:8;

			/* parameter [61] bit(s) <15:8> */
			_u_16_ ses:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_61;

	/* parameter [62] */
	_u_16_ ses1;


} ATTRIBUTE_PACKED;

/************************************************************
I:IND_RTCP_XR_METRICS (Function code=0x8A02, class=0x02, type=0x03)
************************************************************/
struct _IND_RTCP_XR_METRICS_IND
{
	/* parameter [4] */
	_u_16_ length;

			/* parameter [4] bit(s)  */
	_u_16_ revision;

	/* parameter [5] */
	_u_16_ recv_blocks;

	/*parameters [6:7]*/
	_u_32_ remote_rtd;
	/*parameters [8:9]*/
	_u_32_ remote_esd;
	/*parameters [10:11]*/
	_u_32_ remote_signal;
	/*parameters [12:13]*/
	_u_32_ remote_noice;
	/*parameters [14:15]*/
	_u_32_ remote_rerl;
	/* parameter [16] */
	_u_16_ sent_blocks;

	/*parameters [17:18]*/
	_u_32_ local_rtd;
	/*parameters [19:20]*/
	_u_32_ local_esd;
	/*parameters [21:22]*/
	_u_32_ local_signal;
	/*parameters [23:24]*/
	_u_32_ local_noice;
	/*parameters [25:26]*/
	_u_32_ local_rerl;
	/* parameter [27] */
	_u_16_ min_rtd;

	/* parameter [28] */
	_u_16_ max_rtd;

	/* parameter [29] */
	_u_16_ min_esd;

	/* parameter [30] */
	_u_16_ max_esd;

	/* parameter [31] */
	_u_16_ local_discards;


} ATTRIBUTE_PACKED;

/************************************************************
CA:RTCPSTATTMR (Function code=0x80FC, class=0x02, type=0x00)
************************************************************/
struct _RTCPSTATTMR
{
	/* parameter [4] */
	_u_16_ interval;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <0> */
			_u_16_ rtcp_basic:1;

			/* parameter [5] bit(s) <1> */
			_u_16_ rtcp_xr:1;

			/* parameter [5] bit(s) <2> */
			_u_16_ rtcp_xrj:1;

			/* parameter [5] bit(s) <3> */
			_u_16_ rtcp_xr_tx:1;

			/* parameter [5] bit(s) <4> */
			_u_16_ rtcp_xrj_tx:1;

			/* parameter [5] bit(s) <5> */
			_u_16_ xr_metrics_summary:1;

			/* parameter [5] bit(s) <15:6> */
			_u_16_ reserved5_bits_15_6:10;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;


} ATTRIBUTE_PACKED;

/************************************************************
CA:PROGRAM_E_MODEL (Function code=0x81EE, class=0x02, type=0x00)
************************************************************/
struct _PROGRAM_E_MODEL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ reset_all:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ override_telr:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ override_int_t:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ override_int_ie:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ override_int_bpl:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ override_int_ppl:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ override_int_burstr:1;

			/* parameter [4] bit(s) <15:7> */
			_u_16_ reserved4_bits_15_7:9;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ index_0;

	/* parameter [6] */
	_u_16_ value_0;

	/* parameter [7] */
	_u_16_ index_1;

	/* parameter [8] */
	_u_16_ value_1;

	/* parameter [9] */
	_u_16_ index_2;

	/* parameter [10] */
	_u_16_ value_2;

	/* parameter [11] */
	_u_16_ index_3;

	/* parameter [12] */
	_u_16_ value_3;

	/* parameter [13] */
	_u_16_ index_4;

	/* parameter [14] */
	_u_16_ value_4;

	/* parameter [15] */
	_u_16_ index_5;

	/* parameter [16] */
	_u_16_ value_5;

	/* parameter [17] */
	_u_16_ index_6;

	/* parameter [18] */
	_u_16_ value_6;

	/* parameter [19] */
	_u_16_ index_7;

	/* parameter [20] */
	_u_16_ value_7;

	/* parameter [21] */
	_u_16_ index_8;

	/* parameter [22] */
	_u_16_ value_8;

	/* parameter [23] */
	_u_16_ index_9;

	/* parameter [24] */
	_u_16_ value_9;

	/* parameter [25] */
	_u_16_ index_10;

	/* parameter [26] */
	_u_16_ value_10;

	/* parameter [27] */
	_u_16_ index_11;

	/* parameter [28] */
	_u_16_ value_11;

	/* parameter [29] */
	_u_16_ index_12;

	/* parameter [30] */
	_u_16_ value_12;

	/* parameter [31] */
	_u_16_ index_13;

	/* parameter [32] */
	_u_16_ value_13;

	/* parameter [33] */
	_u_16_ index_14;

	/* parameter [34] */
	_u_16_ value_14;

	/* parameter [35] */
	_u_16_ index_15;

	/* parameter [36] */
	_u_16_ value_15;

	/* parameter [37] */
	_u_16_ index_16;

	/* parameter [38] */
	_u_16_ value_16;

	/* parameter [39] */
	_u_16_ index_17;

	/* parameter [40] */
	_u_16_ value_17;


} ATTRIBUTE_PACKED;
#endif /* COMCERTO_RTCP_XR_API_H_ */ 

