/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_RTCP_API_H_
#define _COMCERTO_RTCP_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
C:RTCP_ENA (Function code=0x80A0, class=0x02, type=0x00)
************************************************************/
struct _RTCP_ENA
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:9> */
			_u_16_ reserved4_bits_15_11:5;

			/* parameter [4] bit(s) <10> */
			_u_16_ rtcp_rle_report:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ rtcp_receive_pc:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ rtcp_xr_jitter_block:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ rtcp_aggregation:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ rtcp_tx_indication:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ rtcp_rev4:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ rtcp_xr_indication:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ rtcp_xr:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ rtcp_extended:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ rtcp_indication:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ rtcp:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
I:IND_SR (Function code=0x80A5, class=0x02, type=0x03)
************************************************************/
struct _IND_SR_IND
{
	/* parameter [4] */
	_u_16_ info_length;

	/*parameters [5:6]*/
	_u_32_ ntp_h;
	/*parameters [7:8]*/
	_u_32_ ntp_l;
	/*parameters [9:10]*/
	_u_32_ timestamp;
	/*parameters [11:12]*/
	_u_32_ sent_packets;
	/*parameters [13:14]*/
	_u_32_ sent_octet;
	/*parameters [15:16]*/
	_u_32_ ssrc_1;
	/*parameters [17:18]*/
	_u_32_ lost;
	/*parameters [19:20]*/
	_u_32_ hsnr;
	/*parameters [21:22]*/
	_u_32_ jitter;
	/*parameters [23:24]*/
	_u_32_ lsr;
	/*parameters [25:26]*/
	_u_32_ dlsr;
	/* parameter [27] */
	_u_16_ header;

	/* parameter [28] */
	_u_16_ length;

	/*parameters [29:30]*/
	_u_32_ ssrc;

} ATTRIBUTE_PACKED;

/************************************************************
I:IND_RR (Function code=0x80A6, class=0x02, type=0x03)
************************************************************/
struct _IND_RR_IND
{
	/* parameter [4] */
	_u_16_ info_length;

	/*parameters [5:6]*/
	_u_32_ ssrc_1;
	/*parameters [7:8]*/
	_u_32_ lost;
	/*parameters [9:10]*/
	_u_32_ hsnr;
	/*parameters [11:12]*/
	_u_32_ jitter;
	/*parameters [13:14]*/
	_u_32_ lsr;
	/*parameters [15:16]*/
	_u_32_ dlsr;
	/* parameter [17] */
	_u_16_ header;

	/* parameter [18] */
	_u_16_ length;

	/*parameters [19:20]*/
	_u_32_ ssrc;

} ATTRIBUTE_PACKED;

/************************************************************
I:IND_SDES_CNAME (Function code=0x80A7, class=0x02, type=0x03)
************************************************************/
struct _IND_SDES_CNAME_IND
{
	/* parameter [4] */
	_u_16_ length;

	/* parameters [5:$] = sdes_cname:ASCIZ*/
	_u_8_ sdes_cname [246];

} ATTRIBUTE_PACKED;

/************************************************************
I:IND_BYE (Function code=0x80A8, class=0x02, type=0x03)
************************************************************/
struct _IND_BYE_IND
{
	/* parameter [4] */
	_u_16_ length;


	/*parameters [5:$] = reason:OCTETS*/
	_u_8_ reason [246];

} ATTRIBUTE_PACKED;

/************************************************************
I:IND_RTCP_APP (Function code=0x80AA, class=0x02, type=0x03)
************************************************************/
struct _IND_RTCP_APP_IND
{
	/* parameter [4] */
	_u_16_ length;


	/*parameters [5:6] = name:OCTETS*/
	_u_8_ name [4];

	/*parameters [7:$] = data:OCTETS*/
	_u_8_ data [242];

} ATTRIBUTE_PACKED;

/************************************************************
C:SDES_CNAME (Function code=0x80A1, class=0x02, type=0x00)
************************************************************/
struct _SDES_CNAME
{
	/* parameter [4] */
	_u_16_ length;

	/* parameters [5:$] = sdes_cname:ASCIZ*/
	_u_8_ sdes_cname [246];

} ATTRIBUTE_PACKED;

/************************************************************
C:RTCP_APP (Function code=0x80A9, class=0x02, type=0x00)
************************************************************/
struct _RTCP_APP
{
	/* parameter [4] */
	_u_16_ length;


	/*parameters [5:6] = name:OCTETS*/
	_u_8_ name [4];

	/*parameters [7:$] = data:OCTETS*/
	_u_8_ data [242];

} ATTRIBUTE_PACKED;

/************************************************************
C:RTCP_APP_NAME (Function code=0x80A4, class=0x02, type=0x00)
************************************************************/
struct _RTCP_APP_NAME
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:6> */
			_u_16_ reserved4_bits_15_6:10;

			/* parameter [4] bit(s) <5> */
			_u_16_ send_ctrl:1;

			/* parameter [4] bit(s) <4:0> */
			_u_16_ rtcp_app_subtype:5;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ length;


	/*parameters [6:7] = name:OCTETS*/
	_u_8_ name [4];

	/*parameters [8:$] = data:OCTETS*/
	_u_8_ data [240];

} ATTRIBUTE_PACKED;


/************************************************************
C:SET_RTCP_NTP_TIMESTAMP (Function code=0x80AB, class=0x02, type=0x00)
************************************************************/
struct _SET_RTCP_NTP_TIMESTAMP
{
	/*parameters [4:5]*/
	_u_32_ ntp_h;
	/*parameters [6:7]*/
	_u_32_ ntp_l;

} ATTRIBUTE_PACKED;

/************************************************************
C:SET_RTCP_PACKET_GENERATION_GRANULARITY (Function code=0x80AC, class=0x02, type=0x00)
************************************************************/
struct _SET_RTCP_PACKET_GENERATION_GRANULARITY
{
	/* parameter [4] */
	_u_16_ granularity;

	/* parameter [5] */
	_u_16_ disable_variation;


} ATTRIBUTE_PACKED;

/************************************************************
I:RTCP_IND_TX_SR (Function code=0x80F7, class=0x02, type=0x03)
************************************************************/
struct _RTCP_IND_TX_SR_IND
{
	/* parameter [4] */
	_u_16_ info_length;

	/*parameters [5:6]*/
	_u_32_ ntp_h;
	/*parameters [7:8]*/
	_u_32_ ntp_l;
	/*parameters [9:10]*/
	_u_32_ timestamp;
	/*parameters [11:12]*/
	_u_32_ sent_packets;
	/*parameters [13:14]*/
	_u_32_ sent_octet;
	/*parameters [15:16]*/
	_u_32_ ssrc_1;
	/*parameters [17:18]*/
	_u_32_ lost;
	/*parameters [19:20]*/
	_u_32_ hsnr;
	/*parameters [21:22]*/
	_u_32_ jitter;
	/*parameters [23:24]*/
	_u_32_ lsr;
	/*parameters [25:26]*/
	_u_32_ dlsr;
	/* parameter [27] */
	_u_16_ header;

	/* parameter [28] */
	_u_16_ length;

	/*parameters [29:30]*/
	_u_32_ ssrc;

} ATTRIBUTE_PACKED;

/************************************************************
I:RTCP_IND_TX_RR (Function code=0x80F8, class=0x02, type=0x03)
************************************************************/
struct _RTCP_IND_TX_RR_IND
{
	/* parameter [4] */
	_u_16_ info_length;

	/*parameters [5:6]*/
	_u_32_ ssrc_1;
	/*parameters [7:8]*/
	_u_32_ lost;
	/*parameters [9:10]*/
	_u_32_ hsnr;
	/*parameters [11:12]*/
	_u_32_ jitter;
	/*parameters [13:14]*/
	_u_32_ lsr;
	/*parameters [15:16]*/
	_u_32_ dlsr;
	/* parameter [17] */
	_u_16_ header;

	/* parameter [18] */
	_u_16_ length;

	/*parameters [19:20]*/
	_u_32_ ssrc;

} ATTRIBUTE_PACKED;

/************************************************************
I:RTCP_IND_TX_SDES_CNAME (Function code=0x80F9, class=0x02, type=0x03)
************************************************************/
struct _RTCP_IND_TX_SDES_CNAME_IND
{
	/* parameter [4] */
	_u_16_ length;

	/* parameters [5:$] = sdes_cname:ASCIZ*/
	_u_8_ sdes_cname [246];

} ATTRIBUTE_PACKED;

/************************************************************
I:RTCP_IND_TX_BYE (Function code=0x80FA, class=0x02, type=0x03)
************************************************************/
struct _RTCP_IND_TX_BYE_IND
{
	/* parameter [4] */
	_u_16_ length;


	/*parameters [5:$] = reason:OCTETS*/
	_u_8_ reason [246];

} ATTRIBUTE_PACKED;

/************************************************************
I:RTCP_IND_TX_APP (Function code=0x80FB, class=0x02, type=0x03)
************************************************************/
struct _RTCP_IND_TX_APP_IND
{
	/* parameter [4] */
	_u_16_ length;


	/*parameters [5:6] = name:OCTETS*/
	_u_8_ name [4];

	/*parameters [7:$] = data:OCTETS*/
	_u_8_ data [242];

} ATTRIBUTE_PACKED;
#endif /* COMCERTO_RTCP_API_H_ */ 

