/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_RTCP_QOS_API_H_
#define _COMCERTO_RTCP_QOS_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
C:SESSION_BW (Function code=0x80D5, class=0x02, type=0x00)
************************************************************/
struct _SESSION_BW
{
	/* parameter [4] */
	_u_16_ bw;


} ATTRIBUTE_PACKED;

/************************************************************
C:QOS_THRESHOLD (Function code=0x80D3, class=0x02, type=0x00)
************************************************************/
struct _QOS_THRESHOLD
{
	/* parameter [4] */
	_u_16_ qosm;

	/* parameter [5] */
	_u_16_ rtdt_h;

	/* parameter [6] */
	_u_16_ rtdt_l;

	/* parameter [7] */
	_u_16_ jt_h;

	/* parameter [8] */
	_u_16_ jt_l;

	/* parameter [9] */
	_u_16_ plrt_h;

	/* parameter [10] */
	_u_16_ plrt_l;

	/* parameter [11] */
	_u_16_ rtcpt;


} ATTRIBUTE_PACKED;

/************************************************************
I:QOS_ALARM (Function code=0x80D4, class=0x02, type=0x03)
************************************************************/
struct _QOS_ALARM_IND
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:6> */
			_u_16_ reserved4_bits_15_6:10;

			/* parameter [4] bit(s) <5> */
			_u_16_ riaj:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ liaj:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ rplr:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ lplr:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ rtd:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ rtcpt:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ mrtd;

	/* parameter [6] */
	_u_16_ lmplr;

	/* parameter [7] */
	_u_16_ rmplr;

	/* parameter [8] */
	_u_16_ lmiaj;

	/* parameter [9] */
	_u_16_ rmiaj;


} ATTRIBUTE_PACKED;

/************************************************************
I:SET_RTCP_GENERATION_GRANULARITY (Function code=0x80AC, class=0x02, type=0x03)
************************************************************/
struct _SET_RTCP_GENERATION_GRANULARITY_IND
{
	/* parameter [4] */
	_u_16_ gran;

	/* parameter [5] */
	_u_16_ pgicm;


} ATTRIBUTE_PACKED;

#endif /* COMCERTO_RTCP_QOS_API_H_ */ 

