/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_PLAYBACK_API_H_
#define _COMCERTO_PLAYBACK_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
CA:TDM_SET_PLAYBACK_BUFFER (Function code=0x0414, class=0x06, type=0x00)
************************************************************/
struct _TDM_SET_PLAYBACK_BUFFER
{
	/*parameters [4:5]*/
	_u_32_ index;
	/*parameters [6:7]*/
	_u_32_ size;
	/*parameters [8:9]*/
	_u_32_ offset;

	/*parameters [10:$] = data:OCTETS*/
	_u_8_ data [236];

} ATTRIBUTE_PACKED;

/************************************************************
CA:TDMDIAGCTRL (Function code=0x80F0, class=0x02, type=0x00)
************************************************************/
struct _TDMDIAGCTRL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ rx_record:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ tx_record:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ one_round_playback:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ continuous_playback:1;

			/* parameter [4] bit(s) <15:4> */
			_u_16_ reserved4_bits_15_4:12;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ index;


} ATTRIBUTE_PACKED;

#endif /* COMCERTO_PLAYBACK_API_H_ */ 

