/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_MISC_DEVICE_LEVEL_API_H_
#define _COMCERTO_MISC_DEVICE_LEVEL_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
CA:SPU_FEATURES_CONTROL (Function code=0x0013, class=0x06, type=0x00)
************************************************************/
struct _SPU_FEATURES_CONTROL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ ec_feature:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ silence_indications:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ caller_id_detection:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ g_723_vad:1;

			/* parameter [4] bit(s) <4> */
			_u_16_ call_progress_detection:1;

			/* parameter [4] bit(s) <5> */
			_u_16_ dtmf_distortion:1;

			/* parameter [4] bit(s) <6> */
			_u_16_ packet_tone_detection:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ v_18_detection:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ conferencing_agc:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ conferencing_simple_noise_suppression:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ tone_detector:1;

			/* parameter [4] bit(s) <11> */
			_u_16_ ip_side_aec:1;

			/* parameter [4] bit(s) <12> */
			_u_16_ dual_ec:1;

			/* parameter [4] bit(s) <13> */
			_u_16_ tdm_side_aec:1;

			/* parameter [4] bit(s) <14> */
			_u_16_ tdet:1;

			/* parameter [4] bit(s) <15> */
			_u_16_ spufm_gsm_tonegenip:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <0> */
			_u_16_ reserved5_bit_0:1;

			/* parameter [5] bit(s) <1> */
			_u_16_ fsk_to_tdm_complex_codec:1;

			/* parameter [5] bit(s) <6:2> */
			_u_16_ reserved5_bits_6_2:5;

			/* parameter [5] bit(s) <7> */
			_u_16_ v18_ip_detection:1;

			/* parameter [5] bit(s) <15:8> */
			_u_16_ reserved5_bits_15_8:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;


} ATTRIBUTE_PACKED;

/************************************************************
C:LATENCY_LEVEL (Function code=0x0406, class=0x06, type=0x00)
************************************************************/
struct _LATENCY_LEVEL
{
	/* parameter [4] */
	_u_16_ level;

	/* parameter [5] */
	_u_16_ reserved5;

	/* parameter [6] */
	_u_16_ reserved6;


} ATTRIBUTE_PACKED;

/************************************************************
C:CSME_MULTI_CMD (Function code=0x010A, class=0x06, type=0x00)
************************************************************/
struct _CSME_MULTI_CMD
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ multi_command:1;

			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
CA:DEVICE_SET_COUNTRY_CODE (Function code=0x041B, class=0x06, type=0x00)
************************************************************/
struct _DEVICE_SET_COUNTRY_CODE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:0> */
			_u_16_ code:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
CA:CP_SET_COUNTRY_CODE_PARAMS (Function code=0x041C, class=0x06, type=0x00)
************************************************************/
struct _CP_SET_COUNTRY_CODE_PARAMS
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:0> */
			_u_16_ code_index:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:0> */
			_u_16_ tone1_on_low:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:0> */
			_u_16_ tone1_on_high:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:0> */
			_u_16_ tone1_off_low:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:0> */
			_u_16_ tone1_off_high:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [9] bit(s) <15:0> */
			_u_16_ tone2_on_low:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [10] bit(s) <15:0> */
			_u_16_ tone2_on_high:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_10;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [11] bit(s) <15:0> */
			_u_16_ tone2_off_low:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_11;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [12] bit(s) <15:0> */
			_u_16_ tone2_off_high:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_12;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [13] bit(s) <15:0> */
			_u_16_ tone3_on_low:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_13;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [14] bit(s) <15:0> */
			_u_16_ tone3_on_high:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_14;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [15] bit(s) <15:0> */
			_u_16_ tone3_off_low:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_15;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [16] bit(s) <15:0> */
			_u_16_ tone3_off_high:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_16;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [17] bit(s) <15:0> */
			_u_16_ tone4_on_low:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_17;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [18] bit(s) <15:0> */
			_u_16_ tone4_on_high:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_18;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [19] bit(s) <15:0> */
			_u_16_ tone4_off_low:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_19;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [20] bit(s) <15:0> */
			_u_16_ tone4_off_high:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_20;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [21] bit(s) <15:0> */
			_u_16_ filter1_a2:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_21;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [22] bit(s) <15:0> */
			_u_16_ filter1_a1:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_22;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [23] bit(s) <15:0> */
			_u_16_ filter1_a0:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_23;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [24] bit(s) <15:0> */
			_u_16_ reserved24_bits_15_0:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_24;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [25] bit(s) <15:0> */
			_u_16_ filter1_b2:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_25;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [26] bit(s) <15:0> */
			_u_16_ filter1_b1:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_26;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [27] bit(s) <15:0> */
			_u_16_ filter2_a2:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_27;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [28] bit(s) <15:0> */
			_u_16_ filter2_a1:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_28;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [29] bit(s) <15:0> */
			_u_16_ filter2_a0:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_29;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [30] bit(s) <15:0> */
			_u_16_ reserved30_bits_15_0:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_30;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [31] bit(s) <15:0> */
			_u_16_ filter2_b2:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_31;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [32] bit(s) <15:0> */
			_u_16_ filter2_b1:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_32;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [33] bit(s) <15:0> */
			_u_16_ filter3_a2:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_33;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [34] bit(s) <15:0> */
			_u_16_ filter3_a1:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_34;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [35] bit(s) <15:0> */
			_u_16_ filter3_a0:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_35;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [36] bit(s) <15:0> */
			_u_16_ reserved36_bits_15_0:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_36;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [37] bit(s) <15:0> */
			_u_16_ filter3_b2:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_37;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [38] bit(s) <15:0> */
			_u_16_ filter3_b1:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_38;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [39] bit(s) <15:0> */
			_u_16_ thresh_l:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_39;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [40] bit(s) <15:0> */
			_u_16_ thresh_h:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_40;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [41] bit(s) <15:0> */
			_u_16_ alpha:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_41;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [42] bit(s) <15:0> */
			_u_16_ dropout:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_42;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [43] bit(s) <15:0> */
			_u_16_ cp_nrg_most_mult:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_43;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [44] bit(s) <15:0> */
			_u_16_ nbd_a2:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_44;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [45] bit(s) <15:0> */
			_u_16_ nbd_a1:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_45;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [46] bit(s) <15:0> */
			_u_16_ nbd_a0:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_46;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [47] bit(s) <15:0> */
			_u_16_ reserved47_bits_15_0:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_47;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [48] bit(s) <15:0> */
			_u_16_ nbd_b2:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_48;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [49] bit(s) <15:0> */
			_u_16_ nbd_b1:16;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_49;


} ATTRIBUTE_PACKED;
#endif /* COMCERTO_MISC_DEVICE_LEVEL_API_H_ */ 


