/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_IPV6_API_H_
#define _COMCERTO_IPV6_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
C:IP_ADDRESS_v6 (Function code=0x0310, class=0x06, type=0x00)
************************************************************/
struct _IP_ADDRESS_V6
{

	/*parameters [4:11] = ipv6_addr:OCTETS*/
	_u_8_ ipv6_addr [16];

} ATTRIBUTE_PACKED;

/************************************************************
C:SET_CHANNEL_IP_MODE (Function code=0x9003, class=0x02, type=0x00)
************************************************************/
struct _SET_CHANNEL_IP_MODE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ ip_version:1;

			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
C:SET_IPv6_HDR_CHANNEL (Function code=0x9000, class=0x02, type=0x00)
************************************************************/
struct _SET_IPV6_HDR_CHANNEL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <7:0> */
			_u_16_ serviceid:8;

			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <3:0> */
			_u_16_ tc_bits_0_3:4;

			/* parameter [5] bit(s) <7:4> */
			_u_16_ ip_v:4;

			/* parameter [5] bit(s) <11:8> */
			_u_16_ fl_bits_0_3:4;

			/* parameter [5] bit(s) <15:12> */
			_u_16_ tc_bits_4_7:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <7:0> */
			_u_16_ fl_bits_4_11:8;

			/* parameter [6] bit(s) <15:8> */
			_u_16_ fl_bits_12_19:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	/* parameter [7] */
	_u_16_ payload_len;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <7:0> */
			_u_16_ next_header_id:8;

			/* parameter [8] bit(s) <15:8> */
			_u_16_ hop_limit:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;

	/* parameter [9] */
	_u_16_ ipv6_src_15_0;

	/* parameter [10] */
	_u_16_ ipv6_src_31_16;

	/* parameter [11] */
	_u_16_ ipv6_src_47_32;

	/* parameter [12] */
	_u_16_ ipv6_src_63_48;

	/* parameter [13] */
	_u_16_ ipv6_src_79_64;

	/* parameter [14] */
	_u_16_ ipv6_src_95_80;

	/* parameter [15] */
	_u_16_ ipv6_src_111_96;

	/* parameter [16] */
	_u_16_ ipv6_src_127_112;

	/* parameter [17] */
	_u_16_ ipv6_dst_15_0;

	/* parameter [18] */
	_u_16_ ipv6_dst_31_16;

	/* parameter [19] */
	_u_16_ ipv6_dst_47_32;

	/* parameter [20] */
	_u_16_ ipv6_dst_63_48;

	/* parameter [21] */
	_u_16_ ipv6_dst_79_64;

	/* parameter [22] */
	_u_16_ ipv6_dst_95_80;

	/* parameter [23] */
	_u_16_ ipv6_dst_111_96;

	/* parameter [24] */
	_u_16_ ipv6_dst_127_112;

	/* parameter [25] */
	_u_16_ uh_sport;

	/* parameter [26] */
	_u_16_ uh_dport;

	/* parameter [27] */
	_u_16_ uh_ulen;

	/* parameter [28] */
	_u_16_ uh_sum;


} ATTRIBUTE_PACKED;


#endif /* COMCERTO_IPV6_API_H_ */ 
