/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_IP_DEVICE_LEVEL_API_H_
#define _COMCERTO_IP_DEVICE_LEVEL_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
QR:IP_STATISTICS (class=0x05, type=0x20)
************************************************************/
struct _IP_STATISTICS
{
	/*parameters [4:5]*/
	_u_32_ format;
	/*parameters [6:7]*/
	_u_32_ emitted_frames;
	/*parameters [8:9]*/
	_u_32_ received_frames;
	/*parameters [10:11]*/
	_u_32_ unknown_ip;
	/*parameters [12:13]*/
	_u_32_ unknown_protocol;
	/*parameters [14:15]*/
	_u_32_ fragmented_packets;
	/*parameters [16:17]*/
	_u_32_ unknown_port;
	/*parameters [18:19]*/
	_u_32_ bad_ip_checksum;
	/*parameters [20:21]*/
	_u_32_ bad_udp_checksum;

} ATTRIBUTE_PACKED;

/************************************************************
QR:ICMP_STATISTICS (class=0x05, type=0x21)
************************************************************/
struct _ICMP_STATISTICS
{
	/*parameters [4:5]*/
	_u_32_ format;
	/*parameters [6:7]*/
	_u_32_ emitted_echo_replies;
	/*parameters [8:9]*/
	_u_32_ emitted_dest_unreachable;
	/*parameters [10:11]*/
	_u_32_ received_echo_requests;
	/*parameters [12:13]*/
	_u_32_ received_dest_unreachable;
	/*parameters [14:15]*/
	_u_32_ bad_icmp_checksum;

} ATTRIBUTE_PACKED;

/************************************************************
C:SET_IP_HDR_CHANNEL (Function code=0x9000, class=0x02, type=0x00)
************************************************************/
struct _SET_IP_HDR_CHANNEL
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:14> */
			_u_16_ reserved4_bits_15_14:2;

			/* parameter [4] bit(s) <13:12> */
			_u_16_ checksum_inc_data:2;

			/* parameter [4] bit(s) <11> */
			_u_16_ reserved_bit_11:1;

			/* parameter [4] bit(s) <10> */
			_u_16_ media_sub_layer:1;

			/* parameter [4] bit(s) <9> */
			_u_16_ reserved_bit_9:1;

			/* parameter [4] bit(s) <8> */
			_u_16_ checksum:1;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ serviceid:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:8> */
			_u_16_ ip_tos:8;

			/* parameter [5] bit(s) <7:4> */
			_u_16_ ip_v:4;

			/* parameter [5] bit(s) <3:0> */
			_u_16_ ip_hl:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	/* parameter [6] */
	_u_16_ ip_len;

	/* parameter [7] */
	_u_16_ ip_id;

	/* parameter [8] */
	_u_16_ ip_off;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [9] bit(s) <15:8> */
			_u_16_ ip_p:8;

			/* parameter [9] bit(s) <7:0> */
			_u_16_ ip_ttl:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;

	/* parameter [10] */
	_u_16_ ip_sum;

	/*parameters [11:12]*/
	_u_32_ ip_src;
	/*parameters [13:14]*/
	_u_32_ ip_dst;
	/* parameter [15] */
	_u_16_ uh_sport;

	/* parameter [16] */
	_u_16_ uh_dport;

	/* parameter [17] */
	_u_16_ uh_ulen;

	/* parameter [18] */
	_u_16_ uh_sum;


} ATTRIBUTE_PACKED;

/************************************************************
C:SET_UDP_HDR_ALT (Function code=0x9006, class=0x02, type=0x00)
************************************************************/
struct _SET_UDP_HDR_ALT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ client_id:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ src_port;

	/* parameter [6] */
	_u_16_ dst_port;


} ATTRIBUTE_PACKED;

/************************************************************
C:IP_SERVICE_CONFIG (Function code=0x0302, class=0x06, type=0x00)
************************************************************/
struct _IP_SERVICE_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:10> */
			_u_16_ reserved4_bits_15_10:6;

			/* parameter [4] bit(s) <9:8> */
			_u_16_ encapsulation:2;

			/* parameter [4] bit(s) <7:1> */
			_u_16_ reserved4_bits_7_1:7;

			/* parameter [4] bit(s) <0> */
			_u_16_ checksum_verify:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
C:IP_ADDRESS (Function code=0x0303, class=0x06, type=0x00)
************************************************************/
struct _IP_ADDRESS
{
	/*parameters [4:5]*/
	_u_32_ address;

} ATTRIBUTE_PACKED;

/************************************************************
CAQR:ICMP_SERVICE_CONFIG (Function code=0x0304, class=0x06, type=0x00)
************************************************************/
struct _ICMP_SERVICE_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ ttl:8;

			/* parameter [4] bit(s) <7:4> */
			_u_16_ reserved4_bits_7_4:4;

			/* parameter [4] bit(s) <3> */
			_u_16_ icmp_echo_reply_report:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ destination_unreachable_report:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ destination_unreachable_generation:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ icmp_echo_reply_generation:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
CAQR:IP_OPTIONS (Function code=0x0306, class=0x06, type=0x00)
************************************************************/
struct _IP_OPTIONS
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:5> */
			_u_16_ reserved4_bits_15_5:11;

			/* parameter [4] bit(s) <4> */
			_u_16_ unlimited_src_ip:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ notify_src_ip_changed:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ notify_src_udp_changed:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ verify_src_ip:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ verify_src_udp:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
C:IP_OPTIONS_CHANNEL (Function code=0x9090, class=0x02, type=0x00)
************************************************************/
struct _IP_OPTIONS_CHAN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:9> */
			_u_16_ reserved4_bits_15_9:7;

			/* parameter [4] bit(s) <8> */
			_u_16_ src_hdr_change:1;

			/* parameter [4] bit(s) <7> */
			_u_16_ reserved4_bits_7:1;

			/* parameter [4] bit(s) <6:5> */
			_u_16_ client_monitoring:2;

			/* parameter [4] bit(s) <4> */
			_u_16_ setting_level:1;

			/* parameter [4] bit(s) <3> */
			_u_16_ notify_src_ip_changed:1;

			/* parameter [4] bit(s) <2> */
			_u_16_ notify_src_udp_changed:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ verify_src_ip:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ verify_src_udp:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	_u_32_ rx_flow_filter_ip;

	_u_16_ rx_flow_filter_udp;

} ATTRIBUTE_PACKED;


#endif /* COMCERTO_IP_DEVICE_LEVEL_API_H_ */ 

