/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_FLOW_CONTROL_API_H_
#define _COMCERTO_FLOW_CONTROL_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
CA:SYNCDAT (Function code=0x9402, class=0x02, type=0x00)
************************************************************/
struct _SYNCDAT
{

	/*parameters [4:$] = data:OCTETS*/
	_u_8_ data [248];

} ATTRIBUTE_PACKED;

/************************************************************
I:SYNCDAT (Function code=0x9402, class=0x02, type=0x03)
************************************************************/
struct _SYNCDAT_IND
{

	/*parameters [4:$] = data:OCTETS*/
	_u_8_ data [248];

} ATTRIBUTE_PACKED;

/************************************************************
CA:SYNCEOF (Function code=0x9403, class=0x02, type=0x00)
************************************************************/
struct _SYNCEOF
{

	/*parameters [4:$] = data:OCTETS*/
	_u_8_ data [248];

} ATTRIBUTE_PACKED;

/************************************************************
I:SYNCEOF (Function code=0x9403, class=0x02, type=0x03)
************************************************************/
struct _SYNCEOF_IND
{

	/*parameters [4:$] = data:OCTETS*/
	_u_8_ data [248];

} ATTRIBUTE_PACKED;

/************************************************************
CA:SET_FLOWCON (Function code=0x9404, class=0x02, type=0x00)
************************************************************/
struct _SET_FLOWCON
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ flow_control:1;

			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
IA:SYNCDAT (Function code=0x9402, class=0x02, type=0x05)
************************************************************/
struct _SYNCDAT_IND_RESP
{
	/* parameter [4] */
	_u_16_ result;


} ATTRIBUTE_PACKED;

/************************************************************
IA:SYNCEOF (Function code=0x9403, class=0x02, type=0x05)
************************************************************/
struct _SYNCEOF_IND_RESP
{
	/* parameter [4] */
	_u_16_ result;


} ATTRIBUTE_PACKED;

#endif /* COMCERTO_FLOW_CONTROL_API_H_ */ 

