/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_ETHERNET_INTERFACE_API_H_
#define _COMCERTO_ETHERNET_INTERFACE_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
QR:ETH_STATISTICS (class=0x05, type=0x00)
************************************************************/
struct _ETH_STATISTICS
{
	/*parameters [4:5]*/
	_u_32_ revision;
	/*parameters [6:7]*/
	_u_32_ emitted_frames;
	/*parameters [8:9]*/
	_u_32_ received_frames;
	/*parameters [10:11]*/
	_u_32_ unknown_packet_type_frames;
	/*parameters [12:13]*/
	_u_32_ received_broadcast_frames;
	/*parameters [14:15]*/
	_u_32_ unknown_broadcast_frames;
	/*parameters [16:17]*/
	_u_32_ emitted_vlan_frames;
	/*parameters [18:19]*/
	_u_32_ received_vlan_frames;
	/*parameters [20:21]*/
	_u_32_ received_vlan_e_rif_frames;

} ATTRIBUTE_PACKED;

/************************************************************
QR:ARP_STATISTICS (class=0x05, type=0x01)
************************************************************/
struct _ARP_STATISTICS
{
	/*parameters [4:5]*/
	_u_32_ revision;
	/*parameters [6:7]*/
	_u_32_ received_arp_packets;
	/*parameters [8:9]*/
	_u_32_ emitted_arp_packets;
	/*parameters [10:11]*/
	_u_32_ recieved_arp_request_packets;
	/*parameters [12:13]*/
	_u_32_ emitted_arp_response_packets;
	/*parameters [14:15]*/
	_u_32_ received_frames_dropped;

} ATTRIBUTE_PACKED;

/************************************************************
QR:EMAC_STATS (class=0x05, type=0x30)
************************************************************/
struct _EMAC_STATS
{
	/*parameters [4:5]*/
	_u_32_ revision;
	/*parameters [6:7]*/
	_u_32_ rx_packets;
	/*parameters [8:9]*/
	_u_32_ tx_packets;
	/*parameters [10:11]*/
	_u_32_ rx_bytes;
	/*parameters [12:13]*/
	_u_32_ tx_bytes;
	/*parameters [14:15]*/
	_u_32_ rx_errors;
	/*parameters [16:17]*/
	_u_32_ tx_errors;
	/*parameters [18:19]*/
	_u_32_ rx_dropped;
	/*parameters [20:21]*/
	_u_32_ tx_dropped;
	/*parameters [22:23]*/
	_u_32_ collisions;
	/*parameters [24:25]*/
	_u_32_ rx_multicast;
	/*parameters [26:27]*/
	_u_32_ tx_multicast;
	/*parameters [28:29]*/
	_u_32_ rx_len_errors;
	/*parameters [30:31]*/
	_u_32_ rx_crc_errors;
	/*parameters [32:33]*/
	_u_32_ rx_overflow_errors;
	/*parameters [34:35]*/
	_u_32_ rx_long_packet_errors;
	/*parameters [36:37]*/
	_u_32_ rx_align_errors;
	/*parameters [38:39]*/
	_u_32_ rx_parity_errors;
	/*parameters [40:41]*/
	_u_32_ tx_parity_errors;
	/*parameters [42:43]*/
	_u_32_ tx_sys_underruns;
	/*parameters [44:45]*/
	_u_32_ tx_excessive_collisions;
	/*parameters [46:47]*/
	_u_32_ tx_late_collision_errors;
	/*parameters [48:49]*/
	_u_32_ tx_excessive_deferral;
	/*parameters [50:51]*/
	_u_32_ tx_signal_quality_errors;
	/*parameters [52:53]*/
	_u_32_ tx_pause_and_unpause;
	/*parameters [54:55]*/
	_u_32_ rx_pause;

} ATTRIBUTE_PACKED;

/************************************************************
C:SET_ETH_HDR (Function code=0x0100, class=0x06, type=0x00)
************************************************************/
struct _SET_ETH_HDR
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ action:1;

			/* parameter [4] bit(s) <14:8> */
			_u_16_ reserved4_bits_14_8:7;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ protocol:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:7] = hostmac:EUI48*/
	_u_16_ hostmac[3];
	/*parameters [8:10] = assignedmac:EUI48*/
	_u_16_ assignedmac[3];
	/* parameter [11] */
	_u_16_ type;

	/* parameter [12] */
	_u_16_ tci_1;

	/* parameter [13] */
	_u_16_ type_1;

	/* parameter [14] */
	_u_16_ tci_2;

	/* parameter [15] */
	_u_16_ type_2;

	/* parameter [16] */
	_u_16_ assignedtype;


} ATTRIBUTE_PACKED;

/************************************************************
C:SET_ETH_HDR_GENERIC (Function code=0x0100, class=0x06, type=0x00)
************************************************************/
struct _SET_ETH_HDR_GENERIC
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ action:1;

			/* parameter [4] bit(s) <14:8> */
			_u_16_ reserved4_bits_14_8:7;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ protocol:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:7] = hostmac:EUI48*/
	_u_16_ hostmac[3];

	/*parameters [8:10] = assignedmac:EUI48*/
	_u_16_ assignedmac[3];

	/*parameters [11:251]*/
	_u_16_ eth_options[240];

} ATTRIBUTE_PACKED;

/************************************************************
C:SET_ETH_VLAN_TABLE (Function code=0x0110, class=0x06, type=0x00)
************************************************************/
struct _SET_ETH_VLAN_TABLE
{
	/* parameter [4] */
	_u_16_ vid_1;

	/* parameter [5] */
	_u_16_ vid_2;

	/* parameter [6] */
	_u_16_ vid_3;

	/* parameter [7] */
	_u_16_ vid_4;

	/* parameter [8] */
	_u_16_ vid_5;

	/* parameter [9] */
	_u_16_ vid_6;

	/* parameter [10] */
	_u_16_ vid_7;

	/* parameter [11] */
	_u_16_ vid_8;

	/* parameter [12] */
	_u_16_ vid_9;

	/* parameter [13] */
	_u_16_ vid_10;

	/* parameter [14] */
	_u_16_ vid_11;

	/* parameter [15] */
	_u_16_ vid_12;

	/* parameter [16] */
	_u_16_ vid_13;

	/* parameter [17] */
	_u_16_ vid_14;

	/* parameter [18] */
	_u_16_ vid_15;

	/* parameter [19] */
	_u_16_ vid_16;


} ATTRIBUTE_PACKED;

/************************************************************
C:SET_ETH_DSA_ENA (Function code=0x0140, class=0x06, type=0x00)
************************************************************/
struct _SET_ETH_DSA_ENA
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:3> */
			_u_16_ reserved4_bits_15_3:13;

			/* parameter [4] bit(s) <2> */
			_u_16_ dsa_tag_length:1;

			/* parameter [4] bit(s) <1> */
			_u_16_ dsa_tag_mode:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ dsa_tag_enable:1;
			
		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
C:ETH_FLOW_CONTROL_CONFIG (Function code=0x011D, class=0x06, type=0x00)
************************************************************/
struct _ETH_FLOW_CONTROL_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ gemac_id:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ flow_ctrl:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ pause_time;

	/* parameter [6] */
	_u_16_ upper_threshold;

	/* parameter [7] */
	_u_16_ lower_threshold;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15:2> */
			_u_16_ reserved8_bits_15_2:14;

			/* parameter [8] bit(s) <1> */
			_u_16_ unpause_indic:1;

			/* parameter [8] bit(s) <0> */
			_u_16_ pause_indic:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;


} ATTRIBUTE_PACKED;

/************************************************************
CAQR:SET_RTO (Function code=0x0103, class=0x06, type=0x00)
************************************************************/
struct _SET_RTO
{
	/* parameter [4] */
	_u_16_ opcode;

	/* parameter [5] */
	_u_16_ timeout;


} ATTRIBUTE_PACKED;

/************************************************************
CAQR:ETH_SERVICE_CONFIG (Function code=0x0104, class=0x06, type=0x00)
************************************************************/
struct _ETH_SERVICE_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:5> */
			_u_16_ reserved4_bits_15_5:11;

			/* parameter [4] bit(s) <4:2> */
			_u_16_ transport:3;

			/* parameter [4] bit(s) <1:0> */
			_u_16_ dispatching:2;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:4> */
			_u_16_ reserved5_bits_15_4:12;

			/* parameter [5] bit(s) <3:0> */
			_u_16_ gps_clock_sync:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;


} ATTRIBUTE_PACKED;

/************************************************************
CAQR:ARP_SERVICE_CONFIG (Function code=0x0105, class=0x06, type=0x00)
************************************************************/
struct _ARP_SERVICE_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ arp_reply:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
CA:SELECT_MII_MODE (Function code=0x010E, class=0x06, type=0x00)
************************************************************/
struct _SELECT_MII_MODE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ Mode:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
C:SET_ETH_HDR_CHAN (Function code=0x9010, class=0x02, type=0x00)
************************************************************/
struct _SET_ETH_HDR_CHAN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ action:1;

			/* parameter [4] bit(s) <14:8> */
			_u_16_ reserved4_bits_14_8:7;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ protocol:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:7] = hostmac:EUI48*/
	_u_16_ hostmac[3];
	/*parameters [8:10] = assignedmac:EUI48*/
	_u_16_ assignedmac[3];
	/* parameter [11] */
	_u_16_ type;

	/* parameter [12] */
	_u_16_ tci_1;

	/* parameter [13] */
	_u_16_ type_1;

	/* parameter [14] */
	_u_16_ tci_2;

	/* parameter [15] */
	_u_16_ type_2;

	/* parameter [16] */
	_u_16_ assignedtype;


} ATTRIBUTE_PACKED;

/************************************************************
CAQR:EMAC_Select (Function code=0x011B, class=0x06, type=0x00)
************************************************************/
struct _EMAC_SELECT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ emac_id:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
CAQR:EMAC_Active_Port (Function code=0x011C, class=0x06, type=0x00)
************************************************************/
struct _EMAC_ACTIVE_PORT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:1> */
			_u_16_ reserved4_bits_15_1:15;

			/* parameter [4] bit(s) <0> */
			_u_16_ emac_id:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
C:SELECT_MAC_TRANSMISSION_PARAMETERS (Function code=0x0123, class=0x06, type=0x00)
************************************************************/
struct _SELECT_MAC_TRANSMISSION_PARAMETERS
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ gemac_id:8;

			/* parameter [4] bit(s) <7:3> */
			_u_16_ reserved4_bits_7_3:5;

			/* parameter [4] bit(s) <2:1> */
			_u_16_ speed:2;

			/* parameter [4] bit(s) <0> */
			_u_16_ duplex_mode:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
C:ETH_SWITCH_CONFIG (Function code=0x0121, class=0x06, type=0x00)
************************************************************/
struct _ETH_SWITCH_CONFIG
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ gemac_id:8;

			/* parameter [4] bit(s) <7:1> */
			_u_16_ reserved4_bits_7_1:7;

			/* parameter [4] bit(s) <0> */
			_u_16_ frame_switching:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;


/************************************************************
C:ETH_SWITCH_RULE (Function code=0x0122, class=0x06, type=0x00)
************************************************************/
struct _ETH_SWITCH_RULE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ gemac_id:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ action:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:7] = dst_mac:EUI48*/
	_u_16_ dst_mac[3];
	/* parameter [8] */
	_u_16_ eth_type_1;

	/* parameter [9] */
	_u_16_ vlan_1;

	/* parameter [10] */
	_u_16_ eth_type_2;

	/* parameter [11] */
	_u_16_ vlan_2;


} ATTRIBUTE_PACKED;

/************************************************************
C:SET_MAC_ADDR_PROMISCUOUS_MODE (Function code=0x0114, class=0x06, type=0x00)
************************************************************/
struct _SET_MAC_ADDR_PROMISCUOUS_MODE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:2> */
			_u_16_ reserved4_bits_15_2:14;

			/* parameter [4] bit(s) <1> */
			_u_16_ processing_mode:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ promiscuous_mode:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
C:SET_MULTICAST_ETH_ADDR (Function code=0x0111, class=0x06, type=0x00)
************************************************************/
struct _SET_MULTICAST_ETH_ADDR
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15> */
			_u_16_ action:1;

			/* parameter [4] bit(s) <14:0> */
			_u_16_ reserved4_bits_14_0:15;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/*parameters [5:7] = mac:EUI48*/
	_u_16_ mac[3];

} ATTRIBUTE_PACKED;

/************************************************************
CA:LAG_SERVICE_CFG (Function code=0x0503, class=0x06, type=0x00)
************************************************************/
struct _LAG_SERVICE_CFG
{
	/* parameter [4] */
	_u_16_ system_priority;

	/* parameter [5] */
	_u_16_ distr_algr;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:2> */
			_u_16_ reserved6_bits_15_2:14;

			/* parameter [6] bit(s) <1> */
			_u_16_ port0_lacp_timeout:1;

			/* parameter [6] bit(s) <0> */
			_u_16_ port0_lacp_activity:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <15:2> */
			_u_16_ reserved7_bits_15_2:14;

			/* parameter [7] bit(s) <1> */
			_u_16_ port1_lacp_timeout:1;

			/* parameter [7] bit(s) <0> */
			_u_16_ port1_lacp_activity:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <15> */
			_u_16_ lnk_check:1;

			/* parameter [8] bit(s) <14:13> */
			_u_16_ reserved8_bits_14_13:2;

			/* parameter [8] bit(s) <12:8> */
			_u_16_ emac0_mdio_bus:5;

			/* parameter [8] bit(s) <7:5> */
			_u_16_ reserved8_bits_7_5:3;

			/* parameter [8] bit(s) <4:0> */
			_u_16_ emac0_mdio_phy:5;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [9] bit(s) <15:13> */
			_u_16_ reserved9_bits_15_13:3;

			/* parameter [9] bit(s) <12:8> */
			_u_16_ emac1_mdio_bus:5;

			/* parameter [9] bit(s) <7:5> */
			_u_16_ reserved9_bits_7_5:3;

			/* parameter [9] bit(s) <4:0> */
			_u_16_ emac1_mdio_phy:5;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_9;


} ATTRIBUTE_PACKED;

/************************************************************
CA:LAG_START (Function code=0x0504, class=0x06, type=0x00)
************************************************************/
struct _LAG_START
{
	/* parameter [4] */
	_u_16_ lag;


} ATTRIBUTE_PACKED;

#endif /* COMCERTO_ETHERNET_INTERFACE_API_H_ */ 

