/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifdef _HOST_BIG_ENDIAN_
#include "comcerto-ethernet-interface-types_be.h"
#else
#include "comcerto-ethernet-interface-types_le.h"
#endif

/* Definitions associated to SET_ETH_HDR */
#define SET_ETH_HDR_ACTION_REGISTER 0x0
#define SET_ETH_HDR_ACTION_DEREGISTER 0x1
#define SET_ETH_HDR_PROTOCOL_CONTROL 0x0
#define SET_ETH_HDR_PROTOCOL_IP 0x1
#define SET_ETH_HDR_PROTOCOL_NONIP 0x2
#define SET_ETH_HDR_PROTOCOL_ATMOE 0x3
#define SET_ETH_HDR_PROTOCOL_OPENDIAGNOSTICS 0x4
#define SET_ETH_HDR_PROTOCOL_MEDIA 0x5
#define SET_ETH_HDR_PROTOCOL_IP_V6 0x6
#define SET_ETH_HDR_PROTOCOL_TRFOOE 0x7
#define SET_ETH_HDR_PROTOCOL_PPPOE 0x8

/* Definitions associated to ETH_FLOW_CONTROL_CONFIG */
#define ETH_FLOW_CONTROL_CONFIG_FLOW_CTRL_DISABLE 0x0
#define ETH_FLOW_CONTROL_CONFIG_FLOW_CTRL_ENABLE 0x1
#define ETH_FLOW_CONTROL_CONFIG_FLOW_CTRL_DEFAULT 0x0

#define ETH_FLOW_CONTROL_CONFIG_UNPAUSE_INDIC_DISABLE 0x0
#define ETH_FLOW_CONTROL_CONFIG_UNPAUSE_INDIC_ENABLE 0x1
#define ETH_FLOW_CONTROL_CONFIG_UNPAUSE_INDIC_DEFAULT 0x0

#define ETH_FLOW_CONTROL_CONFIG_PAUSE_INDIC_DISABLE 0x0
#define ETH_FLOW_CONTROL_CONFIG_PAUSE_INDIC_ENABLE 0x1
#define ETH_FLOW_CONTROL_CONFIG_PAUSE_INDIC_DEFAULT 0x0

/* Definitions associated to SET_RTO */
#define SET_RTO_OPCODE_NOOP 0x0
#define SET_RTO_OPCODE_CONTROL 0x1
#define SET_RTO_TIMEOUT_DEFAULT 0x64

/* Definitions associated to ETH_SERVICE_CONFIG */
#define ETH_SERVICE_CONFIG_TRANSPORT_ETHERNET 0x0
#define ETH_SERVICE_CONFIG_TRANSPORT_POS 0x1
#define ETH_SERVICE_CONFIG_TRANSPORT_AAL5 0x2
#define ETH_SERVICE_CONFIG_TRANSPORT_DEFAULT 0x0

#define ETH_SERVICE_CONFIG_DISPATCHING_PACKET_TYPE 0x0
#define ETH_SERVICE_CONFIG_DISPATCHING_VLAN_ENCAPSULATION 0x2
#define ETH_SERVICE_CONFIG_GPS_CLOCK_SYNC_DISABLED 0x0
#define ETH_SERVICE_CONFIG_GPS_CLOCK_SYNC_GPIO_1 0x1

/* Definitions associated to ARP_SERVICE_CONFIG */
#define ARP_SERVICE_CONFIG_ARP_REPLY_DISABLE 0x0
#define ARP_SERVICE_CONFIG_ARP_REPLY_ENABLE 0x1
#define ARP_SERVICE_CONFIG_ARP_REPLY_DEFAULT 0x0

/* Definitions associated to SELECT_MII_MODE */
#define SELECT_MII_MODE_MODE_RMII_SMII 0x0
#define SELECT_MII_MODE_MODE_MII 0x1
#define SELECT_MII_MODE_MODE_DEFAULT 0x0

/* Definitions associated to SET_ETH_HDR_CHAN */
#define SET_ETH_HDR_CHAN_ACTION_REGISTER 0x0
#define SET_ETH_HDR_CHAN_ACTION_DEREGISTER 0x1
#define SET_ETH_HDR_CHAN_PROTOCOL_IP 0x1
#define SET_ETH_HDR_CHAN_PROTOCOL_PPPOE 0x8

/* Definitions associated to EMAC_SELECT */
#define EMAC_SELECT_EMAC_ID_DEFAULT 0x0

/* Definitions associated to EMAC_ACTIVE_PORT */
#define EMAC_ACTIVE_PORT_EMAC_ID_DEFAULT 0x0

/* Definitions associated to SELECT_MAC_TRANSMISSION_PARAMETERS */
#define SELECT_MAC_TRANSMISSION_PARAMETERS_GEMAC_ID_GEMAC_0 0x0
#define SELECT_MAC_TRANSMISSION_PARAMETERS_GEMAC_ID_GEMAC_1 0x1
#define SELECT_MAC_TRANSMISSION_PARAMETERS_SPEED_MBPS_10 0x0
#define SELECT_MAC_TRANSMISSION_PARAMETERS_SPEED_MBPS_100 0x1
#define SELECT_MAC_TRANSMISSION_PARAMETERS_SPEED_MBPS_1000 0x2
#define SELECT_MAC_TRANSMISSION_PARAMETERS_DUPLEX_MODE_HALF 0x0
#define SELECT_MAC_TRANSMISSION_PARAMETERS_DUPLEX_MODE_FULL 0x1

/* Definitions associated to ETH_SWITCH_CONFIG */
#define ETH_SWITCH_CONFIG_GEMAC_ID_GEMAC_0 0x0
#define ETH_SWITCH_CONFIG_GEMAC_ID_GEMAC_1 0x1
#define ETH_SWITCH_CONFIG_FRAME_SWITCHING_DISABLE 0x0
#define ETH_SWITCH_CONFIG_FRAME_SWITCHING_ENABLE 0x1
#define ETH_SWITCH_CONFIG_FRAME_SWITCHING_DEFAULT 0x0

/* Definitions associated to ETH_SWITCH_RULE */
#define ETH_SWITCH_RULE_GEMAC_ID_GEMAC_0 0x0
#define ETH_SWITCH_RULE_GEMAC_ID_GEMAC_1 0x1
#define ETH_SWITCH_RULE_ACTION_DISABLE 0x0
#define ETH_SWITCH_RULE_ACTION_FORWARD 0x1
#define ETH_SWITCH_RULE_ACTION_PROCESS_FORWARD 0x2
#define ETH_SWITCH_RULE_ACTION_DISCARD 0x3

/* Definitions associated to SET_MAC_ADDR_PROMISCUOUS_MODE */
#define SET_MAC_ADDR_PROMISCUOUS_MODE_PROCESSING_MODE_MSP 0x0
#define SET_MAC_ADDR_PROMISCUOUS_MODE_PROCESSING_MODE_MSP_CSP 0x1
#define SET_MAC_ADDR_PROMISCUOUS_MODE_PROCESSING_MODE_DEFAULT 0x0

#define SET_MAC_ADDR_PROMISCUOUS_MODE_PROMISCUOUS_MODE_DISABLE 0x0
#define SET_MAC_ADDR_PROMISCUOUS_MODE_PROMISCUOUS_MODE_ENABLE 0x1
#define SET_MAC_ADDR_PROMISCUOUS_MODE_PROMISCUOUS_MODE_DEFAULT 0x0

/* Definitions associated to SET_MULTICAST_ETH_ADDR */
#define SET_MULTICAST_ETH_ADDR_ACTION_ADD 0x0
#define SET_MULTICAST_ETH_ADDR_ACTION_REMOVE 0x1

/* Definitions associated to LAG_SERVICE_CFG */
#define LAG_SERVICE_CFG_DISTR_ALGR_MAC_ADDR 0x0
#define LAG_SERVICE_CFG_DISTR_ALGR_IP_ADDR 0x1
#define LAG_SERVICE_CFG_DISTR_ALGR_PORT_ADDR 0x2
#define LAG_SERVICE_CFG_PORT0_LACP_TIMEOUT_LONG 0x0
#define LAG_SERVICE_CFG_PORT0_LACP_TIMEOUT_SHORT 0x1
#define LAG_SERVICE_CFG_PORT0_LACP_ACTIVITY_PASSIVE 0x0
#define LAG_SERVICE_CFG_PORT0_LACP_ACTIVITY_ACTIVE 0x1
#define LAG_SERVICE_CFG_PORT1_LACP_TIMEOUT_LONG 0x0
#define LAG_SERVICE_CFG_PORT1_LACP_TIMEOUT_SHORT 0x1
#define LAG_SERVICE_CFG_PORT1_LACP_ACTIVITY_PASSIVE 0x0
#define LAG_SERVICE_CFG_PORT1_LACP_ACTIVITY_ACTIVE 0x1
#define LAG_SERVICE_CFG_LNK_CHECK_DISABLE 0x0
#define LAG_SERVICE_CFG_LNK_CHECK_ENABLE 0x1

/* Definitions associated to LAG_START */
#define LAG_START_LAG_DISABLE 0x0
#define LAG_START_LAG_ENABLE 0x1
#define LAG_START_LAG_DEFAULT 0x0

