/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_ENCRYPTION_API_H_
#define _COMCERTO_ENCRYPTION_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
CAQR:CIPHER_SRTP_OPT (Function code=0x8200, class=0x02, type=0x00)
************************************************************/
struct _CIPHER_SRTP_OPT
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <0> */
			_u_16_ from_to:1;

			/* parameter [4] bit(s) <3:1> */
			_u_16_ authentication:3;

			/* parameter [4] bit(s) <6:4> */
			_u_16_ encryption:3;

			/* parameter [4] bit(s) <9:7> */
			_u_16_ key_material:3;

			/* parameter [4] bit(s) <11:10> */
			_u_16_ direction:2;

			/* parameter [4] bit(s) <13:12> */
			_u_16_ layer:2;

			/* parameter [4] bit(s) <14> */
			_u_16_ byteorder:1;

			/* parameter [4] bit(s) <15> */
			_u_16_ srtp:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <1:0> */
			_u_16_ encrypt_key_size:2;

			/* parameter [5] bit(s) <3:2> */
			_u_16_ master_key_size:2;

			/* parameter [5] bit(s) <7:4> */
			_u_16_ mki_size:4;

			/* parameter [5] bit(s) <12:8> */
			_u_16_ key_derivation:5;

			/* parameter [5] bit(s) <15:13> */
			_u_16_ reserved5_bits_15_13:3;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <8:0> */
			_u_16_ master_salt_key_size:9;

			/* parameter [6] bit(s) <15:9> */
			_u_16_ reserved6_bits_15_9:7;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [7] bit(s) <8:0> */
			_u_16_ salt_key_size:9;

			/* parameter [7] bit(s) <15:9> */
			_u_16_ reserved7_bits_15_9:7;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_7;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [8] bit(s) <3:0> */
			_u_16_ authentication_prefix_size:4;

			/* parameter [8] bit(s) <8:4> */
			_u_16_ authentication_tag_size:5;

			/* parameter [8] bit(s) <15:9> */
			_u_16_ authentication_key_size:7;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_8;


	/*parameters [9:$] = data:OCTETS*/
	_u_8_ data [238];

} ATTRIBUTE_PACKED;

/************************************************************
CA:CIPHER_SRTP_KEY_DERIVATION (Function code=0x8201, class=0x02, type=0x00)
************************************************************/
struct _CIPHER_SRTP_KEY_DERIVATION
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <9:0> */
			_u_16_ reserved4_bits_9_0:10;

			/* parameter [4] bit(s) <11:10> */
			_u_16_ direction:2;

			/* parameter [4] bit(s) <15:12> */
			_u_16_ reserved4_bits_15_12:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ srtp_max_lifetime_32;

	/* parameter [6] */
	_u_16_ srtp_max_lifetime_16;

	/* parameter [7] */
	_u_16_ srtp_max_lifetime_0;

	/*parameters [8:9]*/
	_u_32_ srtcp_max_lifetime;	/*default=0x0*/
	/* parameter [10] */
	_u_16_ from_index_32;

	/* parameter [11] */
	_u_16_ from_index_16;

	/* parameter [12] */
	_u_16_ from_index_0;

	/* parameter [13] */
	_u_16_ to_index_32;

	/* parameter [14] */
	_u_16_ to_index_16;

	/* parameter [15] */
	_u_16_ to_index_0;


	/*parameters [16:$] = data:OCTETS*/
	_u_8_ data [224];

} ATTRIBUTE_PACKED;

#endif /* COMCERTO_ENCRYPTION_API_H_ */ 

