/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifdef _HOST_BIG_ENDIAN_
#include "comcerto-encryption-types_be.h"
#else
#include "comcerto-encryption-types_le.h"
#endif

/* Definitions associated to CIPHER_SRTP_OPT */
#define CIPHER_SRTP_OPT_SRTP_DISABLE 0x0
#define CIPHER_SRTP_OPT_SRTP_ENABLE 0x1
#define CIPHER_SRTP_OPT_BYTEORDER_STANDARD 0x0
#define CIPHER_SRTP_OPT_BYTEORDER_REVERSE 0x1
#define CIPHER_SRTP_OPT_BYTEORDER_DEFAULT 0x0

#define CIPHER_SRTP_OPT_LAYER_SRTP 0x0
#define CIPHER_SRTP_OPT_LAYER_SRTCP 0x1
#define CIPHER_SRTP_OPT_LAYER_SRTP_SRTCP 0x2
#define CIPHER_SRTP_OPT_DIRECTION_ORIGINATE 0x0
#define CIPHER_SRTP_OPT_DIRECTION_TERMINATE 0x1
#define CIPHER_SRTP_OPT_DIRECTION_SYMMETRIC 0x2
#define CIPHER_SRTP_OPT_KEY_MATERIAL_FULL_SPEC_PRF_AES_CM 0x0
#define CIPHER_SRTP_OPT_KEY_MATERIAL_DIRECT_SESSION 0x7
#define CIPHER_SRTP_OPT_KEY_MATERIAL_DEFAULT 0x0

#define CIPHER_SRTP_OPT_ENCRYPTION_DISABLE 0x0
#define CIPHER_SRTP_OPT_ENCRYPTION_AES_CM 0x1
#define CIPHER_SRTP_OPT_ENCRYPTION_AES_F8 0x2
#define CIPHER_SRTP_OPT_ENCRYPTION_DEFAULT 0x1

#define CIPHER_SRTP_OPT_AUTHENTICATION_DISABLE 0x0
#define CIPHER_SRTP_OPT_AUTHENTICATION_HMAC_SHA1 0x1
#define CIPHER_SRTP_OPT_AUTHENTICATION_UNIVERSAL_HASHING 0x2
#define CIPHER_SRTP_OPT_AUTHENTICATION_DEFAULT 0x1

#define CIPHER_SRTP_OPT_FROM_TO_DISABLE 0x0
#define CIPHER_SRTP_OPT_FROM_TO_ENABLE 0x1
#define CIPHER_SRTP_OPT_FROM_TO_DEFAULT 0x0

#define CIPHER_SRTP_OPT_KEY_DERIVATION_DEFAULT 0x0

#define CIPHER_SRTP_OPT_MASTER_KEY_SIZE_BITS_128 0x0
#define CIPHER_SRTP_OPT_MASTER_KEY_SIZE_BITS_192 0x1
#define CIPHER_SRTP_OPT_MASTER_KEY_SIZE_BITS_256 0x2
#define CIPHER_SRTP_OPT_MASTER_KEY_SIZE_DEFAULT 0x0

#define CIPHER_SRTP_OPT_ENCRYPT_KEY_SIZE_BITS_128 0x0
#define CIPHER_SRTP_OPT_ENCRYPT_KEY_SIZE_BITS_192 0x1
#define CIPHER_SRTP_OPT_ENCRYPT_KEY_SIZE_BITS_256 0x2
#define CIPHER_SRTP_OPT_ENCRYPT_KEY_SIZE_DEFAULT 0x0

#define CIPHER_SRTP_OPT_MASTER_SALT_KEY_SIZE_DEFAULT 0x70

#define CIPHER_SRTP_OPT_SALT_KEY_SIZE_DEFAULT 0x70

#define CIPHER_SRTP_OPT_AUTHENTICATION_KEY_SIZE_DEFAULT 0x14

#define CIPHER_SRTP_OPT_AUTHENTICATION_TAG_SIZE_DEFAULT 0xA

#define CIPHER_SRTP_OPT_AUTHENTICATION_PREFIX_SIZE_DEFAULT 0x0

/* Definitions associated to CIPHER_SRTP_KEY_DERIVATION */
#define CIPHER_SRTP_KEY_DERIVATION_DIRECTION_ORIGINATE 0x0
#define CIPHER_SRTP_KEY_DERIVATION_DIRECTION_TERMINATE 0x1
#define CIPHER_SRTP_KEY_DERIVATION_DIRECTION_SYMMETRIC 0x2
#define CIPHER_SRTP_KEY_DERIVATION_SRTP_MAX_LIFETIME_32_DEFAULT 0x0

#define CIPHER_SRTP_KEY_DERIVATION_SRTP_MAX_LIFETIME_16_DEFAULT 0x0

#define CIPHER_SRTP_KEY_DERIVATION_SRTP_MAX_LIFETIME_0_DEFAULT 0x0
