/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_CONFERENCING_API_H_
#define _COMCERTO_CONFERENCING_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
C:CONF_CREATE_CONFERENCE (Function code=0x9310, class=0x06, type=0x00)
************************************************************/
struct _CONF_CREATE_CONFERENCE
{
	/* parameter [4] */
	_u_16_ transcoding;


} ATTRIBUTE_PACKED;


/************************************************************
A:CONF_CREATE_CONFERENCE (Function code=0x9310, class=0x06, type=0x02)
************************************************************/
struct _CONF_CREATE_CONFERENCE_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;

/************************************************************
CA:CONF_DESTROY_CONFERENCE (Function code=0x9311, class=0x06, type=0x00)
************************************************************/
struct _CONF_DESTROY_CONFERENCE
{
	/* parameter [4] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;

/************************************************************
C:CONF_CREATE_PARTICIPANT (Function code=0x9312, class=0x06, type=0x00)
************************************************************/
struct _CONF_CREATE_PARTICIPANT
{
	/* parameter [4] */
	_u_16_ type;

	/* parameter [5] */
	_u_16_ timeslot;

	/* parameter [6] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;


/************************************************************
A:CONF_CREATE_PARTICIPANT (Function code=0x9312, class=0x06, type=0x02)
************************************************************/
struct _CONF_CREATE_PARTICIPANT_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ participant_id;

	/* parameter [6] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;

/************************************************************
C:CONF_DESTROY_PARTICIPANT (Function code=0x9313, class=0x06, type=0x00)
************************************************************/
struct _CONF_DESTROY_PARTICIPANT
{
	/* parameter [4] */
	_u_16_ participant_id;

	/* parameter [5] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;

/************************************************************
A:CONF_DESTROY_PARTICIPANT (Function code=0x9313, class=0x06, type=0x02)
************************************************************/
struct _CONF_DESTROY_PARTICIPANT_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ participant_id;

	/* parameter [6] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;

/************************************************************
C:CONF_MUTE_PARTICIPANT (Function code=0x9314, class=0x06, type=0x00)
************************************************************/
struct _CONF_MUTE_PARTICIPANT
{
	/* parameter [4] */
	_u_16_ participant_id;

	/* parameter [5] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;

/************************************************************
A:CONF_MUTE_PARTICIPANT (Function code=0x9314, class=0x06, type=0x02)
************************************************************/
struct _CONF_MUTE_PARTICIPANT_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ participant_id;

	/* parameter [6] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;

/************************************************************
C:CONF_PUT_PARTICIPANT_ON_HOLD (Function code=0x9315, class=0x06, type=0x00)
************************************************************/
struct _CONF_PUT_PARTICIPANT_ON_HOLD
{
	/* parameter [4] */
	_u_16_ participant_id;

	/* parameter [5] */
	_u_16_ conference_id;

	/* parameter [6] */
	_u_16_ hold_state;

	/* parameter [7] */
	_u_16_ source_participant_id;


} ATTRIBUTE_PACKED;


/************************************************************
A:CONF_PUT_PARTICIPANT_ON_HOLD (Function code=0x9315, class=0x06, type=0x02)
************************************************************/
struct _CONF_PUT_PARTICIPANT_ON_HOLD_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ participant_id;

	/* parameter [6] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;

/************************************************************
C:CONF_SPECIFY_DOMINANT_TALKERS (Function code=0x9316, class=0x06, type=0x00)
************************************************************/
struct _CONF_SPECIFY_DOMINANT_TALKERS
{
	/* parameter [4] */
	_u_16_ conference_id;

	/* parameter [5] */
	_u_16_ dts;

	/* parameter [6] */
	_u_16_ attack;

	/* parameter [7] */
	_u_16_ nth1;

	/* parameter [8] */
	_u_16_ nth2;

	/* parameter [9] */
	_u_16_ hold;

	/* parameter [10] */
	_u_16_ n1;

	/* parameter [11] */
	_u_16_ g1;

	/* parameter [12] */
	_u_16_ n2;

	/* parameter [13] */
	_u_16_ g2;

	/* parameter [14] */
	_u_16_ n3;

	/* parameter [15] */
	_u_16_ g3;


} ATTRIBUTE_PACKED;

/************************************************************
A:CONF_SPECIFY_DOMINANT_TALKERS (Function code=0x9316, class=0x06, type=0x02)
************************************************************/
struct _CONF_SPECIFY_DOMINANT_TALKERS_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ conference_id;


} ATTRIBUTE_PACKED;

/************************************************************
C:CONF_SET_LATENCY (Function code=0x9317, class=0x06, type=0x00)
************************************************************/
struct _CONF_SET_LATENCY
{
	/* parameter [4] */
	_u_16_ latency;

	/* parameter [5] */
	_u_16_ padding;


} ATTRIBUTE_PACKED;

/************************************************************
A:CONF_SET_LATENCY (Function code=0x9317, class=0x06, type=0x02)
************************************************************/
struct _CONF_SET_LATENCY_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ padding;


} ATTRIBUTE_PACKED;

/************************************************************
C:CONF_SET_PARTICIPANT_DGAIN (Function code=0x9318, class=0x06, type=0x00)
************************************************************/
struct _CONF_SET_PARTICIPANT_DGAIN
{
	/* parameter [4] */
	_u_16_ participant_id;

	/* parameter [5] */
	_u_16_ conference_id;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [6] bit(s) <15:4> */
			_u_16_ reserved:12;

			/* parameter [6] bit(s) <3:0> */
			_u_16_ gain:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_6;

	/* parameter [7] */
	_u_16_ padding;


} ATTRIBUTE_PACKED;


/************************************************************
A:CONF_SET_PARTICIPANT_DGAIN (Function code=0x9318, class=0x06, type=0x02)
************************************************************/
struct _CONF_SET_PARTICIPANT_DGAIN_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ padding;


} ATTRIBUTE_PACKED;

/************************************************************
C:CONF_SET_DGAIN (Function code=0x9319, class=0x06, type=0x00)
************************************************************/
struct _CONF_SET_DGAIN
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:4> */
			_u_16_ reserved:12;

			/* parameter [4] bit(s) <3:0> */
			_u_16_ gain:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ padding;


} ATTRIBUTE_PACKED;



/************************************************************
A:CONF_SET_DGAIN (Function code=0x9319, class=0x06, type=0x02)
************************************************************/
struct _CONF_SET_DGAIN_RESP
{
	/* parameter [4] */
	_u_16_ status;

	/* parameter [5] */
	_u_16_ padding;


} ATTRIBUTE_PACKED;

/************************************************************
C:VoIP_NSSET (Function code=0x80D0, class=0x02, type=0x00)
************************************************************/
struct _VOIP_NSSET
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:2> */
			_u_16_ reserved:14;

			/* parameter [4] bit(s) <1> */
			_u_16_ pcm_to_mixer:1;

			/* parameter [4] bit(s) <0> */
			_u_16_ packet_to_mixer:1;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	/* parameter [5] */
	_u_16_ pcm2mix_nsl;

	/* parameter [6] */
	_u_16_ pkt2mix_nsl;


} ATTRIBUTE_PACKED;


/************************************************************
A:VoIP_NSSET (Function code=0x80D0, class=0x02, type=0x02)
************************************************************/
struct _VOIP_NSSET_RESP
{
	/* parameter [4] */
	_u_16_ status;


} ATTRIBUTE_PACKED;
#endif /* COMCERTO_CONFERENCING_API_H_ */ 

