/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifdef _HOST_BIG_ENDIAN_
#include "comcerto-conferencing-types_be.h"
#else
#include "comcerto-conferencing-types_le.h"
#endif

/* Definitions associated to CONF_CREATE_CONFERENCE */
#define CONF_CREATE_CONFERENCE_TRANSCODING_DISABLE 0x0
#define CONF_CREATE_CONFERENCE_TRANSCODING_ENABLE 0x1
#define CONF_CREATE_CONFERENCE_TRANSCODING_DEFAULT 0x0

/* Definitions associated to CONF_CREATE_CONFERENCE */
#define CONF_CREATE_CONFERENCE_STATUS_CNF_OK 0x0

/* Definitions associated to CONF_CREATE_PARTICIPANT */
#define CONF_CREATE_PARTICIPANT_TYPE_LSP 0x0
#define CONF_CREATE_PARTICIPANT_TYPE_RSP 0x1
#define CONF_CREATE_PARTICIPANT_TYPE_TRANSCODING 0x11
#define CONF_CREATE_PARTICIPANT_TIMESLOT_DEFAULT 0x0

/* Definitions associated to CONF_CREATE_PARTICIPANT */
#define CONF_CREATE_PARTICIPANT_STATUS_CNF_OK 0x0

/* Definitions associated to CONF_DESTROY_PARTICIPANT */
#define CONF_DESTROY_PARTICIPANT_STATUS_CNF_OK 0x0

/* Definitions associated to CONF_MUTE_PARTICIPANT */
#define CONF_MUTE_PARTICIPANT_STATUS_CNF_OK 0x0

/* Definitions associated to CONF_PUT_PARTICIPANT_ON_HOLD */
#define CONF_PUT_PARTICIPANT_ON_HOLD_HOLD_STATE_NO_HOLD 0x0
#define CONF_PUT_PARTICIPANT_ON_HOLD_HOLD_STATE_SIMPLE_HOLD 0x1
#define CONF_PUT_PARTICIPANT_ON_HOLD_HOLD_STATE_ANNOUNCEMENT_HOLD 0x2
#define CONF_PUT_PARTICIPANT_ON_HOLD_HOLD_STATE_MONITORED_HOLD 0x3
#define CONF_PUT_PARTICIPANT_ON_HOLD_SOURCE_PARTICIPANT_ID_DEFAULT 0x0

/* Definitions associated to CONF_PUT_PARTICIPANT_ON_HOLD */
#define CONF_PUT_PARTICIPANT_ON_HOLD_STATUS_CNF_OK 0x0

/* Definitions associated to CONF_SPECIFY_DOMINANT_TALKERS */
#define CONF_SPECIFY_DOMINANT_TALKERS_DTS_DISABLE 0x0
#define CONF_SPECIFY_DOMINANT_TALKERS_DTS_ENABLE 0x1
#define CONF_SPECIFY_DOMINANT_TALKERS_DTS_DEFAULT 0x0

#define CONF_SPECIFY_DOMINANT_TALKERS_ATTACK_DEFAULT 0x3C

#define CONF_SPECIFY_DOMINANT_TALKERS_NTH1_DEFAULT 0xFE48

#define CONF_SPECIFY_DOMINANT_TALKERS_NTH2_DEFAULT 0xFEC0

#define CONF_SPECIFY_DOMINANT_TALKERS_HOLD_DEFAULT 0x3E8

#define CONF_SPECIFY_DOMINANT_TALKERS_N1_DEFAULT 0x2

#define CONF_SPECIFY_DOMINANT_TALKERS_G1_DEFAULT 0x0

#define CONF_SPECIFY_DOMINANT_TALKERS_N2_DEFAULT 0x2

#define CONF_SPECIFY_DOMINANT_TALKERS_G2_DEFAULT 0x64

#define CONF_SPECIFY_DOMINANT_TALKERS_N3_DEFAULT 0x2

#define CONF_SPECIFY_DOMINANT_TALKERS_G3_DEFAULT 0xC8

/* Definitions associated to CONF_SPECIFY_DOMINANT_TALKERS */
#define CONF_SPECIFY_DOMINANT_TALKERS_STATUS_CNF_OK 0x0

/* Definitions associated to CONF_SET_LATENCY */
#define CONF_SET_LATENCY_LATENCY_C15MS_100CH 0x0
#define CONF_SET_LATENCY_LATENCY_C20MS_128CH 0x1
#define CONF_SET_LATENCY_LATENCY_C30MS_128CH 0x2
#define CONF_SET_LATENCY_LATENCY_EC15MS_68CH 0x3
#define CONF_SET_LATENCY_LATENCY_EC20MS_80CH 0x4
#define CONF_SET_LATENCY_LATENCY_EC30MS_80CH 0x5
#define CONF_SET_LATENCY_PADDING_DEFAULT 0x0

/* Definitions associated to CONF_SET_LATENCY */
#define CONF_SET_LATENCY_STATUS_CNF_OK 0x0

/* Definitions associated to CONF_SET_PARTICIPANT_DGAIN */
#define CONF_SET_PARTICIPANT_DGAIN_RESERVED_DEFAULT 0x0

#define CONF_SET_PARTICIPANT_DGAIN_GAIN_DB0 0x0
#define CONF_SET_PARTICIPANT_DGAIN_GAIN_DB1_5 0x1
#define CONF_SET_PARTICIPANT_DGAIN_GAIN_DB3 0x2
#define CONF_SET_PARTICIPANT_DGAIN_GAIN_DB4_5 0x3
#define CONF_SET_PARTICIPANT_DGAIN_GAIN_DB6 0x4
#define CONF_SET_PARTICIPANT_DGAIN_GAIN_DB9 0x5
#define CONF_SET_PARTICIPANT_DGAIN_PADDING_DEFAULT 0x0

/* Definitions associated to CONF_SET_PARTICIPANT_DGAIN */
#define CONF_SET_PARTICIPANT_DGAIN_STATUS_CNF_OK 0x0

/* Definitions associated to CONF_SET_DGAIN */
#define CONF_SET_DGAIN_RESERVED_DEFAULT 0x0

#define CONF_SET_DGAIN_GAIN_DB0 0x0
#define CONF_SET_DGAIN_GAIN_DB1_5 0x1
#define CONF_SET_DGAIN_GAIN_DB3 0x2
#define CONF_SET_DGAIN_GAIN_DB4_5 0x3
#define CONF_SET_DGAIN_GAIN_DB6 0x4
#define CONF_SET_DGAIN_GAIN_DB9 0x5
#define CONF_SET_DGAIN_PADDING_DEFAULT 0x0

/* Definitions associated to CONF_SET_DGAIN */
#define CONF_SET_DGAIN_STATUS_CNF_OK 0x0

/* Definitions associated to VOIP_NSSET */
#define VOIP_NSSET_RESERVED_DEFAULT 0x0

#define VOIP_NSSET_PCM_TO_MIXER_DISABLE 0x0
#define VOIP_NSSET_PCM_TO_MIXER_ENABLE 0x1
#define VOIP_NSSET_PCM_TO_MIXER_DEFAULT 0x0

#define VOIP_NSSET_PACKET_TO_MIXER_DISABLE 0x0
#define VOIP_NSSET_PACKET_TO_MIXER_ENABLE 0x1
#define VOIP_NSSET_PACKET_TO_MIXER_DEFAULT 0x0

#define VOIP_NSSET_PCM2MIX_NSL_DEFAULT 0xC

#define VOIP_NSSET_PKT2MIX_NSL_DEFAULT 0xC

/* Definitions associated to VOIP_NSSET */
#define VOIP_NSSET_STATUS_CNF_OK 0x0
 
