/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/ 

#ifndef _COMCERTO_API_DEFS_H_
#define _COMCERTO_API_DEFS_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif


/*
 * Comcerto API header 
 */
struct comcerto_api_hdr {
	_u_8_ length;
	_u_8_ index;

	_u_8_ cmd_type;
	_u_8_ cmd_class;

	_u_16_ func_code;
	_u_16_ reserved;
} __attribute__((packed));

struct comcerto_api_hdr_boot
{
	_u_8_ index;
	_u_8_ length;

	_u_8_ cmd_class;
	_u_8_ cmd_type;

	_u_16_ func_code;
} __attribute__((packed));

#define CIDX_FIFO_LEN   0	/**< Byte Index of FIFO Length in FIFO Array*/
#define CIDX_CMD_INDEX  1	/**< Byte Index of Cmd Index in FIFO Array*/
#define CIDX_CMD_TYPE   2	/**< Byte Index of Cmd Type in FIFO Array*/
#define CIDX_CMD_CLS    3	/**< Byte Index of Cmd Class in FIFO Array*/
#define CIDX_FUNC_CODE  4	/**< Byte Index of Func. code in FIFO Array*/


/*
 * Command class 
 */
#define CMD_CLASS_STAT_CHANNEL			0x01
#define CMD_CLASS_CONF_CHANNEL			0x02
#define CMD_CLASS_LEGACY_MSG			0x03
#define CMD_CLASS_ETH_BOOT_MSG			0x04
#define CMD_CLASS_STAT_DEVICE			0x05
#define CMD_CLASS_CONF_DEVICE			0x06
#define CMD_CLASS_REF_DIAG			0xC1	/*Reference Diagnostics*/
#define CMD_CLASS_OPEN_DIAG			0xC2	/*Open Diagnostic (Mindspeed use only)*/
#define CMD_CLASS_DIAG_TOOL			0xC3	/*Diag tool diagnostis */

/*
 * Command types
 */ 
#define CMD_TYPE_CONF_CHANGE			0x00
#define CMD_TYPE_QUERY				0x01
#define CMD_TYPE_CONF_RESP			0x02
#define CMD_TYPE_INDICATION			0x03
#define CMD_TYPE_QUERY_RESP			0x04
#define CMD_TYPE_INDICATION_RESP		0x05

#define MIN_CMD_TYPE_STATS			0x05
#define MAX_CMD_TYPE_STATS			0xD0

/* Legacy Command Types */
#define CMD_TYPE_SETTSA				0x36
#define CMD_TYPE_CONFIGACK			0x38
#define CMD_TYPE_CHANRESET			0x3B
#define CMD_TYPE_CHANSTATUS			0x3A
#define CMD_TYPE_SETSYNC			0xB9

/*
 * Comcerto command types for boot messages
 */
#define CMD_TYPE_BRM_ERRIND			0x00
#define CMD_TYPE_BRM_BYTEREAD			0x02
#define CMD_TYPE_BRM_BYTEWRITE			0x03
#define CMD_TYPE_BRM_FIFOREAD			0x04
#define CMD_TYPE_BRM_FIFOWRITE			0x05
#define CMD_TYPE_BRM_PROGSTART			0x06
#define CMD_TYPE_BRM_ZEROFILL			0x08
#define CMD_TYPE_BRM_WORDWRITE			0x0B
#define CMD_TYPE_BRM_WORDREAD			0x0A
#define CMD_TYPE_BRM_SETCLOCK			0x0c
#define CMD_TYPE_BRM_SET_SDRAM_PARAM		0x0D
#define CMD_TYPE_BRM_SET_SDRAM_PARAMS_2		0x0E
#define CMD_TYPE_BRM_SET_CS_PARAM		0x0F
#define CMD_TYPE_BRM_RUN_CHKSUM			0x10
#define CMD_TYPE_BRM_GET_VERSION		0x11
#define CMD_TYPE_BRM_CMD_ACK			0x14
#define CMD_TYPE_BRM_SET_ARM_CLKMODE		0x15
#define CMD_TYPE_BRM_DOUBLEWORDREAD		0x16
#define CMD_TYPE_BRM_DOUBLEWORDWRITE_ADDR	0x17
#define CMD_TYPE_BRM_DOUBLEWORDWRITE_DATA	0x18
#define CMD_TYPE_BRM_FIFOWRITEBURST		0x19
#define CMD_TYPE_BRM_MAAS_ASSIGN		0x1B
#define CMD_TYPE_BRM_QUERY_READY		0x1E
#define CMD_TYPE_BRM_SETPLL			0x1F
#define CMD_TYPE_BRM_READY			0x20

#define CMD_TYPE_SUPV_READY			0xD4


/* 
 * Comcerto command types for booting over POS 
 */
#define CMD_TYPE_POS_PHYID_ASSIGN		0x01
#define CMD_TYPE_POS_SET_PLL			0x02
#define CMD_TYPE_POS_SET_SDRAM			0x03
#define CMD_TYPE_POS_PROGSTART			0x06
#define CMD_TYPE_POS_CHKSUM			0x07
#define CMD_TYPE_POS_MEMFILL			0x08
#define CMD_TYPE_POS_MEMWRITE			0x09

/*Unified Diagnostics Command Types*/
#define CMD_TYPE_DIAG_QUERY			0x70 /*Query*/
#define CMD_TYPE_DIAG_QUERY_RESP		0x71 /*QueryResp*/
#define CMD_TYPE_DIAG_REL_QUERY			0x72 /*ReliableQuery*/
#define CMD_TYPE_DIAG_REL_QUERY_RESP		0x73 /*ReliableQueryResp*/
#define CMD_TYPE_DIAG_MON_LIVE_CTRL		0x74 /*Monitor Live Control*/
#define CMD_TYPE_DIAG_MON_LIVE_IND		0x75 /*Monitor Live Indication*/
#define CMD_TYPE_DIAG_CONFIG			0x78 /*diag configuration*/
#define CMD_TYPE_DIAG_RESP			0x79 /*diag response*/

/* Comcerto diagnosics function codes */
#define DIAG_FC_IRM_AVAILABLE		0x0001
#define DIAG_IRM_SPU_CONVTABLE		0x0002
#define DIAG_DEV_QUERY_MEMREAD		0x00EB
#define DIAG_REPORTALLCMD		0x00EC
#define DIAG_RESET_IND			0x00EE
#define DIAG_DISCARDED			0x00EF
#define DIAG_REPORTCMD			0x00FB
#define DIAG_TDM_RX			0x0E00
#define DIAG_TDM_TX			0x0E01
#define DIAG_PACKET_RX			0x0802
#define DIAG_PACKET_TX			0x0803
#define DIAG_AAL2_OVER_ETH_RX		0x0A00
#define DIAG_AAL2_OVER_ETH_TX		0x0A01
#define DIAG_SPU_IOPARAMS		0x1010
#define DIAG_SPU_INSTREAM		0x1011
#define DIAG_SPU_OUTSTREAM		0x1012
#define DIAG_DSP_TASK_IOPARAMS		0x1013
#define DIAG_CSME_MCP_TRACE		0x1014
#define DIAG_DSP_TOMIXER		0x1015
#define DIAG_DSP_FROMMIXER		0x1016
#define DIAG_IUUP_QUERY_BASIC		0x70FF
#define DIAG_STATE_ALERTS		0xA000
#define DIAG_STATE_ALERTS_ADD		0xA001
#define DIAG_STATE_RTXC			0xA002
#define DIAG_STATE_TASKS		0xA003
#define DIAG_STATE_TASKS_STACK		0xA004
#define DIAG_STATE_SEMAPHORES		0xA005
#define DIAG_STATE_HEAPS		0xA006
#define DIAG_STATE_SPU			0xA007
#define DIAG_STATE_QUEUES_0		0xA008
#define DIAG_STATE_QUEUES_1		0xA009
#define DIAG_STATE_QUEUES_2		0xA00A
#define DIAG_RCD_INIT			0xCD00
#define DIAG_RCD_READY			0xCD01


#define CMD_TYPE_STAT_VOIP_RTCP		0x05
#define CMD_TYPE_STAT_VOIP_PLYDLY	0x06
#define CMD_TYPE_STAT_VOIP_PLYERR	0x07
#define CMD_TYPE_STAT_VOIP_PKTTX	0x08
#define CMD_TYPE_STAT_VOIP_PKTRX	0x09
#define CMD_TYPE_STAT_VOIP_VCELVL	0x0A
#define CMD_TYPE_STAT_VOIP_FAXTXRX	0x0B
#define CMD_TYPE_STAT_VOIP_FAXPLY	0x0C
#define CMD_TYPE_STAT_VOIP_FAXDSP	0x0D
#define CMD_TYPE_STAT_VOIP_VCEINFO	0x0E
#define CMD_TYPE_STAT_VOIP_T38INFO	0x0F
#define CMD_TYPE_STAT_VOIP_CONFSUM	0x10
#define CMD_TYPE_STAT_VOIP_PKTDISCARDED	0x25

#define MIN_FIFO_LEN		8
#define MAX_FIFO_LEN		255

#define SUPV_CHANNEL		0xFFFF

/*enum config_result_code */
#define CNF_OK							0x0000
#define CNF_ERROR_UNSPEC					0x0001
#define CNF_ERROR_VOPENA_RTPHEADER				0x0002
#define CNF_ERROR_VOPENA_PT					0x0003
#define CNF_DELAYED_RESP					0x0004
#define CNF_ERROR_NOCHAN					0x000F
#define CNF_ERROR_PTDUPLICATE					0x0018
#define CNF_ERROR_VOPENA_NOIPCLIENT				0x0020
#define CNF_ERROR_VOPENA_REG_RTP_NO_IPLAYER			0x0021
#define CNF_ERROR_VOPENA_REG_RTP_NO_LOWERLAYER			0x0022
#define CNF_ERROR_VOPENA_REG_RTP_NO_MORECLIENTS			0x0023
#define CNF_ERROR_VOPENA_REG_RTP_DUPLICATION			0x0024
#define CNF_ERROR_VOPENA_REG_RTCP_NO_IPLAYER			0x0025
#define CNF_ERROR_VOPENA_REG_RTCP_NO_LOWERLAYER			0x0026
#define CNF_ERROR_VOPENA_REG_RTCP_NO_MORECLIENTS		0x0027
#define CNF_ERROR_VOPENA_REG_RTCP_DUPLICATION			0x0028
#define CNF_ERROR_VOPENA_REG_RTCP_NOT_ENABLED			0x0029
#define CNF_ERROR_VOICE_ACTIVE					0x002A
#define CNF_ERROR_VCEOPT_NOIPCLIENT				0x002B
#define CNF_ERROR_VCEOPT_NOETHCLIENT				0x002C
#define CNF_ERROR_VOPENA_PACKET_LEN				0x002D
#define CNF_ERROR_FIFO_LEN					0x002E
#define CNF_ERROR_PARAM_OUT_OF_RANGE				0x002F
#define CNF_ERROR_PARAM2_OUT_OF_RANGE				0x0030
#define CNF_ERROR_FOPENA_REGISSUE_FOIP_INDEX			0x0031
#define CNF_ERROR_IPV4_DEREG					0x0032
#define CNF_ERROR_PARAM_INVALID_VALUE				0x0033
#define CNF_ERR_VCEOPT_INVALID_PKT_INTERVAL			0x0034
#define CNF_ERR_SENDNTE_INVALID_CHANNEL_STATE			0x0035
#define CNF_ERR_TDM_MODE_NOT_FOURBUS				0x0040
#define CNF_ERR_TDM_BUS_OUT_OF_RANGE_FOURBUS_MODE		0x0041
#define CNF_ERR_TDM_BUS_OUT_OF_RANGE_TWOBUS_MODE		0x0042
#define CNF_ERR_TDM_BUS_OUT_OF_RANGE_ONEBUS_MODE		0x0043
#define CNF_ERR_TDM_CONFIG_PARMS_FAILED_FOURBUS_MODE_OLD	0x0044
#define CNF_ERR_TDM_CONFIG_PARMS_FAILED_FOURBUS_MODE_NEW	0x0045
#define CNF_ERR_TDM_CONFIG_PARMS_FAILED_TWOBUS_MODE		0x0046
#define CNF_ERR_TDM_CONFIG_PARMS_FAILED_ONEBUS_MODE		0x0047
#define CNF_ERR_TDM_PARAMS_INVALID_BUS_MODE			0x0048
#define CNF_ERR_TDM_SELECT_INVALID_BUS_MODE			0x0049
#define CNF_ERR_TDM_INVALID_CMD_LEN				0x004A
#define CNF_ERR_TDM_CONFIG_PARMS_FAILED_SETUP_MULT_INSTANCE	0x004B
#define CNF_ERR_TDM_CONFIG_PARMS_FAILED_SELECT_MULT_INSTANCE	0x004C
#define CNF_ERR_TSDRIVE_INVALID_CMD_LEN				0x004D
#define CNF_ERR_TSDRIVE_INVALID_PARAM				0x004E
#define CNF_ERR_TSDRIVE_CHAN_ALREADY_CREATED			0x004F
#define CNF_ERR_SPI_NOT_CHAGALL					0x0050
#define CNF_ERR_SPI_ENQUEUE_READ_CMD_FAILED			0x0051
#define CNF_ERR_SPI_ENQUEUE_WRITE_CMD_FAILED			0x0052
#define CNF_ERR_SPI_BUS_OUT_OF_RANGE				0x0053
#define CNF_ERR_SPI_INCORRECT_BUS_MODE				0x0054
#define CNF_ERR_SPI_IRQSIZE_ZERO				0x0055
#define CNF_ERR_SPI_IRQSIZE_TOO_LARGE				0x0056
#define CNF_ERR_SPI_IRQSIZE_NOT_SUBMULTIPLE			0x0057
#define CNF_ERR_SPI_TDM_RELEASE_FAILED				0x0058
#define CNF_ERR_SPI_TDM_GRAB_FAILED				0x0059
#define CNF_ERR_SPI_TDM_QUEUE_INIT_FAILED			0x005A
#define CNF_ERR_SPI_TASK_CREATION_FAILED			0x005B
#define CNF_ERR_TSDRIVE_INVALID_FOR_MIRO			0x005C
#define CNF_ERR_MDIO_PHYADDR_OUT_OF_RANGE			0x005D
#define CNF_ERR_MDIO_REGADDR_OUT_OF_RANGE			0x005E
#define CNF_ERR_MDIO_CMD_BUSY_TIMEOUT				0x005F
#define CNF_ERR_THC_MIRO_DEVICE					0x0060
#define CNF_ERR_THC_CHAN_NOT_ACTIVE				0x0061
#define CNF_ERR_THC_CHAN_NOT_G711				0x0062
#define CNF_ERR_THC_NOT_THC					0x0063
#define CNF_ERR_THC_PEER_CHAN_NULL				0x0064
#define CNF_ERR_THC_NOT_SAME_CPU				0x0065
#define CNF_ERR_THC_NOT_SAME_CODING				0x0066
#define CNF_ERR_THC_HAIRPIN_NULL				0x0067
#define CNF_ERR_THC_CMD_INVALID_FOR_THC				0x0068
#define CNF_ERR_PASSTHRU					0x0069
#define CNF_ERR_CRBT_VCEOPT_INVALID_PARAM			0x006A
#define CNF_ERR_COMPLEX_CADENCE_ENGINE_FORMAT_ERROR		0x006B
#define CNF_ERR_TONEGEN_CURRENTLY_RUNNING			0x006C
#define CNF_ERR_MDIO_BUSY_TIMER					0x006D
#define CNF_ERR_THC_NOT_READY					0x006E
#define CNF_ERR_ALT_HDR_ERROR					0x006F
#define CNF_ERROR_CID_RANGE					0x0102
#define CNF_ERROR_NO_VPIVCI					0x0103
#define CNF_ERROR_PHY_NUMBER					0x0104
#define CNF_ERROR_VOICE_FT					0x0105
#define CNF_ERROR_SILENCE_FT					0x0106
#define CNF_ERROR_CPS_REG					0x0107
#define CNF_ERROR_CPS_REG_CID_OUT_OF_RANGE			0x0108
#define CNF_ERROR_CPS_REG_INVALID_VPIVCI			0x0109
#define CNF_ERROR_CPS_REG_VCC_OUT_OF_RANGE			0x010A
#define CNF_ERROR_CPS_REG_VCC_USED				0x010B
#define CNF_ERROR_CPS_REG_VCC_MISMATCH				0x010C
#define CNF_ERROR_CPS_REG_CID_USED				0x010D
#define CNF_ERROR_CPS_REG_NO_CPS_LAYER				0x010E
#define CNF_ERROR_CPS_REG_ATM_RT_REG				0x010F
#define CNF_ERROR_CPS_REG_RESERVED				0x0110
#define CNF_ERROR_CPS_DEREG					0x0111
#define CNF_ERROR_CPS_PACKET_LEN				0x0112
#define CNF_ERROR_FRAME_SIZE					0x0113
#define CNF_ERROR_UNSUPPORTED_PROFILE				0x0120
#define CNF_ERROR_EMPTY_PROFILE					0x0121
#define CNF_ERROR_AAL2_ACTIVE					0x0122
#define CNF_ERROR_PROFILE_TYPE					0x0123
#define CNF_ERROR_PROFILE_SIZE					0x0124
#define CNF_ERROR_PROFILE_USED					0x0125
#define CNF_ERROR_INVALID_VOICE_FT				0x0126
#define CNF_ERROR_INVALID_UUI					0x0127
#define CNF_ERROR_INVALID_LI					0x0128
#define CNF_ERROR_PROFILE_CONFLICT				0x0129
#define CNF_ERROR_CPS_MSGLEN					0x012A
#define CNF_ERROR_CPS_NOMEM					0x012B
#define CNF_ERROR_CPS_NOCLIENT					0x012C
#define CNF_ERROR_CPS_MODE					0x012D
#define CNF_ERROR_CPS_TOO_MANY_CLIENT				0x012E
#define CNF_ERROR_CPS_TIMER					0x012F
#define CNF_ERROR_FEATURE_NOTKEYED				0x0130
#define CNF_HAS_NOT_MEMORY					0x0131
#define CNF_CHANNEL_NOT_ENABLED					0x0132
#define CNF_CODEC_TYPE_ERROR					0x0133
#define CNF_MODE_ERROR						0x0134
#define CNF_CODEC_FRAME_SIZE_ERROR				0x0135
#define CNF_DST_CODEC_TYPE_ERROR				0x0136
#define CNF_ERR_DATA_SIZE_EXCEEDED				0x0170
#define CNF_ERR_HAS_NOT_HANDLER					0x0171
#define CNF_ERROR_AAL1						0x0202
#define CNF_ERROR_ATM_LAYER_DOWN				0x0203
#define CNF_ERROR_N_VALUE					0x0204
#define CNF_ERROR_AUTO_VPI_VCI					0x0205
#define CNF_ERROR_LEN_MSG					0x0206
#define CNF_ERROR_ATM_DEREGISTRATION				0x0207
#define CNF_ERROR_AAL1_UNKNOWN_FUNC				0x0208
#define CNF_ERROR_AAL1_VOICE_INACTIVE				0x0209
#define CNF_ERROR_AAL1_TONEOFF					0x020A
#define CNF_ERROR_AAL1_CADENCE					0x020B
#define CNF_ERROR_AAL1_FREQ					0x020C
#define CNF_ERROR_AAL1_TONEGEN					0x020D
#define CNF_ERROR_AAL1_GAIN					0x020E
#define CNF_ERROR_AAL1_TAILLEN					0x020F
#define CNF_ERROR_AAL1_MODE					0x0210
#define CNF_ERROR_AAL1_LB_ICHAN_SWITCH				0x0211
#define CNF_ERROR_AAL1_LB_SELF					0x0212
#define CNF_ERROR_AAL1_LB_POST_ONTHEFLY				0x0213
#define CNF_ERROR_AAL1_LB_ICHAN_ONTHEFLY			0x0214
#define CNF_ERROR_AAL1_LB_ICHAN_SELF				0x0215
#define CNF_ERROR_AAL1_LB_ONTHEFLY				0x0216
#define CNF_ERROR_AAL1_LB_NO_DEST				0x0217
#define CNF_ERROR_AAL1_LB_NOT_IMPLEMENTED			0x0218
#define CNF_ERROR_AAL1_LB_NO_FPGA				0x0219
#define CNF_ERROR_AAL0_ATM_REGISTRATION				0x0250
#define CNF_ERROR_AAL0_ATM_LAYER_DOWN				0x0251
#define CNF_ERROR_AAL0_LEN_MSG					0x0252
#define CNF_ERROR_AAL0_ATM_DEREGISTRATION			0x0253
#define CNF_ERROR_AAL0_WRONG_PARAMETER				0x0254
#define CNF_ERROR_AAL0_UNKNOWN_FUNC				0x0255
#define CNF_ERROR_AAL0_VOICE_INACTIVE				0x0256
#define CNF_ERROR_AAL0_TONEOFF					0x0257
#define CNF_ERROR_AAL0_CADENCE					0x0258
#define CNF_ERROR_AAL0_FREQ					0x0259
#define CNF_ERROR_AAL0_TONEGEN					0x025A
#define CNF_ERROR_AAL0_GAIN					0x025B
#define CNF_ERROR_AAL0_TAILLEN					0x025C
#define CNF_ERROR_AAL0_VoIP_ALREADYUSED				0x025D
#define CNF_ERROR_CCS_CID_RANGE					0x0302
#define CNF_ERROR_CCS_AUTO_VPI_VCI				0x0303
#define CNF_ERROR_ON_INIT_CHANNEL				0x0304
#define CNF_ERROR_CCS_LEN_MSG					0x0305
#define CNF_ERROR_CCS_CPS_REG					0x0306
#define CNF_ERROR_CCS_MSG_NOT_SENT				0x0307
#define CNF_ERROR_CCS_UNKNOWN_FUNC				0x0308
#define CNF_ERROR_CCS_CHAN_ENABLED				0x0309
#define CNF_ERROR_CDMA_MSG_LEN					0x0402
#define CNF_ERROR_CDMA_PHY_NUMBER				0x0403
#define CNF_ERROR_CDMA_VOICE_FT					0x0404
#define CNF_ERROR_CDMA_GPS_OFFSET				0x0405
#define CNF_ERROR_CDMA_MODE_OF_OPERATION			0x0406
#define CNF_ERROR_CDMA_DATA_SERVICE_RATE			0x0407
#define CNF_ERROR_CDMA_GPS_SYNC_SERVICE_DOWN			0x0408
#define CNF_ERROR_CDMA_DESCRIPTOR				0x0409
#define CNF_ERROR_CDMA_AAL5_REG_SERVICE_DOWN			0x040A
#define CNF_ERROR_CDMA_AAL5_REG_MAX_CLIENTS			0x040B
#define CNF_ERROR_CDMA_AAL5_REG_ALLOC_CLIENT			0x040C
#define CNF_ERROR_CDMA_AAL5_REG_ATM_REGISTRATION		0x040D
#define CNF_ERROR_CDMA_AAL5_DEREG_SERVICE_DOWN			0x040E
#define CNF_ERROR_CDMA_AAL5_DEREG_NO_REGISTERED_CLIENT		0x040F
#define CNF_ERROR_CDMA_AAL5_DEREG_CLIENT_NOT_FOUND		0x0410
#define CNF_ERROR_CDMA_MEMORY					0x0411
#define CNF_ERROR_FOIP_MSG_LEN					0x0502
#define CNF_ERROR_FOIP_LEVEL					0x0503
#define CNF_ERROR_FOIP_DEREG					0x0504
#define CNF_ERROR_FOIP_COD_INVALID				0x0505
#define CNF_ERROR_FOIP_LIM_INVALID				0x0506
#define CNF_ERROR_FOIP_PACKINT_SIZE				0x0507
#define CNF_ERROR_FOIP_PACKINT_GRANULARITY			0x0508
#define CNF_ERROR_FOIP_DATAGRAM_SZ				0x0509
#define CNF_ERROR_FOIP_FEC_NOT_SUPPORTED			0x050A
#define CNF_ERROR_FOIP_INVALID_FOIPORTP_DISABLED		0x050B
#define CNF_ERROR_TDMoPOS_REGISTRATION				0x0550
#define CNF_ERROR_TDMoPOS_LAYER_DOWN				0x0551
#define CNF_ERROR_TDMoPOS_LEN_MSG				0x0552
#define CNF_ERROR_TDMoPOS_DEREGISTRATION			0x0553
#define CNF_ERROR_TDMoPOS_WRONG_PARAMETER			0x0554
#define CNF_ERROR_TDMoPOS_UNKNOWN_FUNC				0x0555
#define CNF_ERROR_TDMoPOS_VOICE_INACTIVE			0x0556
#define CNF_ERROR_TDMoPOS_TONEOFF				0x0557
#define CNF_ERROR_TDMoPOS_CADENCE				0x0558
#define CNF_ERROR_TDMoPOS_FREQ					0x0559
#define CNF_ERROR_TDMoPOS_TONEGEN				0x055A
#define CNF_ERROR_TDMoPOS_GAIN					0x055B
#define CNF_ERROR_TDMoPOS_TAILLEN				0x055C
#define CNF_ERROR_TDMoPOS_VoIP_ALREADYUSED			0x055D
#define CNF_ERROR_AAL5OPT					0x0602
#define CNF_ERROR_AAL5OPT_CLIENT_DESCRIPTOR			0x0603
#define CNF_ERROR_AAL5OPT_AAL5_REG_SERVICE_DOWN			0x0604
#define CNF_ERROR_AAL5OPT_AAL5_REG_MAX_CLIENTS			0x0605
#define CNF_ERROR_AAL5OPT_AAL5_REG_ALLOC_CLIENT			0x0606
#define CNF_ERROR_AAL5OPT_AAL5_REG_ATM_REGISTRATION		0x0607
#define CNF_ERROR_AAL5OPT_AAL5_REG_RFC_ENCAP			0x0608
#define CNF_ERROR_AAL5OPT_AAL5_DEREG_SERVICE_DOWN		0x0609
#define CNF_ERROR_AAL5OPT_AAL5_DEREG_NO_REGISTERED_CLIENT	0x060A
#define CNF_ERROR_AAL5OPT_AAL5_DEREG_CLIENT_NOT_FOUND		0x060B
#define CNF_ERROR_AAL5OPT_INIT					0x060C
#define CNF_ERROR_AAL5OPT_ARM0					0x060D
#define CNF_ERROR_AAL5OPT_DESCRIPTOR				0x060E
#define CNF_ERROR_AAL5OPT_DEVICEDESC				0x060F
#define CNF_ERROR_AAL5_INVALID_PROTOCOL				0x0610
#define CNF_ERROR_AAL5_INVALID_QOS				0x0611
#define CNF_ERROR_AAL5_DESCRIPTOR_UNAVAILABLE			0x0612
#define CNF_ERROR_AAL5_IVNALID_ATMADDRESS			0x0613
#define CNF_ERROR_CIPHER_ALGO_NOT_DEFINED			0x0702
#define CNF_ERROR_CIPHER_BAD_KEY_SIZE				0x0703
#define CNF_ERROR_CIPHER_ERROR1					0x0704
#define CNF_ERROR_CIPHER_ERROR2					0x0705
#define CNF_ERROR_CIPHER_BAD_MODE				0x0706
#define CNF_ERROR_CIPHER_BAD_PADDING_METHOD			0x0707
#define CNF_ERROR_CIPHER_BAD_MAC_KEY_SIZE			0x0708
#define CNF_ERROR_CIPHER_BAD_PACKETCABLE_MODE			0x0709
#define CNF_ERROR_CIPHER_NOT_IMPLEMENTED			0x070A
#define CNF_ERROR_CIPHER_BAD_FIFO_LENGTH			0x070B
#define CNF_ERROR_CIPHER_DSPLIB					0x070C
#define CNF_ERROR_AUTHENTICATION_BAD_PACKETCABLE_MODE		0x070D
#define CNF_ERROR_CIPHER_ALLOC					0x070E
#define CNF_ERROR_AUTHENTICATION_ALLOC				0x070F
#define CNF_ERROR_CIPHER_BAD_CIPHER_LAYER			0x0710
#define CNF_ERROR_AUTHENTICATION_BAD_HASHING_FUNCTION		0x0711
#define CNF_ERROR_AUTHENTICATION_BAD_MAC_SIZE			0x0712
#define CNF_ERROR_CIPHER_KEY_SCHEDULED				0x0713
#define CNF_ERROR_CIPHER_REDUNDANCY				0x0714
#define CNF_ERROR_CIPHER_NOT_ENABLED				0x0715
#define CNF_ERROR_CIPHER_DTMF_RC4				0x0716
#define CNF_ERROR_CIPHER_PKTCABLE_INVALID_COMBINATION1		0x0717
#define CNF_ERROR_CIPHER_PKTCABLE_INVALID_COMBINATION2		0x0718
#define CNF_ERROR_CIPHER_PKTCABLE_INVALID_COMBINATION3		0x0719
#define CNF_ERROR_CIPHER_PKTCABLE_INVALID_COMBINATION4		0x071A
#define CNF_ERROR_CIPHER_PKTCABLE_INVALID_COMBINATION5		0x071B
#define CNF_ERROR_CIPHER_SRTP					0x0750
#define CNF_ERROR_CIPHER_SRTP_BAD_DIRECTION_CONFIGURATION	0x0751
#define CNF_ERROR_CIPHER_SRTP_BAD_KEY_MATERIAL			0x0752
#define CNF_ERROR_CIPHER_SRTP_BAD_ENCRYPT			0x0753
#define CNF_ERROR_CIPHER_SRTP_BAD_AUTH				0x0754
#define CNF_ERROR_CIPHER_SRTP_BAD_FROM_TO			0x0755
#define CNF_ERROR_CIPHER_SRTP_BAD_KEY_DERIV			0x0756
#define CNF_ERROR_CIPHER_SRTP_BAD_MKI_LENGTH			0x0757
#define CNF_ERROR_CIPHER_SRTP_BAD_MASTER_KEY_SIZE		0x0758
#define CNF_ERROR_CIPHER_SRTP_BAD_ENCRYPT_KEY_SIZE		0x0759
#define CNF_ERROR_CIPHER_SRTP_BAD_MASTER_SALT_KEY_SIZE		0x075A
#define CNF_ERROR_CIPHER_SRTP_BAD_SALT_KEY_SIZE			0x075B
#define CNF_ERROR_CIPHER_SRTP_BAD_AUTH_KEY_SIZE			0x075C
#define CNF_ERROR_CIPHER_SRTP_BAD_AUTH_TAG_SIZE			0x075D
#define CNF_ERROR_CIPHER_SRTP_BAD_AUTH_PREF_SIZE		0x075E
#define CNF_ERROR_CIPHER_SRTP_BAD_SRTP_MAX_LIFETIME		0x075F
#define CNF_ERROR_CIPHER_SRTP_BAD_SRTCP_MAX_LIFETIME		0x0760
#define CNF_ERROR_CIPHER_SRTP_BAD_FROM_TO_INDEX			0x0761
#define CNF_ERROR_CIPHER_SRTP_DERIVATION_NULL			0x0762
#define CNF_ERROR_CIPHER_REPLAY_OLD				0x0763
#define CNF_ERROR_CIPHER_REPLAY_FAIL				0x0764
#define CNF_ERROR_CIPHER_SRTP_AUTH_PRE_PROCESS			0x0765
#define CNF_ERROR_CIPHER_SRTP_MASTER_KEY_REKEYING		0x0766
#define CNF_ERROR_CIPHER_SRTP_NOT_WAITING_MASTER_KEY		0x0767
#define CNF_ERROR_CIPHER_SRTP_BAD_MKI				0x0768
#define CNF_ERROR_DESTROY_INVALID_CHAN				0x0800
#define CNF_ERROR_DESTROY_ACTIVE_CHAN				0x0801
#define CNF_ERROR_DESTROY_ANNSRV_CHAN				0x0802
#define CNF_ERROR_DESTROY_C2C_CHAN				0x0803
#define CNF_ERROR_IUUP_UNSPEC					0x0901
#define CNF_ERROR_IUUP_INIT_RFCI_INCORRECT			0x0902
#define CNF_ERROR_IUUP_INIT_PDU_INCORRECT			0x0903
#define CNF_ERROR_IUUP_INIT_MV_NOTSUPPORTED			0x0904
#define CNF_ERROR_IUUP_INIT_SDU_SIZE_INCORRECT			0x0905
#define CNF_ERROR_IUUP_RATE_NUM_RFCI_INCORRECT			0x0906
#define CNF_ERROR_IUUP_RATE_RFCI_NOT_ENABLE			0x0907
#define CNF_ERROR_IUUP_TA_NOT_POSSIBLE				0x0908
#define CNF_ERROR_IUUP_TA_NOT_SUPPORTED				0x0909
#define CNF_ERROR_IUUP_SVC_MV_INCORRECT				0x090A
#define CNF_ERROR_IUUP_PROCEDURE_ACTIVE				0x090B
#define CNF_ERROR_IUUP_LENGTH_TOO_BIG				0x090C
#define CNF_ERROR_IUUP_NOT_UP					0x090D
#define CNF_ERROR_IUUP_MODE_SWITCH_NOT_SUPPORTED		0x090E
#define CNF_ERROR_IUUP_NOT_SUPPORTED_BY_MODE			0x090F
#define CNF_ERROR_IUUP_NOT_CAPABLE_IN_THIS_STATE		0x0910
#define CNF_ERROR_IUUP_OPTIONS_CONFLICT				0x0911
#define CNF_ERROR_TFO_UNSPEC					0x0981
#define CNF_ERROR_TFO_NO_MEM					0x0982
#define CNF_ERROR_TFO_QUEUE_FULL				0x0983
#define CNF_ERROR_TFO_QUEUE_EMPTY				0x0984
#define CNF_ERROR_TFO_EXIST					0x0985
#define CNF_ERROR_TFO_NOT_CREATED				0x0986
#define CNF_ERROR_TFO_NO_ACCESS					0x0987
#define CNF_ERROR_TFO_LENGTH_INCORRECT				0x0988
#define CNF_ERROR_SET_ETH_UNK_ID				0x0A00
#define CNF_ERROR_SET_ETH_TOO_SHORT				0x0A01
#define CNF_ERROR_SET_RTO_UNK_OPCODE				0x0A02
#define CNF_ERROR_SET_RTO_UNK_ACTIVE				0x0A03
#define CNF_ERROR_ARP_NO_ETH_LAYER				0x0A04
#define CNF_ERROR_CSME_MCP_ACTIVE				0x0A05
#define CNF_ERROR_CSME_MCP_REG_NO_IPLAYER			0x0A06
#define CNF_ERROR_CSME_MCP_REG_NO_LOWERLAYER			0x0A07
#define CNF_ERROR_CSME_MCP_REG_NO_MORECLIENTS			0x0A08
#define CNF_ERROR_CSME_MCP_REG_DUPLICATION			0x0A09
#define CNF_ERROR_CSME_MCP_NO_ETH				0x0A0B
#define CNF_ERROR_CSME_MRDT_ACTIVE				0x0A0C
#define CNF_ERROR_CSME_MRDT_REGISSUE_INDEX			0x0A0D
#define CNF_ERROR_CSME_MRDT_REG_NO_LOWERLAYER			0x0A0E
#define CNF_ERROR_CSME_MRDT_REG_NO_MORECLIENTS			0x0A0F
#define CNF_ERROR_CSME_MRDT_REG_DUPLICATION			0x0A10
#define CNF_ERROR_CSME_MRDT_NO_ETH				0x0A12
#define CNF_ERROR_CSME_UNK_OPCODE				0x0A13
#define CNF_ERROR_SPECIALPKT_HANDLING_TOOMANY			0x0A15
#define CNF_ERROR_ARP_CHAGALL					0x0A16
#define CNF_ERROR_ARP_MSG_LEN					0x0A17
#define CNF_ERROR_CSME_NO_CONTEXT				0x0A18
#define CNF_ERROR_ETH_CLIENT_INUSE				0x0A19
#define CNF_ERROR_ETH_CLIENT_CANTREG				0x0A1A
#define CNF_ERROR_ETH_CLIENT_CANTCHANGE				0x0A1B
#define CNF_ERROR_ETH_NO_CONTEXT				0x0A1C
#define CNF_ERROR_IPV4_NO_CONTEXT				0x0A1D
#define CNF_ERROR_VCID_NO_CONTEXT				0x0A1E
#define CNF_ERROR_ETH_CHAN_REG_ISSUE				0x0A1F
#define CNF_ERROR_ETH_NO_HANDLE					0x0A20
#define CNF_ERROR_CHAN_MAC_NE_DEVICE				0x0A21
#define CNF_ERROR_WRONG_PACKET_TYPE				0x0A22
#define CNF_ERROR_SPECIALPKT_NO_MEM				0x0A24
#define CNF_ERROR_BAD_FRAME_SIZE				0x0A25
#define CNF_ERROR_AAL5_IPv4_NOT_REG				0x0A26
#define CNF_ERROR_CSME_ODIAG_REGISSUE_INDEX			0x0A30
#define CNF_ERROR_CSME_ODIAG_REG_NO_LOWERLAYER			0x0A31
#define CNF_ERROR_CSME_ODIAG_REG_NO_MORECLIENTS			0x0A32
#define CNF_ERROR_CSME_ODIAG_REG_DUPLICATION			0x0A33
#define CNF_ERROR_CSME_MEDIA_NO_ETH				0x0A34
#define CNF_ERROR_MII_MODE					0x0A50
#define CNF_ERROR_MII_SELECTION_NOT_AVAILABLE			0x0A51
#define CNF_ERROR_MULTICAST_ETH_ADDR_INCORRECT			0x0A60
#define CNF_ERROR_MULTICAST_ETH_MAX_NUM				0x0A61
#define CNF_ERROR_MULTICAST_ETH_ALREADY_PROGRAMMED		0x0A62
#define CNF_ERROR_MULTICAST_ETH_NOT_PROGRAMMED			0x0A63
#define CNF_ERROR_MULTICAST_ETH_ERROR				0x0A64
#define CNF_ERROR_MULTICAST_IP_ADDR_INCORRECT			0x0A65
#define CNF_ERROR_MULTICAST_IP_MAX_NUM				0x0A66
#define CNF_ERROR_MULTICAST_IP_NOT_PROGRAMMED			0x0A67
#define CNF_ERROR_MULTICAST_IP_ERROR				0x0A68
#define CNF_ERROR_MULTICAST_IP_CHANNEL_NOT_DISABLED		0x0A69
#define CNF_ERROR_MULTICAST_IP_CHANNEL_IN_OTHER_GROUP		0x0A6A
#define CNF_ERROR_ETH_MAC_ADDR_MAX_REGISTERED			0x0A70
#define CNF_ERROR_ETH_MAC_ADDR_ALREADY_REGISTERED		0x0A71
#define CNF_ERROR_ETH_MAC_ADDR_NOT_REGISTERED			0x0A72
#define CNF_ERROR_ETH_MAC_ADDR_REGISTER_FAILED			0x0A73
#define CNF_ERROR_ETH_MAC_ADDR_UNREGISTER_FAILED		0x0A74
#define CNF_ERROR_PKTFWD_NO_CONTEXT				0x0A75
#define CNF_ERROR_PKTFWD_PARAM					0x0A76
#define CNF_ERROR_PKTFWD_NULLPTR				0x0A77
#define CNF_ERROR_PKTFWD_NULL_CLIENT				0x0A78
#define CNF_ERROR_PKTFWD_FULL_TABLE				0x0A79
#define CNF_ERROR_PKTFWD_NO_ITEM				0x0A7A
#define CNF_ERROR_PKTFWD_STATUS					0x0A7B
#define CNF_ERROR_PKTFWD_OVER_QUERY				0x0A7C
#define CNF_ERROR_PKTFWD_INIT_CONTEXT				0x0A7D
#define CNF_ERROR_PKTFWD_DEVICE_INVALID				0x0A7E
#define CNF_ERROR_VLAN_DISPATCH_NOT_ENABLED			0x0A80
#define CNF_ERROR_VLAN_TABLE_NOT_DEFINED			0x0A81
#define CNF_ERROR_VLAN_DIFF_NOT_SUPPORTED			0x0A82
#define CNF_ERROR_PPPOE_NO_IPv4_LAYER				0x0A90
#define CNF_ERROR_PPPOE_NO_IPv6_LAYER				0x0A91
#define CNF_ERROR_PPPOE_LAYER_ALREADY_EXISTS			0x0A92
#define CNF_ERROR_PPPOE_HDR_LENGTH_FIELD			0x0A93
#define CNF_ERROR_PPPOE_REG_ETH_NO_HANDLE			0x0A94
#define CNF_ERROR_PPPoE_REG_ETH_NO_HDR				0x0A95
#define CNF_ERROR_PPPOE_DEREGISTRATION				0x0A9A
#define CNF_ERROR_PPPoE_DEREG_ETH_NO_HANDLE			0x0A9B
#define CNF_ERROR_PPPoE_DEREG_ETH_NO_HDR			0x0A9C
#define CNF_ERROR_PPPOE_LAYER_DOESNOT_EXIST			0x0A9F
#define CNF_ERROR_ICMP_NO_IP_LAYER				0x0B00
#define CNF_ERROR_ICMP_BADTTL					0x0B01
#define CNF_ERROR_IP_ADDRESS_NO_IP_LAYER			0x0B02
#define CNF_ERROR_IP_ADDRESS_BAD_IP_ADDRESS			0x0B03
#define CNF_ERROR_IP_ADDRESS_IPCLIENT_REG			0x0B04
#define CNF_ERROR_SET_IP_UNKSERVICEID				0x0B05
#define CNF_ERROR_SET_IP_TOOSHORT				0x0B06
#define CNF_ERROR_SET_IP_IPADDRESS_NOTSET			0x0B07
#define CNF_ERROR_SET_IP_BADHEADER				0x0B08
#define CNF_ERROR_SET_IP_BADTTL					0x0B09
#define CNF_ERROR_SET_IP_UNKPROT				0x0B0A
#define CNF_ERROR_SET_IP_ODDRTP_PORT				0x0B0B
#define CNF_ERROR_SET_IP_REGISSUE_RTP_INDEX			0x0B0C
#define CNF_ERROR_SET_IP_REG_RTP_NO_LOWERLAYER			0x0B0D
#define CNF_ERROR_SET_IP_REG_RTP_NO_MORECLIENTS			0x0B0E
#define CNF_ERROR_SET_IP_REG_RTP_DUPLICATION			0x0B0F
#define CNF_ERROR_SET_IP_EVENRTCP_PORT				0x0B11
#define CNF_ERROR_SET_IP_REG_RTCP_NO_IPLAYER			0x0B12
#define CNF_ERROR_SET_IP_REG_RTCP_NO_LOWERLAYER			0x0B13
#define CNF_ERROR_SET_IP_REG_RTCP_NO_MORECLIENTS		0x0B14
#define CNF_ERROR_SET_IP_REG_RTCP_DUPLICATION			0x0B15
#define CNF_ERROR_SET_IP_REG_FOIP_NO_IPLAYER			0x0B16
#define CNF_ERROR_SET_IP_REG_FOIP_NO_LOWERLAYER			0x0B17
#define CNF_ERROR_SET_IP_REG_FOIP_NO_MORECLIENTS		0x0B18
#define CNF_ERROR_SET_IP_REG_FOIP_DUPLICATION			0x0B19
#define CNF_ERROR_COMMAND_NEEDS_VOPENA_RTP			0x0B1A
#define CNF_ERROR_COMMAND_NEEDS_VOPENA_SIGNAL			0x0B1B
#define CNF_ERROR_SS7COT_ERROR					0x0B1C
#define CNF_ERROR_CND_DATA_INVALID				0x0B1D
#define CNF_ERROR_NOT_MAX_INFO_COUNT				0x0B1E
#define CNF_ERROR_ATM_SERVICE_SUCCESS				0x0C01
#define CNF_ERROR_ATM_SERVICE_ERROR				0x0C02
#define CNF_ERROR_ATM_SERVICE_BW_EXCEEDED			0x0C03
#define CNF_ERROR_ATM_SERVICE_VPI_OUT_OF_RANGE			0x0C04
#define CNF_ERROR_ATM_SERVICE_VCI_OUT_OF_RANGE			0x0C05
#define CNF_ERROR_ATM_SERVICE_VPCI_NB_NOT_P2			0x0C06
#define CNF_ERROR_ATM_SERVICE_VPCI_NB_OUT_OF_RANGE		0x0C07
#define CNF_ERROR_ATM_SERVICE_HANDLE_NOT_REGISTERED		0x0C08
#define CNF_ERROR_ATM_SERVICE_NO_VCC_TOS			0x0C09
#define CNF_ERROR_ATM_SERVICE_CONFIG_NOT_ALLOWED		0x0C0A
#define CNF_ERROR_ATM_SERVICE_ETH_DOWN				0x0C0B
#define CNF_ERROR_ATM_SERVICE_SLAVE_MODE_ONLY			0x0C0C
#define CNF_ERROR_ATM_SERVICE_CANNOT_ALLOC			0x0C0D
#define CNF_ERROR_ATM_MSG_LEN					0x0C0E
#define CNF_ERROR_ATM_UNKNOWN_FUNC				0x0C0F
#define CNF_ERROR_ATM_NO_UTP					0x0C10
#define CNF_ERROR_ATM_NOT_SUPPORTED				0x0C11
#define CNF_ERROR_ATM_MEMORY					0x0C12
#define CNF_ERROR_ATM_CELL_NOT_SENT				0x0C13
#define CNF_ERROR_NOT_LGESSIG					0x0C14
#define CNF_ERROR_ATM_LAYER_NOT_CONFIGURED			0x0C15
#define CNF_ERROR_ATM_REDIRECT					0x0C20
#define CNF_ERROR_ATM_REDIRECT_NO_CLIENT			0x0C21
#define CNF_ERROR_ATM_REDIRECT_TYPE_INCORRECT			0x0C22
#define CNF_ERROR_ATM_REDIRECT_TYPE_CHANGE_ON_FLY		0x0C23
#define CNF_ERROR_ATM_REDIRECT_NOT_INITIATED			0x0C24
#define CNF_ERROR_PUI_MSG_LEN					0x0D00
#define CNF_ERROR_PUI_NOT_INITIALIZED				0x0D01
#define CNF_ERROR_PUI_MODE_NOT_SET				0x0D02
#define CNF_ERROR_PUI_CONFIGURED				0x0D03
#define CNF_ERROR_PUI_DATABUSW					0x0D04
#define CNF_ERROR_PUI_HANDSHAKE					0x0D05
#define CNF_ERROR_PUI_NUM_ROUTING_TAGS				0x0D06
#define CNF_ERROR_PUI_ROUTING_TAGS_ODD				0x0D07
#define CNF_ERROR_PUI_STRAPCONFIG				0x0D08
#define CNF_ERROR_PUI_NON_SYMETRIC_ADDRESS			0x0D09
#define CNF_ERROR_PUI_INVALID_PHY_ADDRESS			0x0D0A
#define CNF_ERROR_PUI_UNKNOWN_MODE				0x0D0B
#define CNF_ERROR_OPTIPHY_LEN					0x0D0C
#define CNF_ERROR_OPTIPHY_INIT					0x0D0D
#define CNF_ERROR_OPTIPHY_CFG					0x0D0E
#define CNF_ERROR_OPTIPHY_LOOPBACK				0x0D0F
#define CNF_ERROR_POS_CLIENT_INIT				0x0D10
#define CNF_ERROR_POS_CLIENT_CANT_DEREG				0x0D11
#define CNF_ERR_CONF_MAXNO_CREATED				0x0E00
#define CNF_ERR_CONF_INVALID_CPU				0x0E01
#define CNF_ERR_CONF_DESTROY_CONF_FAILED			0x0E02
#define CNF_ERR_CONF_INVALID_CMD_LEN				0x0E03
#define CNF_ERR_CONF_INVALID_PART_TYPE				0x0E04
#define CNF_ERR_CONF_VALIDITY_CHECK_FAILED			0x0E05
#define CNF_ERR_CONF_DELETE_PART_FAILED				0x0E06
#define CNF_ERR_CONF_NO_MIXER					0x0E07
#define CNF_ERR_CONF_MUTE_PART_FAILED				0x0E08
#define CNF_ERR_CONF_HOLD_PART_FAILED				0x0E09
#define CNF_ERR_CONF_NO_MORE_CHANS				0x0E0A
#define CNF_ERR_CONF_NOT_SAME_CPU				0x0E0B
#define CNF_ERR_CONF_MAXNO_PARTS_CREATED			0x0E0C
#define CNF_ERR_CONF_MAX_RSP_SLOTS				0x0E0D
#define CNF_ERR_CONF_INCORRECT_FRAME_SIZE			0x0E0E
#define CNF_ERR_CONF_NO_MUTE					0x0E0F
#define CNF_ERR_CONF_NO_HOLD					0x0E10
#define CNF_ERR_CONF_NO_DESTROY					0x0E11
#define CNF_ERR_CONF_CMD_INVALID_FOR_LSP			0x0E12
#define CNF_ERR_CONF_CMD_INVALID_FOR_RSP			0x0E13
#define CNF_ERR_CONF_CMD_DESTROY_INVALID_FOR_CONF		0x0E14
#define CNF_ERR_CONF_CMD_NONZERO_PARTICIPANTS			0x0E15
#define CNF_ERR_CONF_CMD_DOMTALK_INVALID_FOR_MIRO		0x0E16
#define CNF_ERR_CONF_CMD_SPECIFY_DOMTALK_FAILED			0x0E17
#define CNF_ERR_CONF_CMD_DOMTALK_NOT_SUPPORTED			0x0E18
#define CNF_ERR_CONF_CMD_DOMTALK_PARAM_INVALID_VALUE		0x0E19
#define CNF_ERR_CONF_CMD_NSC_RSP_NOT_ALLOWED			0x0E1A
#define CNF_ERR_CONF_CMD_NSC_LSP_NOT_SAME_BUS			0x0E1B
#define CNF_ERR_CONF_CMD_NSC_NOT_SUPPORTED			0x0E1C
#define CNF_ERR_CONF_CMD_NSC_PARAM_INVALID_VALUE		0x0E1D
#define CNF_ERR_CONF_CMD_NSC_NONZERO_CONFS			0x0E1E
#define CNF_ERR_CONF_CMD_NSC_DGAIN_PART_FAILED			0x0E1F
#define CNF_ERR_CONF_CMD_NSC_NO_DGAIN				0x0E20
#define CNF_ERR_CONF_CMD_NSC_INVALID_FOR_MIRO			0x0E21
#define CNF_ERR_CONF_CMD_INVALID_FOR_RSP_WTC			0x0E22
#define CNF_ERR_CONF_CMD_NSC_MAX_WTC_CREATED			0x0E23
#define CNF_ERR_INVALID_FOR_CT_TONEGEN				0x0E24
#define CNF_ERR_INVALID_FOR_CT_TONEDET				0x0E25
#define CNF_ERR_CNF_NOT_TRANSCODING				0x0E26
#define CNF_ERR_CONF_HOLD_SRC_ALREADY_ON_ANNOUNCEMENT_HOLD	0x0E27
#define CNF_ERR_CONF_CMD_INVALID_FOR_IPV6			0x0E28
#define CNF_ERR_ANNC_INVALID_CODECID				0x0EA0
#define CNF_ERR_ANNC_CURR_MODE					0x0EA1
#define CNF_ERR_ANNC_INVALID_DEST				0x0EA2
#define CNF_ERR_ANNC_INVALID_SRC				0x0EA3
#define CNF_ERR_ANNC_PARAM3_INVALID				0x0EA4
#define CNF_ERR_PLAYBACK_FILE_IN_USE				0x0EF0
#define CNF_ERR_PLAYBACK_CHANGE_TYPE				0x0EF1
#define CNF_ERR_AGC_INVALID_FOR_MIRO				0x0F00
#define CNF_ERR_AGC_NOT_SUPPORTED				0x0F01
#define CNF_ERR_AGC_PARAM_INVALID_VALUE				0x0F02
#define CNF_ERR_SNS_INVALID_FOR_MIRO				0x0F03
#define CNF_ERR_SNS_NOT_SUPPORTED				0x0F04
#define CNF_ERR_SNS_PARAM_INVALID_VALUE				0x0F05
#define CNF_ERR_AEC_CODEC_NOT_SUPPORTED				0x0F07
#define CNF_ERR_NC_CODEC_NOT_SUPPORTED				0x0F08
#define CNF_ERR_NC_NLC_ENABLE_ERROR				0x0F09
#define CNF_ERR_DPNS_CODEC_NOT_SUPPORTED			0x0F0A
#define CNF_ERR_DTX_CODEC_NOT_SUPPORTED				0x0F0B
#define IPRDRCT_SUCCESS						0x1000
#define CNF_ERROR_SET_L3					0x1003
#define CNF_ERROR_SET_L3_TOOSHORT				0x1004
#define CNF_ERROR_SET_L3_IPADDRESS_NOTSET			0x1005
#define CNF_ERROR_SET_L3_BADHEADER				0x1006
#define CNF_ERROR_SET_L3_BADTTL					0x1007
#define CNF_ERROR_SET_L3_UNKPROT				0x1008
#define CNF_ERROR_INIT_SESSION					0x1009
#define CNF_ERROR_SET_L2HDR					0x100A
#define CNF_ERROR_IPRDRCT_NOSPRT				0x100B
#define IPRDRCT_REG_DUPLICATION					0x100C
#define IPRDRCT_REG_NOMORECLIENTS				0x100D
#define IPRDRCT_REG_NO_IP_LAYER					0x100E
#define IPRDRCT_REG_NO_ETH_LAYER				0x100F
#define IPRDRCT_FORK_NO_CONTEXT					0x1010
#define CNF_ERROR_HTDMDRV_INVALID_PORT_ID			0x1100
#define CNF_ERROR_HTDMDRV_PORT_NOT_AVAILABLE			0x1101
#define CNF_ERROR_HTDMDRV_INVALID_LINK_ID			0x1102
#define CNF_ERROR_HTDMDRV_LINK_ID_IN_USE			0x1103
#define CNF_ERROR_HTDMDRV_INVALID_LINK_LENGTH			0x1104
#define CNF_ERROR_HTDMDRV_INVALID_TIMESLOTS			0x1105
#define CNF_ERROR_HTDMDRV_TIMESLOTS_IN_USE			0x1106
#define CNF_ERROR_HTDMDRV_INVALID_HDR_LENGTH			0x1107
#define CNF_ERROR_HTDMDRV_INVALID_CRC_MODE			0x1108
#define CNF_ERROR_HTDMDRV_LINK_ID_NOT_IN_USE			0x1110
#define CNF_ERROR_HTDMDRV_UNSUPPORTED_CHANNEL_TYPE		0x1111
#define CNF_ERROR_HTDMDRV_INVALID_CMD_LENGTH			0x1120
#define CNF_ERROR_HTDMDRV_INVALID_LATENCY			0x1121
#define CNF_ERROR_HTDMDRV_INVALID_PACKET_SIZE			0x1122
#define CNF_ERR_REDUND_INTERNAL_PARAM				0x1200
#define CNF_ERR_REDUND_BAD_OPT_FOR_MODE				0x1201
#define CNF_ERR_REDUND_DEVICE_NOT_FOUND				0x1202
#define CNF_ERR_REDUND_ALREADY_ACTIVE				0x1203
#define CNF_ERR_REDUND_BAD_MODE_FOR_CMD				0x1204
#define CNF_ERR_REDUND_TOO_MANY_DEVS				0x1205
#define CNF_ERR_REDUND_NO_CHAN_ON_STBY				0x1206
#define CNF_ERR_REDUND_ONLY_ONE_STBY				0x1207
#define CNF_ERR_REDUND_UNKNOWN_OPTION				0x1208
#define CNF_ERR_REDUND_SUCCESS_CHANID				0x1209
#define CNF_ERR_REDUND_CANT_DELETE_SELF				0x120A
#define CNF_ERR_REDUND_CMD_NOT_FOR_SELF				0x120B
#define CNF_ERR_REDUND_BAD_SERIAL_NO				0x120C
#define CNF_ERR_REDUND_AUDIT_MISMATCH				0x120D
#define CNF_ERR_REDUND_ALREADY_DOING				0x120E
#define CNF_ERR_REDUND_MODE_FOR_SHADOWED			0x120F
#define CNF_ERR_REDUND_NOTASK					0x1210
#define CNF_ERR_REDUND_CHAN_UNUSED				0x1211
#define CNF_ERR_REDUND_NEED_32MBYTES				0x1212
#define CNF_ERR_REDUND_ILLEGAL_DEV				0x1213
#define CNF_ERR_REDUND_ODD_STATE				0x1214
#define CMDDATA_CNF_ERR_C2C_INVALID_CHAN_IDS			0x1300
#define CMDDATA_CNF_ERR_C2C_INVALID_CHAN_TYPE_CONNECTION	0x1301
#define CMDDATA_CNF_ERR_C2C_INVALID_CODEC_TYPE_CONNECTION	0x1302
#define CMDDATA_CNF_ERR_C2C_EXCEED_MAX_CONNECTIONS		0x1303
#define CMDDATA_CNF_ERR_C2C_FAILURE_TO_CONNECT			0x1304
#define CMDDATA_CNF_ERR_C2C_UNSUPPORTED_MODE			0x1305
#define CMDDATA_CNF_ERR_C2C_SERVICE_CFG_FAILURE			0x1306
#define CMDDATA_CNF_ERR_C2C_FAILURE_TO_DISCONNECT		0x1307
#define CMDDATA_CNF_ERR_C2C_INVALID_VOPENA_STATE		0x1308
#define CMDDATA_CNF_ERR_C2C_DISABLE_FAILURE			0x1309
#define CMDDATA_CNF_ERR_C2C_VOPENA_CONNECT_ERROR		0x1310
#define CMDDATA_CNF_ERR_C2C_CONNECTIONS_EXIST			0x1311
#define CMDDATA_CNF_ERR_C2C_INVALID_CHAN_CONFIG_CONNECTION	0x1312
#define CMDDATA_CNF_ERR_C2C_UNEXPECTED_ERROR			0x1313
#define CMDDATA_CNF_ERR_C2C_CONNECTIONS_NONEXIST		0x1314
#define CMDDATA_CNF_ERR_C2C_NO_CONNECTION_CONTEXT		0x1315
#define CMDDATA_CNF_ERR_C2C_INVALID_OPERATION			0x1316
#define CNF_ERR_SELECTNIF_MAX_VALUE				0x1400
#define CNF_ERROR_NIF_INIT					0x1401
#define CNF_ERROR_PL_MAX_RULES					0x1402
#define CNF_ERROR_PL_MAX_PROTO					0x1403
#define CNF_ERROR_PL_INVALID_ACTION				0x1404
#define CNF_ERROR_PL_INVALID_DESTINATION			0x1405
#define CNF_ERROR_VID_INVALID					0x1406
#define CNF_ERROR_PORT_INIT					0x1407
#define CNF_ERROR_PORT_ALLOC					0x1408
#define CNF_ERROR_PORT_VALUE					0x1409
#define CNF_ERROR_PORT_INITIALIZED				0x140A
#define CNF_ERROR_PORT_NOT_INITIALIZED				0x140B
#define CNF_ERROR_PORT_INVALID					0x140C
#define CNF_ERROR_PORT_VIRTUAL					0x140D
#define CNF_ERROR_PORT_NULL					0x140E
#define CNF_ERROR_PORT_NOT_FREE					0x140F
#define CNF_ERROR_NIF_ALLOC					0x1410
#define CNF_ERROR_NIF_NOT_INITIALIZED				0x1411
#define CNF_ERROR_NIF_NOT_SELECTED				0x1412
#define CNF_ERROR_CONTEXT_NULL					0x1413
#define CNF_ERROR_DESTINATION_NULL				0x1414
#define CNF_ERROR_PKT_NULL					0x1415
#define CNF_ERROR_CONTEXT_ALREADY_INITIALIZED			0x1416
#define CNF_ERROR_TM_ACTION_ERROR				0x1417
#define CNF_ERROR_TM_NIF_NOT_ENABLE				0x1418
#define CNF_ERROR_TM_INCORRECT_PKT_RATE				0x1419
#define CNF_ERROR_TM_OUT_OF_PKT_RATE				0x141A
#define CNF_ERROR_TM_NIF_NOT_FOUND				0x141B
#define CNF_ERROR_TM_NIF_LIST_FULL				0x141C
#define CNF_ERROR_TM_NOT_POSSIBLE				0x141D
#define CNF_ERROR_NIF_NOT_FREE					0x1420
#define CNF_ERROR_VWD_INDEX_NOT_FREE				0x1421
#define CNF_ERROR_NO_LPP_LAYER					0x1500
#define CNF_ERROR_CUSTOMER_ID					0x1501
#define CNF_ERR_SIG_FEATURE_NOT_SUPPORTED			0x2500
#define CNF_ERR_SIG_FEATURE_DISABLED				0x2501
#define CNF_ERR_TSB_TS_ACTIVE_NOT_MONITORED			0x2502
#define CNF_ERR_TSB_TS_NO_MONITOR				0x2503
#define CNF_ERR_TSB_NO_MEMORY					0x2504
#define CNF_ERR_ATM_MON_ACTIVE_NOT_MONITORED			0x2505
#define CNF_ERR_ATM_MON_NO_MONITOR				0x2506
#define CNF_ERR_ATM_MON_VCC_IS_USED_BY_NONAAL2			0x2507
#define CNF_ERR_ATM_MON_NO_MEMORY_ATM_M				0x2508
#define CNF_ERR_ATM_MON_NO_MEMORY_CID_M				0x2509
#define CNF_ERR_ATM_MON_ATM_LAYER_REG				0x250A
#define CNF_ERR_ATM_ACT_SIG_NOT_CONFIGURED			0x250B
#define CNF_ERR_ATM_ACT_SIG_NOT_PERMITED			0x250C
#define CNF_ERR_ATM_ACT_AAL2_SIG_NOT_CONFIGURED			0x250D
#define CNF_ERR_ATM_ACT_TDM_SIG_NOT_CONFIGURED			0x250E
#define CNF_ERR_IP_MON_ACTIVE_NOT_MONITORED			0x250F
#define CNF_ERR_IP_MON_NO_MONITOR				0x2510
#define CNF_ERR_IP_MON_NO_MEMORY_IP_M				0x2511
#define CNF_ERR_IP_ACT_SIG_NOT_CONFIGURED			0x2512
#define CNF_ERR_IP_ACT_SIG_NOT_PERMITED				0x2513
#define CNF_ERR_IP_MON_IP_LAYER_REG				0x2514
#define CNF_ERR_ATM_MON_INVALID_GEN_WITH_RT			0x2520
#define CNF_ERR_INTF_NOT_SUPPORTED				0x2540
#define CNF_ERR_INVALID_BITS_TO_LOCK				0x2541
#define CNF_ERR_INVALID_API_PARAM1				0x2542
#define CNF_ERR_T38_SWITCH_NOT_SUPPORTED			0x2580
#define CNF_ERR_INVALID_VBD_PT					0x2581
#define CNF_ERR_INVALID_JITTER_BUFFER_DELAY			0x2582
#define CNF_ERR_CAS_FSK_CONFLICT				0x2583
#define CNF_ERR_UMA_INVALID_CMR					0x25C0
#define CNF_ERR_UMA_INVALID_WINDOW				0x25C1
#define CNF_ERR_UMA_INVALID_STATE				0x25C2
#define CNF_ERR_UMA_INVALID_BAD_LIMIT				0x25C3
#define CNF_ERR_UMA_INVALID_GOOD_LIMIT				0x25C4
#define CNF_ERROR_TFO_IPE_INCORRECT_FRAME_SIZE			0x25D0
#define CNF_ERROR_TFO_IPE_NOT_CREATED				0x25D1
#define CNF_ERROR_TFO_IPE_ENTITY_CREATED			0x25D2
#define CNF_ERROR_TFO_IPE_ENTITY_NOT_CREATED			0x25D3
#define CNF_ERROR_TFO_IPE_ENTITY_ENABLED			0x25D4
#define CNF_ERROR_TFO_IPE_ENTITY_RESERVED			0x25D5
#define CNF_ERROR_TFO_IPE_MODE_RESERVED				0x25D6
#define CNF_ERROR_FORK_REG_ISSUE				0x2600
#define CNF_ERROR_DIAG_0					0x7800
#define CNF_ERROR_DIAG_1					0x7801
#define CNF_ERROR_DIAG_2					0x7802
#define CNF_ERROR_DIAG_ethreg1					0x7803
#define CNF_ERROR_DIAG_ethreg2					0x7804
#define CNF_ERROR_DIAG_ethreg3					0x7805
#define CNF_ERROR_DIAG_nofacility				0x7806
#define CNF_ERROR_DIAG_NOETHCTXT				0x7807
#define CNF_ERROR_DIAG_NOIPCTXT					0x7808
#define CNF_ERROR_HTDM_ALLOC					0x7900
#define CNF_ERROR_INVALID_DTMF_DIGIT				0x8000
#define CNF_ERROR_DISABLE_BAD_PT				0x8001
#define CNF_ERROR_BAD_FRAME_BUF_LEN				0x8002
#define CNF_ERROR_NO_FRAME_CTRL					0x8003
#define CNF_ERROR_TONEOFF					0x8004
#define CNF_ERROR_TG_TONEGEN					0x8005
#define CNF_ERROR_TG_FREQ					0x8006
#define CNF_ERROR_NO_PROT_WITH_RELAY				0x8007
#define CNF_ERROR_CADENCE					0x8008
#define CNF_ERROR_VOICE_INACTIVE				0x8009
#define CNF_ERROR_LB_ICHAN_SWITCH				0x800A
#define CNF_ERROR_LB_SELF					0x800B
#define CNF_ERROR_LB_POST_ONTHEFLY				0x800C
#define CNF_ERROR_LB_ICHAN_ONTHEFLY				0x800D
#define CNF_ERROR_LB_ICHAN_SELF					0x800E
#define CNF_ERROR_LB_ONTHEFLY					0x800F
#define CNF_ERROR_LB_NO_DEST					0x8010
#define CNF_ERROR_LB_NOT_IMPLEMENTED				0x8011
#define CNF_ERROR_LB_NO_FPGA					0x8012
#define CNF_ERR_NO_HIGHWAY					0x8013
#define CNF_ERR_WRONG_HIGHWAY					0x8014
#define CNF_ERR_NO_CHANGE_CHAN_IN_SVSR				0x8015
#define CNF_ERR_NO_SPEECH_PROC					0x8016
#define CNF_ERR_CHAGALL						0x8017
#define CNF_ERR_NO_DIAGQRYCB					0x8018
#define CNF_ERR_NO_DIAGENACB					0x8019
#define CNF_ERR_NO_CFGCHANGECB					0x801A
#define CNF_ERR_NO_CFGQUERYCB					0x801B
#define CNF_ERR_NO_STATCB					0x801C
#define CNF_ERR_DIGITSTRING_BUFFER_FULL				0x801D
#define DELAYED_ACK						0x8FFF
#define ERR_API_INVALID_PARAM1					0xFF00
#define ERR_API_INVALID_PARAM2					0xFF01
#define ERR_API_INVALID_PARAM3					0xFF02
#define ERR_API_INVALID_PARAM4					0xFF03
#define ERR_API_INVALID_PARAM5					0xFF04
#define ERR_LATENCY_LEVEL_INVALID				0xFFA1
#define ERR_GPIOPIN_INVALID					0xFFA2
#define ERR_GPIOPERIOD_SIZE					0xFFA3
#define ERR_SPU_INV_CODEC					0xFFA4
#define ERR_SPU_FEATURE_NOT_ENABLED				0xFFA5
#define ERR_DSPDIAG_INVCODECID					0xFFA6
#define ERR_CHANNELS_NOT_RUNNING				0xFFA7
#define ERR_VBE_CONFIG						0xFFA8
#define ERR_HEARTBEAT_SIZE					0xFFA9
#define ERR_STAGGER_SIZE					0xFFAA
#define ERR_MAX_SIZE						0xFFAB
#define ERR_CHANNELS_RUNNING					0xFFAC
#define ERR_UNKNOWN_FUNCTION					0xFFAD
#define ERR_COMMAND_LEN						0xFFAE
#define ERR_RTXC_TASK_CREATE_FAILURE				0xFFAF
#define ERR_TONEGEN_IN_USE					0xFFB0
#define ERR_LATENCY_ALREADY_SET					0xFFB1
#define ERR_ILLEGAL_CT_FOR_CC					0xFFB2
#define ERR_ILLEGAL_COMMAND					0xFFB3
#define ERR_ZERO_LENGTH_STATS_INFO				0xFFB4
#define ERR_ILLEGAL_FUNCTION_FOR_IODUMP_CONTROL			0xFFB5
#define ERR_MAXIMUM_IODUMP_CHANNELS_ALLOWED			0xFFB6
#define ERR_ALLOCATED_IODUMP_INDICATION_MEMORY			0xFFB7
#define ERR_TDMDRV_INVTDMDELAY					0xFFBB
#define ERR_TDMDRV_BUS_DISABLED					0xFFBC
#define ERR_TDMDRV_INVTS					0xFFBD
#define ERR_TDMDRV_INVBUSID					0xFFBE
#define ERR_TDMDRV_INVBUFSZ					0xFFBF
#define ERR_FEATURE_NOTSUPPORTED				0xFFC0
#define ERR_CESOPSN_NO_PARTICIPANT_CHAN				0xFFC1
#define ERR_CESOPSN_NO_CONTEXT					0xFFC2
#define ERR_CESOPSN_TS_NOTCREATED				0xFFC3
#define ERR_CESOPSN_NO_LINK					0xFFC4
#define ERR_CESOPSN_BAD_LINK					0xFFC5
#define ERR_CESOPSN_NOT_OUR_LINK_CHAN				0xFFC6
#define ERR_CESOPSN_NEEDS_VOPENA_DIS				0xFFC7
#define ERR_SPEECH_NO_SUCH_CODEC				0xFFCF
#define ERR_INVALID_CHAN_TYPE					0xFFDD
#define ERR_CHANCTRL_NO_SUCH_CHAN				0xFFDE
#define ERR_CHANCTRL_NEED_ARM1_RES				0xFFDF
#define ERR_DPCHAN_CREATE					0xFFE0
#define ERR_FOIP_VOIPCHAN_NULL					0xFFE1
#define ERR_CCT_CHANTYPE_NOT_SUPPORTED				0xFFE2
#define CNF_ERR_CCB_USED					0xFFE3
#define CNF_ERR_G723_ALREADY_RUN				0xFFE4
#define DELAYED_VOIPCONFIG_ACK					0xFFE5
#define CMDDAT_SPDRV_ACP_NOT_READY				0xFFE6
#define ERR_RM_NO_SPU_MIPS_AVAILABLE				0xFFEB
#define ERR_RM_NO_ARM1_MIPS_AVAILABLE				0xFFEC
#define ERR_RM_NO_ARM0_MIPS_AVAILABLE				0xFFED
#define ERR_RM_NO_ARM_MIPS_AVAILABLE				0xFFEE
#define ERR_RM_NEED_ARM1_RES					0xFFEF
#define ERR_MALLOC_GENERIC					0xFFF1
#define ERR_TASK_STACK_OVERFLOW					0xFFF2
#define ERR_OUT_OF_RANGE					0xFFF3
#define ERR_MALLOC_IRAM_LOCAL_NCNB_HEAP				0xFFF4
#define ERR_MALLOC_IRAM_LOCAL_HEAP				0xFFF5
#define ERR_MALLOC_IRAM_GLOBAL_NCNB_HEAP			0xFFF6
#define ERR_MALLOC_IRAM_GLOBAL_HEAP				0xFFF7
#define ERR_MALLOC_ERAM_LOCAL_NCNB_HEAP				0xFFF8
#define ERR_MALLOC_ERAM_LOCAL_HEAP				0xFFF9
#define ERR_MALLOC_ERAM_GLOBAL_NCNB_HEAP			0xFFFA
#define ERR_MALLOC_ERAM_GLOBAL_HEAP				0xFFFB
#define ERR_MALLOC_SDRAM_LOCAL_NCNB_HEAP			0xFFFC
#define ERR_MALLOC_SDRAM_LOCAL_HEAP				0xFFFD
#define ERR_MALLOC_SDRAM_GLOBAL_NCNB_HEAP			0xFFFE
#define ERR_MALLOC_SDRAM_GLOBAL_HEAP				0xFFFF


/* Function codes */
#define FC_EVT_ALERT_IND				0x0000
#define FC_ALERT					0x0000
#define FC_SUPVSR_READY					0x0000
#define FC_REDIRECT_CSM					0x0001
#define FC_REDIRECT_CSM_UDP				0x0004
#define FC_REDIRECT_CSM_ALTHDR				0x0005
#define FC_SUPVSR_CREATE_CHANNEL			0x0010
#define FC_SUPVSR_DESTROY_CHANNEL			0x0011
#define FC_SPU_FEATURES_CONTROL				0x0013
#define FC_SUPVSR_GET_ARM_CODE_VERSION			0x0021
#define FC_SUPVSR_GET_SPU_CODE_VERSION			0x0022
#define FC_SUPVSR_RUN_CHECKSUM				0x0023
#define FC_ARM_FW_BRANCH				0x0024
#define FC_SUPVSR_GET_DEVICE_TYPE			0x0031
#define FC_DIAG_CMD_TRACE				0x00FB
#define FC_SET_ETH_HDR					0x0100
#define FC_GET_ETH_HDR					0x0101
#define FC_SET_RTO					0x0103
#define FC_ETH_SERVICE_CONFIG				0x0104
#define FC_ARP_SERVICE_CONFIG				0x0105
#define FC_SPECIALPKT_HANDLING_SERVICE_CONFIG		0x0107
#define FC_SPECIALPKT_HANDLING_INDICATION_ETH		0x0108
#define FC_SPECIALPKT_HANDLING_GEN_ETH			0x0109
#define FC_CSME_MULTI_CMD				0x010A
#define FC_SPECIALPKT_HANDLING_INDICATION_IP		0x010B
#define FC_SPECIALPKT_HANDLING_GEN_IPOAAL5		0x010C
#define FC_SELECT_MII_MODE				0x010E
#define FC_MULTI_IP_ADDR_LIST				0x010F
#define FC_SET_ETH_VLAN_TABLE				0x0110
#define FC_SET_MULTICAST_ETH_ADDR			0x0111
#define FC_SET_MAC_ADDR_PROMISCUOUS_MODE		0x0114
#define FC_EMAC_SELECT					0x011B
#define FC_EMAC_ACTIVE_PORT				0x011C
#define FC_ETH_FLOW_CONTROL_CONFIG			0x011D
#define FC_ETH_SWITCH_CONFIG				0x0121
#define FC_ETH_SWITCH_RULE				0x0122
#define FC_SELECT_MAC_TRANSMISSION_PARAMETERS		0x0123
#define FC_SET_ETH_DSA_ENA 				0x0140
#define FC_POS10B_SERVICE_CONFIG			0x0216
#define FC_IPEXTEN_SERVICE_CONFIG			0x0230
#define FC_IUUP_IPEXTEN_SERVICE_CONFIG			0x0230
#define FC_IP_SERVICE_CONFIG				0x0302
#define FC_IP_ADDRESS					0x0303
#define FC_ICMP_SERVICE_CONFIG				0x0304
#define FC_IP_OPTIONS					0x0306
#define FC_IP_REDIRECT_CHANNEL_OPTIONS			0x0307
#define FC_IP_REDIRECT_OPTIONS_CFG			0x0307
#define FC_IP_REDIRECT_INIT_SESSION			0x0308
#define FC_IP_REDIRECT_QUERY_UDP			0x0308
#define FC_IP_REDIRECT_QUERY_LAYER3_HDR			0x0309
#define FC_IP_REDIRECT_SET_LAYER3_HDR			0x0309
#define FC_IP_REDIRECT_QUERY_LAYER2_HDR			0x030A
#define FC_IP_REDIRECT_SET_LAYER2_HDR			0x030A
#define FC_IP_REDIRECT_SRCHDRCHG			0x030B
#define FC_IP_REDIRECT_QUERY_SESSION			0x030C
#define FC_IP_REDIRECT_DTMFDET_IND			0x030D
#define FC_IP_REDIRECT_DTMFGEN				0x030D
#define FC_IP_ADDRESS_V6				0x0310
#define FC_TDM_ENABLE_BUS				0x0405
#define FC_LATENCY_LEVEL				0x0406
#define FC_SUPVSR_SETUP_TDM_PARAMS			0x0407
#define FC_FORCE_ALERT					0x0409
#define FC_DEVICE_STATUS				0x040F
#define FC_SUPVSR_GET_DEVICE_VERSION			0x0410
#define FC_SUPVSR_GET_ARM_CLK				0x0411
#define FC_SUPVSR_GET_SPU_CLK				0x0412
#define FC_TDM_SET_PLAYBACK_BUFFER			0x0414
#define FC_TDM_SELECT_BUS_MODE				0x0417
#define FC_DEVICE_SET_COUNTRY_CODE			0x041B
#define FC_CP_SET_COUNTRY_CODE_PARAMS			0x041C
#define FC_SUPVSR_SET_TS_MODE				0x0424
#define FC_SUPVSR_SET_PCM_LAW				0x0425
#define FC_HANG_ON_ALERT				0x0439
#define FC_NTG_CONFIG					0x043F
#define FC_PLAYBACK_SET_BUFFER				0x0450
#define FC_PLAYBACK_SET_FILE				0x0451
#define FC_SUPVSR_NEXT_VOIP_CHAN_ON_ACP			0x0460
#define FC_EXT_MEM_SETUP				0x0461
#define FC_SET_MEDIA_HOST				0x04A0
#define FC_CHANNELS_RESET 				0x04F6
#define FC_CHANNELS_RESET_COMPLETE 			0x04F7
#define FC_SET_ALT_HDR_DEVICE				0x0500
#define FC_PPPOE_SERVICE_CFG				0x0502
#define FC_LAG_SERVICE_CFG				0x0503
#define FC_LAG_START					0x0504
#define FC_IUUP_SERVICE_CONFIG				0x0600
#define FC_IUUP_ERR_IND_CONFIG				0x0601
#define FC_DIAG_PACKET_RX				0x0802
#define FC_DIAG_PACKET_TX				0x0803
#define FC_DIAG_AAL2_OVER_ETH_RX			0x0A00
#define FC_DIAG_AAL2_OVER_ETH_TX			0x0A01
#define FC_C2C_SERVICE_CFG				0x0C00
#define FC_UP_CONNECT					0x0C02
#define FC_C2C_CONNECT_UMA_UP				0x0C07
#define FC_DIAG_TDM_RX					0x0E00
#define FC_DIAG_TDM_TX					0x0E01
#define FC_DIAG_DSP_IOPARAMS				0x1010
#define FC_DIAG_DSP_INSTREAM				0x1011
#define FC_DIAG_DSP_OUTSTREAM				0x1012
#define FC_DIAG_DSP_TASK_IOPARAMS			0x1013
#define FC_DIAG_CSME_MCP_TRACE				0x1014
#define FC_DIAG_DSP_TOMIXER				0x1015
#define FC_DIAG_DSP_FROMMIXER				0x1016
#define FC_AAL2_VOPENA					0x8000
#define FC_IUUP_VOPENA					0x8000
#define FC_VOIP_VOPENA					0x8000
#define FC_AAL2_VCEOPT					0x8001
#define FC_IUUPOAAL2_VCEOPT				0x8001
#define FC_VOIP_VCEOPT					0x8001
#define FC_IUUPOAAL2_DTMFOPT				0x8002
#define FC_VOIP_DTMFOPT					0x8002
#define FC_FAXOPT					0x8003
#define FC_AAL2_DGAIN					0x8005
#define FC_IUUP_DGAIN					0x8005
#define FC_VOIP_DGAIN					0x8005
#define FC_AAL2_ECHOCAN					0x8006
#define FC_IUUP_ECHOCAN					0x8006
#define FC_VOIP_ECHOCAN					0x8006
#define FC_IUUPOAAL2_RPPH				0x8007
#define FC_VOIP_TONEGEN					0x8009
#define FC_VOIP_RTCPSTAT				0x800C
#define FC_IUUP_TONEDET					0x800D
#define FC_VOIP_TONEDET					0x800D
#define FC_VOIP_SSRCCHG					0x800E
#define FC_VOIP_PTCHNG					0x800F
#define FC_VOIP_TCMPLT					0x8010
#define FC_FAXSTATE					0x8011
#define FC_IUUP_LOOPBACK				0x8012
#define FC_VOIP_LOOPBACK				0x8012
#define FC_IUUP_TONEOFF					0x8014
#define FC_VOIP_TONEOFF					0x8014
#define FC_VOIP_EVENTDET				0x8017
#define FC_VOIP_PTMNG					0x8018
#define FC_VOIP_NTECMPLT				0x801F
#define FC_VOIP_NTERCVD					0x8020
#define FC_VOIP_SENDNTE					0x801E
#define FC_VOIP_DTMFDPAR				0x8021
#define FC_AAL2_SELECTPROF				0x8023
#define FC_FAXLVL					0x8026
#define FC_VOIP_SSRCVIOL				0x8027
#define FC_VOIP_PTSET					0x802B
#define FC_VOIP_SS7COT					0x8029
#define FC_VOIP_PTSETRXOVR				0x802D
#define FC_VOIP_DTMFTUNE				0x8034
#define FC_VOIP_VOISIDET				0x8037
#define FC_CND_ONHOOK_GEN				0x8039
#define FC_CND_SET_PARAMS				0x803A
#define FC_CND_OFFHOOK_GEN				0x803B
#define FC_CND_STOP					0x803C
#define FC_CND_DONE					0x803D
#define FC_VOIP_QUADTONEGEN				0x8040
#define FC_CIPHER_AES_OPT				0x8046
#define FC_VOIP_CNTRYCODE				0x805A
#define FC_VOIP_TONECTRL				0x805B
#define FC_VOIP_REMDET					0x805C
#define FC_VOIP_TONEOPT					0x806C
#define FC_VOIP_IPTONEDET				0x806D
#define FC_VOIP_PROGRAM_TONE_ENGINE			0x806E
#define FC_VOIP_PROGRAM_CADENCE_ENGINE			0x806F
#define FC_IUUP_OPTIONS					0x8070
#define FC_IUUP_INITSEND				0x8071
#define FC_IUUP_INITRCVD				0x8072
#define FC_IUUP_INITACK					0x8073
#define FC_IUUP_INITNACK				0x8074
#define FC_IUUP_RATESEND				0x8075
#define FC_IUUP_RATERECVD				0x8076
#define FC_IUUP_RATEACK					0x8077
#define FC_IUUP_RATENACK				0x8078
#define FC_IUUP_ALIGNSEND				0x8079
#define FC_IUUP_ALIGNACK				0x807B
#define FC_IUUP_ALIGNNACK				0x807C
#define FC_IUUP_ERRORSEND				0x807D
#define FC_IUUP_ERRORRCVD				0x807E
#define FC_IUUP_ERRORNACK				0x807F
#define FC_VOIP_INDCTRL					0x8084
#define FC_FOIP_FAXSPLOPT				0x8085
#define FC_IUUP_CELLMONITOR				0x8086
#define FC_IUUP_DATARXINDICATION			0x8087
#define FC_IUUP_DATATXINDICATION			0x8088
#define FC_IUUP_CTRLRXINDICATION			0x8089
#define FC_IUUP_CTRLTXINDICATION			0x808A
#define FC_FOIP_SET_DATAGRAM				0x808B
#define FC_FOIP_GET_DATAGRAM				0X808C
#define FC_FOIP_GET_BUFFSZ				0X808D
#define FC_FOIP_FILLBIT_CTRL				0x808E
#define FC_VOIP_JBOPT					0x8090
#define FC_EC_CONTROL					0x8091
#define FC_VOIP_TONES_RELAY_OPTION			0x8092
#define FC_CNDONDTMFGEN					0x8093
#define FC_CNDONDTMFSTOP				0x8094
#define FC_CNDDTMFTUNE					0x8095
#define FC_CNDONDTMFDONE				0x8096
#define FC_VOIP_DIGITSTRGEN				0x8098
#define FC_VOIP_MFTUNE					0x809A
#define FC_VOIP_MFDPAR					0x809B
#define FC_RTCP_ENA					0x80A0
#define FC_SDES_CNAME					0x80A1
#define FC_IND_RTCP_XR					0x80A2
#define FC_VOIP_RTCP_XR_TX				0x80A3
#define FC_RTCP_APP_NAME				0x80A4
#define FC_IND_SR					0x80A5
#define FC_IND_RR					0x80A6
#define FC_IND_SDES_CNAME				0x80A7
#define FC_IND_BYE					0x80A8
#define FC_RTCP_APP					0x80A9
#define FC_IND_RTCP_APP					0x80AA
#define FC_SET_RTCP_NTP_TIMESTAMP			0x80AB
#define FC_SET_RTCP_GENERATION_GRANULARITY		0x80AC
#define FC_SET_RTCP_PACKET_GENERATION_GRANULARITY	0x80AC
#define FC_CNDRXMSG					0x80AD
#define FC_CNDDETSP					0x80AE
#define FC_VOIP_CDMA_MODES				0x80B0
#define FC_CNDDETCTL					0x80B1
#define FC_EVRC_RTP_OPTIONS				0x80B2
#define	FC_GET_INGRESS_SIGNALING			0x80B8
#define	FC_SET_IP_SIGNALING				0x80BB
#define	FC_IP_SIG_CHANGE_IND				0x80BC
#define FC_UP_SWITCHOVER				0x80BD
#define FC_SET_PASSTHRU_AUTOSWITCH			0x80BE
#define FC_PASSTHRU_AUTOSWITCH_IND			0x80BF
#define FC_VOIP_NSSET					0x80D0
#define FC_VOIP_AGCSET					0x80D1
#define FC_QOS_THRESHOLD				0x80D3
#define FC_QOS_ALARM					0x80D4
#define FC_SESSION_BW					0x80D5
#define FC_PLAYBACK_START				0x80D8
#define FC_PLAYBACK_STOP				0x80D9
#define FC_VOIP_DFECAN					0x80E3
#define FC_VOIP_DFECTUNE				0x80E4
#define FC_AEC_CONTROL					0x80E5
#define FC_RTP_TX_TIMESTAMP				0x80E7
#define FC_RTP_TX_SEQNUM				0x80E8
#define FC_RTP_PKTHDLR_INFO				0x80E9
#define FC_CTM_CONFIG					0x80EA
#define FC_CTM_CHANGE_IND				0x80EB
#define FC_RTCP_BYE_PKT_DISABLE				0x80EC
#define FC_RTP_MONITOR_ENA				0x80EE
#define FC_RTP_MONITOR_IND				0x80EF
#define FC_TDMDIAGCTRL					0x80F0
#define FC_VOIP_RTCP_XR_REMOTE				0x80F2
#define FC_PROGRAM_RTCP_XR_PARAMS			0x80F3
#define FC_RTCP_IND_TX_SR				0x80F7
#define FC_RTCP_IND_TX_RR				0x80F8
#define FC_RTCP_IND_TX_SDES_CNAME			0x80F9
#define FC_RTCP_IND_TX_BYE				0x80FA
#define FC_RTCP_IND_TX_APP				0x80FB
#define FC_RTCPSTATTMR					0x80FC
#define FC_NC_CONTROL					0x81E7
#define FC_NC_TUNE					0x81E8
#define FC_DPNS_CONTROL					0x81E9
#define FC_CDMA_DTX_CONTROL				0x81EA
#define FC_CDMA_DTX_TUNE				0x81EB
#define FC_G729_WB_MODE					0x81EC
#define FC_RL_EVRCX_CONTROL				0x81ED
#define FC_PROGRAM_E_MODEL				0x81EE
#define FC_CIPHER_SRTP_OPT				0x8200
#define FC_CIPHER_SRTP_KEY_DERIVATION			0x8201
#define FC_UP_CHAN_SERVICE_CONFIG			0x8500
#define FC_IUUP_STATE					0x8502
#define FC_UP_RATE					0x8503
#define FC_UP_VADCHANGE					0x85FD
#define FC_SET_UMA_PARAMS				0x8600
#define FC_SET_ISLP_PARAMS				0x870A
#define FC_ISLP_EVENTDET				0x870B
#define FC_MTOM_SETUP					0x8720
#define FC_FAXV8_REMOVAL_CONFIG				0x8730
#define FC_FAXV8_REMOVAL_IND				0x8731
#define FC_EVRC_POSTFILTER_CONFIG			0x8740
#define FC_IND_RTCP_XR_TX				0x8A01
#define FC_IND_RTCP_XR_METRICS				0x8A02
#define FC_SET_IPV6_HDR_CHANNEL				0x9000
#define FC_SET_IP_HDR_CHANNEL				0x9000
#define FC_GET_IP_HDR_CHANNEL				0x9001
#define FC_SET_CHANNEL_IP_MODE				0x9003
#define FC_EVT_IND_FROM_SPI_DEVICE			0x9305
#define FC_SPI_EVT_PROCESS_ACK_CMD			0x9306
#define FC_SET_UDP_HDR_ALT				0x9006
#define FC_SET_ETH_HDR_CHAN				0x9010
#define FC_SET_ALT_HDR_CHANNEL				0x9020
#define FC_SET_POS_10B_HDR				0x9030
#define FC_IPDTMF_CTRL					0x9040
#define FC_INBAND_DTMF_DET				0x9041
#define FC_RFC2833_DTMF_DET				0x9042
#define FC_RFC2833_TONEPLYCFG				0x9050
#define FC_IUUP_SET_IPEXTEN_HDR				0x9055
#define FC_SET_IPEXTEN_HDR				0x9055
#define FC_SET_PPPOE_HDR_CHAN				0x9060
#define FC_IP_OPTIONS_CHAN				0x9090
#define FC_VOIP_MEASOFF					0x9109
#define FC_VOIP_CFGMEAS					0x9110
#define FC_VOIP_MEASTONE				0x9111
#define FC_VOIP_MEASDONE				0x9112
#define FC_VOIP_TDETGLOBALCFG				0x9116
#define FC_VOIP_TDETCFG					0x9117
#define FC_VOIP_TDETIND					0x9118
#define FC_IPTONEDETEN					0x9119
#define FC_THC_REDIRECT_RX				0x9200
#define FC_THC_MODE_ENABLE				0x9201
#define FC_THC_GEN_PKT					0x9202
#define FC_CONF_CREATE_CONFERENCE			0x9310
#define FC_CONF_DESTROY_CONFERENCE			0x9311
#define FC_CONF_CREATE_PARTICIPANT			0x9312
#define FC_CONF_DESTROY_PARTICIPANT			0x9313
#define FC_CONF_MUTE_PARTICIPANT			0x9314
#define FC_CONF_PUT_PARTICIPANT_ON_HOLD			0x9315
#define FC_CONF_SPECIFY_DOMINANT_TALKERS		0x9316
#define FC_CONF_SET_LATENCY				0x9317
#define FC_CONF_SET_PARTICIPANT_DGAIN			0x9318
#define FC_CONF_SET_DGAIN				0x9319
#define FC_CONF_SET_PARTICIPANT_OPT			0x931D
#define FC_TRANS_CONNECT				0x9322
#define FC_MDIO_BUS_WRITE				0x9330
#define FC_MDIO_BUS_READ				0x9331
#define FC_MDIO_START_AUTODETECT			0x9332
#define FC_MDIO_AUTODETECT_IND				0x9333
#define FC_MDIO_SET_FREQ				0x9334
#define FC_MEDIAFORKING_AAL2_ACTIVATE			0x9360
#define FC_MEDIAFORKING_IPREDIR_ACTIVATE		0x9360
#define FC_MEDIAFORKING_IPREDIR_ACTIVATE_QUERY		0x9360
#define FC_MEDIAFORKING_IP_ACTIVATE			0x9360
#define FC_MEDIAFORKING_IPREDIR_SET_LAYER3_HDR		0x9361
#define FC_MEDIAFORKING_IPREDIR_SET_LAYER3_HDR_QUERY	0x9361
#define FC_MEDIAFORKING_SET_UDPIP_HDR			0x9361
#define FC_MEDIAFORKING_IPREDIR_SET_LAYER2_HDR		0x9362
#define FC_MEDIAFORKING_IPREDIR_SET_LAYER2_HDR_QUERY	0x9362
#define FC_MEDIAFORKING_SET_ETH_HDR			0x9362
#define FC_MEDIAFORKING_IPREDIR_SET_CUSTOM_HDR		0x9363
#define FC_MEDIAFORKING_IPREDIR_SET_CUSTOM_HDR_QUERY	0x9363
#define FC_MEDIAFORKING_SET_CUSTOM_HDR			0x9363
#define FC_MEDIAFORKING_SET_ATM_HDR			0x9364
#define FC_VOIP_SET_CHANNEL_MODE			0x9400
#define FC_SYNCDAT					0x9402
#define FC_SYNCEOF					0x9403
#define FC_SET_FLOWCON					0x9404
#define FC_VOIP_DRAIN_PLAYREC_BUFFER			0x9405
#define FC_VOIP_DRAIN_PLAYREC_BUFFER_IND		0x9406
#define FC_VOIP_AS_STOP					0x9407
#define FC_VOIP_AS_SET_RATE				0x9408
#define FC_SELECT_MF_TONEDET				0x9421
#define FC_AAL2_VOPDIS					0x9600
#define FC_IUUP_VOPDIS					0x9600
#define FC_VOIP_VOPDIS					0x9600
#define FC_SUPVSR_MAC_HAIRPIN				0x9700
#define FC_CESOPSN_MAP_CHANS				0x9800
#define FC_CESOPSN_SPEC_MAP_CHANS			0x9801
#define FC_CESOPSN_SERVICE_CONFIG			0x9802
#define FC_CESOPSN_ERR_TIME_QUERY			0x9003
#define FC_CESOPSN_CONF_MONITOR				0x9804
#define FC_CESOPSN_STATE_IND				0x9805
#define FC_IMSOTDM_MEDIA_ENA				0xB000
#define FC_IMSOTDM_TXH245				0xB003
#define FC_H223_LEVEL					0xB004
#define FC_H223_CONFIG					0xB005
#define FC_H223_MXT_CONFIG				0xB006
#define FC_H223_LC_CONFIG				0xB007
#define FC_VIDEO_PTMNG					0xB018
#define FC_VIDEO_PTSET					0xB02B

/************************
Endianness conversion functions
*************************/
#define MSPD_SWAP16(usWord)(_u_16_)((_u_16_)((_u_16_)(usWord) << 8) | (_u_16_)((_u_16_)(usWord) >> 8))

#define MSPD_SWAP32(ulWord)	((((ulWord) & 0x000000ff) << 24) |	\
				(((ulWord) & 0x0000ff00) <<  8) |	\
				(((ulWord) & 0x00ff0000) >>  8) |	\
				(((ulWord) & 0xff000000) >> 24))

#ifdef _HOST_BIG_ENDIAN_
#define MSPD_CPU2LE16(usWord)	MSPD_SWAP16(usWord)
#define MSPD_CPU2BE16(usWord)	(usWord)
#define MSPD_CPU2LE32(ulWord)	MSPD_SWAP32(ulWord)
#define MSPD_CPU2BE32(ulWord)	(ulWord)
#define MSPD_LE2CPU16(usWord)	MSPD_SWAP16(usWord)
#define MSPD_BE2CPU16(usWord)	(usWord)
#define MSPD_LE2CPU32(ulWord)	MSPD_SWAP32(ulWord)
#define MSPD_BE2CPU32(ulWord)	(ulWord)
#else
#define MSPD_CPU2LE16(usWord)	(usWord)
#define MSPD_CPU2BE16(usWord)	MSPD_SWAP16(usWord)
#define MSPD_CPU2LE32(ulWord)	(ulWord)
#define MSPD_CPU2BE32(ulWord)	MSPD_SWAP32(ulWord)
#define MSPD_LE2CPU16(usWord)	(usWord)
#define MSPD_BE2CPU16(usWord)	MSPD_SWAP16(usWord)
#define MSPD_LE2CPU32(ulWord)	(ulWord)
#define MSPD_BE2CPU32(ulWord)	MSPD_SWAP32(ulWord)
#endif

#define GET_BIT_FIELD(param_num, n_bits, offset, from) \
({ \
 	_u_16_ *param = (_u_16_ *) from + param_num; \
 	((*param) >> (offset)) & ((1 << (n_bits)) - 1)); \
}) \

#define SET_BIT_FIELD(val, nb_bits, offset, target) \
 do \
 { \
	_u_16_ temp = (*(target) & (~(((1 << nb_bits) - 1) << offset))); \
	temp |= (val << offset); \
	*(target) = temp; \
 } while (0) \


/*Device models (see SUPVSR_GET_DEVICE_TYPE )*/
/*M823xx  */

#define M82359 0x0012
#define M82349 0x0017

#define M82358 0x0013
#define M82348 0x0018
#define M82318 0x002D
#define M82308 0x002F

#define M82356 0x0014
#define M82346 0x0019

#define M82354 0x0015
#define M82344 0x001A
#define M82334 0x0023
#define M82324 0x0028

#define M82353 0x0016
#define M82343 0x001B
#define M82333 0x0024
#define M82323 0x0029

#define M82352 0x001C
#define M82332 0x0025
#define M82322 0x002A

#define M82351 0x001D
#define M82331 0x0026
#define M82321 0x002B
#define M82311 0x002E

#define M82330 0x0027
#define M82320 0x002C

/*M829xx */
#define M82910 0x0010
#define M82908 0x0020
#define M82906 0x0021
#define M82907 0x0022


# endif /*_COMCERTO_API_DEFS_H_*/
