/*
 * Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

/*============================================================================
*============================================================================
*============= If something is missing or wrong please contact Mindspeed. ===
*============================================================================
*============================================================================*/

#ifndef _COMCERTO_ANNOUNCEMENT_SERVER_API_H_
#define _COMCERTO_ANNOUNCEMENT_SERVER_API_H_
/* WARNINGS make sure these types are 8, 16, 32 bits on the used host */
#ifndef _u_8_
#define _u_8_ unsigned char
#endif

#ifndef _u_16_
#define _u_16_ unsigned short
#endif

#ifndef _u_32_
#define _u_32_ unsigned int
#endif

#ifndef ATTRIBUTE_PACKED
#define ATTRIBUTE_PACKED __attribute__((packed))
#endif

/************************************************************
CA:SET_MEDIA_HOST (Function code=0x04A0, class=0x06, type=0x00)
************************************************************/
struct _SET_MEDIA_HOST
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:3> */
			_u_16_ reserved4_bits_15_3:13;

			/* parameter [4] bit(s) <2:0> */
			_u_16_ interface:3;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_SET_CHANNEL_MODE (Function code=0x9400, class=0x02, type=0x00)
************************************************************/
struct _VOIP_SET_CHANNEL_MODE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ source_coding:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ mode:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;

	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [5] bit(s) <15:8> */
			_u_16_ destination_coding:8;

			/* parameter [5] bit(s) <7:4> */
			_u_16_ destination_type:4;

			/* parameter [5] bit(s) <3:0> */
			_u_16_ source_type:4;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_5;

	/* parameter [6] */
	_u_16_ packet_size;


} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_DRAIN_PLAYREC_BUFFER (Function code=0x9405, class=0x02, type=0x00)
************************************************************/
struct _VOIP_DRAIN_PLAYREC_BUFFER
{
	/* parameter [4] */
	_u_16_ reserved4;


} ATTRIBUTE_PACKED;

/************************************************************
I:VoIP_DRAIN_PLAYREC_BUFFER_IND (Function code=0x9406, class=0x02, type=0x03)
************************************************************/
struct _VOIP_DRAIN_PLAYREC_BUFFER_IND
{
	/* parameter [4] */
	_u_16_ reserved4;


} ATTRIBUTE_PACKED;

/************************************************************
CA:VoIP_AS_SET_RATE (Function code=0x9408, class=0x02, type=0x00)
************************************************************/
struct _VOIP_AS_SET_RATE
{
	union
	{
		_u_16_ word;
		struct
		{
			/* parameter [4] bit(s) <15:8> */
			_u_16_ reserved4_bits_15_8:8;

			/* parameter [4] bit(s) <7:0> */
			_u_16_ rate:8;

		} ATTRIBUTE_PACKED bits;

	} ATTRIBUTE_PACKED param_4;


} ATTRIBUTE_PACKED;
#endif /* COMCERTO_ANNOUNCEMENT_SERVER_API_H_ */ 

