/*! \file vapi_san_var.h
	\brief This file contains some global variables
*/

/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef __VAPI_SAN_VAR_H
#define __VAPI_SAN_VAR_H

#include "vxcompat.h"

/* global variables used by argument parser */
#define MAX_STRING 256 
extern char error_string[MAX_STRING];

extern U16	device_id;
extern U8	boot_option_file;
extern U8	skip_t38;
extern U8	skip_complex;
extern U8	test_level;

extern int	number_of_endpoints;
extern int	number_of_loops;
/* This variable is used to store the number of timeslots thru the VAPI_SetTDMParams*/
extern U16	max_timeslots;

extern CONFID	g_conference_id;
extern int	number_of_participants;

/* used to store ip_address */
extern U8	device_ip_address[];

/* used to store device mac */
extern U8	device_mac_addr[];

/* used to store host mac */
extern U8	host_mac_addr[];
/* set the default mac address to 0 */
extern U8	def_mac_addr[];

extern struct _ENDPOINT_DESC	endpoints[];

/* device configuration, may be read from file or set by default */
extern SDeviceHeader *gtl_device_configuration;



#endif
