/*! \file vapi_san_type.h 
	\brief This file contains various structure ans macros definitions
*/

/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef __VAPI_SAN_TYPE_H
#define __VAPI_SAN_TYPE_H

#include <stdlib.h>
#include <stdio.h>
#include "vxcompat.h"

/* under VxWorks we should use VAPI logging instead of raw printfs */
#if	!defined(_VXWORKS_)

#define info(fmt, args...)		fprintf(stderr, __FILE__ ": " fmt "\n", ## args)
#define PDEBUG(type, fmt, args...)	do { if (type >= 0) info("%d: " fmt, __LINE__ , ## args); } while(0)

#else

#if	defined(_WRS_GNU_VAR_MACROS) || defined(VXWORKS_6_6)

/* we also try to keep diab compatibility under VxWorks */
#define info(fmt, args...)		UT_ErrorLog(TEST, __FILE__ ": " fmt "\n", ## args)
#define PDEBUG(type, fmt, args...)	do { if (type >= 0) info("%d: " fmt, __LINE__ , ## args); } while(0)

#else

#define info(fmt, args, ...)		UT_ErrorLog(TEST, __FILE__ ": " fmt "\n", __VA_ARGS__)
#define PDEBUG(type, fmt, args, ...)	do { if (type >= 0) info("%d: " fmt, __LINE__ , __VA_ARGS__); } while(0)

#endif	/* _WRS_GNU_VAR_MACROS */

#endif	/* !_VXWORKS_ */

#define FC_RESERVED 0x0000


#define DEBUG_ERROR	0
#define DEBUG_INIT	-1
#define DEBUG_INFO	-2
#define DEBUG_FUNCTION	-3

#define MAX_FIFO_SIZE		252

#define MAX_ENDPOINTS		640
#define MAX_PARTICIPANTS	96
/* Modes  SYNC/ASYNC */
#define ASYNC			1
#define SYNC			0

#define TDM_SIDE		0
#define IP_SIDE			1

#define DEFAULT_UDP_PORT	30000

#define ENDPOINT_STATE_IDLE					0
#define ENDPOINT_STATE_READY					1
#define ENDPOINT_STATE_OFF_HOOK					2
#define ENDPOINT_STATE_ON_HOOK					255
#define ENDPOINT_STATE_RINGING					3

#define ENDPOINT_STATE_WAIT_CREATE_CONNECTION_ACK		4
#define ENDPOINT_STATE_WAIT_DESTROY_CONNECTION_ACK		5
#define ENDPOINT_STATE_GENERATE_DIAL_TONE			6
#define ENDPOINT_STATE_WAIT_CREATE_CONNECTION_ORIGINATE_ACK	7
#define ENDPOINT_STATE_WAIT_CREATE_CONNECTION_TERMINATE_ACK	8
#define ENDPOINT_STATE_WAIT_IP_PARAMETERS_ORIGINATE_ACK		9
#define ENDPOINT_STATE_WAIT_IP_PARAMETERS_TERMINATE_ACK		10
#define ENDPOINT_STATE_WAIT_ENABLE_CONNECTION_ORIGINATE_ACK	11
#define ENDPOINT_STATE_WAIT_ENABLE_CONNECTION_TERMINATE_ACK	12
#define ENDPOINT_STATE_WAIT_LOOPBACK_ACK			14
#define ENDPOINT_STATE_CALL_REMOTE				15
#define ENDPOINT_STATE_REMOTE_CALLED				16
#define ENDPOINT_STATE_WAIT_T38_OPTIONS_ACK			17
#define ENDPOINT_STATE_WAIT_T38_IP_PARAMETERS_ACK		18
#define ENDPOINT_STATE_WAIT_ENABLE_T38_CONNECTION_ACK		19
#define ENDPOINT_STATE_FINISH					20
#define ENDPOINT_STATE_WAIT_CREATE_TDM_PARTICIPANT_ACK		21
#define ENDPOINT_STATE_WAIT_CREATE_IP_PARTICIPANT_ACK		22
#define ENDPOINT_STATE_WAIT_IP_PARAMETERS_IP_PARTICIPANT_ACK	23 
#define ENDPOINT_STATE_WAIT_IP_PARTICIPANT_ENABLE_ACK		24
#define ENDPOINT_STATE_CONFERENCE_FINISH			25
#define ENDPOINT_STATE_CID_CMPLT				26
#define ENDPOINT_STATE_WAIT_TIMED_CONNECTION			27

#define ENDPOINT_EVENT_NONE					0
#define ENDPOINT_EVENT_OFF_HOOK					1
#define ENDPOINT_EVENT_ON_HOOK					2
#define ENDPOINT_EVENT_RINGING					3
#define ENDPOINT_EVENT_CREATE_VOIP_CHANNEL			4
#define ENDPOINT_EVENT_VOIP_CHANNEL_CREATED			5
#define ENDPOINT_EVENT_VOIP_CHANNEL_DESTROYED			6
#define ENDPOINT_EVENT_MAKE_OUTGOING_CALL			7
#define ENDPOINT_EVENT_IP_PARAMETERS_SET			8
#define ENDPOINT_EVENT_CONNECTION_ENABLED			9
#define ENDPOINT_EVENT_V21FLAG_DETECTED				10
#define ENDPOINT_EVENT_T38_OPTIONS_ACK				11
#define ENDPOINT_EVENT_T38_IP_PARAMETERS_SET			12
#define ENDPOINT_EVENT_FINISH					13
#define ENDPOINT_EVENT_TDM_PARTICIPANT_CREATED			14
#define ENDPOINT_EVENT_IP_PARTICIPANT_CREATED			15
#define ENDPOINT_EVENT_IP_PARAM_IP_PARTICIPANT_CONFIGURED	16
#define ENDPOINT_EVENT_IP_PARTICIPANT_ENABLED			17
#define ENDPOINT_EVENT_CONNECTION_TIMED				18

#define	TEST_LEVEL_ALL		4
#define	TEST_LEVEL_NO_CFG	3
#define	TEST_LEVEL_NO_LB	2
#define	TEST_LEVEL_NO_CID	1
#define	TEST_LEVEL_DEVICE	0


#define	REQUEST_ID_GENERIC		0xffff
#define	REQUEST_ID_DESTROY_LOOPBACK	0xfffe

extern int debug_level;
extern U16 device_id;
#define SANITY_ERROR	DEBUG_ERROR + debug_level
#define SANITY_INIT	DEBUG_INIT + debug_level
#define SANITY_INFO 	DEBUG_INFO + debug_level
#define SANITY_FUNCTION	DEBUG_FUNCTION + debug_level

#define ERROR_EXIT(str) {PDEBUG(SANITY_ERROR, "%s, device id %d - Failed\n", str, device_id); goto error_exit;}

struct _ENDPOINT_DESC {
	U16 index;
	U16 peer_index;
	U16 timeslot;
	U8 state;
	U8 previous_state;
	U8 event;
	U8 previous_event;
	U16 rtp_port;
	U16 rtcp_port;
	STimer *this_timer;
	unsigned int timeout;
	U32 ptchng_count;
};

/** Diagnostics redirection structure */
struct redirect_info
{
	unsigned char type;		/**< over CSME or IP/UDP*/
	unsigned char src_mac[6];	/**< source MAC address (must be the same as the one set to the device)*/
	unsigned char dst_mac[6];	/**< destination MAC address to redirect to*/
	unsigned int src_ip;		/**< source IP address (must bethe same as the one set to the device)*/
	unsigned int dst_ip;		/**< destination IP address to redirect to*/
	unsigned short src_udp;		/**< Source UDP port used in case of IP/UDP redirection type*/	
	unsigned short dst_udp;		/**< Destination UDP port used in case of IP/UDP redirection type*/
};

struct device_config
{
	SDeviceHeader device_header;
	char *dev_name;			/*Device name */

	/*ETH Interface Specific info */
	U8 aucDevMac[6];		/* Device MAC Address */
	U8 aucHostMac[6];		/* Host MAC Address (used in MAAS ASSIGN only for CSME Slave) */
	U8 ucIsAckReqd;			/* 1 : ACK is required   0 : ACK not required */
};

#endif
