/*! \file vapi_san_func.h
	\brief This file contains the prototypes of the various functions of the application
*/

/* Copyright © 2004-2010 Mindspeed Technologies, Inc.
 * Mindspeed Confidential.
 * All rights reserved.
 *
 * This file is a component of the Mindspeed® VAPI software ("VAPI") and is
 * distributed under the Mindspeed Software License Agreement (the "Agreement").
 * Before using this file, you must agree to be bound by the the terms and conditions of 
 * the Agreement.
 */

#ifndef __VAPI_SAN_FUNC_H
#define __VAPI_SAN_FUNC_H

int set_device_configuration(const char *config_file, void *device_cfg, int device_ctrl_itf);
int	boot_device(const char *firmware);

int	tdm_parameters_initialisation(const char *config_file);

int	network_parameters_initialisation(const char *config_file, U8 ip_flag);
void	display_firmware_version(void);

int	destroy_endpoint(int endpoint_id,  int mode, int endpoint_state);

int	create_participant(int endpoint_id, int mode, int endpoint_state, int conference_id, int participant_type);

void	start_loopback(int endpoint_id, int endpoint_state);
int	create_voip_endpoint(int endpoint_id, int mode, int endpoint_state);
int	set_ip_udp_parameters(int endpoint_id, int mode, int endpoint_state);
int	start_voip_endpoint(int endpoint_id, int mode, int endpoint_state);


int	device_query(U16 device_id, U16 function_code, U16 *response_len, U8 *this_response);
int	comcerto_read_firmware_file (char *filename, unsigned char **buf, int *size);

void	comcerto_response_handler(U32 connection_id,
				  U8 command_level,
				  S32 result,
				  void *response_data,
				  U32 data_length,
				  U32 request_id);

void	comcerto_indication_handler(EEventCode eEventCode, void *pvData);

int	connection_query_rtcpstat(U16 connection_id);
int	connection_rtcp_statistics(U16 connection_id);
void	timed_connection (void *timer_data);
void	set_endpoint_event(int event_type, int index);
void	set_endpoint_state(int state, int index);

int check_passthru(void);
int check_cesopsn(void);
int check_play_tone(void);
int check_change_conn_type(void);
int check_modify_conn(void);
int check_recover(void (*pComsertoIndHand)(EEventCode eEventCode, void *pvData));
int check_conf_transcoding(void);
int check_allocate_participant(void);
int check_cmd_class_type(void);
int check_resource_manager(void);
VSTATUS check_multiple_ip(U16 device_id);

VSTATUS core_dump(DEVID device_id);
VSTATUS set_ntg_config(U16 device_id);

int configure_diag_redirect(struct redirect_info *redirect);

int set_diagnostics(unsigned int id,   /* if 0xFFFF device else connection*/
			unsigned char command_class, 
			unsigned char command_type, 
			unsigned short function_code, 
			unsigned char action); /* 1 = enable, 0 = disable */

#endif
